// from https://github.com/dcousens/hexxer/blob/47191b839fc4bbdc60dc267d9f9673640a50c161/hexxer.hpp
#pragma once

namespace hexxer {
	static const char HEX_ALPHABET[] = "0123456789abcdef";
	static const int HEX_TABLE[] = {
		255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
		0,1,2,3,4,5,6,7,8,9, // 0-9
		255,255,255,255,255,255,255,
		10,11,12,13,14,15, // a-f
		255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
		10,11,12,13,14,15, // A-F
		255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	};

	inline auto encodeFirst (const unsigned char x) {
		return HEX_ALPHABET[x >> 4];
	}

	inline auto encodeSecond (const unsigned char x) {
		return HEX_ALPHABET[x & 0x0f];
	}

	inline auto decode (const char a, const char b) {
		const auto ia = HEX_TABLE[static_cast<unsigned char>(a)];
		const auto ib = HEX_TABLE[static_cast<unsigned char>(b)];
		if (ia == 255) return 0x100;
		if (ib == 255) return 0x100;

		return (ia << 4) + ib;
	}
}
