"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LedgerSigner = void 0;
var filecoin_signer = __importStar(require("@zondax/filecoin-signing-tools"));
//import { import_wasm } from "../utils/import_wasm";
var data_1 = require("../utils/data");
var hw_transport_webusb_1 = __importDefault(require("@ledgerhq/hw-transport-webusb"));
var import_wasm = function () { return { 'catch': function (e) { } }; }; //dummy to avoid including the zondax wasm package
var LedgerSigner = /** @class */ (function () {
    function LedgerSigner(path) {
        if (path === void 0) { path = "m/44'/1'/0/0/1"; }
        this.path = path;
    }
    LedgerSigner.prototype.connect = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, e_1, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _c.trys.push([0, 2, , 3]);
                        _a = this;
                        return [4 /*yield*/, hw_transport_webusb_1.default.create(10000)];
                    case 1:
                        _a.transport = _c.sent();
                        this.transport.setScrambleKey("FIL");
                        return [3 /*break*/, 3];
                    case 2:
                        e_1 = _c.sent();
                        console.log(e_1);
                        return [3 /*break*/, 3];
                    case 3:
                        console.log("\n...Got transport...\n");
                        _b = this;
                        return [4 /*yield*/, import_wasm().catch(console.error)];
                    case 4:
                        _b.wasm = _c.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    LedgerSigner.prototype.sign = function (message) {
        return __awaiter(this, void 0, void 0, function () {
            var responsePk, serializedMessage, messageBuffer, responseRequest, v, RSVsig;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.wasm.keyRetrieveFromDevice(this.path, this.transport)];
                    case 1:
                        responsePk = _a.sent();
                        console.log(responsePk);
                        serializedMessage = filecoin_signer.transactionSerialize(this.messageToSigner(message));
                        console.log(serializedMessage);
                        messageBuffer = Buffer.from(serializedMessage, "hex");
                        return [4 /*yield*/, this.wasm.transactionSignRawWithDevice(messageBuffer, this.path, this.transport)];
                    case 2:
                        responseRequest = _a.sent();
                        v = Buffer.from([1]);
                        RSVsig = Buffer.concat([responseRequest.signature_compact, v]);
                        return [2 /*return*/, {
                                Message: message,
                                Signature: {
                                    Data: data_1.toBase64(RSVsig),
                                    Type: 1
                                }
                            }];
                }
            });
        });
    };
    LedgerSigner.prototype.getDefaultAccount = function () {
        return __awaiter(this, void 0, void 0, function () {
            var responsePk;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.wasm.keyRetrieveFromDevice(this.path, this.transport)];
                    case 1:
                        responsePk = _a.sent();
                        return [2 /*return*/, responsePk.addrString];
                }
            });
        });
    };
    LedgerSigner.prototype.messageToSigner = function (message) {
        return {
            to: message.To,
            from: message.From,
            nonce: message.Nonce,
            value: message.Value.toString(),
            gaslimit: message.GasLimit.toString(),
            gasfeecap: message.GasFeeCap.toString(),
            gaspremium: message.GasPremium.toString(),
            method: message.Method,
            params: message.Params,
        };
    };
    return LedgerSigner;
}());
exports.LedgerSigner = LedgerSigner;
//# sourceMappingURL=LedgerSigner.js.map