#!/usr/bin/env node

exports.id = 708;
exports.ids = [708];
exports.modules = {

/***/ 918508:
/***/ ((module) => {

/* Copyright (c) 2017 Rod Vagg, MIT License */

function AbstractChainedBatch (db) {
  this._db = db
  this._operations = []
  this._written = false
}

AbstractChainedBatch.prototype._serializeKey = function (key) {
  return this._db._serializeKey(key)
}

AbstractChainedBatch.prototype._serializeValue = function (value) {
  return this._db._serializeValue(value)
}

AbstractChainedBatch.prototype._checkWritten = function () {
  if (this._written) {
    throw new Error('write() already called on this batch')
  }
}

AbstractChainedBatch.prototype.put = function (key, value) {
  this._checkWritten()

  var err = this._db._checkKey(key, 'key')
  if (err) { throw err }

  key = this._serializeKey(key)
  value = this._serializeValue(value)

  this._put(key, value)

  return this
}

AbstractChainedBatch.prototype._put = function (key, value) {
  this._operations.push({ type: 'put', key: key, value: value })
}

AbstractChainedBatch.prototype.del = function (key) {
  this._checkWritten()

  var err = this._db._checkKey(key, 'key')
  if (err) { throw err }

  key = this._serializeKey(key)
  this._del(key)

  return this
}

AbstractChainedBatch.prototype._del = function (key) {
  this._operations.push({ type: 'del', key: key })
}

AbstractChainedBatch.prototype.clear = function () {
  this._checkWritten()
  this._operations = []
  this._clear()

  return this
}

AbstractChainedBatch.prototype._clear = function noop () {}

AbstractChainedBatch.prototype.write = function (options, callback) {
  this._checkWritten()

  if (typeof options === 'function') { callback = options }
  if (typeof callback !== 'function') {
    throw new Error('write() requires a callback argument')
  }
  if (typeof options !== 'object') { options = {} }

  this._written = true

  // @ts-ignore
  if (typeof this._write === 'function') { return this._write(callback) }

  if (typeof this._db._batch === 'function') {
    return this._db._batch(this._operations, options, callback)
  }

  process.nextTick(callback)
}

module.exports = AbstractChainedBatch


/***/ }),

/***/ 443538:
/***/ ((module) => {

/* Copyright (c) 2017 Rod Vagg, MIT License */

function AbstractIterator (db) {
  this.db = db
  this._ended = false
  this._nexting = false
}

AbstractIterator.prototype.next = function (callback) {
  var self = this

  if (typeof callback !== 'function') {
    throw new Error('next() requires a callback argument')
  }

  if (self._ended) {
    process.nextTick(callback, new Error('cannot call next() after end()'))
    return self
  }

  if (self._nexting) {
    process.nextTick(callback, new Error('cannot call next() before previous next() has completed'))
    return self
  }

  self._nexting = true
  self._next(function () {
    self._nexting = false
    callback.apply(null, arguments)
  })

  return self
}

AbstractIterator.prototype._next = function (callback) {
  process.nextTick(callback)
}

AbstractIterator.prototype.end = function (callback) {
  if (typeof callback !== 'function') {
    throw new Error('end() requires a callback argument')
  }

  if (this._ended) {
    return process.nextTick(callback, new Error('end() already called on iterator'))
  }

  this._ended = true
  this._end(callback)
}

AbstractIterator.prototype._end = function (callback) {
  process.nextTick(callback)
}

module.exports = AbstractIterator


/***/ }),

/***/ 932554:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Copyright (c) 2017 Rod Vagg, MIT License */

var xtend = __webpack_require__(347529)
var AbstractIterator = __webpack_require__(443538)
var AbstractChainedBatch = __webpack_require__(918508)
var hasOwnProperty = Object.prototype.hasOwnProperty
var rangeOptions = 'start end gt gte lt lte'.split(' ')

function AbstractLevelDOWN (location) {
  if (!arguments.length || location === undefined) {
    throw new Error('constructor requires at least a location argument')
  }

  if (typeof location !== 'string') {
    throw new Error('constructor requires a location string argument')
  }

  this.location = location
  this.status = 'new'
}

AbstractLevelDOWN.prototype.open = function (options, callback) {
  var self = this
  var oldStatus = this.status

  if (typeof options === 'function') { callback = options }

  if (typeof callback !== 'function') {
    throw new Error('open() requires a callback argument')
  }

  if (typeof options !== 'object') { options = {} }

  options.createIfMissing = options.createIfMissing !== false
  options.errorIfExists = !!options.errorIfExists

  this.status = 'opening'
  this._open(options, function (err) {
    if (err) {
      self.status = oldStatus
      return callback(err)
    }
    self.status = 'open'
    callback()
  })
}

AbstractLevelDOWN.prototype._open = function (options, callback) {
  process.nextTick(callback)
}

AbstractLevelDOWN.prototype.close = function (callback) {
  var self = this
  var oldStatus = this.status

  if (typeof callback !== 'function') {
    throw new Error('close() requires a callback argument')
  }

  this.status = 'closing'
  this._close(function (err) {
    if (err) {
      self.status = oldStatus
      return callback(err)
    }
    self.status = 'closed'
    callback()
  })
}

AbstractLevelDOWN.prototype._close = function (callback) {
  process.nextTick(callback)
}

AbstractLevelDOWN.prototype.get = function (key, options, callback) {
  if (typeof options === 'function') { callback = options }

  if (typeof callback !== 'function') {
    throw new Error('get() requires a callback argument')
  }

  var err = this._checkKey(key, 'key')
  if (err) return process.nextTick(callback, err)

  key = this._serializeKey(key)

  if (typeof options !== 'object') { options = {} }

  options.asBuffer = options.asBuffer !== false

  this._get(key, options, callback)
}

AbstractLevelDOWN.prototype._get = function (key, options, callback) {
  process.nextTick(function () { callback(new Error('NotFound')) })
}

AbstractLevelDOWN.prototype.put = function (key, value, options, callback) {
  if (typeof options === 'function') { callback = options }

  if (typeof callback !== 'function') {
    throw new Error('put() requires a callback argument')
  }

  var err = this._checkKey(key, 'key')
  if (err) return process.nextTick(callback, err)

  key = this._serializeKey(key)
  value = this._serializeValue(value)

  if (typeof options !== 'object') { options = {} }

  this._put(key, value, options, callback)
}

AbstractLevelDOWN.prototype._put = function (key, value, options, callback) {
  process.nextTick(callback)
}

AbstractLevelDOWN.prototype.del = function (key, options, callback) {
  if (typeof options === 'function') { callback = options }

  if (typeof callback !== 'function') {
    throw new Error('del() requires a callback argument')
  }

  var err = this._checkKey(key, 'key')
  if (err) return process.nextTick(callback, err)

  key = this._serializeKey(key)

  if (typeof options !== 'object') { options = {} }

  this._del(key, options, callback)
}

AbstractLevelDOWN.prototype._del = function (key, options, callback) {
  process.nextTick(callback)
}

AbstractLevelDOWN.prototype.batch = function (array, options, callback) {
  if (!arguments.length) { return this._chainedBatch() }

  if (typeof options === 'function') { callback = options }

  if (typeof array === 'function') { callback = array }

  if (typeof callback !== 'function') {
    throw new Error('batch(array) requires a callback argument')
  }

  if (!Array.isArray(array)) {
    return process.nextTick(callback, new Error('batch(array) requires an array argument'))
  }

  if (!options || typeof options !== 'object') { options = {} }

  var serialized = new Array(array.length)

  for (var i = 0; i < array.length; i++) {
    if (typeof array[i] !== 'object' || array[i] === null) {
      return process.nextTick(callback, new Error('batch(array) element must be an object and not `null`'))
    }

    var e = xtend(array[i])

    if (e.type !== 'put' && e.type !== 'del') {
      return process.nextTick(callback, new Error("`type` must be 'put' or 'del'"))
    }

    var err = this._checkKey(e.key, 'key')
    if (err) return process.nextTick(callback, err)

    e.key = this._serializeKey(e.key)

    if (e.type === 'put') { e.value = this._serializeValue(e.value) }

    serialized[i] = e
  }

  this._batch(serialized, options, callback)
}

AbstractLevelDOWN.prototype._batch = function (array, options, callback) {
  process.nextTick(callback)
}

AbstractLevelDOWN.prototype._setupIteratorOptions = function (options) {
  options = cleanRangeOptions(options)

  options.reverse = !!options.reverse
  options.keys = options.keys !== false
  options.values = options.values !== false
  options.limit = 'limit' in options ? options.limit : -1
  options.keyAsBuffer = options.keyAsBuffer !== false
  options.valueAsBuffer = options.valueAsBuffer !== false

  return options
}

function cleanRangeOptions (options) {
  var result = {}

  for (var k in options) {
    if (!hasOwnProperty.call(options, k)) continue
    if (isRangeOption(k) && isEmptyRangeOption(options[k])) continue

    result[k] = options[k]
  }

  return result
}

function isRangeOption (k) {
  return rangeOptions.indexOf(k) !== -1
}

function isEmptyRangeOption (v) {
  return v === '' || v == null || isEmptyBuffer(v)
}

function isEmptyBuffer (v) {
  return Buffer.isBuffer(v) && v.length === 0
}

AbstractLevelDOWN.prototype.iterator = function (options) {
  if (typeof options !== 'object') { options = {} }
  options = this._setupIteratorOptions(options)
  return this._iterator(options)
}

AbstractLevelDOWN.prototype._iterator = function (options) {
  return new AbstractIterator(this)
}

AbstractLevelDOWN.prototype._chainedBatch = function () {
  return new AbstractChainedBatch(this)
}

AbstractLevelDOWN.prototype._serializeKey = function (key) {
  return Buffer.isBuffer(key) ? key : String(key)
}

AbstractLevelDOWN.prototype._serializeValue = function (value) {
  if (value == null) return ''
  return Buffer.isBuffer(value) || process.browser ? value : String(value)
}

AbstractLevelDOWN.prototype._checkKey = function (obj, type) {
  if (obj === null || obj === undefined) {
    return new Error(type + ' cannot be `null` or `undefined`')
  }

  if (Buffer.isBuffer(obj) && obj.length === 0) {
    return new Error(type + ' cannot be an empty Buffer')
  }

  if (String(obj) === '') {
    return new Error(type + ' cannot be an empty String')
  }
}

module.exports = AbstractLevelDOWN


/***/ }),

/***/ 924012:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

exports.AbstractLevelDOWN = __webpack_require__(932554)
exports.AbstractIterator = __webpack_require__(443538)
exports.AbstractChainedBatch = __webpack_require__(918508)


/***/ }),

/***/ 346108:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


module.exports = __webpack_require__(224425);


/***/ }),

/***/ 224425:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


var EventEmitter = __webpack_require__(128614).EventEmitter,
    util = __webpack_require__(431669),
    eachSeries = __webpack_require__(194282),
    AsyncEventEmitter;


module.exports = exports = AsyncEventEmitter = function AsyncEventEmitter () {
  EventEmitter.call(this);
};

util.inherits(AsyncEventEmitter, EventEmitter);


/* Public methods
============================================================================= */

AsyncEventEmitter.prototype.emit = function(event, data, callback) {
  var self = this,
      listeners = self._events[event] || [];

  // Optional data argument
  if(!callback && typeof data === 'function') {
    callback = data;
    data = undefined;
  }

  // Special treatment of internal newListener and removeListener events
  if(event === 'newListener' || event === 'removeListener') {
    data = {
      event: data,
      fn: callback
    };

    callback = undefined;
  }

  // A single listener is just a function not an array...
  listeners = Array.isArray(listeners) ? listeners : [listeners];

  eachSeries(listeners.slice(), function (fn, next) {
    var err;

    // Support synchronous functions
    if(fn.length < 2) {
      try {
        fn.call(self, data);
      }
      catch (e) {
        err = e;
      }

      return next(err);
    }

    // Async
    fn.call(self, data, next);
  }, callback);

  return self;
};


AsyncEventEmitter.prototype.once = function (type, listener) {
  var self = this,
      g;

  if (typeof listener !== 'function') {
    throw new TypeError('listener must be a function');
  }

  // Hack to support set arity
  if(listener.length >= 2) {
    g = function (e, next) {
      self.removeListener(type, g);
      listener(e, next);
    };
  }
  else {
    g = function (e) {
      self.removeListener(type, g);
      listener(e);
    };
  }

  g.listener = listener;
  self.on(type, g);

  return self;
};


AsyncEventEmitter.prototype.first = function(event, listener) {
  var listeners = this._events[event] || [];

  // Contract
  if(typeof listener !== 'function') {
    throw new TypeError('listener must be a function');
  }

  // Listeners are not always an array
  if(!Array.isArray(listeners)) {
    this._events[event] = listeners = [listeners];
  }

  listeners.unshift(listener);

  return this;
};


AsyncEventEmitter.prototype.at = function(event, index, listener) {
  var listeners = this._events[event] || [];

  // Contract
  if(typeof listener !== 'function') {
    throw new TypeError('listener must be a function');
  }
  if(typeof index !== 'number' || index < 0) {
    throw new TypeError('index must be a non-negative integer');
  }

  // Listeners are not always an array
  if(!Array.isArray(listeners)) {
    this._events[event] = listeners = [listeners];
  }

  listeners.splice(index, 0, listener);

  return this;
};


AsyncEventEmitter.prototype.before = function(event, target, listener) {
  return this._beforeOrAfter(event, target, listener);
};


AsyncEventEmitter.prototype.after = function(event, target, listener) {
  return this._beforeOrAfter(event, target, listener, 'after');
};


/* Private methods
============================================================================= */

AsyncEventEmitter.prototype._beforeOrAfter = function(event, target, listener, beforeOrAfter) {
  var listeners = this._events[event] || [],
      i, index,
      add = beforeOrAfter === 'after' ? 1 : 0;

  // Contract
  if(typeof listener !== 'function') {
    throw new TypeError('listener must be a function');
  }
  if(typeof target !== 'function') {
    throw new TypeError('target must be a function');
  }

  // Listeners are not always an array
  if(!Array.isArray(listeners)) {
    this._events[event] = listeners = [listeners];
  }

  index = listeners.length;
  
  for(i = listeners.length; i--;) {
    if(listeners[i] === target) {
      index = i + add;
      break;
    }
  }

  listeners.splice(index, 0, listener);

  return this;
};


/***/ }),

/***/ 944409:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = asyncify;

var _isObject = __webpack_require__(513218);

var _isObject2 = _interopRequireDefault(_isObject);

var _initialParams = __webpack_require__(643519);

var _initialParams2 = _interopRequireDefault(_initialParams);

var _setImmediate = __webpack_require__(203111);

var _setImmediate2 = _interopRequireDefault(_setImmediate);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Take a sync function and make it async, passing its return value to a
 * callback. This is useful for plugging sync functions into a waterfall,
 * series, or other async functions. Any arguments passed to the generated
 * function will be passed to the wrapped function (except for the final
 * callback argument). Errors thrown will be passed to the callback.
 *
 * If the function passed to `asyncify` returns a Promise, that promises's
 * resolved/rejected state will be used to call the callback, rather than simply
 * the synchronous return value.
 *
 * This also means you can asyncify ES2017 `async` functions.
 *
 * @name asyncify
 * @static
 * @memberOf module:Utils
 * @method
 * @alias wrapSync
 * @category Util
 * @param {Function} func - The synchronous function, or Promise-returning
 * function to convert to an {@link AsyncFunction}.
 * @returns {AsyncFunction} An asynchronous wrapper of the `func`. To be
 * invoked with `(args..., callback)`.
 * @example
 *
 * // passing a regular synchronous function
 * async.waterfall([
 *     async.apply(fs.readFile, filename, "utf8"),
 *     async.asyncify(JSON.parse),
 *     function (data, next) {
 *         // data is the result of parsing the text.
 *         // If there was a parsing error, it would have been caught.
 *     }
 * ], callback);
 *
 * // passing a function returning a promise
 * async.waterfall([
 *     async.apply(fs.readFile, filename, "utf8"),
 *     async.asyncify(function (contents) {
 *         return db.model.create(contents);
 *     }),
 *     function (model, next) {
 *         // `model` is the instantiated model object.
 *         // If there was an error, this function would be skipped.
 *     }
 * ], callback);
 *
 * // es2017 example, though `asyncify` is not needed if your JS environment
 * // supports async functions out of the box
 * var q = async.queue(async.asyncify(async function(file) {
 *     var intermediateStep = await processFile(file);
 *     return await somePromise(intermediateStep)
 * }));
 *
 * q.push(files);
 */
function asyncify(func) {
    return (0, _initialParams2.default)(function (args, callback) {
        var result;
        try {
            result = func.apply(this, args);
        } catch (e) {
            return callback(e);
        }
        // if result is Promise object
        if ((0, _isObject2.default)(result) && typeof result.then === 'function') {
            result.then(function (value) {
                invokeCallback(callback, null, value);
            }, function (err) {
                invokeCallback(callback, err.message ? err : new Error(err));
            });
        } else {
            callback(null, result);
        }
    });
}

function invokeCallback(callback, error, value) {
    try {
        callback(error, value);
    } catch (e) {
        (0, _setImmediate2.default)(rethrow, e);
    }
}

function rethrow(error) {
    throw error;
}
module.exports = exports['default'];

/***/ }),

/***/ 581195:
/***/ (function(module, exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
(function (global, factory) {
   true ? factory(exports) :
  0;
}(this, (function (exports) { 'use strict';

function slice(arrayLike, start) {
    start = start|0;
    var newLen = Math.max(arrayLike.length - start, 0);
    var newArr = Array(newLen);
    for(var idx = 0; idx < newLen; idx++)  {
        newArr[idx] = arrayLike[start + idx];
    }
    return newArr;
}

/**
 * Creates a continuation function with some arguments already applied.
 *
 * Useful as a shorthand when combined with other control flow functions. Any
 * arguments passed to the returned function are added to the arguments
 * originally passed to apply.
 *
 * @name apply
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {Function} fn - The function you want to eventually apply all
 * arguments to. Invokes with (arguments...).
 * @param {...*} arguments... - Any number of arguments to automatically apply
 * when the continuation is called.
 * @returns {Function} the partially-applied function
 * @example
 *
 * // using apply
 * async.parallel([
 *     async.apply(fs.writeFile, 'testfile1', 'test1'),
 *     async.apply(fs.writeFile, 'testfile2', 'test2')
 * ]);
 *
 *
 * // the same process without using apply
 * async.parallel([
 *     function(callback) {
 *         fs.writeFile('testfile1', 'test1', callback);
 *     },
 *     function(callback) {
 *         fs.writeFile('testfile2', 'test2', callback);
 *     }
 * ]);
 *
 * // It's possible to pass any number of additional arguments when calling the
 * // continuation:
 *
 * node> var fn = async.apply(sys.puts, 'one');
 * node> fn('two', 'three');
 * one
 * two
 * three
 */
var apply = function(fn/*, ...args*/) {
    var args = slice(arguments, 1);
    return function(/*callArgs*/) {
        var callArgs = slice(arguments);
        return fn.apply(null, args.concat(callArgs));
    };
};

var initialParams = function (fn) {
    return function (/*...args, callback*/) {
        var args = slice(arguments);
        var callback = args.pop();
        fn.call(this, args, callback);
    };
};

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

var hasSetImmediate = typeof setImmediate === 'function' && setImmediate;
var hasNextTick = typeof process === 'object' && typeof process.nextTick === 'function';

function fallback(fn) {
    setTimeout(fn, 0);
}

function wrap(defer) {
    return function (fn/*, ...args*/) {
        var args = slice(arguments, 1);
        defer(function () {
            fn.apply(null, args);
        });
    };
}

var _defer;

if (hasSetImmediate) {
    _defer = setImmediate;
} else if (hasNextTick) {
    _defer = process.nextTick;
} else {
    _defer = fallback;
}

var setImmediate$1 = wrap(_defer);

/**
 * Take a sync function and make it async, passing its return value to a
 * callback. This is useful for plugging sync functions into a waterfall,
 * series, or other async functions. Any arguments passed to the generated
 * function will be passed to the wrapped function (except for the final
 * callback argument). Errors thrown will be passed to the callback.
 *
 * If the function passed to `asyncify` returns a Promise, that promises's
 * resolved/rejected state will be used to call the callback, rather than simply
 * the synchronous return value.
 *
 * This also means you can asyncify ES2017 `async` functions.
 *
 * @name asyncify
 * @static
 * @memberOf module:Utils
 * @method
 * @alias wrapSync
 * @category Util
 * @param {Function} func - The synchronous function, or Promise-returning
 * function to convert to an {@link AsyncFunction}.
 * @returns {AsyncFunction} An asynchronous wrapper of the `func`. To be
 * invoked with `(args..., callback)`.
 * @example
 *
 * // passing a regular synchronous function
 * async.waterfall([
 *     async.apply(fs.readFile, filename, "utf8"),
 *     async.asyncify(JSON.parse),
 *     function (data, next) {
 *         // data is the result of parsing the text.
 *         // If there was a parsing error, it would have been caught.
 *     }
 * ], callback);
 *
 * // passing a function returning a promise
 * async.waterfall([
 *     async.apply(fs.readFile, filename, "utf8"),
 *     async.asyncify(function (contents) {
 *         return db.model.create(contents);
 *     }),
 *     function (model, next) {
 *         // `model` is the instantiated model object.
 *         // If there was an error, this function would be skipped.
 *     }
 * ], callback);
 *
 * // es2017 example, though `asyncify` is not needed if your JS environment
 * // supports async functions out of the box
 * var q = async.queue(async.asyncify(async function(file) {
 *     var intermediateStep = await processFile(file);
 *     return await somePromise(intermediateStep)
 * }));
 *
 * q.push(files);
 */
function asyncify(func) {
    return initialParams(function (args, callback) {
        var result;
        try {
            result = func.apply(this, args);
        } catch (e) {
            return callback(e);
        }
        // if result is Promise object
        if (isObject(result) && typeof result.then === 'function') {
            result.then(function(value) {
                invokeCallback(callback, null, value);
            }, function(err) {
                invokeCallback(callback, err.message ? err : new Error(err));
            });
        } else {
            callback(null, result);
        }
    });
}

function invokeCallback(callback, error, value) {
    try {
        callback(error, value);
    } catch (e) {
        setImmediate$1(rethrow, e);
    }
}

function rethrow(error) {
    throw error;
}

var supportsSymbol = typeof Symbol === 'function';

function isAsync(fn) {
    return supportsSymbol && fn[Symbol.toStringTag] === 'AsyncFunction';
}

function wrapAsync(asyncFn) {
    return isAsync(asyncFn) ? asyncify(asyncFn) : asyncFn;
}

function applyEach$1(eachfn) {
    return function(fns/*, ...args*/) {
        var args = slice(arguments, 1);
        var go = initialParams(function(args, callback) {
            var that = this;
            return eachfn(fns, function (fn, cb) {
                wrapAsync(fn).apply(that, args.concat(cb));
            }, callback);
        });
        if (args.length) {
            return go.apply(this, args);
        }
        else {
            return go;
        }
    };
}

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Built-in value references. */
var Symbol$1 = root.Symbol;

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag$1 = Symbol$1 ? Symbol$1.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag$1),
      tag = value[symToStringTag$1];

  try {
    value[symToStringTag$1] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag$1] = tag;
    } else {
      delete value[symToStringTag$1];
    }
  }
  return result;
}

/** Used for built-in method references. */
var objectProto$1 = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString$1 = objectProto$1.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString$1.call(value);
}

/** `Object#toString` result references. */
var nullTag = '[object Null]';
var undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol$1 ? Symbol$1.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]';
var funcTag = '[object Function]';
var genTag = '[object GeneratorFunction]';
var proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

// A temporary value used to identify if the loop should be broken.
// See #1064, #1293
var breakLoop = {};

/**
 * This method returns `undefined`.
 *
 * @static
 * @memberOf _
 * @since 2.3.0
 * @category Util
 * @example
 *
 * _.times(2, _.noop);
 * // => [undefined, undefined]
 */
function noop() {
  // No operation performed.
}

function once(fn) {
    return function () {
        if (fn === null) return;
        var callFn = fn;
        fn = null;
        callFn.apply(this, arguments);
    };
}

var iteratorSymbol = typeof Symbol === 'function' && Symbol.iterator;

var getIterator = function (coll) {
    return iteratorSymbol && coll[iteratorSymbol] && coll[iteratorSymbol]();
};

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

/** Used for built-in method references. */
var objectProto$3 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$2 = objectProto$3.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto$3.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty$2.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && "object" == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER$1 = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER$1 : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

/** `Object#toString` result references. */
var argsTag$1 = '[object Arguments]';
var arrayTag = '[object Array]';
var boolTag = '[object Boolean]';
var dateTag = '[object Date]';
var errorTag = '[object Error]';
var funcTag$1 = '[object Function]';
var mapTag = '[object Map]';
var numberTag = '[object Number]';
var objectTag = '[object Object]';
var regexpTag = '[object RegExp]';
var setTag = '[object Set]';
var stringTag = '[object String]';
var weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]';
var dataViewTag = '[object DataView]';
var float32Tag = '[object Float32Array]';
var float64Tag = '[object Float64Array]';
var int8Tag = '[object Int8Array]';
var int16Tag = '[object Int16Array]';
var int32Tag = '[object Int32Array]';
var uint8Tag = '[object Uint8Array]';
var uint8ClampedTag = '[object Uint8ClampedArray]';
var uint16Tag = '[object Uint16Array]';
var uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag$1] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag$1] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

/** Detect free variable `exports`. */
var freeExports$1 = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule$1 = freeExports$1 && "object" == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports$1 && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    // Use `util.types` for Node.js 10+.
    var types = freeModule$1 && freeModule$1.require && freeModule$1.require('util').types;

    if (types) {
      return types;
    }

    // Legacy `process.binding('util')` for Node.js < 10.
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

/** Used for built-in method references. */
var objectProto$2 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$1 = objectProto$2.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty$1.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

/** Used for built-in method references. */
var objectProto$5 = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto$5;

  return value === proto;
}

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = overArg(Object.keys, Object);

/** Used for built-in method references. */
var objectProto$4 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$3 = objectProto$4.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty$3.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

function createArrayIterator(coll) {
    var i = -1;
    var len = coll.length;
    return function next() {
        return ++i < len ? {value: coll[i], key: i} : null;
    }
}

function createES2015Iterator(iterator) {
    var i = -1;
    return function next() {
        var item = iterator.next();
        if (item.done)
            return null;
        i++;
        return {value: item.value, key: i};
    }
}

function createObjectIterator(obj) {
    var okeys = keys(obj);
    var i = -1;
    var len = okeys.length;
    return function next() {
        var key = okeys[++i];
        return i < len ? {value: obj[key], key: key} : null;
    };
}

function iterator(coll) {
    if (isArrayLike(coll)) {
        return createArrayIterator(coll);
    }

    var iterator = getIterator(coll);
    return iterator ? createES2015Iterator(iterator) : createObjectIterator(coll);
}

function onlyOnce(fn) {
    return function() {
        if (fn === null) throw new Error("Callback was already called.");
        var callFn = fn;
        fn = null;
        callFn.apply(this, arguments);
    };
}

function _eachOfLimit(limit) {
    return function (obj, iteratee, callback) {
        callback = once(callback || noop);
        if (limit <= 0 || !obj) {
            return callback(null);
        }
        var nextElem = iterator(obj);
        var done = false;
        var running = 0;
        var looping = false;

        function iterateeCallback(err, value) {
            running -= 1;
            if (err) {
                done = true;
                callback(err);
            }
            else if (value === breakLoop || (done && running <= 0)) {
                done = true;
                return callback(null);
            }
            else if (!looping) {
                replenish();
            }
        }

        function replenish () {
            looping = true;
            while (running < limit && !done) {
                var elem = nextElem();
                if (elem === null) {
                    done = true;
                    if (running <= 0) {
                        callback(null);
                    }
                    return;
                }
                running += 1;
                iteratee(elem.value, elem.key, onlyOnce(iterateeCallback));
            }
            looping = false;
        }

        replenish();
    };
}

/**
 * The same as [`eachOf`]{@link module:Collections.eachOf} but runs a maximum of `limit` async operations at a
 * time.
 *
 * @name eachOfLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.eachOf]{@link module:Collections.eachOf}
 * @alias forEachOfLimit
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async function to apply to each
 * item in `coll`. The `key` is the item's key, or index in the case of an
 * array.
 * Invoked with (item, key, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 */
function eachOfLimit(coll, limit, iteratee, callback) {
    _eachOfLimit(limit)(coll, wrapAsync(iteratee), callback);
}

function doLimit(fn, limit) {
    return function (iterable, iteratee, callback) {
        return fn(iterable, limit, iteratee, callback);
    };
}

// eachOf implementation optimized for array-likes
function eachOfArrayLike(coll, iteratee, callback) {
    callback = once(callback || noop);
    var index = 0,
        completed = 0,
        length = coll.length;
    if (length === 0) {
        callback(null);
    }

    function iteratorCallback(err, value) {
        if (err) {
            callback(err);
        } else if ((++completed === length) || value === breakLoop) {
            callback(null);
        }
    }

    for (; index < length; index++) {
        iteratee(coll[index], index, onlyOnce(iteratorCallback));
    }
}

// a generic version of eachOf which can handle array, object, and iterator cases.
var eachOfGeneric = doLimit(eachOfLimit, Infinity);

/**
 * Like [`each`]{@link module:Collections.each}, except that it passes the key (or index) as the second argument
 * to the iteratee.
 *
 * @name eachOf
 * @static
 * @memberOf module:Collections
 * @method
 * @alias forEachOf
 * @category Collection
 * @see [async.each]{@link module:Collections.each}
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A function to apply to each
 * item in `coll`.
 * The `key` is the item's key, or index in the case of an array.
 * Invoked with (item, key, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 * @example
 *
 * var obj = {dev: "/dev.json", test: "/test.json", prod: "/prod.json"};
 * var configs = {};
 *
 * async.forEachOf(obj, function (value, key, callback) {
 *     fs.readFile(__dirname + value, "utf8", function (err, data) {
 *         if (err) return callback(err);
 *         try {
 *             configs[key] = JSON.parse(data);
 *         } catch (e) {
 *             return callback(e);
 *         }
 *         callback();
 *     });
 * }, function (err) {
 *     if (err) console.error(err.message);
 *     // configs is now a map of JSON data
 *     doSomethingWith(configs);
 * });
 */
var eachOf = function(coll, iteratee, callback) {
    var eachOfImplementation = isArrayLike(coll) ? eachOfArrayLike : eachOfGeneric;
    eachOfImplementation(coll, wrapAsync(iteratee), callback);
};

function doParallel(fn) {
    return function (obj, iteratee, callback) {
        return fn(eachOf, obj, wrapAsync(iteratee), callback);
    };
}

function _asyncMap(eachfn, arr, iteratee, callback) {
    callback = callback || noop;
    arr = arr || [];
    var results = [];
    var counter = 0;
    var _iteratee = wrapAsync(iteratee);

    eachfn(arr, function (value, _, callback) {
        var index = counter++;
        _iteratee(value, function (err, v) {
            results[index] = v;
            callback(err);
        });
    }, function (err) {
        callback(err, results);
    });
}

/**
 * Produces a new collection of values by mapping each value in `coll` through
 * the `iteratee` function. The `iteratee` is called with an item from `coll`
 * and a callback for when it has finished processing. Each of these callback
 * takes 2 arguments: an `error`, and the transformed item from `coll`. If
 * `iteratee` passes an error to its callback, the main `callback` (for the
 * `map` function) is immediately called with the error.
 *
 * Note, that since this function applies the `iteratee` to each item in
 * parallel, there is no guarantee that the `iteratee` functions will complete
 * in order. However, the results array will be in the same order as the
 * original `coll`.
 *
 * If `map` is passed an Object, the results will be an Array.  The results
 * will roughly be in the order of the original Objects' keys (but this can
 * vary across JavaScript engines).
 *
 * @name map
 * @static
 * @memberOf module:Collections
 * @method
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with the transformed item.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Results is an Array of the
 * transformed items from the `coll`. Invoked with (err, results).
 * @example
 *
 * async.map(['file1','file2','file3'], fs.stat, function(err, results) {
 *     // results is now an array of stats for each file
 * });
 */
var map = doParallel(_asyncMap);

/**
 * Applies the provided arguments to each function in the array, calling
 * `callback` after all functions have completed. If you only provide the first
 * argument, `fns`, then it will return a function which lets you pass in the
 * arguments as if it were a single function call. If more arguments are
 * provided, `callback` is required while `args` is still optional.
 *
 * @name applyEach
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Array|Iterable|Object} fns - A collection of {@link AsyncFunction}s
 * to all call with the same arguments
 * @param {...*} [args] - any number of separate arguments to pass to the
 * function.
 * @param {Function} [callback] - the final argument should be the callback,
 * called when all functions have completed processing.
 * @returns {Function} - If only the first argument, `fns`, is provided, it will
 * return a function which lets you pass in the arguments as if it were a single
 * function call. The signature is `(..args, callback)`. If invoked with any
 * arguments, `callback` is required.
 * @example
 *
 * async.applyEach([enableSearch, updateSchema], 'bucket', callback);
 *
 * // partial application example:
 * async.each(
 *     buckets,
 *     async.applyEach([enableSearch, updateSchema]),
 *     callback
 * );
 */
var applyEach = applyEach$1(map);

function doParallelLimit(fn) {
    return function (obj, limit, iteratee, callback) {
        return fn(_eachOfLimit(limit), obj, wrapAsync(iteratee), callback);
    };
}

/**
 * The same as [`map`]{@link module:Collections.map} but runs a maximum of `limit` async operations at a time.
 *
 * @name mapLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.map]{@link module:Collections.map}
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with the transformed item.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Results is an array of the
 * transformed items from the `coll`. Invoked with (err, results).
 */
var mapLimit = doParallelLimit(_asyncMap);

/**
 * The same as [`map`]{@link module:Collections.map} but runs only a single async operation at a time.
 *
 * @name mapSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.map]{@link module:Collections.map}
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with the transformed item.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Results is an array of the
 * transformed items from the `coll`. Invoked with (err, results).
 */
var mapSeries = doLimit(mapLimit, 1);

/**
 * The same as [`applyEach`]{@link module:ControlFlow.applyEach} but runs only a single async operation at a time.
 *
 * @name applyEachSeries
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.applyEach]{@link module:ControlFlow.applyEach}
 * @category Control Flow
 * @param {Array|Iterable|Object} fns - A collection of {@link AsyncFunction}s to all
 * call with the same arguments
 * @param {...*} [args] - any number of separate arguments to pass to the
 * function.
 * @param {Function} [callback] - the final argument should be the callback,
 * called when all functions have completed processing.
 * @returns {Function} - If only the first argument is provided, it will return
 * a function which lets you pass in the arguments as if it were a single
 * function call.
 */
var applyEachSeries = applyEach$1(mapSeries);

/**
 * A specialized version of `_.forEach` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns `array`.
 */
function arrayEach(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (iteratee(array[index], index, array) === false) {
      break;
    }
  }
  return array;
}

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

/**
 * The base implementation of `_.forOwn` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForOwn(object, iteratee) {
  return object && baseFor(object, iteratee, keys);
}

/**
 * The base implementation of `_.findIndex` and `_.findLastIndex` without
 * support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} predicate The function invoked per iteration.
 * @param {number} fromIndex The index to search from.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseFindIndex(array, predicate, fromIndex, fromRight) {
  var length = array.length,
      index = fromIndex + (fromRight ? 1 : -1);

  while ((fromRight ? index-- : ++index < length)) {
    if (predicate(array[index], index, array)) {
      return index;
    }
  }
  return -1;
}

/**
 * The base implementation of `_.isNaN` without support for number objects.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
 */
function baseIsNaN(value) {
  return value !== value;
}

/**
 * A specialized version of `_.indexOf` which performs strict equality
 * comparisons of values, i.e. `===`.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function strictIndexOf(array, value, fromIndex) {
  var index = fromIndex - 1,
      length = array.length;

  while (++index < length) {
    if (array[index] === value) {
      return index;
    }
  }
  return -1;
}

/**
 * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseIndexOf(array, value, fromIndex) {
  return value === value
    ? strictIndexOf(array, value, fromIndex)
    : baseFindIndex(array, baseIsNaN, fromIndex);
}

/**
 * Determines the best order for running the {@link AsyncFunction}s in `tasks`, based on
 * their requirements. Each function can optionally depend on other functions
 * being completed first, and each function is run as soon as its requirements
 * are satisfied.
 *
 * If any of the {@link AsyncFunction}s pass an error to their callback, the `auto` sequence
 * will stop. Further tasks will not execute (so any other functions depending
 * on it will not run), and the main `callback` is immediately called with the
 * error.
 *
 * {@link AsyncFunction}s also receive an object containing the results of functions which
 * have completed so far as the first argument, if they have dependencies. If a
 * task function has no dependencies, it will only be passed a callback.
 *
 * @name auto
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Object} tasks - An object. Each of its properties is either a
 * function or an array of requirements, with the {@link AsyncFunction} itself the last item
 * in the array. The object's key of a property serves as the name of the task
 * defined by that property, i.e. can be used when specifying requirements for
 * other tasks. The function receives one or two arguments:
 * * a `results` object, containing the results of the previously executed
 *   functions, only passed if the task has any dependencies,
 * * a `callback(err, result)` function, which must be called when finished,
 *   passing an `error` (which can be `null`) and the result of the function's
 *   execution.
 * @param {number} [concurrency=Infinity] - An optional `integer` for
 * determining the maximum number of tasks that can be run in parallel. By
 * default, as many as possible.
 * @param {Function} [callback] - An optional callback which is called when all
 * the tasks have been completed. It receives the `err` argument if any `tasks`
 * pass an error to their callback. Results are always returned; however, if an
 * error occurs, no further `tasks` will be performed, and the results object
 * will only contain partial results. Invoked with (err, results).
 * @returns undefined
 * @example
 *
 * async.auto({
 *     // this function will just be passed a callback
 *     readData: async.apply(fs.readFile, 'data.txt', 'utf-8'),
 *     showData: ['readData', function(results, cb) {
 *         // results.readData is the file's contents
 *         // ...
 *     }]
 * }, callback);
 *
 * async.auto({
 *     get_data: function(callback) {
 *         console.log('in get_data');
 *         // async code to get some data
 *         callback(null, 'data', 'converted to array');
 *     },
 *     make_folder: function(callback) {
 *         console.log('in make_folder');
 *         // async code to create a directory to store a file in
 *         // this is run at the same time as getting the data
 *         callback(null, 'folder');
 *     },
 *     write_file: ['get_data', 'make_folder', function(results, callback) {
 *         console.log('in write_file', JSON.stringify(results));
 *         // once there is some data and the directory exists,
 *         // write the data to a file in the directory
 *         callback(null, 'filename');
 *     }],
 *     email_link: ['write_file', function(results, callback) {
 *         console.log('in email_link', JSON.stringify(results));
 *         // once the file is written let's email a link to it...
 *         // results.write_file contains the filename returned by write_file.
 *         callback(null, {'file':results.write_file, 'email':'user@example.com'});
 *     }]
 * }, function(err, results) {
 *     console.log('err = ', err);
 *     console.log('results = ', results);
 * });
 */
var auto = function (tasks, concurrency, callback) {
    if (typeof concurrency === 'function') {
        // concurrency is optional, shift the args.
        callback = concurrency;
        concurrency = null;
    }
    callback = once(callback || noop);
    var keys$$1 = keys(tasks);
    var numTasks = keys$$1.length;
    if (!numTasks) {
        return callback(null);
    }
    if (!concurrency) {
        concurrency = numTasks;
    }

    var results = {};
    var runningTasks = 0;
    var hasError = false;

    var listeners = Object.create(null);

    var readyTasks = [];

    // for cycle detection:
    var readyToCheck = []; // tasks that have been identified as reachable
    // without the possibility of returning to an ancestor task
    var uncheckedDependencies = {};

    baseForOwn(tasks, function (task, key) {
        if (!isArray(task)) {
            // no dependencies
            enqueueTask(key, [task]);
            readyToCheck.push(key);
            return;
        }

        var dependencies = task.slice(0, task.length - 1);
        var remainingDependencies = dependencies.length;
        if (remainingDependencies === 0) {
            enqueueTask(key, task);
            readyToCheck.push(key);
            return;
        }
        uncheckedDependencies[key] = remainingDependencies;

        arrayEach(dependencies, function (dependencyName) {
            if (!tasks[dependencyName]) {
                throw new Error('async.auto task `' + key +
                    '` has a non-existent dependency `' +
                    dependencyName + '` in ' +
                    dependencies.join(', '));
            }
            addListener(dependencyName, function () {
                remainingDependencies--;
                if (remainingDependencies === 0) {
                    enqueueTask(key, task);
                }
            });
        });
    });

    checkForDeadlocks();
    processQueue();

    function enqueueTask(key, task) {
        readyTasks.push(function () {
            runTask(key, task);
        });
    }

    function processQueue() {
        if (readyTasks.length === 0 && runningTasks === 0) {
            return callback(null, results);
        }
        while(readyTasks.length && runningTasks < concurrency) {
            var run = readyTasks.shift();
            run();
        }

    }

    function addListener(taskName, fn) {
        var taskListeners = listeners[taskName];
        if (!taskListeners) {
            taskListeners = listeners[taskName] = [];
        }

        taskListeners.push(fn);
    }

    function taskComplete(taskName) {
        var taskListeners = listeners[taskName] || [];
        arrayEach(taskListeners, function (fn) {
            fn();
        });
        processQueue();
    }


    function runTask(key, task) {
        if (hasError) return;

        var taskCallback = onlyOnce(function(err, result) {
            runningTasks--;
            if (arguments.length > 2) {
                result = slice(arguments, 1);
            }
            if (err) {
                var safeResults = {};
                baseForOwn(results, function(val, rkey) {
                    safeResults[rkey] = val;
                });
                safeResults[key] = result;
                hasError = true;
                listeners = Object.create(null);

                callback(err, safeResults);
            } else {
                results[key] = result;
                taskComplete(key);
            }
        });

        runningTasks++;
        var taskFn = wrapAsync(task[task.length - 1]);
        if (task.length > 1) {
            taskFn(results, taskCallback);
        } else {
            taskFn(taskCallback);
        }
    }

    function checkForDeadlocks() {
        // Kahn's algorithm
        // https://en.wikipedia.org/wiki/Topological_sorting#Kahn.27s_algorithm
        // http://connalle.blogspot.com/2013/10/topological-sortingkahn-algorithm.html
        var currentTask;
        var counter = 0;
        while (readyToCheck.length) {
            currentTask = readyToCheck.pop();
            counter++;
            arrayEach(getDependents(currentTask), function (dependent) {
                if (--uncheckedDependencies[dependent] === 0) {
                    readyToCheck.push(dependent);
                }
            });
        }

        if (counter !== numTasks) {
            throw new Error(
                'async.auto cannot execute tasks due to a recursive dependency'
            );
        }
    }

    function getDependents(taskName) {
        var result = [];
        baseForOwn(tasks, function (task, key) {
            if (isArray(task) && baseIndexOf(task, taskName, 0) >= 0) {
                result.push(key);
            }
        });
        return result;
    }
};

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol$1 ? Symbol$1.prototype : undefined;
var symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return arrayMap(value, baseToString) + '';
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

/**
 * Casts `array` to a slice if it's needed.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} start The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the cast slice.
 */
function castSlice(array, start, end) {
  var length = array.length;
  end = end === undefined ? length : end;
  return (!start && end >= length) ? array : baseSlice(array, start, end);
}

/**
 * Used by `_.trim` and `_.trimEnd` to get the index of the last string symbol
 * that is not found in the character symbols.
 *
 * @private
 * @param {Array} strSymbols The string symbols to inspect.
 * @param {Array} chrSymbols The character symbols to find.
 * @returns {number} Returns the index of the last unmatched string symbol.
 */
function charsEndIndex(strSymbols, chrSymbols) {
  var index = strSymbols.length;

  while (index-- && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
  return index;
}

/**
 * Used by `_.trim` and `_.trimStart` to get the index of the first string symbol
 * that is not found in the character symbols.
 *
 * @private
 * @param {Array} strSymbols The string symbols to inspect.
 * @param {Array} chrSymbols The character symbols to find.
 * @returns {number} Returns the index of the first unmatched string symbol.
 */
function charsStartIndex(strSymbols, chrSymbols) {
  var index = -1,
      length = strSymbols.length;

  while (++index < length && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
  return index;
}

/**
 * Converts an ASCII `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function asciiToArray(string) {
  return string.split('');
}

/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff';
var rsComboMarksRange = '\\u0300-\\u036f';
var reComboHalfMarksRange = '\\ufe20-\\ufe2f';
var rsComboSymbolsRange = '\\u20d0-\\u20ff';
var rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange;
var rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsZWJ = '\\u200d';

/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');

/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */
function hasUnicode(string) {
  return reHasUnicode.test(string);
}

/** Used to compose unicode character classes. */
var rsAstralRange$1 = '\\ud800-\\udfff';
var rsComboMarksRange$1 = '\\u0300-\\u036f';
var reComboHalfMarksRange$1 = '\\ufe20-\\ufe2f';
var rsComboSymbolsRange$1 = '\\u20d0-\\u20ff';
var rsComboRange$1 = rsComboMarksRange$1 + reComboHalfMarksRange$1 + rsComboSymbolsRange$1;
var rsVarRange$1 = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsAstral = '[' + rsAstralRange$1 + ']';
var rsCombo = '[' + rsComboRange$1 + ']';
var rsFitz = '\\ud83c[\\udffb-\\udfff]';
var rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')';
var rsNonAstral = '[^' + rsAstralRange$1 + ']';
var rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}';
var rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]';
var rsZWJ$1 = '\\u200d';

/** Used to compose unicode regexes. */
var reOptMod = rsModifier + '?';
var rsOptVar = '[' + rsVarRange$1 + ']?';
var rsOptJoin = '(?:' + rsZWJ$1 + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*';
var rsSeq = rsOptVar + reOptMod + rsOptJoin;
var rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

/** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

/**
 * Converts a Unicode `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function unicodeToArray(string) {
  return string.match(reUnicode) || [];
}

/**
 * Converts `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function stringToArray(string) {
  return hasUnicode(string)
    ? unicodeToArray(string)
    : asciiToArray(string);
}

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

/** Used to match leading and trailing whitespace. */
var reTrim = /^\s+|\s+$/g;

/**
 * Removes leading and trailing whitespace or specified characters from `string`.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to trim.
 * @param {string} [chars=whitespace] The characters to trim.
 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
 * @returns {string} Returns the trimmed string.
 * @example
 *
 * _.trim('  abc  ');
 * // => 'abc'
 *
 * _.trim('-_-abc-_-', '_-');
 * // => 'abc'
 *
 * _.map(['  foo  ', '  bar  '], _.trim);
 * // => ['foo', 'bar']
 */
function trim(string, chars, guard) {
  string = toString(string);
  if (string && (guard || chars === undefined)) {
    return string.replace(reTrim, '');
  }
  if (!string || !(chars = baseToString(chars))) {
    return string;
  }
  var strSymbols = stringToArray(string),
      chrSymbols = stringToArray(chars),
      start = charsStartIndex(strSymbols, chrSymbols),
      end = charsEndIndex(strSymbols, chrSymbols) + 1;

  return castSlice(strSymbols, start, end).join('');
}

var FN_ARGS = /^(?:async\s+)?(function)?\s*[^\(]*\(\s*([^\)]*)\)/m;
var FN_ARG_SPLIT = /,/;
var FN_ARG = /(=.+)?(\s*)$/;
var STRIP_COMMENTS = /((\/\/.*$)|(\/\*[\s\S]*?\*\/))/mg;

function parseParams(func) {
    func = func.toString().replace(STRIP_COMMENTS, '');
    func = func.match(FN_ARGS)[2].replace(' ', '');
    func = func ? func.split(FN_ARG_SPLIT) : [];
    func = func.map(function (arg){
        return trim(arg.replace(FN_ARG, ''));
    });
    return func;
}

/**
 * A dependency-injected version of the [async.auto]{@link module:ControlFlow.auto} function. Dependent
 * tasks are specified as parameters to the function, after the usual callback
 * parameter, with the parameter names matching the names of the tasks it
 * depends on. This can provide even more readable task graphs which can be
 * easier to maintain.
 *
 * If a final callback is specified, the task results are similarly injected,
 * specified as named parameters after the initial error parameter.
 *
 * The autoInject function is purely syntactic sugar and its semantics are
 * otherwise equivalent to [async.auto]{@link module:ControlFlow.auto}.
 *
 * @name autoInject
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.auto]{@link module:ControlFlow.auto}
 * @category Control Flow
 * @param {Object} tasks - An object, each of whose properties is an {@link AsyncFunction} of
 * the form 'func([dependencies...], callback). The object's key of a property
 * serves as the name of the task defined by that property, i.e. can be used
 * when specifying requirements for other tasks.
 * * The `callback` parameter is a `callback(err, result)` which must be called
 *   when finished, passing an `error` (which can be `null`) and the result of
 *   the function's execution. The remaining parameters name other tasks on
 *   which the task is dependent, and the results from those tasks are the
 *   arguments of those parameters.
 * @param {Function} [callback] - An optional callback which is called when all
 * the tasks have been completed. It receives the `err` argument if any `tasks`
 * pass an error to their callback, and a `results` object with any completed
 * task results, similar to `auto`.
 * @example
 *
 * //  The example from `auto` can be rewritten as follows:
 * async.autoInject({
 *     get_data: function(callback) {
 *         // async code to get some data
 *         callback(null, 'data', 'converted to array');
 *     },
 *     make_folder: function(callback) {
 *         // async code to create a directory to store a file in
 *         // this is run at the same time as getting the data
 *         callback(null, 'folder');
 *     },
 *     write_file: function(get_data, make_folder, callback) {
 *         // once there is some data and the directory exists,
 *         // write the data to a file in the directory
 *         callback(null, 'filename');
 *     },
 *     email_link: function(write_file, callback) {
 *         // once the file is written let's email a link to it...
 *         // write_file contains the filename returned by write_file.
 *         callback(null, {'file':write_file, 'email':'user@example.com'});
 *     }
 * }, function(err, results) {
 *     console.log('err = ', err);
 *     console.log('email_link = ', results.email_link);
 * });
 *
 * // If you are using a JS minifier that mangles parameter names, `autoInject`
 * // will not work with plain functions, since the parameter names will be
 * // collapsed to a single letter identifier.  To work around this, you can
 * // explicitly specify the names of the parameters your task function needs
 * // in an array, similar to Angular.js dependency injection.
 *
 * // This still has an advantage over plain `auto`, since the results a task
 * // depends on are still spread into arguments.
 * async.autoInject({
 *     //...
 *     write_file: ['get_data', 'make_folder', function(get_data, make_folder, callback) {
 *         callback(null, 'filename');
 *     }],
 *     email_link: ['write_file', function(write_file, callback) {
 *         callback(null, {'file':write_file, 'email':'user@example.com'});
 *     }]
 *     //...
 * }, function(err, results) {
 *     console.log('err = ', err);
 *     console.log('email_link = ', results.email_link);
 * });
 */
function autoInject(tasks, callback) {
    var newTasks = {};

    baseForOwn(tasks, function (taskFn, key) {
        var params;
        var fnIsAsync = isAsync(taskFn);
        var hasNoDeps =
            (!fnIsAsync && taskFn.length === 1) ||
            (fnIsAsync && taskFn.length === 0);

        if (isArray(taskFn)) {
            params = taskFn.slice(0, -1);
            taskFn = taskFn[taskFn.length - 1];

            newTasks[key] = params.concat(params.length > 0 ? newTask : taskFn);
        } else if (hasNoDeps) {
            // no dependencies, use the function as-is
            newTasks[key] = taskFn;
        } else {
            params = parseParams(taskFn);
            if (taskFn.length === 0 && !fnIsAsync && params.length === 0) {
                throw new Error("autoInject task functions require explicit parameters.");
            }

            // remove callback param
            if (!fnIsAsync) params.pop();

            newTasks[key] = params.concat(newTask);
        }

        function newTask(results, taskCb) {
            var newArgs = arrayMap(params, function (name) {
                return results[name];
            });
            newArgs.push(taskCb);
            wrapAsync(taskFn).apply(null, newArgs);
        }
    });

    auto(newTasks, callback);
}

// Simple doubly linked list (https://en.wikipedia.org/wiki/Doubly_linked_list) implementation
// used for queues. This implementation assumes that the node provided by the user can be modified
// to adjust the next and last properties. We implement only the minimal functionality
// for queue support.
function DLL() {
    this.head = this.tail = null;
    this.length = 0;
}

function setInitial(dll, node) {
    dll.length = 1;
    dll.head = dll.tail = node;
}

DLL.prototype.removeLink = function(node) {
    if (node.prev) node.prev.next = node.next;
    else this.head = node.next;
    if (node.next) node.next.prev = node.prev;
    else this.tail = node.prev;

    node.prev = node.next = null;
    this.length -= 1;
    return node;
};

DLL.prototype.empty = function () {
    while(this.head) this.shift();
    return this;
};

DLL.prototype.insertAfter = function(node, newNode) {
    newNode.prev = node;
    newNode.next = node.next;
    if (node.next) node.next.prev = newNode;
    else this.tail = newNode;
    node.next = newNode;
    this.length += 1;
};

DLL.prototype.insertBefore = function(node, newNode) {
    newNode.prev = node.prev;
    newNode.next = node;
    if (node.prev) node.prev.next = newNode;
    else this.head = newNode;
    node.prev = newNode;
    this.length += 1;
};

DLL.prototype.unshift = function(node) {
    if (this.head) this.insertBefore(this.head, node);
    else setInitial(this, node);
};

DLL.prototype.push = function(node) {
    if (this.tail) this.insertAfter(this.tail, node);
    else setInitial(this, node);
};

DLL.prototype.shift = function() {
    return this.head && this.removeLink(this.head);
};

DLL.prototype.pop = function() {
    return this.tail && this.removeLink(this.tail);
};

DLL.prototype.toArray = function () {
    var arr = Array(this.length);
    var curr = this.head;
    for(var idx = 0; idx < this.length; idx++) {
        arr[idx] = curr.data;
        curr = curr.next;
    }
    return arr;
};

DLL.prototype.remove = function (testFn) {
    var curr = this.head;
    while(!!curr) {
        var next = curr.next;
        if (testFn(curr)) {
            this.removeLink(curr);
        }
        curr = next;
    }
    return this;
};

function queue(worker, concurrency, payload) {
    if (concurrency == null) {
        concurrency = 1;
    }
    else if(concurrency === 0) {
        throw new Error('Concurrency must not be zero');
    }

    var _worker = wrapAsync(worker);
    var numRunning = 0;
    var workersList = [];

    var processingScheduled = false;
    function _insert(data, insertAtFront, callback) {
        if (callback != null && typeof callback !== 'function') {
            throw new Error('task callback must be a function');
        }
        q.started = true;
        if (!isArray(data)) {
            data = [data];
        }
        if (data.length === 0 && q.idle()) {
            // call drain immediately if there are no tasks
            return setImmediate$1(function() {
                q.drain();
            });
        }

        for (var i = 0, l = data.length; i < l; i++) {
            var item = {
                data: data[i],
                callback: callback || noop
            };

            if (insertAtFront) {
                q._tasks.unshift(item);
            } else {
                q._tasks.push(item);
            }
        }

        if (!processingScheduled) {
            processingScheduled = true;
            setImmediate$1(function() {
                processingScheduled = false;
                q.process();
            });
        }
    }

    function _next(tasks) {
        return function(err){
            numRunning -= 1;

            for (var i = 0, l = tasks.length; i < l; i++) {
                var task = tasks[i];

                var index = baseIndexOf(workersList, task, 0);
                if (index === 0) {
                    workersList.shift();
                } else if (index > 0) {
                    workersList.splice(index, 1);
                }

                task.callback.apply(task, arguments);

                if (err != null) {
                    q.error(err, task.data);
                }
            }

            if (numRunning <= (q.concurrency - q.buffer) ) {
                q.unsaturated();
            }

            if (q.idle()) {
                q.drain();
            }
            q.process();
        };
    }

    var isProcessing = false;
    var q = {
        _tasks: new DLL(),
        concurrency: concurrency,
        payload: payload,
        saturated: noop,
        unsaturated:noop,
        buffer: concurrency / 4,
        empty: noop,
        drain: noop,
        error: noop,
        started: false,
        paused: false,
        push: function (data, callback) {
            _insert(data, false, callback);
        },
        kill: function () {
            q.drain = noop;
            q._tasks.empty();
        },
        unshift: function (data, callback) {
            _insert(data, true, callback);
        },
        remove: function (testFn) {
            q._tasks.remove(testFn);
        },
        process: function () {
            // Avoid trying to start too many processing operations. This can occur
            // when callbacks resolve synchronously (#1267).
            if (isProcessing) {
                return;
            }
            isProcessing = true;
            while(!q.paused && numRunning < q.concurrency && q._tasks.length){
                var tasks = [], data = [];
                var l = q._tasks.length;
                if (q.payload) l = Math.min(l, q.payload);
                for (var i = 0; i < l; i++) {
                    var node = q._tasks.shift();
                    tasks.push(node);
                    workersList.push(node);
                    data.push(node.data);
                }

                numRunning += 1;

                if (q._tasks.length === 0) {
                    q.empty();
                }

                if (numRunning === q.concurrency) {
                    q.saturated();
                }

                var cb = onlyOnce(_next(tasks));
                _worker(data, cb);
            }
            isProcessing = false;
        },
        length: function () {
            return q._tasks.length;
        },
        running: function () {
            return numRunning;
        },
        workersList: function () {
            return workersList;
        },
        idle: function() {
            return q._tasks.length + numRunning === 0;
        },
        pause: function () {
            q.paused = true;
        },
        resume: function () {
            if (q.paused === false) { return; }
            q.paused = false;
            setImmediate$1(q.process);
        }
    };
    return q;
}

/**
 * A cargo of tasks for the worker function to complete. Cargo inherits all of
 * the same methods and event callbacks as [`queue`]{@link module:ControlFlow.queue}.
 * @typedef {Object} CargoObject
 * @memberOf module:ControlFlow
 * @property {Function} length - A function returning the number of items
 * waiting to be processed. Invoke like `cargo.length()`.
 * @property {number} payload - An `integer` for determining how many tasks
 * should be process per round. This property can be changed after a `cargo` is
 * created to alter the payload on-the-fly.
 * @property {Function} push - Adds `task` to the `queue`. The callback is
 * called once the `worker` has finished processing the task. Instead of a
 * single task, an array of `tasks` can be submitted. The respective callback is
 * used for every task in the list. Invoke like `cargo.push(task, [callback])`.
 * @property {Function} saturated - A callback that is called when the
 * `queue.length()` hits the concurrency and further tasks will be queued.
 * @property {Function} empty - A callback that is called when the last item
 * from the `queue` is given to a `worker`.
 * @property {Function} drain - A callback that is called when the last item
 * from the `queue` has returned from the `worker`.
 * @property {Function} idle - a function returning false if there are items
 * waiting or being processed, or true if not. Invoke like `cargo.idle()`.
 * @property {Function} pause - a function that pauses the processing of tasks
 * until `resume()` is called. Invoke like `cargo.pause()`.
 * @property {Function} resume - a function that resumes the processing of
 * queued tasks when the queue is paused. Invoke like `cargo.resume()`.
 * @property {Function} kill - a function that removes the `drain` callback and
 * empties remaining tasks from the queue forcing it to go idle. Invoke like `cargo.kill()`.
 */

/**
 * Creates a `cargo` object with the specified payload. Tasks added to the
 * cargo will be processed altogether (up to the `payload` limit). If the
 * `worker` is in progress, the task is queued until it becomes available. Once
 * the `worker` has completed some tasks, each callback of those tasks is
 * called. Check out [these](https://camo.githubusercontent.com/6bbd36f4cf5b35a0f11a96dcd2e97711ffc2fb37/68747470733a2f2f662e636c6f75642e6769746875622e636f6d2f6173736574732f313637363837312f36383130382f62626330636662302d356632392d313165322d393734662d3333393763363464633835382e676966) [animations](https://camo.githubusercontent.com/f4810e00e1c5f5f8addbe3e9f49064fd5d102699/68747470733a2f2f662e636c6f75642e6769746875622e636f6d2f6173736574732f313637363837312f36383130312f38346339323036362d356632392d313165322d383134662d3964336430323431336266642e676966)
 * for how `cargo` and `queue` work.
 *
 * While [`queue`]{@link module:ControlFlow.queue} passes only one task to one of a group of workers
 * at a time, cargo passes an array of tasks to a single worker, repeating
 * when the worker is finished.
 *
 * @name cargo
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.queue]{@link module:ControlFlow.queue}
 * @category Control Flow
 * @param {AsyncFunction} worker - An asynchronous function for processing an array
 * of queued tasks. Invoked with `(tasks, callback)`.
 * @param {number} [payload=Infinity] - An optional `integer` for determining
 * how many tasks should be processed per round; if omitted, the default is
 * unlimited.
 * @returns {module:ControlFlow.CargoObject} A cargo object to manage the tasks. Callbacks can
 * attached as certain properties to listen for specific events during the
 * lifecycle of the cargo and inner queue.
 * @example
 *
 * // create a cargo object with payload 2
 * var cargo = async.cargo(function(tasks, callback) {
 *     for (var i=0; i<tasks.length; i++) {
 *         console.log('hello ' + tasks[i].name);
 *     }
 *     callback();
 * }, 2);
 *
 * // add some items
 * cargo.push({name: 'foo'}, function(err) {
 *     console.log('finished processing foo');
 * });
 * cargo.push({name: 'bar'}, function(err) {
 *     console.log('finished processing bar');
 * });
 * cargo.push({name: 'baz'}, function(err) {
 *     console.log('finished processing baz');
 * });
 */
function cargo(worker, payload) {
    return queue(worker, 1, payload);
}

/**
 * The same as [`eachOf`]{@link module:Collections.eachOf} but runs only a single async operation at a time.
 *
 * @name eachOfSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.eachOf]{@link module:Collections.eachOf}
 * @alias forEachOfSeries
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * Invoked with (item, key, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Invoked with (err).
 */
var eachOfSeries = doLimit(eachOfLimit, 1);

/**
 * Reduces `coll` into a single value using an async `iteratee` to return each
 * successive step. `memo` is the initial state of the reduction. This function
 * only operates in series.
 *
 * For performance reasons, it may make sense to split a call to this function
 * into a parallel map, and then use the normal `Array.prototype.reduce` on the
 * results. This function is for situations where each step in the reduction
 * needs to be async; if you can get the data before reducing it, then it's
 * probably a good idea to do so.
 *
 * @name reduce
 * @static
 * @memberOf module:Collections
 * @method
 * @alias inject
 * @alias foldl
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {*} memo - The initial state of the reduction.
 * @param {AsyncFunction} iteratee - A function applied to each item in the
 * array to produce the next step in the reduction.
 * The `iteratee` should complete with the next state of the reduction.
 * If the iteratee complete with an error, the reduction is stopped and the
 * main `callback` is immediately called with the error.
 * Invoked with (memo, item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Result is the reduced value. Invoked with
 * (err, result).
 * @example
 *
 * async.reduce([1,2,3], 0, function(memo, item, callback) {
 *     // pointless async:
 *     process.nextTick(function() {
 *         callback(null, memo + item)
 *     });
 * }, function(err, result) {
 *     // result is now equal to the last value of memo, which is 6
 * });
 */
function reduce(coll, memo, iteratee, callback) {
    callback = once(callback || noop);
    var _iteratee = wrapAsync(iteratee);
    eachOfSeries(coll, function(x, i, callback) {
        _iteratee(memo, x, function(err, v) {
            memo = v;
            callback(err);
        });
    }, function(err) {
        callback(err, memo);
    });
}

/**
 * Version of the compose function that is more natural to read. Each function
 * consumes the return value of the previous function. It is the equivalent of
 * [compose]{@link module:ControlFlow.compose} with the arguments reversed.
 *
 * Each function is executed with the `this` binding of the composed function.
 *
 * @name seq
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.compose]{@link module:ControlFlow.compose}
 * @category Control Flow
 * @param {...AsyncFunction} functions - the asynchronous functions to compose
 * @returns {Function} a function that composes the `functions` in order
 * @example
 *
 * // Requires lodash (or underscore), express3 and dresende's orm2.
 * // Part of an app, that fetches cats of the logged user.
 * // This example uses `seq` function to avoid overnesting and error
 * // handling clutter.
 * app.get('/cats', function(request, response) {
 *     var User = request.models.User;
 *     async.seq(
 *         _.bind(User.get, User),  // 'User.get' has signature (id, callback(err, data))
 *         function(user, fn) {
 *             user.getCats(fn);      // 'getCats' has signature (callback(err, data))
 *         }
 *     )(req.session.user_id, function (err, cats) {
 *         if (err) {
 *             console.error(err);
 *             response.json({ status: 'error', message: err.message });
 *         } else {
 *             response.json({ status: 'ok', message: 'Cats found', data: cats });
 *         }
 *     });
 * });
 */
function seq(/*...functions*/) {
    var _functions = arrayMap(arguments, wrapAsync);
    return function(/*...args*/) {
        var args = slice(arguments);
        var that = this;

        var cb = args[args.length - 1];
        if (typeof cb == 'function') {
            args.pop();
        } else {
            cb = noop;
        }

        reduce(_functions, args, function(newargs, fn, cb) {
            fn.apply(that, newargs.concat(function(err/*, ...nextargs*/) {
                var nextargs = slice(arguments, 1);
                cb(err, nextargs);
            }));
        },
        function(err, results) {
            cb.apply(that, [err].concat(results));
        });
    };
}

/**
 * Creates a function which is a composition of the passed asynchronous
 * functions. Each function consumes the return value of the function that
 * follows. Composing functions `f()`, `g()`, and `h()` would produce the result
 * of `f(g(h()))`, only this version uses callbacks to obtain the return values.
 *
 * Each function is executed with the `this` binding of the composed function.
 *
 * @name compose
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {...AsyncFunction} functions - the asynchronous functions to compose
 * @returns {Function} an asynchronous function that is the composed
 * asynchronous `functions`
 * @example
 *
 * function add1(n, callback) {
 *     setTimeout(function () {
 *         callback(null, n + 1);
 *     }, 10);
 * }
 *
 * function mul3(n, callback) {
 *     setTimeout(function () {
 *         callback(null, n * 3);
 *     }, 10);
 * }
 *
 * var add1mul3 = async.compose(mul3, add1);
 * add1mul3(4, function (err, result) {
 *     // result now equals 15
 * });
 */
var compose = function(/*...args*/) {
    return seq.apply(null, slice(arguments).reverse());
};

var _concat = Array.prototype.concat;

/**
 * The same as [`concat`]{@link module:Collections.concat} but runs a maximum of `limit` async operations at a time.
 *
 * @name concatLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.concat]{@link module:Collections.concat}
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - A function to apply to each item in `coll`,
 * which should use an array as its result. Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished, or an error occurs. Results is an array
 * containing the concatenated results of the `iteratee` function. Invoked with
 * (err, results).
 */
var concatLimit = function(coll, limit, iteratee, callback) {
    callback = callback || noop;
    var _iteratee = wrapAsync(iteratee);
    mapLimit(coll, limit, function(val, callback) {
        _iteratee(val, function(err /*, ...args*/) {
            if (err) return callback(err);
            return callback(null, slice(arguments, 1));
        });
    }, function(err, mapResults) {
        var result = [];
        for (var i = 0; i < mapResults.length; i++) {
            if (mapResults[i]) {
                result = _concat.apply(result, mapResults[i]);
            }
        }

        return callback(err, result);
    });
};

/**
 * Applies `iteratee` to each item in `coll`, concatenating the results. Returns
 * the concatenated list. The `iteratee`s are called in parallel, and the
 * results are concatenated as they return. There is no guarantee that the
 * results array will be returned in the original order of `coll` passed to the
 * `iteratee` function.
 *
 * @name concat
 * @static
 * @memberOf module:Collections
 * @method
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A function to apply to each item in `coll`,
 * which should use an array as its result. Invoked with (item, callback).
 * @param {Function} [callback(err)] - A callback which is called after all the
 * `iteratee` functions have finished, or an error occurs. Results is an array
 * containing the concatenated results of the `iteratee` function. Invoked with
 * (err, results).
 * @example
 *
 * async.concat(['dir1','dir2','dir3'], fs.readdir, function(err, files) {
 *     // files is now a list of filenames that exist in the 3 directories
 * });
 */
var concat = doLimit(concatLimit, Infinity);

/**
 * The same as [`concat`]{@link module:Collections.concat} but runs only a single async operation at a time.
 *
 * @name concatSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.concat]{@link module:Collections.concat}
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A function to apply to each item in `coll`.
 * The iteratee should complete with an array an array of results.
 * Invoked with (item, callback).
 * @param {Function} [callback(err)] - A callback which is called after all the
 * `iteratee` functions have finished, or an error occurs. Results is an array
 * containing the concatenated results of the `iteratee` function. Invoked with
 * (err, results).
 */
var concatSeries = doLimit(concatLimit, 1);

/**
 * Returns a function that when called, calls-back with the values provided.
 * Useful as the first function in a [`waterfall`]{@link module:ControlFlow.waterfall}, or for plugging values in to
 * [`auto`]{@link module:ControlFlow.auto}.
 *
 * @name constant
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {...*} arguments... - Any number of arguments to automatically invoke
 * callback with.
 * @returns {AsyncFunction} Returns a function that when invoked, automatically
 * invokes the callback with the previous given arguments.
 * @example
 *
 * async.waterfall([
 *     async.constant(42),
 *     function (value, next) {
 *         // value === 42
 *     },
 *     //...
 * ], callback);
 *
 * async.waterfall([
 *     async.constant(filename, "utf8"),
 *     fs.readFile,
 *     function (fileData, next) {
 *         //...
 *     }
 *     //...
 * ], callback);
 *
 * async.auto({
 *     hostname: async.constant("https://server.net/"),
 *     port: findFreePort,
 *     launchServer: ["hostname", "port", function (options, cb) {
 *         startServer(options, cb);
 *     }],
 *     //...
 * }, callback);
 */
var constant = function(/*...values*/) {
    var values = slice(arguments);
    var args = [null].concat(values);
    return function (/*...ignoredArgs, callback*/) {
        var callback = arguments[arguments.length - 1];
        return callback.apply(this, args);
    };
};

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

function _createTester(check, getResult) {
    return function(eachfn, arr, iteratee, cb) {
        cb = cb || noop;
        var testPassed = false;
        var testResult;
        eachfn(arr, function(value, _, callback) {
            iteratee(value, function(err, result) {
                if (err) {
                    callback(err);
                } else if (check(result) && !testResult) {
                    testPassed = true;
                    testResult = getResult(true, value);
                    callback(null, breakLoop);
                } else {
                    callback();
                }
            });
        }, function(err) {
            if (err) {
                cb(err);
            } else {
                cb(null, testPassed ? testResult : getResult(false));
            }
        });
    };
}

function _findGetResult(v, x) {
    return x;
}

/**
 * Returns the first value in `coll` that passes an async truth test. The
 * `iteratee` is applied in parallel, meaning the first iteratee to return
 * `true` will fire the detect `callback` with that result. That means the
 * result might not be the first item in the original `coll` (in terms of order)
 * that passes the test.

 * If order within the original `coll` is important, then look at
 * [`detectSeries`]{@link module:Collections.detectSeries}.
 *
 * @name detect
 * @static
 * @memberOf module:Collections
 * @method
 * @alias find
 * @category Collections
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A truth test to apply to each item in `coll`.
 * The iteratee must complete with a boolean value as its result.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called as soon as any
 * iteratee returns `true`, or after all the `iteratee` functions have finished.
 * Result will be the first item in the array that passes the truth test
 * (iteratee) or the value `undefined` if none passed. Invoked with
 * (err, result).
 * @example
 *
 * async.detect(['file1','file2','file3'], function(filePath, callback) {
 *     fs.access(filePath, function(err) {
 *         callback(null, !err)
 *     });
 * }, function(err, result) {
 *     // result now equals the first file in the list that exists
 * });
 */
var detect = doParallel(_createTester(identity, _findGetResult));

/**
 * The same as [`detect`]{@link module:Collections.detect} but runs a maximum of `limit` async operations at a
 * time.
 *
 * @name detectLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.detect]{@link module:Collections.detect}
 * @alias findLimit
 * @category Collections
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - A truth test to apply to each item in `coll`.
 * The iteratee must complete with a boolean value as its result.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called as soon as any
 * iteratee returns `true`, or after all the `iteratee` functions have finished.
 * Result will be the first item in the array that passes the truth test
 * (iteratee) or the value `undefined` if none passed. Invoked with
 * (err, result).
 */
var detectLimit = doParallelLimit(_createTester(identity, _findGetResult));

/**
 * The same as [`detect`]{@link module:Collections.detect} but runs only a single async operation at a time.
 *
 * @name detectSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.detect]{@link module:Collections.detect}
 * @alias findSeries
 * @category Collections
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A truth test to apply to each item in `coll`.
 * The iteratee must complete with a boolean value as its result.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called as soon as any
 * iteratee returns `true`, or after all the `iteratee` functions have finished.
 * Result will be the first item in the array that passes the truth test
 * (iteratee) or the value `undefined` if none passed. Invoked with
 * (err, result).
 */
var detectSeries = doLimit(detectLimit, 1);

function consoleFunc(name) {
    return function (fn/*, ...args*/) {
        var args = slice(arguments, 1);
        args.push(function (err/*, ...args*/) {
            var args = slice(arguments, 1);
            if (typeof console === 'object') {
                if (err) {
                    if (console.error) {
                        console.error(err);
                    }
                } else if (console[name]) {
                    arrayEach(args, function (x) {
                        console[name](x);
                    });
                }
            }
        });
        wrapAsync(fn).apply(null, args);
    };
}

/**
 * Logs the result of an [`async` function]{@link AsyncFunction} to the
 * `console` using `console.dir` to display the properties of the resulting object.
 * Only works in Node.js or in browsers that support `console.dir` and
 * `console.error` (such as FF and Chrome).
 * If multiple arguments are returned from the async function,
 * `console.dir` is called on each argument in order.
 *
 * @name dir
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {AsyncFunction} function - The function you want to eventually apply
 * all arguments to.
 * @param {...*} arguments... - Any number of arguments to apply to the function.
 * @example
 *
 * // in a module
 * var hello = function(name, callback) {
 *     setTimeout(function() {
 *         callback(null, {hello: name});
 *     }, 1000);
 * };
 *
 * // in the node repl
 * node> async.dir(hello, 'world');
 * {hello: 'world'}
 */
var dir = consoleFunc('dir');

/**
 * The post-check version of [`during`]{@link module:ControlFlow.during}. To reflect the difference in
 * the order of operations, the arguments `test` and `fn` are switched.
 *
 * Also a version of [`doWhilst`]{@link module:ControlFlow.doWhilst} with asynchronous `test` function.
 * @name doDuring
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.during]{@link module:ControlFlow.during}
 * @category Control Flow
 * @param {AsyncFunction} fn - An async function which is called each time
 * `test` passes. Invoked with (callback).
 * @param {AsyncFunction} test - asynchronous truth test to perform before each
 * execution of `fn`. Invoked with (...args, callback), where `...args` are the
 * non-error args from the previous callback of `fn`.
 * @param {Function} [callback] - A callback which is called after the test
 * function has failed and repeated execution of `fn` has stopped. `callback`
 * will be passed an error if one occurred, otherwise `null`.
 */
function doDuring(fn, test, callback) {
    callback = onlyOnce(callback || noop);
    var _fn = wrapAsync(fn);
    var _test = wrapAsync(test);

    function next(err/*, ...args*/) {
        if (err) return callback(err);
        var args = slice(arguments, 1);
        args.push(check);
        _test.apply(this, args);
    }

    function check(err, truth) {
        if (err) return callback(err);
        if (!truth) return callback(null);
        _fn(next);
    }

    check(null, true);

}

/**
 * The post-check version of [`whilst`]{@link module:ControlFlow.whilst}. To reflect the difference in
 * the order of operations, the arguments `test` and `iteratee` are switched.
 *
 * `doWhilst` is to `whilst` as `do while` is to `while` in plain JavaScript.
 *
 * @name doWhilst
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.whilst]{@link module:ControlFlow.whilst}
 * @category Control Flow
 * @param {AsyncFunction} iteratee - A function which is called each time `test`
 * passes. Invoked with (callback).
 * @param {Function} test - synchronous truth test to perform after each
 * execution of `iteratee`. Invoked with any non-error callback results of
 * `iteratee`.
 * @param {Function} [callback] - A callback which is called after the test
 * function has failed and repeated execution of `iteratee` has stopped.
 * `callback` will be passed an error and any arguments passed to the final
 * `iteratee`'s callback. Invoked with (err, [results]);
 */
function doWhilst(iteratee, test, callback) {
    callback = onlyOnce(callback || noop);
    var _iteratee = wrapAsync(iteratee);
    var next = function(err/*, ...args*/) {
        if (err) return callback(err);
        var args = slice(arguments, 1);
        if (test.apply(this, args)) return _iteratee(next);
        callback.apply(null, [null].concat(args));
    };
    _iteratee(next);
}

/**
 * Like ['doWhilst']{@link module:ControlFlow.doWhilst}, except the `test` is inverted. Note the
 * argument ordering differs from `until`.
 *
 * @name doUntil
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.doWhilst]{@link module:ControlFlow.doWhilst}
 * @category Control Flow
 * @param {AsyncFunction} iteratee - An async function which is called each time
 * `test` fails. Invoked with (callback).
 * @param {Function} test - synchronous truth test to perform after each
 * execution of `iteratee`. Invoked with any non-error callback results of
 * `iteratee`.
 * @param {Function} [callback] - A callback which is called after the test
 * function has passed and repeated execution of `iteratee` has stopped. `callback`
 * will be passed an error and any arguments passed to the final `iteratee`'s
 * callback. Invoked with (err, [results]);
 */
function doUntil(iteratee, test, callback) {
    doWhilst(iteratee, function() {
        return !test.apply(this, arguments);
    }, callback);
}

/**
 * Like [`whilst`]{@link module:ControlFlow.whilst}, except the `test` is an asynchronous function that
 * is passed a callback in the form of `function (err, truth)`. If error is
 * passed to `test` or `fn`, the main callback is immediately called with the
 * value of the error.
 *
 * @name during
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.whilst]{@link module:ControlFlow.whilst}
 * @category Control Flow
 * @param {AsyncFunction} test - asynchronous truth test to perform before each
 * execution of `fn`. Invoked with (callback).
 * @param {AsyncFunction} fn - An async function which is called each time
 * `test` passes. Invoked with (callback).
 * @param {Function} [callback] - A callback which is called after the test
 * function has failed and repeated execution of `fn` has stopped. `callback`
 * will be passed an error, if one occurred, otherwise `null`.
 * @example
 *
 * var count = 0;
 *
 * async.during(
 *     function (callback) {
 *         return callback(null, count < 5);
 *     },
 *     function (callback) {
 *         count++;
 *         setTimeout(callback, 1000);
 *     },
 *     function (err) {
 *         // 5 seconds have passed
 *     }
 * );
 */
function during(test, fn, callback) {
    callback = onlyOnce(callback || noop);
    var _fn = wrapAsync(fn);
    var _test = wrapAsync(test);

    function next(err) {
        if (err) return callback(err);
        _test(check);
    }

    function check(err, truth) {
        if (err) return callback(err);
        if (!truth) return callback(null);
        _fn(next);
    }

    _test(check);
}

function _withoutIndex(iteratee) {
    return function (value, index, callback) {
        return iteratee(value, callback);
    };
}

/**
 * Applies the function `iteratee` to each item in `coll`, in parallel.
 * The `iteratee` is called with an item from the list, and a callback for when
 * it has finished. If the `iteratee` passes an error to its `callback`, the
 * main `callback` (for the `each` function) is immediately called with the
 * error.
 *
 * Note, that since this function applies `iteratee` to each item in parallel,
 * there is no guarantee that the iteratee functions will complete in order.
 *
 * @name each
 * @static
 * @memberOf module:Collections
 * @method
 * @alias forEach
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to
 * each item in `coll`. Invoked with (item, callback).
 * The array index is not passed to the iteratee.
 * If you need the index, use `eachOf`.
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 * @example
 *
 * // assuming openFiles is an array of file names and saveFile is a function
 * // to save the modified contents of that file:
 *
 * async.each(openFiles, saveFile, function(err){
 *   // if any of the saves produced an error, err would equal that error
 * });
 *
 * // assuming openFiles is an array of file names
 * async.each(openFiles, function(file, callback) {
 *
 *     // Perform operation on file here.
 *     console.log('Processing file ' + file);
 *
 *     if( file.length > 32 ) {
 *       console.log('This file name is too long');
 *       callback('File name too long');
 *     } else {
 *       // Do work to process file here
 *       console.log('File processed');
 *       callback();
 *     }
 * }, function(err) {
 *     // if any of the file processing produced an error, err would equal that error
 *     if( err ) {
 *       // One of the iterations produced an error.
 *       // All processing will now stop.
 *       console.log('A file failed to process');
 *     } else {
 *       console.log('All files have been processed successfully');
 *     }
 * });
 */
function eachLimit(coll, iteratee, callback) {
    eachOf(coll, _withoutIndex(wrapAsync(iteratee)), callback);
}

/**
 * The same as [`each`]{@link module:Collections.each} but runs a maximum of `limit` async operations at a time.
 *
 * @name eachLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.each]{@link module:Collections.each}
 * @alias forEachLimit
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The array index is not passed to the iteratee.
 * If you need the index, use `eachOfLimit`.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 */
function eachLimit$1(coll, limit, iteratee, callback) {
    _eachOfLimit(limit)(coll, _withoutIndex(wrapAsync(iteratee)), callback);
}

/**
 * The same as [`each`]{@link module:Collections.each} but runs only a single async operation at a time.
 *
 * @name eachSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.each]{@link module:Collections.each}
 * @alias forEachSeries
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each
 * item in `coll`.
 * The array index is not passed to the iteratee.
 * If you need the index, use `eachOfSeries`.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 */
var eachSeries = doLimit(eachLimit$1, 1);

/**
 * Wrap an async function and ensure it calls its callback on a later tick of
 * the event loop.  If the function already calls its callback on a next tick,
 * no extra deferral is added. This is useful for preventing stack overflows
 * (`RangeError: Maximum call stack size exceeded`) and generally keeping
 * [Zalgo](http://blog.izs.me/post/59142742143/designing-apis-for-asynchrony)
 * contained. ES2017 `async` functions are returned as-is -- they are immune
 * to Zalgo's corrupting influences, as they always resolve on a later tick.
 *
 * @name ensureAsync
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {AsyncFunction} fn - an async function, one that expects a node-style
 * callback as its last argument.
 * @returns {AsyncFunction} Returns a wrapped function with the exact same call
 * signature as the function passed in.
 * @example
 *
 * function sometimesAsync(arg, callback) {
 *     if (cache[arg]) {
 *         return callback(null, cache[arg]); // this would be synchronous!!
 *     } else {
 *         doSomeIO(arg, callback); // this IO would be asynchronous
 *     }
 * }
 *
 * // this has a risk of stack overflows if many results are cached in a row
 * async.mapSeries(args, sometimesAsync, done);
 *
 * // this will defer sometimesAsync's callback if necessary,
 * // preventing stack overflows
 * async.mapSeries(args, async.ensureAsync(sometimesAsync), done);
 */
function ensureAsync(fn) {
    if (isAsync(fn)) return fn;
    return initialParams(function (args, callback) {
        var sync = true;
        args.push(function () {
            var innerArgs = arguments;
            if (sync) {
                setImmediate$1(function () {
                    callback.apply(null, innerArgs);
                });
            } else {
                callback.apply(null, innerArgs);
            }
        });
        fn.apply(this, args);
        sync = false;
    });
}

function notId(v) {
    return !v;
}

/**
 * Returns `true` if every element in `coll` satisfies an async test. If any
 * iteratee call returns `false`, the main `callback` is immediately called.
 *
 * @name every
 * @static
 * @memberOf module:Collections
 * @method
 * @alias all
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async truth test to apply to each item
 * in the collection in parallel.
 * The iteratee must complete with a boolean result value.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Result will be either `true` or `false`
 * depending on the values of the async tests. Invoked with (err, result).
 * @example
 *
 * async.every(['file1','file2','file3'], function(filePath, callback) {
 *     fs.access(filePath, function(err) {
 *         callback(null, !err)
 *     });
 * }, function(err, result) {
 *     // if result is true then every file exists
 * });
 */
var every = doParallel(_createTester(notId, notId));

/**
 * The same as [`every`]{@link module:Collections.every} but runs a maximum of `limit` async operations at a time.
 *
 * @name everyLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.every]{@link module:Collections.every}
 * @alias allLimit
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async truth test to apply to each item
 * in the collection in parallel.
 * The iteratee must complete with a boolean result value.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Result will be either `true` or `false`
 * depending on the values of the async tests. Invoked with (err, result).
 */
var everyLimit = doParallelLimit(_createTester(notId, notId));

/**
 * The same as [`every`]{@link module:Collections.every} but runs only a single async operation at a time.
 *
 * @name everySeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.every]{@link module:Collections.every}
 * @alias allSeries
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async truth test to apply to each item
 * in the collection in series.
 * The iteratee must complete with a boolean result value.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Result will be either `true` or `false`
 * depending on the values of the async tests. Invoked with (err, result).
 */
var everySeries = doLimit(everyLimit, 1);

/**
 * The base implementation of `_.property` without support for deep paths.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function baseProperty(key) {
  return function(object) {
    return object == null ? undefined : object[key];
  };
}

function filterArray(eachfn, arr, iteratee, callback) {
    var truthValues = new Array(arr.length);
    eachfn(arr, function (x, index, callback) {
        iteratee(x, function (err, v) {
            truthValues[index] = !!v;
            callback(err);
        });
    }, function (err) {
        if (err) return callback(err);
        var results = [];
        for (var i = 0; i < arr.length; i++) {
            if (truthValues[i]) results.push(arr[i]);
        }
        callback(null, results);
    });
}

function filterGeneric(eachfn, coll, iteratee, callback) {
    var results = [];
    eachfn(coll, function (x, index, callback) {
        iteratee(x, function (err, v) {
            if (err) {
                callback(err);
            } else {
                if (v) {
                    results.push({index: index, value: x});
                }
                callback();
            }
        });
    }, function (err) {
        if (err) {
            callback(err);
        } else {
            callback(null, arrayMap(results.sort(function (a, b) {
                return a.index - b.index;
            }), baseProperty('value')));
        }
    });
}

function _filter(eachfn, coll, iteratee, callback) {
    var filter = isArrayLike(coll) ? filterArray : filterGeneric;
    filter(eachfn, coll, wrapAsync(iteratee), callback || noop);
}

/**
 * Returns a new array of all the values in `coll` which pass an async truth
 * test. This operation is performed in parallel, but the results array will be
 * in the same order as the original.
 *
 * @name filter
 * @static
 * @memberOf module:Collections
 * @method
 * @alias select
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {Function} iteratee - A truth test to apply to each item in `coll`.
 * The `iteratee` is passed a `callback(err, truthValue)`, which must be called
 * with a boolean argument once it has completed. Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Invoked with (err, results).
 * @example
 *
 * async.filter(['file1','file2','file3'], function(filePath, callback) {
 *     fs.access(filePath, function(err) {
 *         callback(null, !err)
 *     });
 * }, function(err, results) {
 *     // results now equals an array of the existing files
 * });
 */
var filter = doParallel(_filter);

/**
 * The same as [`filter`]{@link module:Collections.filter} but runs a maximum of `limit` async operations at a
 * time.
 *
 * @name filterLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.filter]{@link module:Collections.filter}
 * @alias selectLimit
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {Function} iteratee - A truth test to apply to each item in `coll`.
 * The `iteratee` is passed a `callback(err, truthValue)`, which must be called
 * with a boolean argument once it has completed. Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Invoked with (err, results).
 */
var filterLimit = doParallelLimit(_filter);

/**
 * The same as [`filter`]{@link module:Collections.filter} but runs only a single async operation at a time.
 *
 * @name filterSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.filter]{@link module:Collections.filter}
 * @alias selectSeries
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {Function} iteratee - A truth test to apply to each item in `coll`.
 * The `iteratee` is passed a `callback(err, truthValue)`, which must be called
 * with a boolean argument once it has completed. Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Invoked with (err, results)
 */
var filterSeries = doLimit(filterLimit, 1);

/**
 * Calls the asynchronous function `fn` with a callback parameter that allows it
 * to call itself again, in series, indefinitely.

 * If an error is passed to the callback then `errback` is called with the
 * error, and execution stops, otherwise it will never be called.
 *
 * @name forever
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {AsyncFunction} fn - an async function to call repeatedly.
 * Invoked with (next).
 * @param {Function} [errback] - when `fn` passes an error to it's callback,
 * this function will be called, and execution stops. Invoked with (err).
 * @example
 *
 * async.forever(
 *     function(next) {
 *         // next is suitable for passing to things that need a callback(err [, whatever]);
 *         // it will result in this function being called again.
 *     },
 *     function(err) {
 *         // if next is called with a value in its first parameter, it will appear
 *         // in here as 'err', and execution will stop.
 *     }
 * );
 */
function forever(fn, errback) {
    var done = onlyOnce(errback || noop);
    var task = wrapAsync(ensureAsync(fn));

    function next(err) {
        if (err) return done(err);
        task(next);
    }
    next();
}

/**
 * The same as [`groupBy`]{@link module:Collections.groupBy} but runs a maximum of `limit` async operations at a time.
 *
 * @name groupByLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.groupBy]{@link module:Collections.groupBy}
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with a `key` to group the value under.
 * Invoked with (value, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Result is an `Object` whoses
 * properties are arrays of values which returned the corresponding key.
 */
var groupByLimit = function(coll, limit, iteratee, callback) {
    callback = callback || noop;
    var _iteratee = wrapAsync(iteratee);
    mapLimit(coll, limit, function(val, callback) {
        _iteratee(val, function(err, key) {
            if (err) return callback(err);
            return callback(null, {key: key, val: val});
        });
    }, function(err, mapResults) {
        var result = {};
        // from MDN, handle object having an `hasOwnProperty` prop
        var hasOwnProperty = Object.prototype.hasOwnProperty;

        for (var i = 0; i < mapResults.length; i++) {
            if (mapResults[i]) {
                var key = mapResults[i].key;
                var val = mapResults[i].val;

                if (hasOwnProperty.call(result, key)) {
                    result[key].push(val);
                } else {
                    result[key] = [val];
                }
            }
        }

        return callback(err, result);
    });
};

/**
 * Returns a new object, where each value corresponds to an array of items, from
 * `coll`, that returned the corresponding key. That is, the keys of the object
 * correspond to the values passed to the `iteratee` callback.
 *
 * Note: Since this function applies the `iteratee` to each item in parallel,
 * there is no guarantee that the `iteratee` functions will complete in order.
 * However, the values for each key in the `result` will be in the same order as
 * the original `coll`. For Objects, the values will roughly be in the order of
 * the original Objects' keys (but this can vary across JavaScript engines).
 *
 * @name groupBy
 * @static
 * @memberOf module:Collections
 * @method
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with a `key` to group the value under.
 * Invoked with (value, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Result is an `Object` whoses
 * properties are arrays of values which returned the corresponding key.
 * @example
 *
 * async.groupBy(['userId1', 'userId2', 'userId3'], function(userId, callback) {
 *     db.findById(userId, function(err, user) {
 *         if (err) return callback(err);
 *         return callback(null, user.age);
 *     });
 * }, function(err, result) {
 *     // result is object containing the userIds grouped by age
 *     // e.g. { 30: ['userId1', 'userId3'], 42: ['userId2']};
 * });
 */
var groupBy = doLimit(groupByLimit, Infinity);

/**
 * The same as [`groupBy`]{@link module:Collections.groupBy} but runs only a single async operation at a time.
 *
 * @name groupBySeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.groupBy]{@link module:Collections.groupBy}
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with a `key` to group the value under.
 * Invoked with (value, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Result is an `Object` whoses
 * properties are arrays of values which returned the corresponding key.
 */
var groupBySeries = doLimit(groupByLimit, 1);

/**
 * Logs the result of an `async` function to the `console`. Only works in
 * Node.js or in browsers that support `console.log` and `console.error` (such
 * as FF and Chrome). If multiple arguments are returned from the async
 * function, `console.log` is called on each argument in order.
 *
 * @name log
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {AsyncFunction} function - The function you want to eventually apply
 * all arguments to.
 * @param {...*} arguments... - Any number of arguments to apply to the function.
 * @example
 *
 * // in a module
 * var hello = function(name, callback) {
 *     setTimeout(function() {
 *         callback(null, 'hello ' + name);
 *     }, 1000);
 * };
 *
 * // in the node repl
 * node> async.log(hello, 'world');
 * 'hello world'
 */
var log = consoleFunc('log');

/**
 * The same as [`mapValues`]{@link module:Collections.mapValues} but runs a maximum of `limit` async operations at a
 * time.
 *
 * @name mapValuesLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.mapValues]{@link module:Collections.mapValues}
 * @category Collection
 * @param {Object} obj - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - A function to apply to each value and key
 * in `coll`.
 * The iteratee should complete with the transformed value as its result.
 * Invoked with (value, key, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. `result` is a new object consisting
 * of each key from `obj`, with each transformed value on the right-hand side.
 * Invoked with (err, result).
 */
function mapValuesLimit(obj, limit, iteratee, callback) {
    callback = once(callback || noop);
    var newObj = {};
    var _iteratee = wrapAsync(iteratee);
    eachOfLimit(obj, limit, function(val, key, next) {
        _iteratee(val, key, function (err, result) {
            if (err) return next(err);
            newObj[key] = result;
            next();
        });
    }, function (err) {
        callback(err, newObj);
    });
}

/**
 * A relative of [`map`]{@link module:Collections.map}, designed for use with objects.
 *
 * Produces a new Object by mapping each value of `obj` through the `iteratee`
 * function. The `iteratee` is called each `value` and `key` from `obj` and a
 * callback for when it has finished processing. Each of these callbacks takes
 * two arguments: an `error`, and the transformed item from `obj`. If `iteratee`
 * passes an error to its callback, the main `callback` (for the `mapValues`
 * function) is immediately called with the error.
 *
 * Note, the order of the keys in the result is not guaranteed.  The keys will
 * be roughly in the order they complete, (but this is very engine-specific)
 *
 * @name mapValues
 * @static
 * @memberOf module:Collections
 * @method
 * @category Collection
 * @param {Object} obj - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A function to apply to each value and key
 * in `coll`.
 * The iteratee should complete with the transformed value as its result.
 * Invoked with (value, key, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. `result` is a new object consisting
 * of each key from `obj`, with each transformed value on the right-hand side.
 * Invoked with (err, result).
 * @example
 *
 * async.mapValues({
 *     f1: 'file1',
 *     f2: 'file2',
 *     f3: 'file3'
 * }, function (file, key, callback) {
 *   fs.stat(file, callback);
 * }, function(err, result) {
 *     // result is now a map of stats for each file, e.g.
 *     // {
 *     //     f1: [stats for file1],
 *     //     f2: [stats for file2],
 *     //     f3: [stats for file3]
 *     // }
 * });
 */

var mapValues = doLimit(mapValuesLimit, Infinity);

/**
 * The same as [`mapValues`]{@link module:Collections.mapValues} but runs only a single async operation at a time.
 *
 * @name mapValuesSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.mapValues]{@link module:Collections.mapValues}
 * @category Collection
 * @param {Object} obj - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A function to apply to each value and key
 * in `coll`.
 * The iteratee should complete with the transformed value as its result.
 * Invoked with (value, key, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. `result` is a new object consisting
 * of each key from `obj`, with each transformed value on the right-hand side.
 * Invoked with (err, result).
 */
var mapValuesSeries = doLimit(mapValuesLimit, 1);

function has(obj, key) {
    return key in obj;
}

/**
 * Caches the results of an async function. When creating a hash to store
 * function results against, the callback is omitted from the hash and an
 * optional hash function can be used.
 *
 * If no hash function is specified, the first argument is used as a hash key,
 * which may work reasonably if it is a string or a data type that converts to a
 * distinct string. Note that objects and arrays will not behave reasonably.
 * Neither will cases where the other arguments are significant. In such cases,
 * specify your own hash function.
 *
 * The cache of results is exposed as the `memo` property of the function
 * returned by `memoize`.
 *
 * @name memoize
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {AsyncFunction} fn - The async function to proxy and cache results from.
 * @param {Function} hasher - An optional function for generating a custom hash
 * for storing results. It has all the arguments applied to it apart from the
 * callback, and must be synchronous.
 * @returns {AsyncFunction} a memoized version of `fn`
 * @example
 *
 * var slow_fn = function(name, callback) {
 *     // do something
 *     callback(null, result);
 * };
 * var fn = async.memoize(slow_fn);
 *
 * // fn can now be used as if it were slow_fn
 * fn('some name', function() {
 *     // callback
 * });
 */
function memoize(fn, hasher) {
    var memo = Object.create(null);
    var queues = Object.create(null);
    hasher = hasher || identity;
    var _fn = wrapAsync(fn);
    var memoized = initialParams(function memoized(args, callback) {
        var key = hasher.apply(null, args);
        if (has(memo, key)) {
            setImmediate$1(function() {
                callback.apply(null, memo[key]);
            });
        } else if (has(queues, key)) {
            queues[key].push(callback);
        } else {
            queues[key] = [callback];
            _fn.apply(null, args.concat(function(/*args*/) {
                var args = slice(arguments);
                memo[key] = args;
                var q = queues[key];
                delete queues[key];
                for (var i = 0, l = q.length; i < l; i++) {
                    q[i].apply(null, args);
                }
            }));
        }
    });
    memoized.memo = memo;
    memoized.unmemoized = fn;
    return memoized;
}

/**
 * Calls `callback` on a later loop around the event loop. In Node.js this just
 * calls `process.nextTick`.  In the browser it will use `setImmediate` if
 * available, otherwise `setTimeout(callback, 0)`, which means other higher
 * priority events may precede the execution of `callback`.
 *
 * This is used internally for browser-compatibility purposes.
 *
 * @name nextTick
 * @static
 * @memberOf module:Utils
 * @method
 * @see [async.setImmediate]{@link module:Utils.setImmediate}
 * @category Util
 * @param {Function} callback - The function to call on a later loop around
 * the event loop. Invoked with (args...).
 * @param {...*} args... - any number of additional arguments to pass to the
 * callback on the next tick.
 * @example
 *
 * var call_order = [];
 * async.nextTick(function() {
 *     call_order.push('two');
 *     // call_order now equals ['one','two']
 * });
 * call_order.push('one');
 *
 * async.setImmediate(function (a, b, c) {
 *     // a, b, and c equal 1, 2, and 3
 * }, 1, 2, 3);
 */
var _defer$1;

if (hasNextTick) {
    _defer$1 = process.nextTick;
} else if (hasSetImmediate) {
    _defer$1 = setImmediate;
} else {
    _defer$1 = fallback;
}

var nextTick = wrap(_defer$1);

function _parallel(eachfn, tasks, callback) {
    callback = callback || noop;
    var results = isArrayLike(tasks) ? [] : {};

    eachfn(tasks, function (task, key, callback) {
        wrapAsync(task)(function (err, result) {
            if (arguments.length > 2) {
                result = slice(arguments, 1);
            }
            results[key] = result;
            callback(err);
        });
    }, function (err) {
        callback(err, results);
    });
}

/**
 * Run the `tasks` collection of functions in parallel, without waiting until
 * the previous function has completed. If any of the functions pass an error to
 * its callback, the main `callback` is immediately called with the value of the
 * error. Once the `tasks` have completed, the results are passed to the final
 * `callback` as an array.
 *
 * **Note:** `parallel` is about kicking-off I/O tasks in parallel, not about
 * parallel execution of code.  If your tasks do not use any timers or perform
 * any I/O, they will actually be executed in series.  Any synchronous setup
 * sections for each task will happen one after the other.  JavaScript remains
 * single-threaded.
 *
 * **Hint:** Use [`reflect`]{@link module:Utils.reflect} to continue the
 * execution of other tasks when a task fails.
 *
 * It is also possible to use an object instead of an array. Each property will
 * be run as a function and the results will be passed to the final `callback`
 * as an object instead of an array. This can be a more readable way of handling
 * results from {@link async.parallel}.
 *
 * @name parallel
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Array|Iterable|Object} tasks - A collection of
 * [async functions]{@link AsyncFunction} to run.
 * Each async function can complete with any number of optional `result` values.
 * @param {Function} [callback] - An optional callback to run once all the
 * functions have completed successfully. This function gets a results array
 * (or object) containing all the result arguments passed to the task callbacks.
 * Invoked with (err, results).
 *
 * @example
 * async.parallel([
 *     function(callback) {
 *         setTimeout(function() {
 *             callback(null, 'one');
 *         }, 200);
 *     },
 *     function(callback) {
 *         setTimeout(function() {
 *             callback(null, 'two');
 *         }, 100);
 *     }
 * ],
 * // optional callback
 * function(err, results) {
 *     // the results array will equal ['one','two'] even though
 *     // the second function had a shorter timeout.
 * });
 *
 * // an example using an object instead of an array
 * async.parallel({
 *     one: function(callback) {
 *         setTimeout(function() {
 *             callback(null, 1);
 *         }, 200);
 *     },
 *     two: function(callback) {
 *         setTimeout(function() {
 *             callback(null, 2);
 *         }, 100);
 *     }
 * }, function(err, results) {
 *     // results is now equals to: {one: 1, two: 2}
 * });
 */
function parallelLimit(tasks, callback) {
    _parallel(eachOf, tasks, callback);
}

/**
 * The same as [`parallel`]{@link module:ControlFlow.parallel} but runs a maximum of `limit` async operations at a
 * time.
 *
 * @name parallelLimit
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.parallel]{@link module:ControlFlow.parallel}
 * @category Control Flow
 * @param {Array|Iterable|Object} tasks - A collection of
 * [async functions]{@link AsyncFunction} to run.
 * Each async function can complete with any number of optional `result` values.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {Function} [callback] - An optional callback to run once all the
 * functions have completed successfully. This function gets a results array
 * (or object) containing all the result arguments passed to the task callbacks.
 * Invoked with (err, results).
 */
function parallelLimit$1(tasks, limit, callback) {
    _parallel(_eachOfLimit(limit), tasks, callback);
}

/**
 * A queue of tasks for the worker function to complete.
 * @typedef {Object} QueueObject
 * @memberOf module:ControlFlow
 * @property {Function} length - a function returning the number of items
 * waiting to be processed. Invoke with `queue.length()`.
 * @property {boolean} started - a boolean indicating whether or not any
 * items have been pushed and processed by the queue.
 * @property {Function} running - a function returning the number of items
 * currently being processed. Invoke with `queue.running()`.
 * @property {Function} workersList - a function returning the array of items
 * currently being processed. Invoke with `queue.workersList()`.
 * @property {Function} idle - a function returning false if there are items
 * waiting or being processed, or true if not. Invoke with `queue.idle()`.
 * @property {number} concurrency - an integer for determining how many `worker`
 * functions should be run in parallel. This property can be changed after a
 * `queue` is created to alter the concurrency on-the-fly.
 * @property {Function} push - add a new task to the `queue`. Calls `callback`
 * once the `worker` has finished processing the task. Instead of a single task,
 * a `tasks` array can be submitted. The respective callback is used for every
 * task in the list. Invoke with `queue.push(task, [callback])`,
 * @property {Function} unshift - add a new task to the front of the `queue`.
 * Invoke with `queue.unshift(task, [callback])`.
 * @property {Function} remove - remove items from the queue that match a test
 * function.  The test function will be passed an object with a `data` property,
 * and a `priority` property, if this is a
 * [priorityQueue]{@link module:ControlFlow.priorityQueue} object.
 * Invoked with `queue.remove(testFn)`, where `testFn` is of the form
 * `function ({data, priority}) {}` and returns a Boolean.
 * @property {Function} saturated - a callback that is called when the number of
 * running workers hits the `concurrency` limit, and further tasks will be
 * queued.
 * @property {Function} unsaturated - a callback that is called when the number
 * of running workers is less than the `concurrency` & `buffer` limits, and
 * further tasks will not be queued.
 * @property {number} buffer - A minimum threshold buffer in order to say that
 * the `queue` is `unsaturated`.
 * @property {Function} empty - a callback that is called when the last item
 * from the `queue` is given to a `worker`.
 * @property {Function} drain - a callback that is called when the last item
 * from the `queue` has returned from the `worker`.
 * @property {Function} error - a callback that is called when a task errors.
 * Has the signature `function(error, task)`.
 * @property {boolean} paused - a boolean for determining whether the queue is
 * in a paused state.
 * @property {Function} pause - a function that pauses the processing of tasks
 * until `resume()` is called. Invoke with `queue.pause()`.
 * @property {Function} resume - a function that resumes the processing of
 * queued tasks when the queue is paused. Invoke with `queue.resume()`.
 * @property {Function} kill - a function that removes the `drain` callback and
 * empties remaining tasks from the queue forcing it to go idle. No more tasks
 * should be pushed to the queue after calling this function. Invoke with `queue.kill()`.
 */

/**
 * Creates a `queue` object with the specified `concurrency`. Tasks added to the
 * `queue` are processed in parallel (up to the `concurrency` limit). If all
 * `worker`s are in progress, the task is queued until one becomes available.
 * Once a `worker` completes a `task`, that `task`'s callback is called.
 *
 * @name queue
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {AsyncFunction} worker - An async function for processing a queued task.
 * If you want to handle errors from an individual task, pass a callback to
 * `q.push()`. Invoked with (task, callback).
 * @param {number} [concurrency=1] - An `integer` for determining how many
 * `worker` functions should be run in parallel.  If omitted, the concurrency
 * defaults to `1`.  If the concurrency is `0`, an error is thrown.
 * @returns {module:ControlFlow.QueueObject} A queue object to manage the tasks. Callbacks can
 * attached as certain properties to listen for specific events during the
 * lifecycle of the queue.
 * @example
 *
 * // create a queue object with concurrency 2
 * var q = async.queue(function(task, callback) {
 *     console.log('hello ' + task.name);
 *     callback();
 * }, 2);
 *
 * // assign a callback
 * q.drain = function() {
 *     console.log('all items have been processed');
 * };
 *
 * // add some items to the queue
 * q.push({name: 'foo'}, function(err) {
 *     console.log('finished processing foo');
 * });
 * q.push({name: 'bar'}, function (err) {
 *     console.log('finished processing bar');
 * });
 *
 * // add some items to the queue (batch-wise)
 * q.push([{name: 'baz'},{name: 'bay'},{name: 'bax'}], function(err) {
 *     console.log('finished processing item');
 * });
 *
 * // add some items to the front of the queue
 * q.unshift({name: 'bar'}, function (err) {
 *     console.log('finished processing bar');
 * });
 */
var queue$1 = function (worker, concurrency) {
    var _worker = wrapAsync(worker);
    return queue(function (items, cb) {
        _worker(items[0], cb);
    }, concurrency, 1);
};

/**
 * The same as [async.queue]{@link module:ControlFlow.queue} only tasks are assigned a priority and
 * completed in ascending priority order.
 *
 * @name priorityQueue
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.queue]{@link module:ControlFlow.queue}
 * @category Control Flow
 * @param {AsyncFunction} worker - An async function for processing a queued task.
 * If you want to handle errors from an individual task, pass a callback to
 * `q.push()`.
 * Invoked with (task, callback).
 * @param {number} concurrency - An `integer` for determining how many `worker`
 * functions should be run in parallel.  If omitted, the concurrency defaults to
 * `1`.  If the concurrency is `0`, an error is thrown.
 * @returns {module:ControlFlow.QueueObject} A priorityQueue object to manage the tasks. There are two
 * differences between `queue` and `priorityQueue` objects:
 * * `push(task, priority, [callback])` - `priority` should be a number. If an
 *   array of `tasks` is given, all tasks will be assigned the same priority.
 * * The `unshift` method was removed.
 */
var priorityQueue = function(worker, concurrency) {
    // Start with a normal queue
    var q = queue$1(worker, concurrency);

    // Override push to accept second parameter representing priority
    q.push = function(data, priority, callback) {
        if (callback == null) callback = noop;
        if (typeof callback !== 'function') {
            throw new Error('task callback must be a function');
        }
        q.started = true;
        if (!isArray(data)) {
            data = [data];
        }
        if (data.length === 0) {
            // call drain immediately if there are no tasks
            return setImmediate$1(function() {
                q.drain();
            });
        }

        priority = priority || 0;
        var nextNode = q._tasks.head;
        while (nextNode && priority >= nextNode.priority) {
            nextNode = nextNode.next;
        }

        for (var i = 0, l = data.length; i < l; i++) {
            var item = {
                data: data[i],
                priority: priority,
                callback: callback
            };

            if (nextNode) {
                q._tasks.insertBefore(nextNode, item);
            } else {
                q._tasks.push(item);
            }
        }
        setImmediate$1(q.process);
    };

    // Remove unshift function
    delete q.unshift;

    return q;
};

/**
 * Runs the `tasks` array of functions in parallel, without waiting until the
 * previous function has completed. Once any of the `tasks` complete or pass an
 * error to its callback, the main `callback` is immediately called. It's
 * equivalent to `Promise.race()`.
 *
 * @name race
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Array} tasks - An array containing [async functions]{@link AsyncFunction}
 * to run. Each function can complete with an optional `result` value.
 * @param {Function} callback - A callback to run once any of the functions have
 * completed. This function gets an error or result from the first function that
 * completed. Invoked with (err, result).
 * @returns undefined
 * @example
 *
 * async.race([
 *     function(callback) {
 *         setTimeout(function() {
 *             callback(null, 'one');
 *         }, 200);
 *     },
 *     function(callback) {
 *         setTimeout(function() {
 *             callback(null, 'two');
 *         }, 100);
 *     }
 * ],
 * // main callback
 * function(err, result) {
 *     // the result will be equal to 'two' as it finishes earlier
 * });
 */
function race(tasks, callback) {
    callback = once(callback || noop);
    if (!isArray(tasks)) return callback(new TypeError('First argument to race must be an array of functions'));
    if (!tasks.length) return callback();
    for (var i = 0, l = tasks.length; i < l; i++) {
        wrapAsync(tasks[i])(callback);
    }
}

/**
 * Same as [`reduce`]{@link module:Collections.reduce}, only operates on `array` in reverse order.
 *
 * @name reduceRight
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.reduce]{@link module:Collections.reduce}
 * @alias foldr
 * @category Collection
 * @param {Array} array - A collection to iterate over.
 * @param {*} memo - The initial state of the reduction.
 * @param {AsyncFunction} iteratee - A function applied to each item in the
 * array to produce the next step in the reduction.
 * The `iteratee` should complete with the next state of the reduction.
 * If the iteratee complete with an error, the reduction is stopped and the
 * main `callback` is immediately called with the error.
 * Invoked with (memo, item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Result is the reduced value. Invoked with
 * (err, result).
 */
function reduceRight (array, memo, iteratee, callback) {
    var reversed = slice(array).reverse();
    reduce(reversed, memo, iteratee, callback);
}

/**
 * Wraps the async function in another function that always completes with a
 * result object, even when it errors.
 *
 * The result object has either the property `error` or `value`.
 *
 * @name reflect
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {AsyncFunction} fn - The async function you want to wrap
 * @returns {Function} - A function that always passes null to it's callback as
 * the error. The second argument to the callback will be an `object` with
 * either an `error` or a `value` property.
 * @example
 *
 * async.parallel([
 *     async.reflect(function(callback) {
 *         // do some stuff ...
 *         callback(null, 'one');
 *     }),
 *     async.reflect(function(callback) {
 *         // do some more stuff but error ...
 *         callback('bad stuff happened');
 *     }),
 *     async.reflect(function(callback) {
 *         // do some more stuff ...
 *         callback(null, 'two');
 *     })
 * ],
 * // optional callback
 * function(err, results) {
 *     // values
 *     // results[0].value = 'one'
 *     // results[1].error = 'bad stuff happened'
 *     // results[2].value = 'two'
 * });
 */
function reflect(fn) {
    var _fn = wrapAsync(fn);
    return initialParams(function reflectOn(args, reflectCallback) {
        args.push(function callback(error, cbArg) {
            if (error) {
                reflectCallback(null, { error: error });
            } else {
                var value;
                if (arguments.length <= 2) {
                    value = cbArg;
                } else {
                    value = slice(arguments, 1);
                }
                reflectCallback(null, { value: value });
            }
        });

        return _fn.apply(this, args);
    });
}

/**
 * A helper function that wraps an array or an object of functions with `reflect`.
 *
 * @name reflectAll
 * @static
 * @memberOf module:Utils
 * @method
 * @see [async.reflect]{@link module:Utils.reflect}
 * @category Util
 * @param {Array|Object|Iterable} tasks - The collection of
 * [async functions]{@link AsyncFunction} to wrap in `async.reflect`.
 * @returns {Array} Returns an array of async functions, each wrapped in
 * `async.reflect`
 * @example
 *
 * let tasks = [
 *     function(callback) {
 *         setTimeout(function() {
 *             callback(null, 'one');
 *         }, 200);
 *     },
 *     function(callback) {
 *         // do some more stuff but error ...
 *         callback(new Error('bad stuff happened'));
 *     },
 *     function(callback) {
 *         setTimeout(function() {
 *             callback(null, 'two');
 *         }, 100);
 *     }
 * ];
 *
 * async.parallel(async.reflectAll(tasks),
 * // optional callback
 * function(err, results) {
 *     // values
 *     // results[0].value = 'one'
 *     // results[1].error = Error('bad stuff happened')
 *     // results[2].value = 'two'
 * });
 *
 * // an example using an object instead of an array
 * let tasks = {
 *     one: function(callback) {
 *         setTimeout(function() {
 *             callback(null, 'one');
 *         }, 200);
 *     },
 *     two: function(callback) {
 *         callback('two');
 *     },
 *     three: function(callback) {
 *         setTimeout(function() {
 *             callback(null, 'three');
 *         }, 100);
 *     }
 * };
 *
 * async.parallel(async.reflectAll(tasks),
 * // optional callback
 * function(err, results) {
 *     // values
 *     // results.one.value = 'one'
 *     // results.two.error = 'two'
 *     // results.three.value = 'three'
 * });
 */
function reflectAll(tasks) {
    var results;
    if (isArray(tasks)) {
        results = arrayMap(tasks, reflect);
    } else {
        results = {};
        baseForOwn(tasks, function(task, key) {
            results[key] = reflect.call(this, task);
        });
    }
    return results;
}

function reject$1(eachfn, arr, iteratee, callback) {
    _filter(eachfn, arr, function(value, cb) {
        iteratee(value, function(err, v) {
            cb(err, !v);
        });
    }, callback);
}

/**
 * The opposite of [`filter`]{@link module:Collections.filter}. Removes values that pass an `async` truth test.
 *
 * @name reject
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.filter]{@link module:Collections.filter}
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {Function} iteratee - An async truth test to apply to each item in
 * `coll`.
 * The should complete with a boolean value as its `result`.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Invoked with (err, results).
 * @example
 *
 * async.reject(['file1','file2','file3'], function(filePath, callback) {
 *     fs.access(filePath, function(err) {
 *         callback(null, !err)
 *     });
 * }, function(err, results) {
 *     // results now equals an array of missing files
 *     createFiles(results);
 * });
 */
var reject = doParallel(reject$1);

/**
 * The same as [`reject`]{@link module:Collections.reject} but runs a maximum of `limit` async operations at a
 * time.
 *
 * @name rejectLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.reject]{@link module:Collections.reject}
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {Function} iteratee - An async truth test to apply to each item in
 * `coll`.
 * The should complete with a boolean value as its `result`.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Invoked with (err, results).
 */
var rejectLimit = doParallelLimit(reject$1);

/**
 * The same as [`reject`]{@link module:Collections.reject} but runs only a single async operation at a time.
 *
 * @name rejectSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.reject]{@link module:Collections.reject}
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {Function} iteratee - An async truth test to apply to each item in
 * `coll`.
 * The should complete with a boolean value as its `result`.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Invoked with (err, results).
 */
var rejectSeries = doLimit(rejectLimit, 1);

/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant$1(value) {
  return function() {
    return value;
  };
}

/**
 * Attempts to get a successful response from `task` no more than `times` times
 * before returning an error. If the task is successful, the `callback` will be
 * passed the result of the successful task. If all attempts fail, the callback
 * will be passed the error and result (if any) of the final attempt.
 *
 * @name retry
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @see [async.retryable]{@link module:ControlFlow.retryable}
 * @param {Object|number} [opts = {times: 5, interval: 0}| 5] - Can be either an
 * object with `times` and `interval` or a number.
 * * `times` - The number of attempts to make before giving up.  The default
 *   is `5`.
 * * `interval` - The time to wait between retries, in milliseconds.  The
 *   default is `0`. The interval may also be specified as a function of the
 *   retry count (see example).
 * * `errorFilter` - An optional synchronous function that is invoked on
 *   erroneous result. If it returns `true` the retry attempts will continue;
 *   if the function returns `false` the retry flow is aborted with the current
 *   attempt's error and result being returned to the final callback.
 *   Invoked with (err).
 * * If `opts` is a number, the number specifies the number of times to retry,
 *   with the default interval of `0`.
 * @param {AsyncFunction} task - An async function to retry.
 * Invoked with (callback).
 * @param {Function} [callback] - An optional callback which is called when the
 * task has succeeded, or after the final failed attempt. It receives the `err`
 * and `result` arguments of the last attempt at completing the `task`. Invoked
 * with (err, results).
 *
 * @example
 *
 * // The `retry` function can be used as a stand-alone control flow by passing
 * // a callback, as shown below:
 *
 * // try calling apiMethod 3 times
 * async.retry(3, apiMethod, function(err, result) {
 *     // do something with the result
 * });
 *
 * // try calling apiMethod 3 times, waiting 200 ms between each retry
 * async.retry({times: 3, interval: 200}, apiMethod, function(err, result) {
 *     // do something with the result
 * });
 *
 * // try calling apiMethod 10 times with exponential backoff
 * // (i.e. intervals of 100, 200, 400, 800, 1600, ... milliseconds)
 * async.retry({
 *   times: 10,
 *   interval: function(retryCount) {
 *     return 50 * Math.pow(2, retryCount);
 *   }
 * }, apiMethod, function(err, result) {
 *     // do something with the result
 * });
 *
 * // try calling apiMethod the default 5 times no delay between each retry
 * async.retry(apiMethod, function(err, result) {
 *     // do something with the result
 * });
 *
 * // try calling apiMethod only when error condition satisfies, all other
 * // errors will abort the retry control flow and return to final callback
 * async.retry({
 *   errorFilter: function(err) {
 *     return err.message === 'Temporary error'; // only retry on a specific error
 *   }
 * }, apiMethod, function(err, result) {
 *     // do something with the result
 * });
 *
 * // to retry individual methods that are not as reliable within other
 * // control flow functions, use the `retryable` wrapper:
 * async.auto({
 *     users: api.getUsers.bind(api),
 *     payments: async.retryable(3, api.getPayments.bind(api))
 * }, function(err, results) {
 *     // do something with the results
 * });
 *
 */
function retry(opts, task, callback) {
    var DEFAULT_TIMES = 5;
    var DEFAULT_INTERVAL = 0;

    var options = {
        times: DEFAULT_TIMES,
        intervalFunc: constant$1(DEFAULT_INTERVAL)
    };

    function parseTimes(acc, t) {
        if (typeof t === 'object') {
            acc.times = +t.times || DEFAULT_TIMES;

            acc.intervalFunc = typeof t.interval === 'function' ?
                t.interval :
                constant$1(+t.interval || DEFAULT_INTERVAL);

            acc.errorFilter = t.errorFilter;
        } else if (typeof t === 'number' || typeof t === 'string') {
            acc.times = +t || DEFAULT_TIMES;
        } else {
            throw new Error("Invalid arguments for async.retry");
        }
    }

    if (arguments.length < 3 && typeof opts === 'function') {
        callback = task || noop;
        task = opts;
    } else {
        parseTimes(options, opts);
        callback = callback || noop;
    }

    if (typeof task !== 'function') {
        throw new Error("Invalid arguments for async.retry");
    }

    var _task = wrapAsync(task);

    var attempt = 1;
    function retryAttempt() {
        _task(function(err) {
            if (err && attempt++ < options.times &&
                (typeof options.errorFilter != 'function' ||
                    options.errorFilter(err))) {
                setTimeout(retryAttempt, options.intervalFunc(attempt));
            } else {
                callback.apply(null, arguments);
            }
        });
    }

    retryAttempt();
}

/**
 * A close relative of [`retry`]{@link module:ControlFlow.retry}.  This method
 * wraps a task and makes it retryable, rather than immediately calling it
 * with retries.
 *
 * @name retryable
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.retry]{@link module:ControlFlow.retry}
 * @category Control Flow
 * @param {Object|number} [opts = {times: 5, interval: 0}| 5] - optional
 * options, exactly the same as from `retry`
 * @param {AsyncFunction} task - the asynchronous function to wrap.
 * This function will be passed any arguments passed to the returned wrapper.
 * Invoked with (...args, callback).
 * @returns {AsyncFunction} The wrapped function, which when invoked, will
 * retry on an error, based on the parameters specified in `opts`.
 * This function will accept the same parameters as `task`.
 * @example
 *
 * async.auto({
 *     dep1: async.retryable(3, getFromFlakyService),
 *     process: ["dep1", async.retryable(3, function (results, cb) {
 *         maybeProcessData(results.dep1, cb);
 *     })]
 * }, callback);
 */
var retryable = function (opts, task) {
    if (!task) {
        task = opts;
        opts = null;
    }
    var _task = wrapAsync(task);
    return initialParams(function (args, callback) {
        function taskFn(cb) {
            _task.apply(null, args.concat(cb));
        }

        if (opts) retry(opts, taskFn, callback);
        else retry(taskFn, callback);

    });
};

/**
 * Run the functions in the `tasks` collection in series, each one running once
 * the previous function has completed. If any functions in the series pass an
 * error to its callback, no more functions are run, and `callback` is
 * immediately called with the value of the error. Otherwise, `callback`
 * receives an array of results when `tasks` have completed.
 *
 * It is also possible to use an object instead of an array. Each property will
 * be run as a function, and the results will be passed to the final `callback`
 * as an object instead of an array. This can be a more readable way of handling
 *  results from {@link async.series}.
 *
 * **Note** that while many implementations preserve the order of object
 * properties, the [ECMAScript Language Specification](http://www.ecma-international.org/ecma-262/5.1/#sec-8.6)
 * explicitly states that
 *
 * > The mechanics and order of enumerating the properties is not specified.
 *
 * So if you rely on the order in which your series of functions are executed,
 * and want this to work on all platforms, consider using an array.
 *
 * @name series
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Array|Iterable|Object} tasks - A collection containing
 * [async functions]{@link AsyncFunction} to run in series.
 * Each function can complete with any number of optional `result` values.
 * @param {Function} [callback] - An optional callback to run once all the
 * functions have completed. This function gets a results array (or object)
 * containing all the result arguments passed to the `task` callbacks. Invoked
 * with (err, result).
 * @example
 * async.series([
 *     function(callback) {
 *         // do some stuff ...
 *         callback(null, 'one');
 *     },
 *     function(callback) {
 *         // do some more stuff ...
 *         callback(null, 'two');
 *     }
 * ],
 * // optional callback
 * function(err, results) {
 *     // results is now equal to ['one', 'two']
 * });
 *
 * async.series({
 *     one: function(callback) {
 *         setTimeout(function() {
 *             callback(null, 1);
 *         }, 200);
 *     },
 *     two: function(callback){
 *         setTimeout(function() {
 *             callback(null, 2);
 *         }, 100);
 *     }
 * }, function(err, results) {
 *     // results is now equal to: {one: 1, two: 2}
 * });
 */
function series(tasks, callback) {
    _parallel(eachOfSeries, tasks, callback);
}

/**
 * Returns `true` if at least one element in the `coll` satisfies an async test.
 * If any iteratee call returns `true`, the main `callback` is immediately
 * called.
 *
 * @name some
 * @static
 * @memberOf module:Collections
 * @method
 * @alias any
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async truth test to apply to each item
 * in the collections in parallel.
 * The iteratee should complete with a boolean `result` value.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called as soon as any
 * iteratee returns `true`, or after all the iteratee functions have finished.
 * Result will be either `true` or `false` depending on the values of the async
 * tests. Invoked with (err, result).
 * @example
 *
 * async.some(['file1','file2','file3'], function(filePath, callback) {
 *     fs.access(filePath, function(err) {
 *         callback(null, !err)
 *     });
 * }, function(err, result) {
 *     // if result is true then at least one of the files exists
 * });
 */
var some = doParallel(_createTester(Boolean, identity));

/**
 * The same as [`some`]{@link module:Collections.some} but runs a maximum of `limit` async operations at a time.
 *
 * @name someLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.some]{@link module:Collections.some}
 * @alias anyLimit
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async truth test to apply to each item
 * in the collections in parallel.
 * The iteratee should complete with a boolean `result` value.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called as soon as any
 * iteratee returns `true`, or after all the iteratee functions have finished.
 * Result will be either `true` or `false` depending on the values of the async
 * tests. Invoked with (err, result).
 */
var someLimit = doParallelLimit(_createTester(Boolean, identity));

/**
 * The same as [`some`]{@link module:Collections.some} but runs only a single async operation at a time.
 *
 * @name someSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.some]{@link module:Collections.some}
 * @alias anySeries
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async truth test to apply to each item
 * in the collections in series.
 * The iteratee should complete with a boolean `result` value.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called as soon as any
 * iteratee returns `true`, or after all the iteratee functions have finished.
 * Result will be either `true` or `false` depending on the values of the async
 * tests. Invoked with (err, result).
 */
var someSeries = doLimit(someLimit, 1);

/**
 * Sorts a list by the results of running each `coll` value through an async
 * `iteratee`.
 *
 * @name sortBy
 * @static
 * @memberOf module:Collections
 * @method
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with a value to use as the sort criteria as
 * its `result`.
 * Invoked with (item, callback).
 * @param {Function} callback - A callback which is called after all the
 * `iteratee` functions have finished, or an error occurs. Results is the items
 * from the original `coll` sorted by the values returned by the `iteratee`
 * calls. Invoked with (err, results).
 * @example
 *
 * async.sortBy(['file1','file2','file3'], function(file, callback) {
 *     fs.stat(file, function(err, stats) {
 *         callback(err, stats.mtime);
 *     });
 * }, function(err, results) {
 *     // results is now the original array of files sorted by
 *     // modified date
 * });
 *
 * // By modifying the callback parameter the
 * // sorting order can be influenced:
 *
 * // ascending order
 * async.sortBy([1,9,3,5], function(x, callback) {
 *     callback(null, x);
 * }, function(err,result) {
 *     // result callback
 * });
 *
 * // descending order
 * async.sortBy([1,9,3,5], function(x, callback) {
 *     callback(null, x*-1);    //<- x*-1 instead of x, turns the order around
 * }, function(err,result) {
 *     // result callback
 * });
 */
function sortBy (coll, iteratee, callback) {
    var _iteratee = wrapAsync(iteratee);
    map(coll, function (x, callback) {
        _iteratee(x, function (err, criteria) {
            if (err) return callback(err);
            callback(null, {value: x, criteria: criteria});
        });
    }, function (err, results) {
        if (err) return callback(err);
        callback(null, arrayMap(results.sort(comparator), baseProperty('value')));
    });

    function comparator(left, right) {
        var a = left.criteria, b = right.criteria;
        return a < b ? -1 : a > b ? 1 : 0;
    }
}

/**
 * Sets a time limit on an asynchronous function. If the function does not call
 * its callback within the specified milliseconds, it will be called with a
 * timeout error. The code property for the error object will be `'ETIMEDOUT'`.
 *
 * @name timeout
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {AsyncFunction} asyncFn - The async function to limit in time.
 * @param {number} milliseconds - The specified time limit.
 * @param {*} [info] - Any variable you want attached (`string`, `object`, etc)
 * to timeout Error for more information..
 * @returns {AsyncFunction} Returns a wrapped function that can be used with any
 * of the control flow functions.
 * Invoke this function with the same parameters as you would `asyncFunc`.
 * @example
 *
 * function myFunction(foo, callback) {
 *     doAsyncTask(foo, function(err, data) {
 *         // handle errors
 *         if (err) return callback(err);
 *
 *         // do some stuff ...
 *
 *         // return processed data
 *         return callback(null, data);
 *     });
 * }
 *
 * var wrapped = async.timeout(myFunction, 1000);
 *
 * // call `wrapped` as you would `myFunction`
 * wrapped({ bar: 'bar' }, function(err, data) {
 *     // if `myFunction` takes < 1000 ms to execute, `err`
 *     // and `data` will have their expected values
 *
 *     // else `err` will be an Error with the code 'ETIMEDOUT'
 * });
 */
function timeout(asyncFn, milliseconds, info) {
    var fn = wrapAsync(asyncFn);

    return initialParams(function (args, callback) {
        var timedOut = false;
        var timer;

        function timeoutCallback() {
            var name = asyncFn.name || 'anonymous';
            var error  = new Error('Callback function "' + name + '" timed out.');
            error.code = 'ETIMEDOUT';
            if (info) {
                error.info = info;
            }
            timedOut = true;
            callback(error);
        }

        args.push(function () {
            if (!timedOut) {
                callback.apply(null, arguments);
                clearTimeout(timer);
            }
        });

        // setup timer and call original function
        timer = setTimeout(timeoutCallback, milliseconds);
        fn.apply(null, args);
    });
}

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeCeil = Math.ceil;
var nativeMax = Math.max;

/**
 * The base implementation of `_.range` and `_.rangeRight` which doesn't
 * coerce arguments.
 *
 * @private
 * @param {number} start The start of the range.
 * @param {number} end The end of the range.
 * @param {number} step The value to increment or decrement by.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Array} Returns the range of numbers.
 */
function baseRange(start, end, step, fromRight) {
  var index = -1,
      length = nativeMax(nativeCeil((end - start) / (step || 1)), 0),
      result = Array(length);

  while (length--) {
    result[fromRight ? length : ++index] = start;
    start += step;
  }
  return result;
}

/**
 * The same as [times]{@link module:ControlFlow.times} but runs a maximum of `limit` async operations at a
 * time.
 *
 * @name timesLimit
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.times]{@link module:ControlFlow.times}
 * @category Control Flow
 * @param {number} count - The number of times to run the function.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - The async function to call `n` times.
 * Invoked with the iteration index and a callback: (n, next).
 * @param {Function} callback - see [async.map]{@link module:Collections.map}.
 */
function timeLimit(count, limit, iteratee, callback) {
    var _iteratee = wrapAsync(iteratee);
    mapLimit(baseRange(0, count, 1), limit, _iteratee, callback);
}

/**
 * Calls the `iteratee` function `n` times, and accumulates results in the same
 * manner you would use with [map]{@link module:Collections.map}.
 *
 * @name times
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.map]{@link module:Collections.map}
 * @category Control Flow
 * @param {number} n - The number of times to run the function.
 * @param {AsyncFunction} iteratee - The async function to call `n` times.
 * Invoked with the iteration index and a callback: (n, next).
 * @param {Function} callback - see {@link module:Collections.map}.
 * @example
 *
 * // Pretend this is some complicated async factory
 * var createUser = function(id, callback) {
 *     callback(null, {
 *         id: 'user' + id
 *     });
 * };
 *
 * // generate 5 users
 * async.times(5, function(n, next) {
 *     createUser(n, function(err, user) {
 *         next(err, user);
 *     });
 * }, function(err, users) {
 *     // we should now have 5 users
 * });
 */
var times = doLimit(timeLimit, Infinity);

/**
 * The same as [times]{@link module:ControlFlow.times} but runs only a single async operation at a time.
 *
 * @name timesSeries
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.times]{@link module:ControlFlow.times}
 * @category Control Flow
 * @param {number} n - The number of times to run the function.
 * @param {AsyncFunction} iteratee - The async function to call `n` times.
 * Invoked with the iteration index and a callback: (n, next).
 * @param {Function} callback - see {@link module:Collections.map}.
 */
var timesSeries = doLimit(timeLimit, 1);

/**
 * A relative of `reduce`.  Takes an Object or Array, and iterates over each
 * element in series, each step potentially mutating an `accumulator` value.
 * The type of the accumulator defaults to the type of collection passed in.
 *
 * @name transform
 * @static
 * @memberOf module:Collections
 * @method
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {*} [accumulator] - The initial state of the transform.  If omitted,
 * it will default to an empty Object or Array, depending on the type of `coll`
 * @param {AsyncFunction} iteratee - A function applied to each item in the
 * collection that potentially modifies the accumulator.
 * Invoked with (accumulator, item, key, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Result is the transformed accumulator.
 * Invoked with (err, result).
 * @example
 *
 * async.transform([1,2,3], function(acc, item, index, callback) {
 *     // pointless async:
 *     process.nextTick(function() {
 *         acc.push(item * 2)
 *         callback(null)
 *     });
 * }, function(err, result) {
 *     // result is now equal to [2, 4, 6]
 * });
 *
 * @example
 *
 * async.transform({a: 1, b: 2, c: 3}, function (obj, val, key, callback) {
 *     setImmediate(function () {
 *         obj[key] = val * 2;
 *         callback();
 *     })
 * }, function (err, result) {
 *     // result is equal to {a: 2, b: 4, c: 6}
 * })
 */
function transform (coll, accumulator, iteratee, callback) {
    if (arguments.length <= 3) {
        callback = iteratee;
        iteratee = accumulator;
        accumulator = isArray(coll) ? [] : {};
    }
    callback = once(callback || noop);
    var _iteratee = wrapAsync(iteratee);

    eachOf(coll, function(v, k, cb) {
        _iteratee(accumulator, v, k, cb);
    }, function(err) {
        callback(err, accumulator);
    });
}

/**
 * It runs each task in series but stops whenever any of the functions were
 * successful. If one of the tasks were successful, the `callback` will be
 * passed the result of the successful task. If all tasks fail, the callback
 * will be passed the error and result (if any) of the final attempt.
 *
 * @name tryEach
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Array|Iterable|Object} tasks - A collection containing functions to
 * run, each function is passed a `callback(err, result)` it must call on
 * completion with an error `err` (which can be `null`) and an optional `result`
 * value.
 * @param {Function} [callback] - An optional callback which is called when one
 * of the tasks has succeeded, or all have failed. It receives the `err` and
 * `result` arguments of the last attempt at completing the `task`. Invoked with
 * (err, results).
 * @example
 * async.tryEach([
 *     function getDataFromFirstWebsite(callback) {
 *         // Try getting the data from the first website
 *         callback(err, data);
 *     },
 *     function getDataFromSecondWebsite(callback) {
 *         // First website failed,
 *         // Try getting the data from the backup website
 *         callback(err, data);
 *     }
 * ],
 * // optional callback
 * function(err, results) {
 *     Now do something with the data.
 * });
 *
 */
function tryEach(tasks, callback) {
    var error = null;
    var result;
    callback = callback || noop;
    eachSeries(tasks, function(task, callback) {
        wrapAsync(task)(function (err, res/*, ...args*/) {
            if (arguments.length > 2) {
                result = slice(arguments, 1);
            } else {
                result = res;
            }
            error = err;
            callback(!err);
        });
    }, function () {
        callback(error, result);
    });
}

/**
 * Undoes a [memoize]{@link module:Utils.memoize}d function, reverting it to the original,
 * unmemoized form. Handy for testing.
 *
 * @name unmemoize
 * @static
 * @memberOf module:Utils
 * @method
 * @see [async.memoize]{@link module:Utils.memoize}
 * @category Util
 * @param {AsyncFunction} fn - the memoized function
 * @returns {AsyncFunction} a function that calls the original unmemoized function
 */
function unmemoize(fn) {
    return function () {
        return (fn.unmemoized || fn).apply(null, arguments);
    };
}

/**
 * Repeatedly call `iteratee`, while `test` returns `true`. Calls `callback` when
 * stopped, or an error occurs.
 *
 * @name whilst
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Function} test - synchronous truth test to perform before each
 * execution of `iteratee`. Invoked with ().
 * @param {AsyncFunction} iteratee - An async function which is called each time
 * `test` passes. Invoked with (callback).
 * @param {Function} [callback] - A callback which is called after the test
 * function has failed and repeated execution of `iteratee` has stopped. `callback`
 * will be passed an error and any arguments passed to the final `iteratee`'s
 * callback. Invoked with (err, [results]);
 * @returns undefined
 * @example
 *
 * var count = 0;
 * async.whilst(
 *     function() { return count < 5; },
 *     function(callback) {
 *         count++;
 *         setTimeout(function() {
 *             callback(null, count);
 *         }, 1000);
 *     },
 *     function (err, n) {
 *         // 5 seconds have passed, n = 5
 *     }
 * );
 */
function whilst(test, iteratee, callback) {
    callback = onlyOnce(callback || noop);
    var _iteratee = wrapAsync(iteratee);
    if (!test()) return callback(null);
    var next = function(err/*, ...args*/) {
        if (err) return callback(err);
        if (test()) return _iteratee(next);
        var args = slice(arguments, 1);
        callback.apply(null, [null].concat(args));
    };
    _iteratee(next);
}

/**
 * Repeatedly call `iteratee` until `test` returns `true`. Calls `callback` when
 * stopped, or an error occurs. `callback` will be passed an error and any
 * arguments passed to the final `iteratee`'s callback.
 *
 * The inverse of [whilst]{@link module:ControlFlow.whilst}.
 *
 * @name until
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.whilst]{@link module:ControlFlow.whilst}
 * @category Control Flow
 * @param {Function} test - synchronous truth test to perform before each
 * execution of `iteratee`. Invoked with ().
 * @param {AsyncFunction} iteratee - An async function which is called each time
 * `test` fails. Invoked with (callback).
 * @param {Function} [callback] - A callback which is called after the test
 * function has passed and repeated execution of `iteratee` has stopped. `callback`
 * will be passed an error and any arguments passed to the final `iteratee`'s
 * callback. Invoked with (err, [results]);
 */
function until(test, iteratee, callback) {
    whilst(function() {
        return !test.apply(this, arguments);
    }, iteratee, callback);
}

/**
 * Runs the `tasks` array of functions in series, each passing their results to
 * the next in the array. However, if any of the `tasks` pass an error to their
 * own callback, the next function is not executed, and the main `callback` is
 * immediately called with the error.
 *
 * @name waterfall
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Array} tasks - An array of [async functions]{@link AsyncFunction}
 * to run.
 * Each function should complete with any number of `result` values.
 * The `result` values will be passed as arguments, in order, to the next task.
 * @param {Function} [callback] - An optional callback to run once all the
 * functions have completed. This will be passed the results of the last task's
 * callback. Invoked with (err, [results]).
 * @returns undefined
 * @example
 *
 * async.waterfall([
 *     function(callback) {
 *         callback(null, 'one', 'two');
 *     },
 *     function(arg1, arg2, callback) {
 *         // arg1 now equals 'one' and arg2 now equals 'two'
 *         callback(null, 'three');
 *     },
 *     function(arg1, callback) {
 *         // arg1 now equals 'three'
 *         callback(null, 'done');
 *     }
 * ], function (err, result) {
 *     // result now equals 'done'
 * });
 *
 * // Or, with named functions:
 * async.waterfall([
 *     myFirstFunction,
 *     mySecondFunction,
 *     myLastFunction,
 * ], function (err, result) {
 *     // result now equals 'done'
 * });
 * function myFirstFunction(callback) {
 *     callback(null, 'one', 'two');
 * }
 * function mySecondFunction(arg1, arg2, callback) {
 *     // arg1 now equals 'one' and arg2 now equals 'two'
 *     callback(null, 'three');
 * }
 * function myLastFunction(arg1, callback) {
 *     // arg1 now equals 'three'
 *     callback(null, 'done');
 * }
 */
var waterfall = function(tasks, callback) {
    callback = once(callback || noop);
    if (!isArray(tasks)) return callback(new Error('First argument to waterfall must be an array of functions'));
    if (!tasks.length) return callback();
    var taskIndex = 0;

    function nextTask(args) {
        var task = wrapAsync(tasks[taskIndex++]);
        args.push(onlyOnce(next));
        task.apply(null, args);
    }

    function next(err/*, ...args*/) {
        if (err || taskIndex === tasks.length) {
            return callback.apply(null, arguments);
        }
        nextTask(slice(arguments, 1));
    }

    nextTask([]);
};

/**
 * An "async function" in the context of Async is an asynchronous function with
 * a variable number of parameters, with the final parameter being a callback.
 * (`function (arg1, arg2, ..., callback) {}`)
 * The final callback is of the form `callback(err, results...)`, which must be
 * called once the function is completed.  The callback should be called with a
 * Error as its first argument to signal that an error occurred.
 * Otherwise, if no error occurred, it should be called with `null` as the first
 * argument, and any additional `result` arguments that may apply, to signal
 * successful completion.
 * The callback must be called exactly once, ideally on a later tick of the
 * JavaScript event loop.
 *
 * This type of function is also referred to as a "Node-style async function",
 * or a "continuation passing-style function" (CPS). Most of the methods of this
 * library are themselves CPS/Node-style async functions, or functions that
 * return CPS/Node-style async functions.
 *
 * Wherever we accept a Node-style async function, we also directly accept an
 * [ES2017 `async` function]{@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/async_function}.
 * In this case, the `async` function will not be passed a final callback
 * argument, and any thrown error will be used as the `err` argument of the
 * implicit callback, and the return value will be used as the `result` value.
 * (i.e. a `rejected` of the returned Promise becomes the `err` callback
 * argument, and a `resolved` value becomes the `result`.)
 *
 * Note, due to JavaScript limitations, we can only detect native `async`
 * functions and not transpilied implementations.
 * Your environment must have `async`/`await` support for this to work.
 * (e.g. Node > v7.6, or a recent version of a modern browser).
 * If you are using `async` functions through a transpiler (e.g. Babel), you
 * must still wrap the function with [asyncify]{@link module:Utils.asyncify},
 * because the `async function` will be compiled to an ordinary function that
 * returns a promise.
 *
 * @typedef {Function} AsyncFunction
 * @static
 */

/**
 * Async is a utility module which provides straight-forward, powerful functions
 * for working with asynchronous JavaScript. Although originally designed for
 * use with [Node.js](http://nodejs.org) and installable via
 * `npm install --save async`, it can also be used directly in the browser.
 * @module async
 * @see AsyncFunction
 */


/**
 * A collection of `async` functions for manipulating collections, such as
 * arrays and objects.
 * @module Collections
 */

/**
 * A collection of `async` functions for controlling the flow through a script.
 * @module ControlFlow
 */

/**
 * A collection of `async` utility functions.
 * @module Utils
 */

var index = {
    apply: apply,
    applyEach: applyEach,
    applyEachSeries: applyEachSeries,
    asyncify: asyncify,
    auto: auto,
    autoInject: autoInject,
    cargo: cargo,
    compose: compose,
    concat: concat,
    concatLimit: concatLimit,
    concatSeries: concatSeries,
    constant: constant,
    detect: detect,
    detectLimit: detectLimit,
    detectSeries: detectSeries,
    dir: dir,
    doDuring: doDuring,
    doUntil: doUntil,
    doWhilst: doWhilst,
    during: during,
    each: eachLimit,
    eachLimit: eachLimit$1,
    eachOf: eachOf,
    eachOfLimit: eachOfLimit,
    eachOfSeries: eachOfSeries,
    eachSeries: eachSeries,
    ensureAsync: ensureAsync,
    every: every,
    everyLimit: everyLimit,
    everySeries: everySeries,
    filter: filter,
    filterLimit: filterLimit,
    filterSeries: filterSeries,
    forever: forever,
    groupBy: groupBy,
    groupByLimit: groupByLimit,
    groupBySeries: groupBySeries,
    log: log,
    map: map,
    mapLimit: mapLimit,
    mapSeries: mapSeries,
    mapValues: mapValues,
    mapValuesLimit: mapValuesLimit,
    mapValuesSeries: mapValuesSeries,
    memoize: memoize,
    nextTick: nextTick,
    parallel: parallelLimit,
    parallelLimit: parallelLimit$1,
    priorityQueue: priorityQueue,
    queue: queue$1,
    race: race,
    reduce: reduce,
    reduceRight: reduceRight,
    reflect: reflect,
    reflectAll: reflectAll,
    reject: reject,
    rejectLimit: rejectLimit,
    rejectSeries: rejectSeries,
    retry: retry,
    retryable: retryable,
    seq: seq,
    series: series,
    setImmediate: setImmediate$1,
    some: some,
    someLimit: someLimit,
    someSeries: someSeries,
    sortBy: sortBy,
    timeout: timeout,
    times: times,
    timesLimit: timeLimit,
    timesSeries: timesSeries,
    transform: transform,
    tryEach: tryEach,
    unmemoize: unmemoize,
    until: until,
    waterfall: waterfall,
    whilst: whilst,

    // aliases
    all: every,
    allLimit: everyLimit,
    allSeries: everySeries,
    any: some,
    anyLimit: someLimit,
    anySeries: someSeries,
    find: detect,
    findLimit: detectLimit,
    findSeries: detectSeries,
    forEach: eachLimit,
    forEachSeries: eachSeries,
    forEachLimit: eachLimit$1,
    forEachOf: eachOf,
    forEachOfSeries: eachOfSeries,
    forEachOfLimit: eachOfLimit,
    inject: reduce,
    foldl: reduce,
    foldr: reduceRight,
    select: filter,
    selectLimit: filterLimit,
    selectSeries: filterSeries,
    wrapSync: asyncify
};

exports['default'] = index;
exports.apply = apply;
exports.applyEach = applyEach;
exports.applyEachSeries = applyEachSeries;
exports.asyncify = asyncify;
exports.auto = auto;
exports.autoInject = autoInject;
exports.cargo = cargo;
exports.compose = compose;
exports.concat = concat;
exports.concatLimit = concatLimit;
exports.concatSeries = concatSeries;
exports.constant = constant;
exports.detect = detect;
exports.detectLimit = detectLimit;
exports.detectSeries = detectSeries;
exports.dir = dir;
exports.doDuring = doDuring;
exports.doUntil = doUntil;
exports.doWhilst = doWhilst;
exports.during = during;
exports.each = eachLimit;
exports.eachLimit = eachLimit$1;
exports.eachOf = eachOf;
exports.eachOfLimit = eachOfLimit;
exports.eachOfSeries = eachOfSeries;
exports.eachSeries = eachSeries;
exports.ensureAsync = ensureAsync;
exports.every = every;
exports.everyLimit = everyLimit;
exports.everySeries = everySeries;
exports.filter = filter;
exports.filterLimit = filterLimit;
exports.filterSeries = filterSeries;
exports.forever = forever;
exports.groupBy = groupBy;
exports.groupByLimit = groupByLimit;
exports.groupBySeries = groupBySeries;
exports.log = log;
exports.map = map;
exports.mapLimit = mapLimit;
exports.mapSeries = mapSeries;
exports.mapValues = mapValues;
exports.mapValuesLimit = mapValuesLimit;
exports.mapValuesSeries = mapValuesSeries;
exports.memoize = memoize;
exports.nextTick = nextTick;
exports.parallel = parallelLimit;
exports.parallelLimit = parallelLimit$1;
exports.priorityQueue = priorityQueue;
exports.queue = queue$1;
exports.race = race;
exports.reduce = reduce;
exports.reduceRight = reduceRight;
exports.reflect = reflect;
exports.reflectAll = reflectAll;
exports.reject = reject;
exports.rejectLimit = rejectLimit;
exports.rejectSeries = rejectSeries;
exports.retry = retry;
exports.retryable = retryable;
exports.seq = seq;
exports.series = series;
exports.setImmediate = setImmediate$1;
exports.some = some;
exports.someLimit = someLimit;
exports.someSeries = someSeries;
exports.sortBy = sortBy;
exports.timeout = timeout;
exports.times = times;
exports.timesLimit = timeLimit;
exports.timesSeries = timesSeries;
exports.transform = transform;
exports.tryEach = tryEach;
exports.unmemoize = unmemoize;
exports.until = until;
exports.waterfall = waterfall;
exports.whilst = whilst;
exports.all = every;
exports.allLimit = everyLimit;
exports.allSeries = everySeries;
exports.any = some;
exports.anyLimit = someLimit;
exports.anySeries = someSeries;
exports.find = detect;
exports.findLimit = detectLimit;
exports.findSeries = detectSeries;
exports.forEach = eachLimit;
exports.forEachSeries = eachSeries;
exports.forEachLimit = eachLimit$1;
exports.forEachOf = eachOf;
exports.forEachOfSeries = eachOfSeries;
exports.forEachOfLimit = eachOfLimit;
exports.inject = reduce;
exports.foldl = reduce;
exports.foldr = reduceRight;
exports.select = filter;
exports.selectLimit = filterLimit;
exports.selectSeries = filterSeries;
exports.wrapSync = asyncify;

Object.defineProperty(exports, '__esModule', { value: true });

})));


/***/ }),

/***/ 814338:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = eachLimit;

var _eachOfLimit = __webpack_require__(656954);

var _eachOfLimit2 = _interopRequireDefault(_eachOfLimit);

var _withoutIndex = __webpack_require__(236529);

var _withoutIndex2 = _interopRequireDefault(_withoutIndex);

var _wrapAsync = __webpack_require__(28993);

var _wrapAsync2 = _interopRequireDefault(_wrapAsync);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The same as [`each`]{@link module:Collections.each} but runs a maximum of `limit` async operations at a time.
 *
 * @name eachLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.each]{@link module:Collections.each}
 * @alias forEachLimit
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The array index is not passed to the iteratee.
 * If you need the index, use `eachOfLimit`.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 */
function eachLimit(coll, limit, iteratee, callback) {
  (0, _eachOfLimit2.default)(limit)(coll, (0, _withoutIndex2.default)((0, _wrapAsync2.default)(iteratee)), callback);
}
module.exports = exports['default'];

/***/ }),

/***/ 171846:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));

exports.default = function (coll, iteratee, callback) {
    var eachOfImplementation = (0, _isArrayLike2.default)(coll) ? eachOfArrayLike : eachOfGeneric;
    eachOfImplementation(coll, (0, _wrapAsync2.default)(iteratee), callback);
};

var _isArrayLike = __webpack_require__(498612);

var _isArrayLike2 = _interopRequireDefault(_isArrayLike);

var _breakLoop = __webpack_require__(801605);

var _breakLoop2 = _interopRequireDefault(_breakLoop);

var _eachOfLimit = __webpack_require__(297388);

var _eachOfLimit2 = _interopRequireDefault(_eachOfLimit);

var _doLimit = __webpack_require__(153875);

var _doLimit2 = _interopRequireDefault(_doLimit);

var _noop = __webpack_require__(850308);

var _noop2 = _interopRequireDefault(_noop);

var _once = __webpack_require__(146979);

var _once2 = _interopRequireDefault(_once);

var _onlyOnce = __webpack_require__(413362);

var _onlyOnce2 = _interopRequireDefault(_onlyOnce);

var _wrapAsync = __webpack_require__(28993);

var _wrapAsync2 = _interopRequireDefault(_wrapAsync);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// eachOf implementation optimized for array-likes
function eachOfArrayLike(coll, iteratee, callback) {
    callback = (0, _once2.default)(callback || _noop2.default);
    var index = 0,
        completed = 0,
        length = coll.length;
    if (length === 0) {
        callback(null);
    }

    function iteratorCallback(err, value) {
        if (err) {
            callback(err);
        } else if (++completed === length || value === _breakLoop2.default) {
            callback(null);
        }
    }

    for (; index < length; index++) {
        iteratee(coll[index], index, (0, _onlyOnce2.default)(iteratorCallback));
    }
}

// a generic version of eachOf which can handle array, object, and iterator cases.
var eachOfGeneric = (0, _doLimit2.default)(_eachOfLimit2.default, Infinity);

/**
 * Like [`each`]{@link module:Collections.each}, except that it passes the key (or index) as the second argument
 * to the iteratee.
 *
 * @name eachOf
 * @static
 * @memberOf module:Collections
 * @method
 * @alias forEachOf
 * @category Collection
 * @see [async.each]{@link module:Collections.each}
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A function to apply to each
 * item in `coll`.
 * The `key` is the item's key, or index in the case of an array.
 * Invoked with (item, key, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 * @example
 *
 * var obj = {dev: "/dev.json", test: "/test.json", prod: "/prod.json"};
 * var configs = {};
 *
 * async.forEachOf(obj, function (value, key, callback) {
 *     fs.readFile(__dirname + value, "utf8", function (err, data) {
 *         if (err) return callback(err);
 *         try {
 *             configs[key] = JSON.parse(data);
 *         } catch (e) {
 *             return callback(e);
 *         }
 *         callback();
 *     });
 * }, function (err) {
 *     if (err) console.error(err.message);
 *     // configs is now a map of JSON data
 *     doSomethingWith(configs);
 * });
 */
module.exports = exports['default'];

/***/ }),

/***/ 297388:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = eachOfLimit;

var _eachOfLimit2 = __webpack_require__(656954);

var _eachOfLimit3 = _interopRequireDefault(_eachOfLimit2);

var _wrapAsync = __webpack_require__(28993);

var _wrapAsync2 = _interopRequireDefault(_wrapAsync);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The same as [`eachOf`]{@link module:Collections.eachOf} but runs a maximum of `limit` async operations at a
 * time.
 *
 * @name eachOfLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.eachOf]{@link module:Collections.eachOf}
 * @alias forEachOfLimit
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async function to apply to each
 * item in `coll`. The `key` is the item's key, or index in the case of an
 * array.
 * Invoked with (item, key, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 */
function eachOfLimit(coll, limit, iteratee, callback) {
  (0, _eachOfLimit3.default)(limit)(coll, (0, _wrapAsync2.default)(iteratee), callback);
}
module.exports = exports['default'];

/***/ }),

/***/ 194282:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var _eachLimit = __webpack_require__(814338);

var _eachLimit2 = _interopRequireDefault(_eachLimit);

var _doLimit = __webpack_require__(153875);

var _doLimit2 = _interopRequireDefault(_doLimit);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The same as [`each`]{@link module:Collections.each} but runs only a single async operation at a time.
 *
 * @name eachSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.each]{@link module:Collections.each}
 * @alias forEachSeries
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each
 * item in `coll`.
 * The array index is not passed to the iteratee.
 * If you need the index, use `eachOfSeries`.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 */
exports.default = (0, _doLimit2.default)(_eachLimit2.default, 1);
module.exports = exports['default'];

/***/ }),

/***/ 801605:
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
// A temporary value used to identify if the loop should be broken.
// See #1064, #1293
exports.default = {};
module.exports = exports["default"];

/***/ }),

/***/ 153875:
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = doLimit;
function doLimit(fn, limit) {
    return function (iterable, iteratee, callback) {
        return fn(iterable, limit, iteratee, callback);
    };
}
module.exports = exports["default"];

/***/ }),

/***/ 368468:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = doParallel;

var _eachOf = __webpack_require__(171846);

var _eachOf2 = _interopRequireDefault(_eachOf);

var _wrapAsync = __webpack_require__(28993);

var _wrapAsync2 = _interopRequireDefault(_wrapAsync);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function doParallel(fn) {
    return function (obj, iteratee, callback) {
        return fn(_eachOf2.default, obj, (0, _wrapAsync2.default)(iteratee), callback);
    };
}
module.exports = exports['default'];

/***/ }),

/***/ 656954:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = _eachOfLimit;

var _noop = __webpack_require__(850308);

var _noop2 = _interopRequireDefault(_noop);

var _once = __webpack_require__(146979);

var _once2 = _interopRequireDefault(_once);

var _iterator = __webpack_require__(309733);

var _iterator2 = _interopRequireDefault(_iterator);

var _onlyOnce = __webpack_require__(413362);

var _onlyOnce2 = _interopRequireDefault(_onlyOnce);

var _breakLoop = __webpack_require__(801605);

var _breakLoop2 = _interopRequireDefault(_breakLoop);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _eachOfLimit(limit) {
    return function (obj, iteratee, callback) {
        callback = (0, _once2.default)(callback || _noop2.default);
        if (limit <= 0 || !obj) {
            return callback(null);
        }
        var nextElem = (0, _iterator2.default)(obj);
        var done = false;
        var running = 0;
        var looping = false;

        function iterateeCallback(err, value) {
            running -= 1;
            if (err) {
                done = true;
                callback(err);
            } else if (value === _breakLoop2.default || done && running <= 0) {
                done = true;
                return callback(null);
            } else if (!looping) {
                replenish();
            }
        }

        function replenish() {
            looping = true;
            while (running < limit && !done) {
                var elem = nextElem();
                if (elem === null) {
                    done = true;
                    if (running <= 0) {
                        callback(null);
                    }
                    return;
                }
                running += 1;
                iteratee(elem.value, elem.key, (0, _onlyOnce2.default)(iterateeCallback));
            }
            looping = false;
        }

        replenish();
    };
}
module.exports = exports['default'];

/***/ }),

/***/ 37818:
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));

exports.default = function (coll) {
    return iteratorSymbol && coll[iteratorSymbol] && coll[iteratorSymbol]();
};

var iteratorSymbol = typeof Symbol === 'function' && Symbol.iterator;

module.exports = exports['default'];

/***/ }),

/***/ 643519:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));

exports.default = function (fn) {
    return function () /*...args, callback*/{
        var args = (0, _slice2.default)(arguments);
        var callback = args.pop();
        fn.call(this, args, callback);
    };
};

var _slice = __webpack_require__(163033);

var _slice2 = _interopRequireDefault(_slice);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

module.exports = exports['default'];

/***/ }),

/***/ 309733:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = iterator;

var _isArrayLike = __webpack_require__(498612);

var _isArrayLike2 = _interopRequireDefault(_isArrayLike);

var _getIterator = __webpack_require__(37818);

var _getIterator2 = _interopRequireDefault(_getIterator);

var _keys = __webpack_require__(3674);

var _keys2 = _interopRequireDefault(_keys);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createArrayIterator(coll) {
    var i = -1;
    var len = coll.length;
    return function next() {
        return ++i < len ? { value: coll[i], key: i } : null;
    };
}

function createES2015Iterator(iterator) {
    var i = -1;
    return function next() {
        var item = iterator.next();
        if (item.done) return null;
        i++;
        return { value: item.value, key: i };
    };
}

function createObjectIterator(obj) {
    var okeys = (0, _keys2.default)(obj);
    var i = -1;
    var len = okeys.length;
    return function next() {
        var key = okeys[++i];
        return i < len ? { value: obj[key], key: key } : null;
    };
}

function iterator(coll) {
    if ((0, _isArrayLike2.default)(coll)) {
        return createArrayIterator(coll);
    }

    var iterator = (0, _getIterator2.default)(coll);
    return iterator ? createES2015Iterator(iterator) : createObjectIterator(coll);
}
module.exports = exports['default'];

/***/ }),

/***/ 947662:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = _asyncMap;

var _noop = __webpack_require__(850308);

var _noop2 = _interopRequireDefault(_noop);

var _wrapAsync = __webpack_require__(28993);

var _wrapAsync2 = _interopRequireDefault(_wrapAsync);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncMap(eachfn, arr, iteratee, callback) {
    callback = callback || _noop2.default;
    arr = arr || [];
    var results = [];
    var counter = 0;
    var _iteratee = (0, _wrapAsync2.default)(iteratee);

    eachfn(arr, function (value, _, callback) {
        var index = counter++;
        _iteratee(value, function (err, v) {
            results[index] = v;
            callback(err);
        });
    }, function (err) {
        callback(err, results);
    });
}
module.exports = exports['default'];

/***/ }),

/***/ 146979:
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = once;
function once(fn) {
    return function () {
        if (fn === null) return;
        var callFn = fn;
        fn = null;
        callFn.apply(this, arguments);
    };
}
module.exports = exports["default"];

/***/ }),

/***/ 413362:
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = onlyOnce;
function onlyOnce(fn) {
    return function () {
        if (fn === null) throw new Error("Callback was already called.");
        var callFn = fn;
        fn = null;
        callFn.apply(this, arguments);
    };
}
module.exports = exports["default"];

/***/ }),

/***/ 203111:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.hasNextTick = exports.hasSetImmediate = undefined;
exports.fallback = fallback;
exports.wrap = wrap;

var _slice = __webpack_require__(163033);

var _slice2 = _interopRequireDefault(_slice);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var hasSetImmediate = exports.hasSetImmediate = typeof setImmediate === 'function' && setImmediate;
var hasNextTick = exports.hasNextTick = typeof process === 'object' && typeof process.nextTick === 'function';

function fallback(fn) {
    setTimeout(fn, 0);
}

function wrap(defer) {
    return function (fn /*, ...args*/) {
        var args = (0, _slice2.default)(arguments, 1);
        defer(function () {
            fn.apply(null, args);
        });
    };
}

var _defer;

if (hasSetImmediate) {
    _defer = setImmediate;
} else if (hasNextTick) {
    _defer = process.nextTick;
} else {
    _defer = fallback;
}

exports.default = wrap(_defer);

/***/ }),

/***/ 163033:
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = slice;
function slice(arrayLike, start) {
    start = start | 0;
    var newLen = Math.max(arrayLike.length - start, 0);
    var newArr = Array(newLen);
    for (var idx = 0; idx < newLen; idx++) {
        newArr[idx] = arrayLike[start + idx];
    }
    return newArr;
}
module.exports = exports["default"];

/***/ }),

/***/ 236529:
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.default = _withoutIndex;
function _withoutIndex(iteratee) {
    return function (value, index, callback) {
        return iteratee(value, callback);
    };
}
module.exports = exports["default"];

/***/ }),

/***/ 28993:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
    value: true
}));
exports.isAsync = undefined;

var _asyncify = __webpack_require__(944409);

var _asyncify2 = _interopRequireDefault(_asyncify);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var supportsSymbol = typeof Symbol === 'function';

function isAsync(fn) {
    return supportsSymbol && fn[Symbol.toStringTag] === 'AsyncFunction';
}

function wrapAsync(asyncFn) {
    return isAsync(asyncFn) ? (0, _asyncify2.default)(asyncFn) : asyncFn;
}

exports.default = wrapAsync;
exports.isAsync = isAsync;

/***/ }),

/***/ 494005:
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var _doParallel = __webpack_require__(368468);

var _doParallel2 = _interopRequireDefault(_doParallel);

var _map = __webpack_require__(947662);

var _map2 = _interopRequireDefault(_map);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Produces a new collection of values by mapping each value in `coll` through
 * the `iteratee` function. The `iteratee` is called with an item from `coll`
 * and a callback for when it has finished processing. Each of these callback
 * takes 2 arguments: an `error`, and the transformed item from `coll`. If
 * `iteratee` passes an error to its callback, the main `callback` (for the
 * `map` function) is immediately called with the error.
 *
 * Note, that since this function applies the `iteratee` to each item in
 * parallel, there is no guarantee that the `iteratee` functions will complete
 * in order. However, the results array will be in the same order as the
 * original `coll`.
 *
 * If `map` is passed an Object, the results will be an Array.  The results
 * will roughly be in the order of the original Objects' keys (but this can
 * vary across JavaScript engines).
 *
 * @name map
 * @static
 * @memberOf module:Collections
 * @method
 * @category Collection
 * @param {Array|Iterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with the transformed item.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Results is an Array of the
 * transformed items from the `coll`. Invoked with (err, results).
 * @example
 *
 * async.map(['file1','file2','file3'], fs.stat, function(err, results) {
 *     // results is now an array of stats for each file
 * });
 */
exports.default = (0, _doParallel2.default)(_map2.default);
module.exports = exports['default'];

/***/ }),

/***/ 705672:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Buffer = __webpack_require__(289509).Buffer
var createHash = __webpack_require__(189913)
var pbkdf2 = __webpack_require__(848601).pbkdf2Sync
var randomBytes = __webpack_require__(351353)

// use unorm until String.prototype.normalize gets better browser support
var unorm = __webpack_require__(331457)

var CHINESE_SIMPLIFIED_WORDLIST = __webpack_require__(102936)
var CHINESE_TRADITIONAL_WORDLIST = __webpack_require__(802678)
var ENGLISH_WORDLIST = __webpack_require__(285401)
var FRENCH_WORDLIST = __webpack_require__(662354)
var ITALIAN_WORDLIST = __webpack_require__(165296)
var JAPANESE_WORDLIST = __webpack_require__(598439)
var KOREAN_WORDLIST = __webpack_require__(77576)
var SPANISH_WORDLIST = __webpack_require__(594390)
var DEFAULT_WORDLIST = ENGLISH_WORDLIST

var INVALID_MNEMONIC = 'Invalid mnemonic'
var INVALID_ENTROPY = 'Invalid entropy'
var INVALID_CHECKSUM = 'Invalid mnemonic checksum'

function lpad (str, padString, length) {
  while (str.length < length) str = padString + str
  return str
}

function binaryToByte (bin) {
  return parseInt(bin, 2)
}

function bytesToBinary (bytes) {
  return bytes.map(function (x) {
    return lpad(x.toString(2), '0', 8)
  }).join('')
}

function deriveChecksumBits (entropyBuffer) {
  var ENT = entropyBuffer.length * 8
  var CS = ENT / 32
  var hash = createHash('sha256').update(entropyBuffer).digest()

  return bytesToBinary([].slice.call(hash)).slice(0, CS)
}

function salt (password) {
  return 'mnemonic' + (password || '')
}

function mnemonicToSeed (mnemonic, password) {
  var mnemonicBuffer = Buffer.from(unorm.nfkd(mnemonic), 'utf8')
  var saltBuffer = Buffer.from(salt(unorm.nfkd(password)), 'utf8')

  return pbkdf2(mnemonicBuffer, saltBuffer, 2048, 64, 'sha512')
}

function mnemonicToSeedHex (mnemonic, password) {
  return mnemonicToSeed(mnemonic, password).toString('hex')
}

function mnemonicToEntropy (mnemonic, wordlist) {
  wordlist = wordlist || DEFAULT_WORDLIST

  var words = unorm.nfkd(mnemonic).split(' ')
  if (words.length % 3 !== 0) throw new Error(INVALID_MNEMONIC)

  // convert word indices to 11 bit binary strings
  var bits = words.map(function (word) {
    var index = wordlist.indexOf(word)
    if (index === -1) throw new Error(INVALID_MNEMONIC)

    return lpad(index.toString(2), '0', 11)
  }).join('')

  // split the binary string into ENT/CS
  var dividerIndex = Math.floor(bits.length / 33) * 32
  var entropyBits = bits.slice(0, dividerIndex)
  var checksumBits = bits.slice(dividerIndex)

  // calculate the checksum and compare
  var entropyBytes = entropyBits.match(/(.{1,8})/g).map(binaryToByte)
  if (entropyBytes.length < 16) throw new Error(INVALID_ENTROPY)
  if (entropyBytes.length > 32) throw new Error(INVALID_ENTROPY)
  if (entropyBytes.length % 4 !== 0) throw new Error(INVALID_ENTROPY)

  var entropy = Buffer.from(entropyBytes)
  var newChecksum = deriveChecksumBits(entropy)
  if (newChecksum !== checksumBits) throw new Error(INVALID_CHECKSUM)

  return entropy.toString('hex')
}

function entropyToMnemonic (entropy, wordlist) {
  if (!Buffer.isBuffer(entropy)) entropy = Buffer.from(entropy, 'hex')
  wordlist = wordlist || DEFAULT_WORDLIST

  // 128 <= ENT <= 256
  if (entropy.length < 16) throw new TypeError(INVALID_ENTROPY)
  if (entropy.length > 32) throw new TypeError(INVALID_ENTROPY)
  if (entropy.length % 4 !== 0) throw new TypeError(INVALID_ENTROPY)

  var entropyBits = bytesToBinary([].slice.call(entropy))
  var checksumBits = deriveChecksumBits(entropy)

  var bits = entropyBits + checksumBits
  var chunks = bits.match(/(.{1,11})/g)
  var words = chunks.map(function (binary) {
    var index = binaryToByte(binary)
    return wordlist[index]
  })

  return wordlist === JAPANESE_WORDLIST ? words.join('\u3000') : words.join(' ')
}

function generateMnemonic (strength, rng, wordlist) {
  strength = strength || 128
  if (strength % 32 !== 0) throw new TypeError(INVALID_ENTROPY)
  rng = rng || randomBytes

  return entropyToMnemonic(rng(strength / 8), wordlist)
}

function validateMnemonic (mnemonic, wordlist) {
  try {
    mnemonicToEntropy(mnemonic, wordlist)
  } catch (e) {
    return false
  }

  return true
}

module.exports = {
  mnemonicToSeed: mnemonicToSeed,
  mnemonicToSeedHex: mnemonicToSeedHex,
  mnemonicToEntropy: mnemonicToEntropy,
  entropyToMnemonic: entropyToMnemonic,
  generateMnemonic: generateMnemonic,
  validateMnemonic: validateMnemonic,
  wordlists: {
    EN: ENGLISH_WORDLIST,
    JA: JAPANESE_WORDLIST,

    chinese_simplified: CHINESE_SIMPLIFIED_WORDLIST,
    chinese_traditional: CHINESE_TRADITIONAL_WORDLIST,
    english: ENGLISH_WORDLIST,
    french: FRENCH_WORDLIST,
    italian: ITALIAN_WORDLIST,
    japanese: JAPANESE_WORDLIST,
    korean: KOREAN_WORDLIST,
    spanish: SPANISH_WORDLIST
  }
}


/***/ }),

/***/ 102936:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse("[\"的\",\"一\",\"是\",\"在\",\"不\",\"了\",\"有\",\"和\",\"人\",\"这\",\"中\",\"大\",\"为\",\"上\",\"个\",\"国\",\"我\",\"以\",\"要\",\"他\",\"时\",\"来\",\"用\",\"们\",\"生\",\"到\",\"作\",\"地\",\"于\",\"出\",\"就\",\"分\",\"对\",\"成\",\"会\",\"可\",\"主\",\"发\",\"年\",\"动\",\"同\",\"工\",\"也\",\"能\",\"下\",\"过\",\"子\",\"说\",\"产\",\"种\",\"面\",\"而\",\"方\",\"后\",\"多\",\"定\",\"行\",\"学\",\"法\",\"所\",\"民\",\"得\",\"经\",\"十\",\"三\",\"之\",\"进\",\"着\",\"等\",\"部\",\"度\",\"家\",\"电\",\"力\",\"里\",\"如\",\"水\",\"化\",\"高\",\"自\",\"二\",\"理\",\"起\",\"小\",\"物\",\"现\",\"实\",\"加\",\"量\",\"都\",\"两\",\"体\",\"制\",\"机\",\"当\",\"使\",\"点\",\"从\",\"业\",\"本\",\"去\",\"把\",\"性\",\"好\",\"应\",\"开\",\"它\",\"合\",\"还\",\"因\",\"由\",\"其\",\"些\",\"然\",\"前\",\"外\",\"天\",\"政\",\"四\",\"日\",\"那\",\"社\",\"义\",\"事\",\"平\",\"形\",\"相\",\"全\",\"表\",\"间\",\"样\",\"与\",\"关\",\"各\",\"重\",\"新\",\"线\",\"内\",\"数\",\"正\",\"心\",\"反\",\"你\",\"明\",\"看\",\"原\",\"又\",\"么\",\"利\",\"比\",\"或\",\"但\",\"质\",\"气\",\"第\",\"向\",\"道\",\"命\",\"此\",\"变\",\"条\",\"只\",\"没\",\"结\",\"解\",\"问\",\"意\",\"建\",\"月\",\"公\",\"无\",\"系\",\"军\",\"很\",\"情\",\"者\",\"最\",\"立\",\"代\",\"想\",\"已\",\"通\",\"并\",\"提\",\"直\",\"题\",\"党\",\"程\",\"展\",\"五\",\"果\",\"料\",\"象\",\"员\",\"革\",\"位\",\"入\",\"常\",\"文\",\"总\",\"次\",\"品\",\"式\",\"活\",\"设\",\"及\",\"管\",\"特\",\"件\",\"长\",\"求\",\"老\",\"头\",\"基\",\"资\",\"边\",\"流\",\"路\",\"级\",\"少\",\"图\",\"山\",\"统\",\"接\",\"知\",\"较\",\"将\",\"组\",\"见\",\"计\",\"别\",\"她\",\"手\",\"角\",\"期\",\"根\",\"论\",\"运\",\"农\",\"指\",\"几\",\"九\",\"区\",\"强\",\"放\",\"决\",\"西\",\"被\",\"干\",\"做\",\"必\",\"战\",\"先\",\"回\",\"则\",\"任\",\"取\",\"据\",\"处\",\"队\",\"南\",\"给\",\"色\",\"光\",\"门\",\"即\",\"保\",\"治\",\"北\",\"造\",\"百\",\"规\",\"热\",\"领\",\"七\",\"海\",\"口\",\"东\",\"导\",\"器\",\"压\",\"志\",\"世\",\"金\",\"增\",\"争\",\"济\",\"阶\",\"油\",\"思\",\"术\",\"极\",\"交\",\"受\",\"联\",\"什\",\"认\",\"六\",\"共\",\"权\",\"收\",\"证\",\"改\",\"清\",\"美\",\"再\",\"采\",\"转\",\"更\",\"单\",\"风\",\"切\",\"打\",\"白\",\"教\",\"速\",\"花\",\"带\",\"安\",\"场\",\"身\",\"车\",\"例\",\"真\",\"务\",\"具\",\"万\",\"每\",\"目\",\"至\",\"达\",\"走\",\"积\",\"示\",\"议\",\"声\",\"报\",\"斗\",\"完\",\"类\",\"八\",\"离\",\"华\",\"名\",\"确\",\"才\",\"科\",\"张\",\"信\",\"马\",\"节\",\"话\",\"米\",\"整\",\"空\",\"元\",\"况\",\"今\",\"集\",\"温\",\"传\",\"土\",\"许\",\"步\",\"群\",\"广\",\"石\",\"记\",\"需\",\"段\",\"研\",\"界\",\"拉\",\"林\",\"律\",\"叫\",\"且\",\"究\",\"观\",\"越\",\"织\",\"装\",\"影\",\"算\",\"低\",\"持\",\"音\",\"众\",\"书\",\"布\",\"复\",\"容\",\"儿\",\"须\",\"际\",\"商\",\"非\",\"验\",\"连\",\"断\",\"深\",\"难\",\"近\",\"矿\",\"千\",\"周\",\"委\",\"素\",\"技\",\"备\",\"半\",\"办\",\"青\",\"省\",\"列\",\"习\",\"响\",\"约\",\"支\",\"般\",\"史\",\"感\",\"劳\",\"便\",\"团\",\"往\",\"酸\",\"历\",\"市\",\"克\",\"何\",\"除\",\"消\",\"构\",\"府\",\"称\",\"太\",\"准\",\"精\",\"值\",\"号\",\"率\",\"族\",\"维\",\"划\",\"选\",\"标\",\"写\",\"存\",\"候\",\"毛\",\"亲\",\"快\",\"效\",\"斯\",\"院\",\"查\",\"江\",\"型\",\"眼\",\"王\",\"按\",\"格\",\"养\",\"易\",\"置\",\"派\",\"层\",\"片\",\"始\",\"却\",\"专\",\"状\",\"育\",\"厂\",\"京\",\"识\",\"适\",\"属\",\"圆\",\"包\",\"火\",\"住\",\"调\",\"满\",\"县\",\"局\",\"照\",\"参\",\"红\",\"细\",\"引\",\"听\",\"该\",\"铁\",\"价\",\"严\",\"首\",\"底\",\"液\",\"官\",\"德\",\"随\",\"病\",\"苏\",\"失\",\"尔\",\"死\",\"讲\",\"配\",\"女\",\"黄\",\"推\",\"显\",\"谈\",\"罪\",\"神\",\"艺\",\"呢\",\"席\",\"含\",\"企\",\"望\",\"密\",\"批\",\"营\",\"项\",\"防\",\"举\",\"球\",\"英\",\"氧\",\"势\",\"告\",\"李\",\"台\",\"落\",\"木\",\"帮\",\"轮\",\"破\",\"亚\",\"师\",\"围\",\"注\",\"远\",\"字\",\"材\",\"排\",\"供\",\"河\",\"态\",\"封\",\"另\",\"施\",\"减\",\"树\",\"溶\",\"怎\",\"止\",\"案\",\"言\",\"士\",\"均\",\"武\",\"固\",\"叶\",\"鱼\",\"波\",\"视\",\"仅\",\"费\",\"紧\",\"爱\",\"左\",\"章\",\"早\",\"朝\",\"害\",\"续\",\"轻\",\"服\",\"试\",\"食\",\"充\",\"兵\",\"源\",\"判\",\"护\",\"司\",\"足\",\"某\",\"练\",\"差\",\"致\",\"板\",\"田\",\"降\",\"黑\",\"犯\",\"负\",\"击\",\"范\",\"继\",\"兴\",\"似\",\"余\",\"坚\",\"曲\",\"输\",\"修\",\"故\",\"城\",\"夫\",\"够\",\"送\",\"笔\",\"船\",\"占\",\"右\",\"财\",\"吃\",\"富\",\"春\",\"职\",\"觉\",\"汉\",\"画\",\"功\",\"巴\",\"跟\",\"虽\",\"杂\",\"飞\",\"检\",\"吸\",\"助\",\"升\",\"阳\",\"互\",\"初\",\"创\",\"抗\",\"考\",\"投\",\"坏\",\"策\",\"古\",\"径\",\"换\",\"未\",\"跑\",\"留\",\"钢\",\"曾\",\"端\",\"责\",\"站\",\"简\",\"述\",\"钱\",\"副\",\"尽\",\"帝\",\"射\",\"草\",\"冲\",\"承\",\"独\",\"令\",\"限\",\"阿\",\"宣\",\"环\",\"双\",\"请\",\"超\",\"微\",\"让\",\"控\",\"州\",\"良\",\"轴\",\"找\",\"否\",\"纪\",\"益\",\"依\",\"优\",\"顶\",\"础\",\"载\",\"倒\",\"房\",\"突\",\"坐\",\"粉\",\"敌\",\"略\",\"客\",\"袁\",\"冷\",\"胜\",\"绝\",\"析\",\"块\",\"剂\",\"测\",\"丝\",\"协\",\"诉\",\"念\",\"陈\",\"仍\",\"罗\",\"盐\",\"友\",\"洋\",\"错\",\"苦\",\"夜\",\"刑\",\"移\",\"频\",\"逐\",\"靠\",\"混\",\"母\",\"短\",\"皮\",\"终\",\"聚\",\"汽\",\"村\",\"云\",\"哪\",\"既\",\"距\",\"卫\",\"停\",\"烈\",\"央\",\"察\",\"烧\",\"迅\",\"境\",\"若\",\"印\",\"洲\",\"刻\",\"括\",\"激\",\"孔\",\"搞\",\"甚\",\"室\",\"待\",\"核\",\"校\",\"散\",\"侵\",\"吧\",\"甲\",\"游\",\"久\",\"菜\",\"味\",\"旧\",\"模\",\"湖\",\"货\",\"损\",\"预\",\"阻\",\"毫\",\"普\",\"稳\",\"乙\",\"妈\",\"植\",\"息\",\"扩\",\"银\",\"语\",\"挥\",\"酒\",\"守\",\"拿\",\"序\",\"纸\",\"医\",\"缺\",\"雨\",\"吗\",\"针\",\"刘\",\"啊\",\"急\",\"唱\",\"误\",\"训\",\"愿\",\"审\",\"附\",\"获\",\"茶\",\"鲜\",\"粮\",\"斤\",\"孩\",\"脱\",\"硫\",\"肥\",\"善\",\"龙\",\"演\",\"父\",\"渐\",\"血\",\"欢\",\"械\",\"掌\",\"歌\",\"沙\",\"刚\",\"攻\",\"谓\",\"盾\",\"讨\",\"晚\",\"粒\",\"乱\",\"燃\",\"矛\",\"乎\",\"杀\",\"药\",\"宁\",\"鲁\",\"贵\",\"钟\",\"煤\",\"读\",\"班\",\"伯\",\"香\",\"介\",\"迫\",\"句\",\"丰\",\"培\",\"握\",\"兰\",\"担\",\"弦\",\"蛋\",\"沉\",\"假\",\"穿\",\"执\",\"答\",\"乐\",\"谁\",\"顺\",\"烟\",\"缩\",\"征\",\"脸\",\"喜\",\"松\",\"脚\",\"困\",\"异\",\"免\",\"背\",\"星\",\"福\",\"买\",\"染\",\"井\",\"概\",\"慢\",\"怕\",\"磁\",\"倍\",\"祖\",\"皇\",\"促\",\"静\",\"补\",\"评\",\"翻\",\"肉\",\"践\",\"尼\",\"衣\",\"宽\",\"扬\",\"棉\",\"希\",\"伤\",\"操\",\"垂\",\"秋\",\"宜\",\"氢\",\"套\",\"督\",\"振\",\"架\",\"亮\",\"末\",\"宪\",\"庆\",\"编\",\"牛\",\"触\",\"映\",\"雷\",\"销\",\"诗\",\"座\",\"居\",\"抓\",\"裂\",\"胞\",\"呼\",\"娘\",\"景\",\"威\",\"绿\",\"晶\",\"厚\",\"盟\",\"衡\",\"鸡\",\"孙\",\"延\",\"危\",\"胶\",\"屋\",\"乡\",\"临\",\"陆\",\"顾\",\"掉\",\"呀\",\"灯\",\"岁\",\"措\",\"束\",\"耐\",\"剧\",\"玉\",\"赵\",\"跳\",\"哥\",\"季\",\"课\",\"凯\",\"胡\",\"额\",\"款\",\"绍\",\"卷\",\"齐\",\"伟\",\"蒸\",\"殖\",\"永\",\"宗\",\"苗\",\"川\",\"炉\",\"岩\",\"弱\",\"零\",\"杨\",\"奏\",\"沿\",\"露\",\"杆\",\"探\",\"滑\",\"镇\",\"饭\",\"浓\",\"航\",\"怀\",\"赶\",\"库\",\"夺\",\"伊\",\"灵\",\"税\",\"途\",\"灭\",\"赛\",\"归\",\"召\",\"鼓\",\"播\",\"盘\",\"裁\",\"险\",\"康\",\"唯\",\"录\",\"菌\",\"纯\",\"借\",\"糖\",\"盖\",\"横\",\"符\",\"私\",\"努\",\"堂\",\"域\",\"枪\",\"润\",\"幅\",\"哈\",\"竟\",\"熟\",\"虫\",\"泽\",\"脑\",\"壤\",\"碳\",\"欧\",\"遍\",\"侧\",\"寨\",\"敢\",\"彻\",\"虑\",\"斜\",\"薄\",\"庭\",\"纳\",\"弹\",\"饲\",\"伸\",\"折\",\"麦\",\"湿\",\"暗\",\"荷\",\"瓦\",\"塞\",\"床\",\"筑\",\"恶\",\"户\",\"访\",\"塔\",\"奇\",\"透\",\"梁\",\"刀\",\"旋\",\"迹\",\"卡\",\"氯\",\"遇\",\"份\",\"毒\",\"泥\",\"退\",\"洗\",\"摆\",\"灰\",\"彩\",\"卖\",\"耗\",\"夏\",\"择\",\"忙\",\"铜\",\"献\",\"硬\",\"予\",\"繁\",\"圈\",\"雪\",\"函\",\"亦\",\"抽\",\"篇\",\"阵\",\"阴\",\"丁\",\"尺\",\"追\",\"堆\",\"雄\",\"迎\",\"泛\",\"爸\",\"楼\",\"避\",\"谋\",\"吨\",\"野\",\"猪\",\"旗\",\"累\",\"偏\",\"典\",\"馆\",\"索\",\"秦\",\"脂\",\"潮\",\"爷\",\"豆\",\"忽\",\"托\",\"惊\",\"塑\",\"遗\",\"愈\",\"朱\",\"替\",\"纤\",\"粗\",\"倾\",\"尚\",\"痛\",\"楚\",\"谢\",\"奋\",\"购\",\"磨\",\"君\",\"池\",\"旁\",\"碎\",\"骨\",\"监\",\"捕\",\"弟\",\"暴\",\"割\",\"贯\",\"殊\",\"释\",\"词\",\"亡\",\"壁\",\"顿\",\"宝\",\"午\",\"尘\",\"闻\",\"揭\",\"炮\",\"残\",\"冬\",\"桥\",\"妇\",\"警\",\"综\",\"招\",\"吴\",\"付\",\"浮\",\"遭\",\"徐\",\"您\",\"摇\",\"谷\",\"赞\",\"箱\",\"隔\",\"订\",\"男\",\"吹\",\"园\",\"纷\",\"唐\",\"败\",\"宋\",\"玻\",\"巨\",\"耕\",\"坦\",\"荣\",\"闭\",\"湾\",\"键\",\"凡\",\"驻\",\"锅\",\"救\",\"恩\",\"剥\",\"凝\",\"碱\",\"齿\",\"截\",\"炼\",\"麻\",\"纺\",\"禁\",\"废\",\"盛\",\"版\",\"缓\",\"净\",\"睛\",\"昌\",\"婚\",\"涉\",\"筒\",\"嘴\",\"插\",\"岸\",\"朗\",\"庄\",\"街\",\"藏\",\"姑\",\"贸\",\"腐\",\"奴\",\"啦\",\"惯\",\"乘\",\"伙\",\"恢\",\"匀\",\"纱\",\"扎\",\"辩\",\"耳\",\"彪\",\"臣\",\"亿\",\"璃\",\"抵\",\"脉\",\"秀\",\"萨\",\"俄\",\"网\",\"舞\",\"店\",\"喷\",\"纵\",\"寸\",\"汗\",\"挂\",\"洪\",\"贺\",\"闪\",\"柬\",\"爆\",\"烯\",\"津\",\"稻\",\"墙\",\"软\",\"勇\",\"像\",\"滚\",\"厘\",\"蒙\",\"芳\",\"肯\",\"坡\",\"柱\",\"荡\",\"腿\",\"仪\",\"旅\",\"尾\",\"轧\",\"冰\",\"贡\",\"登\",\"黎\",\"削\",\"钻\",\"勒\",\"逃\",\"障\",\"氨\",\"郭\",\"峰\",\"币\",\"港\",\"伏\",\"轨\",\"亩\",\"毕\",\"擦\",\"莫\",\"刺\",\"浪\",\"秘\",\"援\",\"株\",\"健\",\"售\",\"股\",\"岛\",\"甘\",\"泡\",\"睡\",\"童\",\"铸\",\"汤\",\"阀\",\"休\",\"汇\",\"舍\",\"牧\",\"绕\",\"炸\",\"哲\",\"磷\",\"绩\",\"朋\",\"淡\",\"尖\",\"启\",\"陷\",\"柴\",\"呈\",\"徒\",\"颜\",\"泪\",\"稍\",\"忘\",\"泵\",\"蓝\",\"拖\",\"洞\",\"授\",\"镜\",\"辛\",\"壮\",\"锋\",\"贫\",\"虚\",\"弯\",\"摩\",\"泰\",\"幼\",\"廷\",\"尊\",\"窗\",\"纲\",\"弄\",\"隶\",\"疑\",\"氏\",\"宫\",\"姐\",\"震\",\"瑞\",\"怪\",\"尤\",\"琴\",\"循\",\"描\",\"膜\",\"违\",\"夹\",\"腰\",\"缘\",\"珠\",\"穷\",\"森\",\"枝\",\"竹\",\"沟\",\"催\",\"绳\",\"忆\",\"邦\",\"剩\",\"幸\",\"浆\",\"栏\",\"拥\",\"牙\",\"贮\",\"礼\",\"滤\",\"钠\",\"纹\",\"罢\",\"拍\",\"咱\",\"喊\",\"袖\",\"埃\",\"勤\",\"罚\",\"焦\",\"潜\",\"伍\",\"墨\",\"欲\",\"缝\",\"姓\",\"刊\",\"饱\",\"仿\",\"奖\",\"铝\",\"鬼\",\"丽\",\"跨\",\"默\",\"挖\",\"链\",\"扫\",\"喝\",\"袋\",\"炭\",\"污\",\"幕\",\"诸\",\"弧\",\"励\",\"梅\",\"奶\",\"洁\",\"灾\",\"舟\",\"鉴\",\"苯\",\"讼\",\"抱\",\"毁\",\"懂\",\"寒\",\"智\",\"埔\",\"寄\",\"届\",\"跃\",\"渡\",\"挑\",\"丹\",\"艰\",\"贝\",\"碰\",\"拔\",\"爹\",\"戴\",\"码\",\"梦\",\"芽\",\"熔\",\"赤\",\"渔\",\"哭\",\"敬\",\"颗\",\"奔\",\"铅\",\"仲\",\"虎\",\"稀\",\"妹\",\"乏\",\"珍\",\"申\",\"桌\",\"遵\",\"允\",\"隆\",\"螺\",\"仓\",\"魏\",\"锐\",\"晓\",\"氮\",\"兼\",\"隐\",\"碍\",\"赫\",\"拨\",\"忠\",\"肃\",\"缸\",\"牵\",\"抢\",\"博\",\"巧\",\"壳\",\"兄\",\"杜\",\"讯\",\"诚\",\"碧\",\"祥\",\"柯\",\"页\",\"巡\",\"矩\",\"悲\",\"灌\",\"龄\",\"伦\",\"票\",\"寻\",\"桂\",\"铺\",\"圣\",\"恐\",\"恰\",\"郑\",\"趣\",\"抬\",\"荒\",\"腾\",\"贴\",\"柔\",\"滴\",\"猛\",\"阔\",\"辆\",\"妻\",\"填\",\"撤\",\"储\",\"签\",\"闹\",\"扰\",\"紫\",\"砂\",\"递\",\"戏\",\"吊\",\"陶\",\"伐\",\"喂\",\"疗\",\"瓶\",\"婆\",\"抚\",\"臂\",\"摸\",\"忍\",\"虾\",\"蜡\",\"邻\",\"胸\",\"巩\",\"挤\",\"偶\",\"弃\",\"槽\",\"劲\",\"乳\",\"邓\",\"吉\",\"仁\",\"烂\",\"砖\",\"租\",\"乌\",\"舰\",\"伴\",\"瓜\",\"浅\",\"丙\",\"暂\",\"燥\",\"橡\",\"柳\",\"迷\",\"暖\",\"牌\",\"秧\",\"胆\",\"详\",\"簧\",\"踏\",\"瓷\",\"谱\",\"呆\",\"宾\",\"糊\",\"洛\",\"辉\",\"愤\",\"竞\",\"隙\",\"怒\",\"粘\",\"乃\",\"绪\",\"肩\",\"籍\",\"敏\",\"涂\",\"熙\",\"皆\",\"侦\",\"悬\",\"掘\",\"享\",\"纠\",\"醒\",\"狂\",\"锁\",\"淀\",\"恨\",\"牲\",\"霸\",\"爬\",\"赏\",\"逆\",\"玩\",\"陵\",\"祝\",\"秒\",\"浙\",\"貌\",\"役\",\"彼\",\"悉\",\"鸭\",\"趋\",\"凤\",\"晨\",\"畜\",\"辈\",\"秩\",\"卵\",\"署\",\"梯\",\"炎\",\"滩\",\"棋\",\"驱\",\"筛\",\"峡\",\"冒\",\"啥\",\"寿\",\"译\",\"浸\",\"泉\",\"帽\",\"迟\",\"硅\",\"疆\",\"贷\",\"漏\",\"稿\",\"冠\",\"嫩\",\"胁\",\"芯\",\"牢\",\"叛\",\"蚀\",\"奥\",\"鸣\",\"岭\",\"羊\",\"凭\",\"串\",\"塘\",\"绘\",\"酵\",\"融\",\"盆\",\"锡\",\"庙\",\"筹\",\"冻\",\"辅\",\"摄\",\"袭\",\"筋\",\"拒\",\"僚\",\"旱\",\"钾\",\"鸟\",\"漆\",\"沈\",\"眉\",\"疏\",\"添\",\"棒\",\"穗\",\"硝\",\"韩\",\"逼\",\"扭\",\"侨\",\"凉\",\"挺\",\"碗\",\"栽\",\"炒\",\"杯\",\"患\",\"馏\",\"劝\",\"豪\",\"辽\",\"勃\",\"鸿\",\"旦\",\"吏\",\"拜\",\"狗\",\"埋\",\"辊\",\"掩\",\"饮\",\"搬\",\"骂\",\"辞\",\"勾\",\"扣\",\"估\",\"蒋\",\"绒\",\"雾\",\"丈\",\"朵\",\"姆\",\"拟\",\"宇\",\"辑\",\"陕\",\"雕\",\"偿\",\"蓄\",\"崇\",\"剪\",\"倡\",\"厅\",\"咬\",\"驶\",\"薯\",\"刷\",\"斥\",\"番\",\"赋\",\"奉\",\"佛\",\"浇\",\"漫\",\"曼\",\"扇\",\"钙\",\"桃\",\"扶\",\"仔\",\"返\",\"俗\",\"亏\",\"腔\",\"鞋\",\"棱\",\"覆\",\"框\",\"悄\",\"叔\",\"撞\",\"骗\",\"勘\",\"旺\",\"沸\",\"孤\",\"吐\",\"孟\",\"渠\",\"屈\",\"疾\",\"妙\",\"惜\",\"仰\",\"狠\",\"胀\",\"谐\",\"抛\",\"霉\",\"桑\",\"岗\",\"嘛\",\"衰\",\"盗\",\"渗\",\"脏\",\"赖\",\"涌\",\"甜\",\"曹\",\"阅\",\"肌\",\"哩\",\"厉\",\"烃\",\"纬\",\"毅\",\"昨\",\"伪\",\"症\",\"煮\",\"叹\",\"钉\",\"搭\",\"茎\",\"笼\",\"酷\",\"偷\",\"弓\",\"锥\",\"恒\",\"杰\",\"坑\",\"鼻\",\"翼\",\"纶\",\"叙\",\"狱\",\"逮\",\"罐\",\"络\",\"棚\",\"抑\",\"膨\",\"蔬\",\"寺\",\"骤\",\"穆\",\"冶\",\"枯\",\"册\",\"尸\",\"凸\",\"绅\",\"坯\",\"牺\",\"焰\",\"轰\",\"欣\",\"晋\",\"瘦\",\"御\",\"锭\",\"锦\",\"丧\",\"旬\",\"锻\",\"垄\",\"搜\",\"扑\",\"邀\",\"亭\",\"酯\",\"迈\",\"舒\",\"脆\",\"酶\",\"闲\",\"忧\",\"酚\",\"顽\",\"羽\",\"涨\",\"卸\",\"仗\",\"陪\",\"辟\",\"惩\",\"杭\",\"姚\",\"肚\",\"捉\",\"飘\",\"漂\",\"昆\",\"欺\",\"吾\",\"郎\",\"烷\",\"汁\",\"呵\",\"饰\",\"萧\",\"雅\",\"邮\",\"迁\",\"燕\",\"撒\",\"姻\",\"赴\",\"宴\",\"烦\",\"债\",\"帐\",\"斑\",\"铃\",\"旨\",\"醇\",\"董\",\"饼\",\"雏\",\"姿\",\"拌\",\"傅\",\"腹\",\"妥\",\"揉\",\"贤\",\"拆\",\"歪\",\"葡\",\"胺\",\"丢\",\"浩\",\"徽\",\"昂\",\"垫\",\"挡\",\"览\",\"贪\",\"慰\",\"缴\",\"汪\",\"慌\",\"冯\",\"诺\",\"姜\",\"谊\",\"凶\",\"劣\",\"诬\",\"耀\",\"昏\",\"躺\",\"盈\",\"骑\",\"乔\",\"溪\",\"丛\",\"卢\",\"抹\",\"闷\",\"咨\",\"刮\",\"驾\",\"缆\",\"悟\",\"摘\",\"铒\",\"掷\",\"颇\",\"幻\",\"柄\",\"惠\",\"惨\",\"佳\",\"仇\",\"腊\",\"窝\",\"涤\",\"剑\",\"瞧\",\"堡\",\"泼\",\"葱\",\"罩\",\"霍\",\"捞\",\"胎\",\"苍\",\"滨\",\"俩\",\"捅\",\"湘\",\"砍\",\"霞\",\"邵\",\"萄\",\"疯\",\"淮\",\"遂\",\"熊\",\"粪\",\"烘\",\"宿\",\"档\",\"戈\",\"驳\",\"嫂\",\"裕\",\"徙\",\"箭\",\"捐\",\"肠\",\"撑\",\"晒\",\"辨\",\"殿\",\"莲\",\"摊\",\"搅\",\"酱\",\"屏\",\"疫\",\"哀\",\"蔡\",\"堵\",\"沫\",\"皱\",\"畅\",\"叠\",\"阁\",\"莱\",\"敲\",\"辖\",\"钩\",\"痕\",\"坝\",\"巷\",\"饿\",\"祸\",\"丘\",\"玄\",\"溜\",\"曰\",\"逻\",\"彭\",\"尝\",\"卿\",\"妨\",\"艇\",\"吞\",\"韦\",\"怨\",\"矮\",\"歇\"]");

/***/ }),

/***/ 802678:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse("[\"的\",\"一\",\"是\",\"在\",\"不\",\"了\",\"有\",\"和\",\"人\",\"這\",\"中\",\"大\",\"為\",\"上\",\"個\",\"國\",\"我\",\"以\",\"要\",\"他\",\"時\",\"來\",\"用\",\"們\",\"生\",\"到\",\"作\",\"地\",\"於\",\"出\",\"就\",\"分\",\"對\",\"成\",\"會\",\"可\",\"主\",\"發\",\"年\",\"動\",\"同\",\"工\",\"也\",\"能\",\"下\",\"過\",\"子\",\"說\",\"產\",\"種\",\"面\",\"而\",\"方\",\"後\",\"多\",\"定\",\"行\",\"學\",\"法\",\"所\",\"民\",\"得\",\"經\",\"十\",\"三\",\"之\",\"進\",\"著\",\"等\",\"部\",\"度\",\"家\",\"電\",\"力\",\"裡\",\"如\",\"水\",\"化\",\"高\",\"自\",\"二\",\"理\",\"起\",\"小\",\"物\",\"現\",\"實\",\"加\",\"量\",\"都\",\"兩\",\"體\",\"制\",\"機\",\"當\",\"使\",\"點\",\"從\",\"業\",\"本\",\"去\",\"把\",\"性\",\"好\",\"應\",\"開\",\"它\",\"合\",\"還\",\"因\",\"由\",\"其\",\"些\",\"然\",\"前\",\"外\",\"天\",\"政\",\"四\",\"日\",\"那\",\"社\",\"義\",\"事\",\"平\",\"形\",\"相\",\"全\",\"表\",\"間\",\"樣\",\"與\",\"關\",\"各\",\"重\",\"新\",\"線\",\"內\",\"數\",\"正\",\"心\",\"反\",\"你\",\"明\",\"看\",\"原\",\"又\",\"麼\",\"利\",\"比\",\"或\",\"但\",\"質\",\"氣\",\"第\",\"向\",\"道\",\"命\",\"此\",\"變\",\"條\",\"只\",\"沒\",\"結\",\"解\",\"問\",\"意\",\"建\",\"月\",\"公\",\"無\",\"系\",\"軍\",\"很\",\"情\",\"者\",\"最\",\"立\",\"代\",\"想\",\"已\",\"通\",\"並\",\"提\",\"直\",\"題\",\"黨\",\"程\",\"展\",\"五\",\"果\",\"料\",\"象\",\"員\",\"革\",\"位\",\"入\",\"常\",\"文\",\"總\",\"次\",\"品\",\"式\",\"活\",\"設\",\"及\",\"管\",\"特\",\"件\",\"長\",\"求\",\"老\",\"頭\",\"基\",\"資\",\"邊\",\"流\",\"路\",\"級\",\"少\",\"圖\",\"山\",\"統\",\"接\",\"知\",\"較\",\"將\",\"組\",\"見\",\"計\",\"別\",\"她\",\"手\",\"角\",\"期\",\"根\",\"論\",\"運\",\"農\",\"指\",\"幾\",\"九\",\"區\",\"強\",\"放\",\"決\",\"西\",\"被\",\"幹\",\"做\",\"必\",\"戰\",\"先\",\"回\",\"則\",\"任\",\"取\",\"據\",\"處\",\"隊\",\"南\",\"給\",\"色\",\"光\",\"門\",\"即\",\"保\",\"治\",\"北\",\"造\",\"百\",\"規\",\"熱\",\"領\",\"七\",\"海\",\"口\",\"東\",\"導\",\"器\",\"壓\",\"志\",\"世\",\"金\",\"增\",\"爭\",\"濟\",\"階\",\"油\",\"思\",\"術\",\"極\",\"交\",\"受\",\"聯\",\"什\",\"認\",\"六\",\"共\",\"權\",\"收\",\"證\",\"改\",\"清\",\"美\",\"再\",\"採\",\"轉\",\"更\",\"單\",\"風\",\"切\",\"打\",\"白\",\"教\",\"速\",\"花\",\"帶\",\"安\",\"場\",\"身\",\"車\",\"例\",\"真\",\"務\",\"具\",\"萬\",\"每\",\"目\",\"至\",\"達\",\"走\",\"積\",\"示\",\"議\",\"聲\",\"報\",\"鬥\",\"完\",\"類\",\"八\",\"離\",\"華\",\"名\",\"確\",\"才\",\"科\",\"張\",\"信\",\"馬\",\"節\",\"話\",\"米\",\"整\",\"空\",\"元\",\"況\",\"今\",\"集\",\"溫\",\"傳\",\"土\",\"許\",\"步\",\"群\",\"廣\",\"石\",\"記\",\"需\",\"段\",\"研\",\"界\",\"拉\",\"林\",\"律\",\"叫\",\"且\",\"究\",\"觀\",\"越\",\"織\",\"裝\",\"影\",\"算\",\"低\",\"持\",\"音\",\"眾\",\"書\",\"布\",\"复\",\"容\",\"兒\",\"須\",\"際\",\"商\",\"非\",\"驗\",\"連\",\"斷\",\"深\",\"難\",\"近\",\"礦\",\"千\",\"週\",\"委\",\"素\",\"技\",\"備\",\"半\",\"辦\",\"青\",\"省\",\"列\",\"習\",\"響\",\"約\",\"支\",\"般\",\"史\",\"感\",\"勞\",\"便\",\"團\",\"往\",\"酸\",\"歷\",\"市\",\"克\",\"何\",\"除\",\"消\",\"構\",\"府\",\"稱\",\"太\",\"準\",\"精\",\"值\",\"號\",\"率\",\"族\",\"維\",\"劃\",\"選\",\"標\",\"寫\",\"存\",\"候\",\"毛\",\"親\",\"快\",\"效\",\"斯\",\"院\",\"查\",\"江\",\"型\",\"眼\",\"王\",\"按\",\"格\",\"養\",\"易\",\"置\",\"派\",\"層\",\"片\",\"始\",\"卻\",\"專\",\"狀\",\"育\",\"廠\",\"京\",\"識\",\"適\",\"屬\",\"圓\",\"包\",\"火\",\"住\",\"調\",\"滿\",\"縣\",\"局\",\"照\",\"參\",\"紅\",\"細\",\"引\",\"聽\",\"該\",\"鐵\",\"價\",\"嚴\",\"首\",\"底\",\"液\",\"官\",\"德\",\"隨\",\"病\",\"蘇\",\"失\",\"爾\",\"死\",\"講\",\"配\",\"女\",\"黃\",\"推\",\"顯\",\"談\",\"罪\",\"神\",\"藝\",\"呢\",\"席\",\"含\",\"企\",\"望\",\"密\",\"批\",\"營\",\"項\",\"防\",\"舉\",\"球\",\"英\",\"氧\",\"勢\",\"告\",\"李\",\"台\",\"落\",\"木\",\"幫\",\"輪\",\"破\",\"亞\",\"師\",\"圍\",\"注\",\"遠\",\"字\",\"材\",\"排\",\"供\",\"河\",\"態\",\"封\",\"另\",\"施\",\"減\",\"樹\",\"溶\",\"怎\",\"止\",\"案\",\"言\",\"士\",\"均\",\"武\",\"固\",\"葉\",\"魚\",\"波\",\"視\",\"僅\",\"費\",\"緊\",\"愛\",\"左\",\"章\",\"早\",\"朝\",\"害\",\"續\",\"輕\",\"服\",\"試\",\"食\",\"充\",\"兵\",\"源\",\"判\",\"護\",\"司\",\"足\",\"某\",\"練\",\"差\",\"致\",\"板\",\"田\",\"降\",\"黑\",\"犯\",\"負\",\"擊\",\"范\",\"繼\",\"興\",\"似\",\"餘\",\"堅\",\"曲\",\"輸\",\"修\",\"故\",\"城\",\"夫\",\"夠\",\"送\",\"筆\",\"船\",\"佔\",\"右\",\"財\",\"吃\",\"富\",\"春\",\"職\",\"覺\",\"漢\",\"畫\",\"功\",\"巴\",\"跟\",\"雖\",\"雜\",\"飛\",\"檢\",\"吸\",\"助\",\"昇\",\"陽\",\"互\",\"初\",\"創\",\"抗\",\"考\",\"投\",\"壞\",\"策\",\"古\",\"徑\",\"換\",\"未\",\"跑\",\"留\",\"鋼\",\"曾\",\"端\",\"責\",\"站\",\"簡\",\"述\",\"錢\",\"副\",\"盡\",\"帝\",\"射\",\"草\",\"衝\",\"承\",\"獨\",\"令\",\"限\",\"阿\",\"宣\",\"環\",\"雙\",\"請\",\"超\",\"微\",\"讓\",\"控\",\"州\",\"良\",\"軸\",\"找\",\"否\",\"紀\",\"益\",\"依\",\"優\",\"頂\",\"礎\",\"載\",\"倒\",\"房\",\"突\",\"坐\",\"粉\",\"敵\",\"略\",\"客\",\"袁\",\"冷\",\"勝\",\"絕\",\"析\",\"塊\",\"劑\",\"測\",\"絲\",\"協\",\"訴\",\"念\",\"陳\",\"仍\",\"羅\",\"鹽\",\"友\",\"洋\",\"錯\",\"苦\",\"夜\",\"刑\",\"移\",\"頻\",\"逐\",\"靠\",\"混\",\"母\",\"短\",\"皮\",\"終\",\"聚\",\"汽\",\"村\",\"雲\",\"哪\",\"既\",\"距\",\"衛\",\"停\",\"烈\",\"央\",\"察\",\"燒\",\"迅\",\"境\",\"若\",\"印\",\"洲\",\"刻\",\"括\",\"激\",\"孔\",\"搞\",\"甚\",\"室\",\"待\",\"核\",\"校\",\"散\",\"侵\",\"吧\",\"甲\",\"遊\",\"久\",\"菜\",\"味\",\"舊\",\"模\",\"湖\",\"貨\",\"損\",\"預\",\"阻\",\"毫\",\"普\",\"穩\",\"乙\",\"媽\",\"植\",\"息\",\"擴\",\"銀\",\"語\",\"揮\",\"酒\",\"守\",\"拿\",\"序\",\"紙\",\"醫\",\"缺\",\"雨\",\"嗎\",\"針\",\"劉\",\"啊\",\"急\",\"唱\",\"誤\",\"訓\",\"願\",\"審\",\"附\",\"獲\",\"茶\",\"鮮\",\"糧\",\"斤\",\"孩\",\"脫\",\"硫\",\"肥\",\"善\",\"龍\",\"演\",\"父\",\"漸\",\"血\",\"歡\",\"械\",\"掌\",\"歌\",\"沙\",\"剛\",\"攻\",\"謂\",\"盾\",\"討\",\"晚\",\"粒\",\"亂\",\"燃\",\"矛\",\"乎\",\"殺\",\"藥\",\"寧\",\"魯\",\"貴\",\"鐘\",\"煤\",\"讀\",\"班\",\"伯\",\"香\",\"介\",\"迫\",\"句\",\"豐\",\"培\",\"握\",\"蘭\",\"擔\",\"弦\",\"蛋\",\"沉\",\"假\",\"穿\",\"執\",\"答\",\"樂\",\"誰\",\"順\",\"煙\",\"縮\",\"徵\",\"臉\",\"喜\",\"松\",\"腳\",\"困\",\"異\",\"免\",\"背\",\"星\",\"福\",\"買\",\"染\",\"井\",\"概\",\"慢\",\"怕\",\"磁\",\"倍\",\"祖\",\"皇\",\"促\",\"靜\",\"補\",\"評\",\"翻\",\"肉\",\"踐\",\"尼\",\"衣\",\"寬\",\"揚\",\"棉\",\"希\",\"傷\",\"操\",\"垂\",\"秋\",\"宜\",\"氫\",\"套\",\"督\",\"振\",\"架\",\"亮\",\"末\",\"憲\",\"慶\",\"編\",\"牛\",\"觸\",\"映\",\"雷\",\"銷\",\"詩\",\"座\",\"居\",\"抓\",\"裂\",\"胞\",\"呼\",\"娘\",\"景\",\"威\",\"綠\",\"晶\",\"厚\",\"盟\",\"衡\",\"雞\",\"孫\",\"延\",\"危\",\"膠\",\"屋\",\"鄉\",\"臨\",\"陸\",\"顧\",\"掉\",\"呀\",\"燈\",\"歲\",\"措\",\"束\",\"耐\",\"劇\",\"玉\",\"趙\",\"跳\",\"哥\",\"季\",\"課\",\"凱\",\"胡\",\"額\",\"款\",\"紹\",\"卷\",\"齊\",\"偉\",\"蒸\",\"殖\",\"永\",\"宗\",\"苗\",\"川\",\"爐\",\"岩\",\"弱\",\"零\",\"楊\",\"奏\",\"沿\",\"露\",\"桿\",\"探\",\"滑\",\"鎮\",\"飯\",\"濃\",\"航\",\"懷\",\"趕\",\"庫\",\"奪\",\"伊\",\"靈\",\"稅\",\"途\",\"滅\",\"賽\",\"歸\",\"召\",\"鼓\",\"播\",\"盤\",\"裁\",\"險\",\"康\",\"唯\",\"錄\",\"菌\",\"純\",\"借\",\"糖\",\"蓋\",\"橫\",\"符\",\"私\",\"努\",\"堂\",\"域\",\"槍\",\"潤\",\"幅\",\"哈\",\"竟\",\"熟\",\"蟲\",\"澤\",\"腦\",\"壤\",\"碳\",\"歐\",\"遍\",\"側\",\"寨\",\"敢\",\"徹\",\"慮\",\"斜\",\"薄\",\"庭\",\"納\",\"彈\",\"飼\",\"伸\",\"折\",\"麥\",\"濕\",\"暗\",\"荷\",\"瓦\",\"塞\",\"床\",\"築\",\"惡\",\"戶\",\"訪\",\"塔\",\"奇\",\"透\",\"梁\",\"刀\",\"旋\",\"跡\",\"卡\",\"氯\",\"遇\",\"份\",\"毒\",\"泥\",\"退\",\"洗\",\"擺\",\"灰\",\"彩\",\"賣\",\"耗\",\"夏\",\"擇\",\"忙\",\"銅\",\"獻\",\"硬\",\"予\",\"繁\",\"圈\",\"雪\",\"函\",\"亦\",\"抽\",\"篇\",\"陣\",\"陰\",\"丁\",\"尺\",\"追\",\"堆\",\"雄\",\"迎\",\"泛\",\"爸\",\"樓\",\"避\",\"謀\",\"噸\",\"野\",\"豬\",\"旗\",\"累\",\"偏\",\"典\",\"館\",\"索\",\"秦\",\"脂\",\"潮\",\"爺\",\"豆\",\"忽\",\"托\",\"驚\",\"塑\",\"遺\",\"愈\",\"朱\",\"替\",\"纖\",\"粗\",\"傾\",\"尚\",\"痛\",\"楚\",\"謝\",\"奮\",\"購\",\"磨\",\"君\",\"池\",\"旁\",\"碎\",\"骨\",\"監\",\"捕\",\"弟\",\"暴\",\"割\",\"貫\",\"殊\",\"釋\",\"詞\",\"亡\",\"壁\",\"頓\",\"寶\",\"午\",\"塵\",\"聞\",\"揭\",\"炮\",\"殘\",\"冬\",\"橋\",\"婦\",\"警\",\"綜\",\"招\",\"吳\",\"付\",\"浮\",\"遭\",\"徐\",\"您\",\"搖\",\"谷\",\"贊\",\"箱\",\"隔\",\"訂\",\"男\",\"吹\",\"園\",\"紛\",\"唐\",\"敗\",\"宋\",\"玻\",\"巨\",\"耕\",\"坦\",\"榮\",\"閉\",\"灣\",\"鍵\",\"凡\",\"駐\",\"鍋\",\"救\",\"恩\",\"剝\",\"凝\",\"鹼\",\"齒\",\"截\",\"煉\",\"麻\",\"紡\",\"禁\",\"廢\",\"盛\",\"版\",\"緩\",\"淨\",\"睛\",\"昌\",\"婚\",\"涉\",\"筒\",\"嘴\",\"插\",\"岸\",\"朗\",\"莊\",\"街\",\"藏\",\"姑\",\"貿\",\"腐\",\"奴\",\"啦\",\"慣\",\"乘\",\"夥\",\"恢\",\"勻\",\"紗\",\"扎\",\"辯\",\"耳\",\"彪\",\"臣\",\"億\",\"璃\",\"抵\",\"脈\",\"秀\",\"薩\",\"俄\",\"網\",\"舞\",\"店\",\"噴\",\"縱\",\"寸\",\"汗\",\"掛\",\"洪\",\"賀\",\"閃\",\"柬\",\"爆\",\"烯\",\"津\",\"稻\",\"牆\",\"軟\",\"勇\",\"像\",\"滾\",\"厘\",\"蒙\",\"芳\",\"肯\",\"坡\",\"柱\",\"盪\",\"腿\",\"儀\",\"旅\",\"尾\",\"軋\",\"冰\",\"貢\",\"登\",\"黎\",\"削\",\"鑽\",\"勒\",\"逃\",\"障\",\"氨\",\"郭\",\"峰\",\"幣\",\"港\",\"伏\",\"軌\",\"畝\",\"畢\",\"擦\",\"莫\",\"刺\",\"浪\",\"秘\",\"援\",\"株\",\"健\",\"售\",\"股\",\"島\",\"甘\",\"泡\",\"睡\",\"童\",\"鑄\",\"湯\",\"閥\",\"休\",\"匯\",\"舍\",\"牧\",\"繞\",\"炸\",\"哲\",\"磷\",\"績\",\"朋\",\"淡\",\"尖\",\"啟\",\"陷\",\"柴\",\"呈\",\"徒\",\"顏\",\"淚\",\"稍\",\"忘\",\"泵\",\"藍\",\"拖\",\"洞\",\"授\",\"鏡\",\"辛\",\"壯\",\"鋒\",\"貧\",\"虛\",\"彎\",\"摩\",\"泰\",\"幼\",\"廷\",\"尊\",\"窗\",\"綱\",\"弄\",\"隸\",\"疑\",\"氏\",\"宮\",\"姐\",\"震\",\"瑞\",\"怪\",\"尤\",\"琴\",\"循\",\"描\",\"膜\",\"違\",\"夾\",\"腰\",\"緣\",\"珠\",\"窮\",\"森\",\"枝\",\"竹\",\"溝\",\"催\",\"繩\",\"憶\",\"邦\",\"剩\",\"幸\",\"漿\",\"欄\",\"擁\",\"牙\",\"貯\",\"禮\",\"濾\",\"鈉\",\"紋\",\"罷\",\"拍\",\"咱\",\"喊\",\"袖\",\"埃\",\"勤\",\"罰\",\"焦\",\"潛\",\"伍\",\"墨\",\"欲\",\"縫\",\"姓\",\"刊\",\"飽\",\"仿\",\"獎\",\"鋁\",\"鬼\",\"麗\",\"跨\",\"默\",\"挖\",\"鏈\",\"掃\",\"喝\",\"袋\",\"炭\",\"污\",\"幕\",\"諸\",\"弧\",\"勵\",\"梅\",\"奶\",\"潔\",\"災\",\"舟\",\"鑑\",\"苯\",\"訟\",\"抱\",\"毀\",\"懂\",\"寒\",\"智\",\"埔\",\"寄\",\"屆\",\"躍\",\"渡\",\"挑\",\"丹\",\"艱\",\"貝\",\"碰\",\"拔\",\"爹\",\"戴\",\"碼\",\"夢\",\"芽\",\"熔\",\"赤\",\"漁\",\"哭\",\"敬\",\"顆\",\"奔\",\"鉛\",\"仲\",\"虎\",\"稀\",\"妹\",\"乏\",\"珍\",\"申\",\"桌\",\"遵\",\"允\",\"隆\",\"螺\",\"倉\",\"魏\",\"銳\",\"曉\",\"氮\",\"兼\",\"隱\",\"礙\",\"赫\",\"撥\",\"忠\",\"肅\",\"缸\",\"牽\",\"搶\",\"博\",\"巧\",\"殼\",\"兄\",\"杜\",\"訊\",\"誠\",\"碧\",\"祥\",\"柯\",\"頁\",\"巡\",\"矩\",\"悲\",\"灌\",\"齡\",\"倫\",\"票\",\"尋\",\"桂\",\"鋪\",\"聖\",\"恐\",\"恰\",\"鄭\",\"趣\",\"抬\",\"荒\",\"騰\",\"貼\",\"柔\",\"滴\",\"猛\",\"闊\",\"輛\",\"妻\",\"填\",\"撤\",\"儲\",\"簽\",\"鬧\",\"擾\",\"紫\",\"砂\",\"遞\",\"戲\",\"吊\",\"陶\",\"伐\",\"餵\",\"療\",\"瓶\",\"婆\",\"撫\",\"臂\",\"摸\",\"忍\",\"蝦\",\"蠟\",\"鄰\",\"胸\",\"鞏\",\"擠\",\"偶\",\"棄\",\"槽\",\"勁\",\"乳\",\"鄧\",\"吉\",\"仁\",\"爛\",\"磚\",\"租\",\"烏\",\"艦\",\"伴\",\"瓜\",\"淺\",\"丙\",\"暫\",\"燥\",\"橡\",\"柳\",\"迷\",\"暖\",\"牌\",\"秧\",\"膽\",\"詳\",\"簧\",\"踏\",\"瓷\",\"譜\",\"呆\",\"賓\",\"糊\",\"洛\",\"輝\",\"憤\",\"競\",\"隙\",\"怒\",\"粘\",\"乃\",\"緒\",\"肩\",\"籍\",\"敏\",\"塗\",\"熙\",\"皆\",\"偵\",\"懸\",\"掘\",\"享\",\"糾\",\"醒\",\"狂\",\"鎖\",\"淀\",\"恨\",\"牲\",\"霸\",\"爬\",\"賞\",\"逆\",\"玩\",\"陵\",\"祝\",\"秒\",\"浙\",\"貌\",\"役\",\"彼\",\"悉\",\"鴨\",\"趨\",\"鳳\",\"晨\",\"畜\",\"輩\",\"秩\",\"卵\",\"署\",\"梯\",\"炎\",\"灘\",\"棋\",\"驅\",\"篩\",\"峽\",\"冒\",\"啥\",\"壽\",\"譯\",\"浸\",\"泉\",\"帽\",\"遲\",\"矽\",\"疆\",\"貸\",\"漏\",\"稿\",\"冠\",\"嫩\",\"脅\",\"芯\",\"牢\",\"叛\",\"蝕\",\"奧\",\"鳴\",\"嶺\",\"羊\",\"憑\",\"串\",\"塘\",\"繪\",\"酵\",\"融\",\"盆\",\"錫\",\"廟\",\"籌\",\"凍\",\"輔\",\"攝\",\"襲\",\"筋\",\"拒\",\"僚\",\"旱\",\"鉀\",\"鳥\",\"漆\",\"沈\",\"眉\",\"疏\",\"添\",\"棒\",\"穗\",\"硝\",\"韓\",\"逼\",\"扭\",\"僑\",\"涼\",\"挺\",\"碗\",\"栽\",\"炒\",\"杯\",\"患\",\"餾\",\"勸\",\"豪\",\"遼\",\"勃\",\"鴻\",\"旦\",\"吏\",\"拜\",\"狗\",\"埋\",\"輥\",\"掩\",\"飲\",\"搬\",\"罵\",\"辭\",\"勾\",\"扣\",\"估\",\"蔣\",\"絨\",\"霧\",\"丈\",\"朵\",\"姆\",\"擬\",\"宇\",\"輯\",\"陝\",\"雕\",\"償\",\"蓄\",\"崇\",\"剪\",\"倡\",\"廳\",\"咬\",\"駛\",\"薯\",\"刷\",\"斥\",\"番\",\"賦\",\"奉\",\"佛\",\"澆\",\"漫\",\"曼\",\"扇\",\"鈣\",\"桃\",\"扶\",\"仔\",\"返\",\"俗\",\"虧\",\"腔\",\"鞋\",\"棱\",\"覆\",\"框\",\"悄\",\"叔\",\"撞\",\"騙\",\"勘\",\"旺\",\"沸\",\"孤\",\"吐\",\"孟\",\"渠\",\"屈\",\"疾\",\"妙\",\"惜\",\"仰\",\"狠\",\"脹\",\"諧\",\"拋\",\"黴\",\"桑\",\"崗\",\"嘛\",\"衰\",\"盜\",\"滲\",\"臟\",\"賴\",\"湧\",\"甜\",\"曹\",\"閱\",\"肌\",\"哩\",\"厲\",\"烴\",\"緯\",\"毅\",\"昨\",\"偽\",\"症\",\"煮\",\"嘆\",\"釘\",\"搭\",\"莖\",\"籠\",\"酷\",\"偷\",\"弓\",\"錐\",\"恆\",\"傑\",\"坑\",\"鼻\",\"翼\",\"綸\",\"敘\",\"獄\",\"逮\",\"罐\",\"絡\",\"棚\",\"抑\",\"膨\",\"蔬\",\"寺\",\"驟\",\"穆\",\"冶\",\"枯\",\"冊\",\"屍\",\"凸\",\"紳\",\"坯\",\"犧\",\"焰\",\"轟\",\"欣\",\"晉\",\"瘦\",\"禦\",\"錠\",\"錦\",\"喪\",\"旬\",\"鍛\",\"壟\",\"搜\",\"撲\",\"邀\",\"亭\",\"酯\",\"邁\",\"舒\",\"脆\",\"酶\",\"閒\",\"憂\",\"酚\",\"頑\",\"羽\",\"漲\",\"卸\",\"仗\",\"陪\",\"闢\",\"懲\",\"杭\",\"姚\",\"肚\",\"捉\",\"飄\",\"漂\",\"昆\",\"欺\",\"吾\",\"郎\",\"烷\",\"汁\",\"呵\",\"飾\",\"蕭\",\"雅\",\"郵\",\"遷\",\"燕\",\"撒\",\"姻\",\"赴\",\"宴\",\"煩\",\"債\",\"帳\",\"斑\",\"鈴\",\"旨\",\"醇\",\"董\",\"餅\",\"雛\",\"姿\",\"拌\",\"傅\",\"腹\",\"妥\",\"揉\",\"賢\",\"拆\",\"歪\",\"葡\",\"胺\",\"丟\",\"浩\",\"徽\",\"昂\",\"墊\",\"擋\",\"覽\",\"貪\",\"慰\",\"繳\",\"汪\",\"慌\",\"馮\",\"諾\",\"姜\",\"誼\",\"兇\",\"劣\",\"誣\",\"耀\",\"昏\",\"躺\",\"盈\",\"騎\",\"喬\",\"溪\",\"叢\",\"盧\",\"抹\",\"悶\",\"諮\",\"刮\",\"駕\",\"纜\",\"悟\",\"摘\",\"鉺\",\"擲\",\"頗\",\"幻\",\"柄\",\"惠\",\"慘\",\"佳\",\"仇\",\"臘\",\"窩\",\"滌\",\"劍\",\"瞧\",\"堡\",\"潑\",\"蔥\",\"罩\",\"霍\",\"撈\",\"胎\",\"蒼\",\"濱\",\"倆\",\"捅\",\"湘\",\"砍\",\"霞\",\"邵\",\"萄\",\"瘋\",\"淮\",\"遂\",\"熊\",\"糞\",\"烘\",\"宿\",\"檔\",\"戈\",\"駁\",\"嫂\",\"裕\",\"徙\",\"箭\",\"捐\",\"腸\",\"撐\",\"曬\",\"辨\",\"殿\",\"蓮\",\"攤\",\"攪\",\"醬\",\"屏\",\"疫\",\"哀\",\"蔡\",\"堵\",\"沫\",\"皺\",\"暢\",\"疊\",\"閣\",\"萊\",\"敲\",\"轄\",\"鉤\",\"痕\",\"壩\",\"巷\",\"餓\",\"禍\",\"丘\",\"玄\",\"溜\",\"曰\",\"邏\",\"彭\",\"嘗\",\"卿\",\"妨\",\"艇\",\"吞\",\"韋\",\"怨\",\"矮\",\"歇\"]");

/***/ }),

/***/ 285401:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse("[\"abandon\",\"ability\",\"able\",\"about\",\"above\",\"absent\",\"absorb\",\"abstract\",\"absurd\",\"abuse\",\"access\",\"accident\",\"account\",\"accuse\",\"achieve\",\"acid\",\"acoustic\",\"acquire\",\"across\",\"act\",\"action\",\"actor\",\"actress\",\"actual\",\"adapt\",\"add\",\"addict\",\"address\",\"adjust\",\"admit\",\"adult\",\"advance\",\"advice\",\"aerobic\",\"affair\",\"afford\",\"afraid\",\"again\",\"age\",\"agent\",\"agree\",\"ahead\",\"aim\",\"air\",\"airport\",\"aisle\",\"alarm\",\"album\",\"alcohol\",\"alert\",\"alien\",\"all\",\"alley\",\"allow\",\"almost\",\"alone\",\"alpha\",\"already\",\"also\",\"alter\",\"always\",\"amateur\",\"amazing\",\"among\",\"amount\",\"amused\",\"analyst\",\"anchor\",\"ancient\",\"anger\",\"angle\",\"angry\",\"animal\",\"ankle\",\"announce\",\"annual\",\"another\",\"answer\",\"antenna\",\"antique\",\"anxiety\",\"any\",\"apart\",\"apology\",\"appear\",\"apple\",\"approve\",\"april\",\"arch\",\"arctic\",\"area\",\"arena\",\"argue\",\"arm\",\"armed\",\"armor\",\"army\",\"around\",\"arrange\",\"arrest\",\"arrive\",\"arrow\",\"art\",\"artefact\",\"artist\",\"artwork\",\"ask\",\"aspect\",\"assault\",\"asset\",\"assist\",\"assume\",\"asthma\",\"athlete\",\"atom\",\"attack\",\"attend\",\"attitude\",\"attract\",\"auction\",\"audit\",\"august\",\"aunt\",\"author\",\"auto\",\"autumn\",\"average\",\"avocado\",\"avoid\",\"awake\",\"aware\",\"away\",\"awesome\",\"awful\",\"awkward\",\"axis\",\"baby\",\"bachelor\",\"bacon\",\"badge\",\"bag\",\"balance\",\"balcony\",\"ball\",\"bamboo\",\"banana\",\"banner\",\"bar\",\"barely\",\"bargain\",\"barrel\",\"base\",\"basic\",\"basket\",\"battle\",\"beach\",\"bean\",\"beauty\",\"because\",\"become\",\"beef\",\"before\",\"begin\",\"behave\",\"behind\",\"believe\",\"below\",\"belt\",\"bench\",\"benefit\",\"best\",\"betray\",\"better\",\"between\",\"beyond\",\"bicycle\",\"bid\",\"bike\",\"bind\",\"biology\",\"bird\",\"birth\",\"bitter\",\"black\",\"blade\",\"blame\",\"blanket\",\"blast\",\"bleak\",\"bless\",\"blind\",\"blood\",\"blossom\",\"blouse\",\"blue\",\"blur\",\"blush\",\"board\",\"boat\",\"body\",\"boil\",\"bomb\",\"bone\",\"bonus\",\"book\",\"boost\",\"border\",\"boring\",\"borrow\",\"boss\",\"bottom\",\"bounce\",\"box\",\"boy\",\"bracket\",\"brain\",\"brand\",\"brass\",\"brave\",\"bread\",\"breeze\",\"brick\",\"bridge\",\"brief\",\"bright\",\"bring\",\"brisk\",\"broccoli\",\"broken\",\"bronze\",\"broom\",\"brother\",\"brown\",\"brush\",\"bubble\",\"buddy\",\"budget\",\"buffalo\",\"build\",\"bulb\",\"bulk\",\"bullet\",\"bundle\",\"bunker\",\"burden\",\"burger\",\"burst\",\"bus\",\"business\",\"busy\",\"butter\",\"buyer\",\"buzz\",\"cabbage\",\"cabin\",\"cable\",\"cactus\",\"cage\",\"cake\",\"call\",\"calm\",\"camera\",\"camp\",\"can\",\"canal\",\"cancel\",\"candy\",\"cannon\",\"canoe\",\"canvas\",\"canyon\",\"capable\",\"capital\",\"captain\",\"car\",\"carbon\",\"card\",\"cargo\",\"carpet\",\"carry\",\"cart\",\"case\",\"cash\",\"casino\",\"castle\",\"casual\",\"cat\",\"catalog\",\"catch\",\"category\",\"cattle\",\"caught\",\"cause\",\"caution\",\"cave\",\"ceiling\",\"celery\",\"cement\",\"census\",\"century\",\"cereal\",\"certain\",\"chair\",\"chalk\",\"champion\",\"change\",\"chaos\",\"chapter\",\"charge\",\"chase\",\"chat\",\"cheap\",\"check\",\"cheese\",\"chef\",\"cherry\",\"chest\",\"chicken\",\"chief\",\"child\",\"chimney\",\"choice\",\"choose\",\"chronic\",\"chuckle\",\"chunk\",\"churn\",\"cigar\",\"cinnamon\",\"circle\",\"citizen\",\"city\",\"civil\",\"claim\",\"clap\",\"clarify\",\"claw\",\"clay\",\"clean\",\"clerk\",\"clever\",\"click\",\"client\",\"cliff\",\"climb\",\"clinic\",\"clip\",\"clock\",\"clog\",\"close\",\"cloth\",\"cloud\",\"clown\",\"club\",\"clump\",\"cluster\",\"clutch\",\"coach\",\"coast\",\"coconut\",\"code\",\"coffee\",\"coil\",\"coin\",\"collect\",\"color\",\"column\",\"combine\",\"come\",\"comfort\",\"comic\",\"common\",\"company\",\"concert\",\"conduct\",\"confirm\",\"congress\",\"connect\",\"consider\",\"control\",\"convince\",\"cook\",\"cool\",\"copper\",\"copy\",\"coral\",\"core\",\"corn\",\"correct\",\"cost\",\"cotton\",\"couch\",\"country\",\"couple\",\"course\",\"cousin\",\"cover\",\"coyote\",\"crack\",\"cradle\",\"craft\",\"cram\",\"crane\",\"crash\",\"crater\",\"crawl\",\"crazy\",\"cream\",\"credit\",\"creek\",\"crew\",\"cricket\",\"crime\",\"crisp\",\"critic\",\"crop\",\"cross\",\"crouch\",\"crowd\",\"crucial\",\"cruel\",\"cruise\",\"crumble\",\"crunch\",\"crush\",\"cry\",\"crystal\",\"cube\",\"culture\",\"cup\",\"cupboard\",\"curious\",\"current\",\"curtain\",\"curve\",\"cushion\",\"custom\",\"cute\",\"cycle\",\"dad\",\"damage\",\"damp\",\"dance\",\"danger\",\"daring\",\"dash\",\"daughter\",\"dawn\",\"day\",\"deal\",\"debate\",\"debris\",\"decade\",\"december\",\"decide\",\"decline\",\"decorate\",\"decrease\",\"deer\",\"defense\",\"define\",\"defy\",\"degree\",\"delay\",\"deliver\",\"demand\",\"demise\",\"denial\",\"dentist\",\"deny\",\"depart\",\"depend\",\"deposit\",\"depth\",\"deputy\",\"derive\",\"describe\",\"desert\",\"design\",\"desk\",\"despair\",\"destroy\",\"detail\",\"detect\",\"develop\",\"device\",\"devote\",\"diagram\",\"dial\",\"diamond\",\"diary\",\"dice\",\"diesel\",\"diet\",\"differ\",\"digital\",\"dignity\",\"dilemma\",\"dinner\",\"dinosaur\",\"direct\",\"dirt\",\"disagree\",\"discover\",\"disease\",\"dish\",\"dismiss\",\"disorder\",\"display\",\"distance\",\"divert\",\"divide\",\"divorce\",\"dizzy\",\"doctor\",\"document\",\"dog\",\"doll\",\"dolphin\",\"domain\",\"donate\",\"donkey\",\"donor\",\"door\",\"dose\",\"double\",\"dove\",\"draft\",\"dragon\",\"drama\",\"drastic\",\"draw\",\"dream\",\"dress\",\"drift\",\"drill\",\"drink\",\"drip\",\"drive\",\"drop\",\"drum\",\"dry\",\"duck\",\"dumb\",\"dune\",\"during\",\"dust\",\"dutch\",\"duty\",\"dwarf\",\"dynamic\",\"eager\",\"eagle\",\"early\",\"earn\",\"earth\",\"easily\",\"east\",\"easy\",\"echo\",\"ecology\",\"economy\",\"edge\",\"edit\",\"educate\",\"effort\",\"egg\",\"eight\",\"either\",\"elbow\",\"elder\",\"electric\",\"elegant\",\"element\",\"elephant\",\"elevator\",\"elite\",\"else\",\"embark\",\"embody\",\"embrace\",\"emerge\",\"emotion\",\"employ\",\"empower\",\"empty\",\"enable\",\"enact\",\"end\",\"endless\",\"endorse\",\"enemy\",\"energy\",\"enforce\",\"engage\",\"engine\",\"enhance\",\"enjoy\",\"enlist\",\"enough\",\"enrich\",\"enroll\",\"ensure\",\"enter\",\"entire\",\"entry\",\"envelope\",\"episode\",\"equal\",\"equip\",\"era\",\"erase\",\"erode\",\"erosion\",\"error\",\"erupt\",\"escape\",\"essay\",\"essence\",\"estate\",\"eternal\",\"ethics\",\"evidence\",\"evil\",\"evoke\",\"evolve\",\"exact\",\"example\",\"excess\",\"exchange\",\"excite\",\"exclude\",\"excuse\",\"execute\",\"exercise\",\"exhaust\",\"exhibit\",\"exile\",\"exist\",\"exit\",\"exotic\",\"expand\",\"expect\",\"expire\",\"explain\",\"expose\",\"express\",\"extend\",\"extra\",\"eye\",\"eyebrow\",\"fabric\",\"face\",\"faculty\",\"fade\",\"faint\",\"faith\",\"fall\",\"false\",\"fame\",\"family\",\"famous\",\"fan\",\"fancy\",\"fantasy\",\"farm\",\"fashion\",\"fat\",\"fatal\",\"father\",\"fatigue\",\"fault\",\"favorite\",\"feature\",\"february\",\"federal\",\"fee\",\"feed\",\"feel\",\"female\",\"fence\",\"festival\",\"fetch\",\"fever\",\"few\",\"fiber\",\"fiction\",\"field\",\"figure\",\"file\",\"film\",\"filter\",\"final\",\"find\",\"fine\",\"finger\",\"finish\",\"fire\",\"firm\",\"first\",\"fiscal\",\"fish\",\"fit\",\"fitness\",\"fix\",\"flag\",\"flame\",\"flash\",\"flat\",\"flavor\",\"flee\",\"flight\",\"flip\",\"float\",\"flock\",\"floor\",\"flower\",\"fluid\",\"flush\",\"fly\",\"foam\",\"focus\",\"fog\",\"foil\",\"fold\",\"follow\",\"food\",\"foot\",\"force\",\"forest\",\"forget\",\"fork\",\"fortune\",\"forum\",\"forward\",\"fossil\",\"foster\",\"found\",\"fox\",\"fragile\",\"frame\",\"frequent\",\"fresh\",\"friend\",\"fringe\",\"frog\",\"front\",\"frost\",\"frown\",\"frozen\",\"fruit\",\"fuel\",\"fun\",\"funny\",\"furnace\",\"fury\",\"future\",\"gadget\",\"gain\",\"galaxy\",\"gallery\",\"game\",\"gap\",\"garage\",\"garbage\",\"garden\",\"garlic\",\"garment\",\"gas\",\"gasp\",\"gate\",\"gather\",\"gauge\",\"gaze\",\"general\",\"genius\",\"genre\",\"gentle\",\"genuine\",\"gesture\",\"ghost\",\"giant\",\"gift\",\"giggle\",\"ginger\",\"giraffe\",\"girl\",\"give\",\"glad\",\"glance\",\"glare\",\"glass\",\"glide\",\"glimpse\",\"globe\",\"gloom\",\"glory\",\"glove\",\"glow\",\"glue\",\"goat\",\"goddess\",\"gold\",\"good\",\"goose\",\"gorilla\",\"gospel\",\"gossip\",\"govern\",\"gown\",\"grab\",\"grace\",\"grain\",\"grant\",\"grape\",\"grass\",\"gravity\",\"great\",\"green\",\"grid\",\"grief\",\"grit\",\"grocery\",\"group\",\"grow\",\"grunt\",\"guard\",\"guess\",\"guide\",\"guilt\",\"guitar\",\"gun\",\"gym\",\"habit\",\"hair\",\"half\",\"hammer\",\"hamster\",\"hand\",\"happy\",\"harbor\",\"hard\",\"harsh\",\"harvest\",\"hat\",\"have\",\"hawk\",\"hazard\",\"head\",\"health\",\"heart\",\"heavy\",\"hedgehog\",\"height\",\"hello\",\"helmet\",\"help\",\"hen\",\"hero\",\"hidden\",\"high\",\"hill\",\"hint\",\"hip\",\"hire\",\"history\",\"hobby\",\"hockey\",\"hold\",\"hole\",\"holiday\",\"hollow\",\"home\",\"honey\",\"hood\",\"hope\",\"horn\",\"horror\",\"horse\",\"hospital\",\"host\",\"hotel\",\"hour\",\"hover\",\"hub\",\"huge\",\"human\",\"humble\",\"humor\",\"hundred\",\"hungry\",\"hunt\",\"hurdle\",\"hurry\",\"hurt\",\"husband\",\"hybrid\",\"ice\",\"icon\",\"idea\",\"identify\",\"idle\",\"ignore\",\"ill\",\"illegal\",\"illness\",\"image\",\"imitate\",\"immense\",\"immune\",\"impact\",\"impose\",\"improve\",\"impulse\",\"inch\",\"include\",\"income\",\"increase\",\"index\",\"indicate\",\"indoor\",\"industry\",\"infant\",\"inflict\",\"inform\",\"inhale\",\"inherit\",\"initial\",\"inject\",\"injury\",\"inmate\",\"inner\",\"innocent\",\"input\",\"inquiry\",\"insane\",\"insect\",\"inside\",\"inspire\",\"install\",\"intact\",\"interest\",\"into\",\"invest\",\"invite\",\"involve\",\"iron\",\"island\",\"isolate\",\"issue\",\"item\",\"ivory\",\"jacket\",\"jaguar\",\"jar\",\"jazz\",\"jealous\",\"jeans\",\"jelly\",\"jewel\",\"job\",\"join\",\"joke\",\"journey\",\"joy\",\"judge\",\"juice\",\"jump\",\"jungle\",\"junior\",\"junk\",\"just\",\"kangaroo\",\"keen\",\"keep\",\"ketchup\",\"key\",\"kick\",\"kid\",\"kidney\",\"kind\",\"kingdom\",\"kiss\",\"kit\",\"kitchen\",\"kite\",\"kitten\",\"kiwi\",\"knee\",\"knife\",\"knock\",\"know\",\"lab\",\"label\",\"labor\",\"ladder\",\"lady\",\"lake\",\"lamp\",\"language\",\"laptop\",\"large\",\"later\",\"latin\",\"laugh\",\"laundry\",\"lava\",\"law\",\"lawn\",\"lawsuit\",\"layer\",\"lazy\",\"leader\",\"leaf\",\"learn\",\"leave\",\"lecture\",\"left\",\"leg\",\"legal\",\"legend\",\"leisure\",\"lemon\",\"lend\",\"length\",\"lens\",\"leopard\",\"lesson\",\"letter\",\"level\",\"liar\",\"liberty\",\"library\",\"license\",\"life\",\"lift\",\"light\",\"like\",\"limb\",\"limit\",\"link\",\"lion\",\"liquid\",\"list\",\"little\",\"live\",\"lizard\",\"load\",\"loan\",\"lobster\",\"local\",\"lock\",\"logic\",\"lonely\",\"long\",\"loop\",\"lottery\",\"loud\",\"lounge\",\"love\",\"loyal\",\"lucky\",\"luggage\",\"lumber\",\"lunar\",\"lunch\",\"luxury\",\"lyrics\",\"machine\",\"mad\",\"magic\",\"magnet\",\"maid\",\"mail\",\"main\",\"major\",\"make\",\"mammal\",\"man\",\"manage\",\"mandate\",\"mango\",\"mansion\",\"manual\",\"maple\",\"marble\",\"march\",\"margin\",\"marine\",\"market\",\"marriage\",\"mask\",\"mass\",\"master\",\"match\",\"material\",\"math\",\"matrix\",\"matter\",\"maximum\",\"maze\",\"meadow\",\"mean\",\"measure\",\"meat\",\"mechanic\",\"medal\",\"media\",\"melody\",\"melt\",\"member\",\"memory\",\"mention\",\"menu\",\"mercy\",\"merge\",\"merit\",\"merry\",\"mesh\",\"message\",\"metal\",\"method\",\"middle\",\"midnight\",\"milk\",\"million\",\"mimic\",\"mind\",\"minimum\",\"minor\",\"minute\",\"miracle\",\"mirror\",\"misery\",\"miss\",\"mistake\",\"mix\",\"mixed\",\"mixture\",\"mobile\",\"model\",\"modify\",\"mom\",\"moment\",\"monitor\",\"monkey\",\"monster\",\"month\",\"moon\",\"moral\",\"more\",\"morning\",\"mosquito\",\"mother\",\"motion\",\"motor\",\"mountain\",\"mouse\",\"move\",\"movie\",\"much\",\"muffin\",\"mule\",\"multiply\",\"muscle\",\"museum\",\"mushroom\",\"music\",\"must\",\"mutual\",\"myself\",\"mystery\",\"myth\",\"naive\",\"name\",\"napkin\",\"narrow\",\"nasty\",\"nation\",\"nature\",\"near\",\"neck\",\"need\",\"negative\",\"neglect\",\"neither\",\"nephew\",\"nerve\",\"nest\",\"net\",\"network\",\"neutral\",\"never\",\"news\",\"next\",\"nice\",\"night\",\"noble\",\"noise\",\"nominee\",\"noodle\",\"normal\",\"north\",\"nose\",\"notable\",\"note\",\"nothing\",\"notice\",\"novel\",\"now\",\"nuclear\",\"number\",\"nurse\",\"nut\",\"oak\",\"obey\",\"object\",\"oblige\",\"obscure\",\"observe\",\"obtain\",\"obvious\",\"occur\",\"ocean\",\"october\",\"odor\",\"off\",\"offer\",\"office\",\"often\",\"oil\",\"okay\",\"old\",\"olive\",\"olympic\",\"omit\",\"once\",\"one\",\"onion\",\"online\",\"only\",\"open\",\"opera\",\"opinion\",\"oppose\",\"option\",\"orange\",\"orbit\",\"orchard\",\"order\",\"ordinary\",\"organ\",\"orient\",\"original\",\"orphan\",\"ostrich\",\"other\",\"outdoor\",\"outer\",\"output\",\"outside\",\"oval\",\"oven\",\"over\",\"own\",\"owner\",\"oxygen\",\"oyster\",\"ozone\",\"pact\",\"paddle\",\"page\",\"pair\",\"palace\",\"palm\",\"panda\",\"panel\",\"panic\",\"panther\",\"paper\",\"parade\",\"parent\",\"park\",\"parrot\",\"party\",\"pass\",\"patch\",\"path\",\"patient\",\"patrol\",\"pattern\",\"pause\",\"pave\",\"payment\",\"peace\",\"peanut\",\"pear\",\"peasant\",\"pelican\",\"pen\",\"penalty\",\"pencil\",\"people\",\"pepper\",\"perfect\",\"permit\",\"person\",\"pet\",\"phone\",\"photo\",\"phrase\",\"physical\",\"piano\",\"picnic\",\"picture\",\"piece\",\"pig\",\"pigeon\",\"pill\",\"pilot\",\"pink\",\"pioneer\",\"pipe\",\"pistol\",\"pitch\",\"pizza\",\"place\",\"planet\",\"plastic\",\"plate\",\"play\",\"please\",\"pledge\",\"pluck\",\"plug\",\"plunge\",\"poem\",\"poet\",\"point\",\"polar\",\"pole\",\"police\",\"pond\",\"pony\",\"pool\",\"popular\",\"portion\",\"position\",\"possible\",\"post\",\"potato\",\"pottery\",\"poverty\",\"powder\",\"power\",\"practice\",\"praise\",\"predict\",\"prefer\",\"prepare\",\"present\",\"pretty\",\"prevent\",\"price\",\"pride\",\"primary\",\"print\",\"priority\",\"prison\",\"private\",\"prize\",\"problem\",\"process\",\"produce\",\"profit\",\"program\",\"project\",\"promote\",\"proof\",\"property\",\"prosper\",\"protect\",\"proud\",\"provide\",\"public\",\"pudding\",\"pull\",\"pulp\",\"pulse\",\"pumpkin\",\"punch\",\"pupil\",\"puppy\",\"purchase\",\"purity\",\"purpose\",\"purse\",\"push\",\"put\",\"puzzle\",\"pyramid\",\"quality\",\"quantum\",\"quarter\",\"question\",\"quick\",\"quit\",\"quiz\",\"quote\",\"rabbit\",\"raccoon\",\"race\",\"rack\",\"radar\",\"radio\",\"rail\",\"rain\",\"raise\",\"rally\",\"ramp\",\"ranch\",\"random\",\"range\",\"rapid\",\"rare\",\"rate\",\"rather\",\"raven\",\"raw\",\"razor\",\"ready\",\"real\",\"reason\",\"rebel\",\"rebuild\",\"recall\",\"receive\",\"recipe\",\"record\",\"recycle\",\"reduce\",\"reflect\",\"reform\",\"refuse\",\"region\",\"regret\",\"regular\",\"reject\",\"relax\",\"release\",\"relief\",\"rely\",\"remain\",\"remember\",\"remind\",\"remove\",\"render\",\"renew\",\"rent\",\"reopen\",\"repair\",\"repeat\",\"replace\",\"report\",\"require\",\"rescue\",\"resemble\",\"resist\",\"resource\",\"response\",\"result\",\"retire\",\"retreat\",\"return\",\"reunion\",\"reveal\",\"review\",\"reward\",\"rhythm\",\"rib\",\"ribbon\",\"rice\",\"rich\",\"ride\",\"ridge\",\"rifle\",\"right\",\"rigid\",\"ring\",\"riot\",\"ripple\",\"risk\",\"ritual\",\"rival\",\"river\",\"road\",\"roast\",\"robot\",\"robust\",\"rocket\",\"romance\",\"roof\",\"rookie\",\"room\",\"rose\",\"rotate\",\"rough\",\"round\",\"route\",\"royal\",\"rubber\",\"rude\",\"rug\",\"rule\",\"run\",\"runway\",\"rural\",\"sad\",\"saddle\",\"sadness\",\"safe\",\"sail\",\"salad\",\"salmon\",\"salon\",\"salt\",\"salute\",\"same\",\"sample\",\"sand\",\"satisfy\",\"satoshi\",\"sauce\",\"sausage\",\"save\",\"say\",\"scale\",\"scan\",\"scare\",\"scatter\",\"scene\",\"scheme\",\"school\",\"science\",\"scissors\",\"scorpion\",\"scout\",\"scrap\",\"screen\",\"script\",\"scrub\",\"sea\",\"search\",\"season\",\"seat\",\"second\",\"secret\",\"section\",\"security\",\"seed\",\"seek\",\"segment\",\"select\",\"sell\",\"seminar\",\"senior\",\"sense\",\"sentence\",\"series\",\"service\",\"session\",\"settle\",\"setup\",\"seven\",\"shadow\",\"shaft\",\"shallow\",\"share\",\"shed\",\"shell\",\"sheriff\",\"shield\",\"shift\",\"shine\",\"ship\",\"shiver\",\"shock\",\"shoe\",\"shoot\",\"shop\",\"short\",\"shoulder\",\"shove\",\"shrimp\",\"shrug\",\"shuffle\",\"shy\",\"sibling\",\"sick\",\"side\",\"siege\",\"sight\",\"sign\",\"silent\",\"silk\",\"silly\",\"silver\",\"similar\",\"simple\",\"since\",\"sing\",\"siren\",\"sister\",\"situate\",\"six\",\"size\",\"skate\",\"sketch\",\"ski\",\"skill\",\"skin\",\"skirt\",\"skull\",\"slab\",\"slam\",\"sleep\",\"slender\",\"slice\",\"slide\",\"slight\",\"slim\",\"slogan\",\"slot\",\"slow\",\"slush\",\"small\",\"smart\",\"smile\",\"smoke\",\"smooth\",\"snack\",\"snake\",\"snap\",\"sniff\",\"snow\",\"soap\",\"soccer\",\"social\",\"sock\",\"soda\",\"soft\",\"solar\",\"soldier\",\"solid\",\"solution\",\"solve\",\"someone\",\"song\",\"soon\",\"sorry\",\"sort\",\"soul\",\"sound\",\"soup\",\"source\",\"south\",\"space\",\"spare\",\"spatial\",\"spawn\",\"speak\",\"special\",\"speed\",\"spell\",\"spend\",\"sphere\",\"spice\",\"spider\",\"spike\",\"spin\",\"spirit\",\"split\",\"spoil\",\"sponsor\",\"spoon\",\"sport\",\"spot\",\"spray\",\"spread\",\"spring\",\"spy\",\"square\",\"squeeze\",\"squirrel\",\"stable\",\"stadium\",\"staff\",\"stage\",\"stairs\",\"stamp\",\"stand\",\"start\",\"state\",\"stay\",\"steak\",\"steel\",\"stem\",\"step\",\"stereo\",\"stick\",\"still\",\"sting\",\"stock\",\"stomach\",\"stone\",\"stool\",\"story\",\"stove\",\"strategy\",\"street\",\"strike\",\"strong\",\"struggle\",\"student\",\"stuff\",\"stumble\",\"style\",\"subject\",\"submit\",\"subway\",\"success\",\"such\",\"sudden\",\"suffer\",\"sugar\",\"suggest\",\"suit\",\"summer\",\"sun\",\"sunny\",\"sunset\",\"super\",\"supply\",\"supreme\",\"sure\",\"surface\",\"surge\",\"surprise\",\"surround\",\"survey\",\"suspect\",\"sustain\",\"swallow\",\"swamp\",\"swap\",\"swarm\",\"swear\",\"sweet\",\"swift\",\"swim\",\"swing\",\"switch\",\"sword\",\"symbol\",\"symptom\",\"syrup\",\"system\",\"table\",\"tackle\",\"tag\",\"tail\",\"talent\",\"talk\",\"tank\",\"tape\",\"target\",\"task\",\"taste\",\"tattoo\",\"taxi\",\"teach\",\"team\",\"tell\",\"ten\",\"tenant\",\"tennis\",\"tent\",\"term\",\"test\",\"text\",\"thank\",\"that\",\"theme\",\"then\",\"theory\",\"there\",\"they\",\"thing\",\"this\",\"thought\",\"three\",\"thrive\",\"throw\",\"thumb\",\"thunder\",\"ticket\",\"tide\",\"tiger\",\"tilt\",\"timber\",\"time\",\"tiny\",\"tip\",\"tired\",\"tissue\",\"title\",\"toast\",\"tobacco\",\"today\",\"toddler\",\"toe\",\"together\",\"toilet\",\"token\",\"tomato\",\"tomorrow\",\"tone\",\"tongue\",\"tonight\",\"tool\",\"tooth\",\"top\",\"topic\",\"topple\",\"torch\",\"tornado\",\"tortoise\",\"toss\",\"total\",\"tourist\",\"toward\",\"tower\",\"town\",\"toy\",\"track\",\"trade\",\"traffic\",\"tragic\",\"train\",\"transfer\",\"trap\",\"trash\",\"travel\",\"tray\",\"treat\",\"tree\",\"trend\",\"trial\",\"tribe\",\"trick\",\"trigger\",\"trim\",\"trip\",\"trophy\",\"trouble\",\"truck\",\"true\",\"truly\",\"trumpet\",\"trust\",\"truth\",\"try\",\"tube\",\"tuition\",\"tumble\",\"tuna\",\"tunnel\",\"turkey\",\"turn\",\"turtle\",\"twelve\",\"twenty\",\"twice\",\"twin\",\"twist\",\"two\",\"type\",\"typical\",\"ugly\",\"umbrella\",\"unable\",\"unaware\",\"uncle\",\"uncover\",\"under\",\"undo\",\"unfair\",\"unfold\",\"unhappy\",\"uniform\",\"unique\",\"unit\",\"universe\",\"unknown\",\"unlock\",\"until\",\"unusual\",\"unveil\",\"update\",\"upgrade\",\"uphold\",\"upon\",\"upper\",\"upset\",\"urban\",\"urge\",\"usage\",\"use\",\"used\",\"useful\",\"useless\",\"usual\",\"utility\",\"vacant\",\"vacuum\",\"vague\",\"valid\",\"valley\",\"valve\",\"van\",\"vanish\",\"vapor\",\"various\",\"vast\",\"vault\",\"vehicle\",\"velvet\",\"vendor\",\"venture\",\"venue\",\"verb\",\"verify\",\"version\",\"very\",\"vessel\",\"veteran\",\"viable\",\"vibrant\",\"vicious\",\"victory\",\"video\",\"view\",\"village\",\"vintage\",\"violin\",\"virtual\",\"virus\",\"visa\",\"visit\",\"visual\",\"vital\",\"vivid\",\"vocal\",\"voice\",\"void\",\"volcano\",\"volume\",\"vote\",\"voyage\",\"wage\",\"wagon\",\"wait\",\"walk\",\"wall\",\"walnut\",\"want\",\"warfare\",\"warm\",\"warrior\",\"wash\",\"wasp\",\"waste\",\"water\",\"wave\",\"way\",\"wealth\",\"weapon\",\"wear\",\"weasel\",\"weather\",\"web\",\"wedding\",\"weekend\",\"weird\",\"welcome\",\"west\",\"wet\",\"whale\",\"what\",\"wheat\",\"wheel\",\"when\",\"where\",\"whip\",\"whisper\",\"wide\",\"width\",\"wife\",\"wild\",\"will\",\"win\",\"window\",\"wine\",\"wing\",\"wink\",\"winner\",\"winter\",\"wire\",\"wisdom\",\"wise\",\"wish\",\"witness\",\"wolf\",\"woman\",\"wonder\",\"wood\",\"wool\",\"word\",\"work\",\"world\",\"worry\",\"worth\",\"wrap\",\"wreck\",\"wrestle\",\"wrist\",\"write\",\"wrong\",\"yard\",\"year\",\"yellow\",\"you\",\"young\",\"youth\",\"zebra\",\"zero\",\"zone\",\"zoo\"]");

/***/ }),

/***/ 662354:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse("[\"abaisser\",\"abandon\",\"abdiquer\",\"abeille\",\"abolir\",\"aborder\",\"aboutir\",\"aboyer\",\"abrasif\",\"abreuver\",\"abriter\",\"abroger\",\"abrupt\",\"absence\",\"absolu\",\"absurde\",\"abusif\",\"abyssal\",\"académie\",\"acajou\",\"acarien\",\"accabler\",\"accepter\",\"acclamer\",\"accolade\",\"accroche\",\"accuser\",\"acerbe\",\"achat\",\"acheter\",\"aciduler\",\"acier\",\"acompte\",\"acquérir\",\"acronyme\",\"acteur\",\"actif\",\"actuel\",\"adepte\",\"adéquat\",\"adhésif\",\"adjectif\",\"adjuger\",\"admettre\",\"admirer\",\"adopter\",\"adorer\",\"adoucir\",\"adresse\",\"adroit\",\"adulte\",\"adverbe\",\"aérer\",\"aéronef\",\"affaire\",\"affecter\",\"affiche\",\"affreux\",\"affubler\",\"agacer\",\"agencer\",\"agile\",\"agiter\",\"agrafer\",\"agréable\",\"agrume\",\"aider\",\"aiguille\",\"ailier\",\"aimable\",\"aisance\",\"ajouter\",\"ajuster\",\"alarmer\",\"alchimie\",\"alerte\",\"algèbre\",\"algue\",\"aliéner\",\"aliment\",\"alléger\",\"alliage\",\"allouer\",\"allumer\",\"alourdir\",\"alpaga\",\"altesse\",\"alvéole\",\"amateur\",\"ambigu\",\"ambre\",\"aménager\",\"amertume\",\"amidon\",\"amiral\",\"amorcer\",\"amour\",\"amovible\",\"amphibie\",\"ampleur\",\"amusant\",\"analyse\",\"anaphore\",\"anarchie\",\"anatomie\",\"ancien\",\"anéantir\",\"angle\",\"angoisse\",\"anguleux\",\"animal\",\"annexer\",\"annonce\",\"annuel\",\"anodin\",\"anomalie\",\"anonyme\",\"anormal\",\"antenne\",\"antidote\",\"anxieux\",\"apaiser\",\"apéritif\",\"aplanir\",\"apologie\",\"appareil\",\"appeler\",\"apporter\",\"appuyer\",\"aquarium\",\"aqueduc\",\"arbitre\",\"arbuste\",\"ardeur\",\"ardoise\",\"argent\",\"arlequin\",\"armature\",\"armement\",\"armoire\",\"armure\",\"arpenter\",\"arracher\",\"arriver\",\"arroser\",\"arsenic\",\"artériel\",\"article\",\"aspect\",\"asphalte\",\"aspirer\",\"assaut\",\"asservir\",\"assiette\",\"associer\",\"assurer\",\"asticot\",\"astre\",\"astuce\",\"atelier\",\"atome\",\"atrium\",\"atroce\",\"attaque\",\"attentif\",\"attirer\",\"attraper\",\"aubaine\",\"auberge\",\"audace\",\"audible\",\"augurer\",\"aurore\",\"automne\",\"autruche\",\"avaler\",\"avancer\",\"avarice\",\"avenir\",\"averse\",\"aveugle\",\"aviateur\",\"avide\",\"avion\",\"aviser\",\"avoine\",\"avouer\",\"avril\",\"axial\",\"axiome\",\"badge\",\"bafouer\",\"bagage\",\"baguette\",\"baignade\",\"balancer\",\"balcon\",\"baleine\",\"balisage\",\"bambin\",\"bancaire\",\"bandage\",\"banlieue\",\"bannière\",\"banquier\",\"barbier\",\"baril\",\"baron\",\"barque\",\"barrage\",\"bassin\",\"bastion\",\"bataille\",\"bateau\",\"batterie\",\"baudrier\",\"bavarder\",\"belette\",\"bélier\",\"belote\",\"bénéfice\",\"berceau\",\"berger\",\"berline\",\"bermuda\",\"besace\",\"besogne\",\"bétail\",\"beurre\",\"biberon\",\"bicycle\",\"bidule\",\"bijou\",\"bilan\",\"bilingue\",\"billard\",\"binaire\",\"biologie\",\"biopsie\",\"biotype\",\"biscuit\",\"bison\",\"bistouri\",\"bitume\",\"bizarre\",\"blafard\",\"blague\",\"blanchir\",\"blessant\",\"blinder\",\"blond\",\"bloquer\",\"blouson\",\"bobard\",\"bobine\",\"boire\",\"boiser\",\"bolide\",\"bonbon\",\"bondir\",\"bonheur\",\"bonifier\",\"bonus\",\"bordure\",\"borne\",\"botte\",\"boucle\",\"boueux\",\"bougie\",\"boulon\",\"bouquin\",\"bourse\",\"boussole\",\"boutique\",\"boxeur\",\"branche\",\"brasier\",\"brave\",\"brebis\",\"brèche\",\"breuvage\",\"bricoler\",\"brigade\",\"brillant\",\"brioche\",\"brique\",\"brochure\",\"broder\",\"bronzer\",\"brousse\",\"broyeur\",\"brume\",\"brusque\",\"brutal\",\"bruyant\",\"buffle\",\"buisson\",\"bulletin\",\"bureau\",\"burin\",\"bustier\",\"butiner\",\"butoir\",\"buvable\",\"buvette\",\"cabanon\",\"cabine\",\"cachette\",\"cadeau\",\"cadre\",\"caféine\",\"caillou\",\"caisson\",\"calculer\",\"calepin\",\"calibre\",\"calmer\",\"calomnie\",\"calvaire\",\"camarade\",\"caméra\",\"camion\",\"campagne\",\"canal\",\"caneton\",\"canon\",\"cantine\",\"canular\",\"capable\",\"caporal\",\"caprice\",\"capsule\",\"capter\",\"capuche\",\"carabine\",\"carbone\",\"caresser\",\"caribou\",\"carnage\",\"carotte\",\"carreau\",\"carton\",\"cascade\",\"casier\",\"casque\",\"cassure\",\"causer\",\"caution\",\"cavalier\",\"caverne\",\"caviar\",\"cédille\",\"ceinture\",\"céleste\",\"cellule\",\"cendrier\",\"censurer\",\"central\",\"cercle\",\"cérébral\",\"cerise\",\"cerner\",\"cerveau\",\"cesser\",\"chagrin\",\"chaise\",\"chaleur\",\"chambre\",\"chance\",\"chapitre\",\"charbon\",\"chasseur\",\"chaton\",\"chausson\",\"chavirer\",\"chemise\",\"chenille\",\"chéquier\",\"chercher\",\"cheval\",\"chien\",\"chiffre\",\"chignon\",\"chimère\",\"chiot\",\"chlorure\",\"chocolat\",\"choisir\",\"chose\",\"chouette\",\"chrome\",\"chute\",\"cigare\",\"cigogne\",\"cimenter\",\"cinéma\",\"cintrer\",\"circuler\",\"cirer\",\"cirque\",\"citerne\",\"citoyen\",\"citron\",\"civil\",\"clairon\",\"clameur\",\"claquer\",\"classe\",\"clavier\",\"client\",\"cligner\",\"climat\",\"clivage\",\"cloche\",\"clonage\",\"cloporte\",\"cobalt\",\"cobra\",\"cocasse\",\"cocotier\",\"coder\",\"codifier\",\"coffre\",\"cogner\",\"cohésion\",\"coiffer\",\"coincer\",\"colère\",\"colibri\",\"colline\",\"colmater\",\"colonel\",\"combat\",\"comédie\",\"commande\",\"compact\",\"concert\",\"conduire\",\"confier\",\"congeler\",\"connoter\",\"consonne\",\"contact\",\"convexe\",\"copain\",\"copie\",\"corail\",\"corbeau\",\"cordage\",\"corniche\",\"corpus\",\"correct\",\"cortège\",\"cosmique\",\"costume\",\"coton\",\"coude\",\"coupure\",\"courage\",\"couteau\",\"couvrir\",\"coyote\",\"crabe\",\"crainte\",\"cravate\",\"crayon\",\"créature\",\"créditer\",\"crémeux\",\"creuser\",\"crevette\",\"cribler\",\"crier\",\"cristal\",\"critère\",\"croire\",\"croquer\",\"crotale\",\"crucial\",\"cruel\",\"crypter\",\"cubique\",\"cueillir\",\"cuillère\",\"cuisine\",\"cuivre\",\"culminer\",\"cultiver\",\"cumuler\",\"cupide\",\"curatif\",\"curseur\",\"cyanure\",\"cycle\",\"cylindre\",\"cynique\",\"daigner\",\"damier\",\"danger\",\"danseur\",\"dauphin\",\"débattre\",\"débiter\",\"déborder\",\"débrider\",\"débutant\",\"décaler\",\"décembre\",\"déchirer\",\"décider\",\"déclarer\",\"décorer\",\"décrire\",\"décupler\",\"dédale\",\"déductif\",\"déesse\",\"défensif\",\"défiler\",\"défrayer\",\"dégager\",\"dégivrer\",\"déglutir\",\"dégrafer\",\"déjeuner\",\"délice\",\"déloger\",\"demander\",\"demeurer\",\"démolir\",\"dénicher\",\"dénouer\",\"dentelle\",\"dénuder\",\"départ\",\"dépenser\",\"déphaser\",\"déplacer\",\"déposer\",\"déranger\",\"dérober\",\"désastre\",\"descente\",\"désert\",\"désigner\",\"désobéir\",\"dessiner\",\"destrier\",\"détacher\",\"détester\",\"détourer\",\"détresse\",\"devancer\",\"devenir\",\"deviner\",\"devoir\",\"diable\",\"dialogue\",\"diamant\",\"dicter\",\"différer\",\"digérer\",\"digital\",\"digne\",\"diluer\",\"dimanche\",\"diminuer\",\"dioxyde\",\"directif\",\"diriger\",\"discuter\",\"disposer\",\"dissiper\",\"distance\",\"divertir\",\"diviser\",\"docile\",\"docteur\",\"dogme\",\"doigt\",\"domaine\",\"domicile\",\"dompter\",\"donateur\",\"donjon\",\"donner\",\"dopamine\",\"dortoir\",\"dorure\",\"dosage\",\"doseur\",\"dossier\",\"dotation\",\"douanier\",\"double\",\"douceur\",\"douter\",\"doyen\",\"dragon\",\"draper\",\"dresser\",\"dribbler\",\"droiture\",\"duperie\",\"duplexe\",\"durable\",\"durcir\",\"dynastie\",\"éblouir\",\"écarter\",\"écharpe\",\"échelle\",\"éclairer\",\"éclipse\",\"éclore\",\"écluse\",\"école\",\"économie\",\"écorce\",\"écouter\",\"écraser\",\"écrémer\",\"écrivain\",\"écrou\",\"écume\",\"écureuil\",\"édifier\",\"éduquer\",\"effacer\",\"effectif\",\"effigie\",\"effort\",\"effrayer\",\"effusion\",\"égaliser\",\"égarer\",\"éjecter\",\"élaborer\",\"élargir\",\"électron\",\"élégant\",\"éléphant\",\"élève\",\"éligible\",\"élitisme\",\"éloge\",\"élucider\",\"éluder\",\"emballer\",\"embellir\",\"embryon\",\"émeraude\",\"émission\",\"emmener\",\"émotion\",\"émouvoir\",\"empereur\",\"employer\",\"emporter\",\"emprise\",\"émulsion\",\"encadrer\",\"enchère\",\"enclave\",\"encoche\",\"endiguer\",\"endosser\",\"endroit\",\"enduire\",\"énergie\",\"enfance\",\"enfermer\",\"enfouir\",\"engager\",\"engin\",\"englober\",\"énigme\",\"enjamber\",\"enjeu\",\"enlever\",\"ennemi\",\"ennuyeux\",\"enrichir\",\"enrobage\",\"enseigne\",\"entasser\",\"entendre\",\"entier\",\"entourer\",\"entraver\",\"énumérer\",\"envahir\",\"enviable\",\"envoyer\",\"enzyme\",\"éolien\",\"épaissir\",\"épargne\",\"épatant\",\"épaule\",\"épicerie\",\"épidémie\",\"épier\",\"épilogue\",\"épine\",\"épisode\",\"épitaphe\",\"époque\",\"épreuve\",\"éprouver\",\"épuisant\",\"équerre\",\"équipe\",\"ériger\",\"érosion\",\"erreur\",\"éruption\",\"escalier\",\"espadon\",\"espèce\",\"espiègle\",\"espoir\",\"esprit\",\"esquiver\",\"essayer\",\"essence\",\"essieu\",\"essorer\",\"estime\",\"estomac\",\"estrade\",\"étagère\",\"étaler\",\"étanche\",\"étatique\",\"éteindre\",\"étendoir\",\"éternel\",\"éthanol\",\"éthique\",\"ethnie\",\"étirer\",\"étoffer\",\"étoile\",\"étonnant\",\"étourdir\",\"étrange\",\"étroit\",\"étude\",\"euphorie\",\"évaluer\",\"évasion\",\"éventail\",\"évidence\",\"éviter\",\"évolutif\",\"évoquer\",\"exact\",\"exagérer\",\"exaucer\",\"exceller\",\"excitant\",\"exclusif\",\"excuse\",\"exécuter\",\"exemple\",\"exercer\",\"exhaler\",\"exhorter\",\"exigence\",\"exiler\",\"exister\",\"exotique\",\"expédier\",\"explorer\",\"exposer\",\"exprimer\",\"exquis\",\"extensif\",\"extraire\",\"exulter\",\"fable\",\"fabuleux\",\"facette\",\"facile\",\"facture\",\"faiblir\",\"falaise\",\"fameux\",\"famille\",\"farceur\",\"farfelu\",\"farine\",\"farouche\",\"fasciner\",\"fatal\",\"fatigue\",\"faucon\",\"fautif\",\"faveur\",\"favori\",\"fébrile\",\"féconder\",\"fédérer\",\"félin\",\"femme\",\"fémur\",\"fendoir\",\"féodal\",\"fermer\",\"féroce\",\"ferveur\",\"festival\",\"feuille\",\"feutre\",\"février\",\"fiasco\",\"ficeler\",\"fictif\",\"fidèle\",\"figure\",\"filature\",\"filetage\",\"filière\",\"filleul\",\"filmer\",\"filou\",\"filtrer\",\"financer\",\"finir\",\"fiole\",\"firme\",\"fissure\",\"fixer\",\"flairer\",\"flamme\",\"flasque\",\"flatteur\",\"fléau\",\"flèche\",\"fleur\",\"flexion\",\"flocon\",\"flore\",\"fluctuer\",\"fluide\",\"fluvial\",\"folie\",\"fonderie\",\"fongible\",\"fontaine\",\"forcer\",\"forgeron\",\"formuler\",\"fortune\",\"fossile\",\"foudre\",\"fougère\",\"fouiller\",\"foulure\",\"fourmi\",\"fragile\",\"fraise\",\"franchir\",\"frapper\",\"frayeur\",\"frégate\",\"freiner\",\"frelon\",\"frémir\",\"frénésie\",\"frère\",\"friable\",\"friction\",\"frisson\",\"frivole\",\"froid\",\"fromage\",\"frontal\",\"frotter\",\"fruit\",\"fugitif\",\"fuite\",\"fureur\",\"furieux\",\"furtif\",\"fusion\",\"futur\",\"gagner\",\"galaxie\",\"galerie\",\"gambader\",\"garantir\",\"gardien\",\"garnir\",\"garrigue\",\"gazelle\",\"gazon\",\"géant\",\"gélatine\",\"gélule\",\"gendarme\",\"général\",\"génie\",\"genou\",\"gentil\",\"géologie\",\"géomètre\",\"géranium\",\"germe\",\"gestuel\",\"geyser\",\"gibier\",\"gicler\",\"girafe\",\"givre\",\"glace\",\"glaive\",\"glisser\",\"globe\",\"gloire\",\"glorieux\",\"golfeur\",\"gomme\",\"gonfler\",\"gorge\",\"gorille\",\"goudron\",\"gouffre\",\"goulot\",\"goupille\",\"gourmand\",\"goutte\",\"graduel\",\"graffiti\",\"graine\",\"grand\",\"grappin\",\"gratuit\",\"gravir\",\"grenat\",\"griffure\",\"griller\",\"grimper\",\"grogner\",\"gronder\",\"grotte\",\"groupe\",\"gruger\",\"grutier\",\"gruyère\",\"guépard\",\"guerrier\",\"guide\",\"guimauve\",\"guitare\",\"gustatif\",\"gymnaste\",\"gyrostat\",\"habitude\",\"hachoir\",\"halte\",\"hameau\",\"hangar\",\"hanneton\",\"haricot\",\"harmonie\",\"harpon\",\"hasard\",\"hélium\",\"hématome\",\"herbe\",\"hérisson\",\"hermine\",\"héron\",\"hésiter\",\"heureux\",\"hiberner\",\"hibou\",\"hilarant\",\"histoire\",\"hiver\",\"homard\",\"hommage\",\"homogène\",\"honneur\",\"honorer\",\"honteux\",\"horde\",\"horizon\",\"horloge\",\"hormone\",\"horrible\",\"houleux\",\"housse\",\"hublot\",\"huileux\",\"humain\",\"humble\",\"humide\",\"humour\",\"hurler\",\"hydromel\",\"hygiène\",\"hymne\",\"hypnose\",\"idylle\",\"ignorer\",\"iguane\",\"illicite\",\"illusion\",\"image\",\"imbiber\",\"imiter\",\"immense\",\"immobile\",\"immuable\",\"impact\",\"impérial\",\"implorer\",\"imposer\",\"imprimer\",\"imputer\",\"incarner\",\"incendie\",\"incident\",\"incliner\",\"incolore\",\"indexer\",\"indice\",\"inductif\",\"inédit\",\"ineptie\",\"inexact\",\"infini\",\"infliger\",\"informer\",\"infusion\",\"ingérer\",\"inhaler\",\"inhiber\",\"injecter\",\"injure\",\"innocent\",\"inoculer\",\"inonder\",\"inscrire\",\"insecte\",\"insigne\",\"insolite\",\"inspirer\",\"instinct\",\"insulter\",\"intact\",\"intense\",\"intime\",\"intrigue\",\"intuitif\",\"inutile\",\"invasion\",\"inventer\",\"inviter\",\"invoquer\",\"ironique\",\"irradier\",\"irréel\",\"irriter\",\"isoler\",\"ivoire\",\"ivresse\",\"jaguar\",\"jaillir\",\"jambe\",\"janvier\",\"jardin\",\"jauger\",\"jaune\",\"javelot\",\"jetable\",\"jeton\",\"jeudi\",\"jeunesse\",\"joindre\",\"joncher\",\"jongler\",\"joueur\",\"jouissif\",\"journal\",\"jovial\",\"joyau\",\"joyeux\",\"jubiler\",\"jugement\",\"junior\",\"jupon\",\"juriste\",\"justice\",\"juteux\",\"juvénile\",\"kayak\",\"kimono\",\"kiosque\",\"label\",\"labial\",\"labourer\",\"lacérer\",\"lactose\",\"lagune\",\"laine\",\"laisser\",\"laitier\",\"lambeau\",\"lamelle\",\"lampe\",\"lanceur\",\"langage\",\"lanterne\",\"lapin\",\"largeur\",\"larme\",\"laurier\",\"lavabo\",\"lavoir\",\"lecture\",\"légal\",\"léger\",\"légume\",\"lessive\",\"lettre\",\"levier\",\"lexique\",\"lézard\",\"liasse\",\"libérer\",\"libre\",\"licence\",\"licorne\",\"liège\",\"lièvre\",\"ligature\",\"ligoter\",\"ligue\",\"limer\",\"limite\",\"limonade\",\"limpide\",\"linéaire\",\"lingot\",\"lionceau\",\"liquide\",\"lisière\",\"lister\",\"lithium\",\"litige\",\"littoral\",\"livreur\",\"logique\",\"lointain\",\"loisir\",\"lombric\",\"loterie\",\"louer\",\"lourd\",\"loutre\",\"louve\",\"loyal\",\"lubie\",\"lucide\",\"lucratif\",\"lueur\",\"lugubre\",\"luisant\",\"lumière\",\"lunaire\",\"lundi\",\"luron\",\"lutter\",\"luxueux\",\"machine\",\"magasin\",\"magenta\",\"magique\",\"maigre\",\"maillon\",\"maintien\",\"mairie\",\"maison\",\"majorer\",\"malaxer\",\"maléfice\",\"malheur\",\"malice\",\"mallette\",\"mammouth\",\"mandater\",\"maniable\",\"manquant\",\"manteau\",\"manuel\",\"marathon\",\"marbre\",\"marchand\",\"mardi\",\"maritime\",\"marqueur\",\"marron\",\"marteler\",\"mascotte\",\"massif\",\"matériel\",\"matière\",\"matraque\",\"maudire\",\"maussade\",\"mauve\",\"maximal\",\"méchant\",\"méconnu\",\"médaille\",\"médecin\",\"méditer\",\"méduse\",\"meilleur\",\"mélange\",\"mélodie\",\"membre\",\"mémoire\",\"menacer\",\"mener\",\"menhir\",\"mensonge\",\"mentor\",\"mercredi\",\"mérite\",\"merle\",\"messager\",\"mesure\",\"métal\",\"météore\",\"méthode\",\"métier\",\"meuble\",\"miauler\",\"microbe\",\"miette\",\"mignon\",\"migrer\",\"milieu\",\"million\",\"mimique\",\"mince\",\"minéral\",\"minimal\",\"minorer\",\"minute\",\"miracle\",\"miroiter\",\"missile\",\"mixte\",\"mobile\",\"moderne\",\"moelleux\",\"mondial\",\"moniteur\",\"monnaie\",\"monotone\",\"monstre\",\"montagne\",\"monument\",\"moqueur\",\"morceau\",\"morsure\",\"mortier\",\"moteur\",\"motif\",\"mouche\",\"moufle\",\"moulin\",\"mousson\",\"mouton\",\"mouvant\",\"multiple\",\"munition\",\"muraille\",\"murène\",\"murmure\",\"muscle\",\"muséum\",\"musicien\",\"mutation\",\"muter\",\"mutuel\",\"myriade\",\"myrtille\",\"mystère\",\"mythique\",\"nageur\",\"nappe\",\"narquois\",\"narrer\",\"natation\",\"nation\",\"nature\",\"naufrage\",\"nautique\",\"navire\",\"nébuleux\",\"nectar\",\"néfaste\",\"négation\",\"négliger\",\"négocier\",\"neige\",\"nerveux\",\"nettoyer\",\"neurone\",\"neutron\",\"neveu\",\"niche\",\"nickel\",\"nitrate\",\"niveau\",\"noble\",\"nocif\",\"nocturne\",\"noirceur\",\"noisette\",\"nomade\",\"nombreux\",\"nommer\",\"normatif\",\"notable\",\"notifier\",\"notoire\",\"nourrir\",\"nouveau\",\"novateur\",\"novembre\",\"novice\",\"nuage\",\"nuancer\",\"nuire\",\"nuisible\",\"numéro\",\"nuptial\",\"nuque\",\"nutritif\",\"obéir\",\"objectif\",\"obliger\",\"obscur\",\"observer\",\"obstacle\",\"obtenir\",\"obturer\",\"occasion\",\"occuper\",\"océan\",\"octobre\",\"octroyer\",\"octupler\",\"oculaire\",\"odeur\",\"odorant\",\"offenser\",\"officier\",\"offrir\",\"ogive\",\"oiseau\",\"oisillon\",\"olfactif\",\"olivier\",\"ombrage\",\"omettre\",\"onctueux\",\"onduler\",\"onéreux\",\"onirique\",\"opale\",\"opaque\",\"opérer\",\"opinion\",\"opportun\",\"opprimer\",\"opter\",\"optique\",\"orageux\",\"orange\",\"orbite\",\"ordonner\",\"oreille\",\"organe\",\"orgueil\",\"orifice\",\"ornement\",\"orque\",\"ortie\",\"osciller\",\"osmose\",\"ossature\",\"otarie\",\"ouragan\",\"ourson\",\"outil\",\"outrager\",\"ouvrage\",\"ovation\",\"oxyde\",\"oxygène\",\"ozone\",\"paisible\",\"palace\",\"palmarès\",\"palourde\",\"palper\",\"panache\",\"panda\",\"pangolin\",\"paniquer\",\"panneau\",\"panorama\",\"pantalon\",\"papaye\",\"papier\",\"papoter\",\"papyrus\",\"paradoxe\",\"parcelle\",\"paresse\",\"parfumer\",\"parler\",\"parole\",\"parrain\",\"parsemer\",\"partager\",\"parure\",\"parvenir\",\"passion\",\"pastèque\",\"paternel\",\"patience\",\"patron\",\"pavillon\",\"pavoiser\",\"payer\",\"paysage\",\"peigne\",\"peintre\",\"pelage\",\"pélican\",\"pelle\",\"pelouse\",\"peluche\",\"pendule\",\"pénétrer\",\"pénible\",\"pensif\",\"pénurie\",\"pépite\",\"péplum\",\"perdrix\",\"perforer\",\"période\",\"permuter\",\"perplexe\",\"persil\",\"perte\",\"peser\",\"pétale\",\"petit\",\"pétrir\",\"peuple\",\"pharaon\",\"phobie\",\"phoque\",\"photon\",\"phrase\",\"physique\",\"piano\",\"pictural\",\"pièce\",\"pierre\",\"pieuvre\",\"pilote\",\"pinceau\",\"pipette\",\"piquer\",\"pirogue\",\"piscine\",\"piston\",\"pivoter\",\"pixel\",\"pizza\",\"placard\",\"plafond\",\"plaisir\",\"planer\",\"plaque\",\"plastron\",\"plateau\",\"pleurer\",\"plexus\",\"pliage\",\"plomb\",\"plonger\",\"pluie\",\"plumage\",\"pochette\",\"poésie\",\"poète\",\"pointe\",\"poirier\",\"poisson\",\"poivre\",\"polaire\",\"policier\",\"pollen\",\"polygone\",\"pommade\",\"pompier\",\"ponctuel\",\"pondérer\",\"poney\",\"portique\",\"position\",\"posséder\",\"posture\",\"potager\",\"poteau\",\"potion\",\"pouce\",\"poulain\",\"poumon\",\"pourpre\",\"poussin\",\"pouvoir\",\"prairie\",\"pratique\",\"précieux\",\"prédire\",\"préfixe\",\"prélude\",\"prénom\",\"présence\",\"prétexte\",\"prévoir\",\"primitif\",\"prince\",\"prison\",\"priver\",\"problème\",\"procéder\",\"prodige\",\"profond\",\"progrès\",\"proie\",\"projeter\",\"prologue\",\"promener\",\"propre\",\"prospère\",\"protéger\",\"prouesse\",\"proverbe\",\"prudence\",\"pruneau\",\"psychose\",\"public\",\"puceron\",\"puiser\",\"pulpe\",\"pulsar\",\"punaise\",\"punitif\",\"pupitre\",\"purifier\",\"puzzle\",\"pyramide\",\"quasar\",\"querelle\",\"question\",\"quiétude\",\"quitter\",\"quotient\",\"racine\",\"raconter\",\"radieux\",\"ragondin\",\"raideur\",\"raisin\",\"ralentir\",\"rallonge\",\"ramasser\",\"rapide\",\"rasage\",\"ratisser\",\"ravager\",\"ravin\",\"rayonner\",\"réactif\",\"réagir\",\"réaliser\",\"réanimer\",\"recevoir\",\"réciter\",\"réclamer\",\"récolter\",\"recruter\",\"reculer\",\"recycler\",\"rédiger\",\"redouter\",\"refaire\",\"réflexe\",\"réformer\",\"refrain\",\"refuge\",\"régalien\",\"région\",\"réglage\",\"régulier\",\"réitérer\",\"rejeter\",\"rejouer\",\"relatif\",\"relever\",\"relief\",\"remarque\",\"remède\",\"remise\",\"remonter\",\"remplir\",\"remuer\",\"renard\",\"renfort\",\"renifler\",\"renoncer\",\"rentrer\",\"renvoi\",\"replier\",\"reporter\",\"reprise\",\"reptile\",\"requin\",\"réserve\",\"résineux\",\"résoudre\",\"respect\",\"rester\",\"résultat\",\"rétablir\",\"retenir\",\"réticule\",\"retomber\",\"retracer\",\"réunion\",\"réussir\",\"revanche\",\"revivre\",\"révolte\",\"révulsif\",\"richesse\",\"rideau\",\"rieur\",\"rigide\",\"rigoler\",\"rincer\",\"riposter\",\"risible\",\"risque\",\"rituel\",\"rival\",\"rivière\",\"rocheux\",\"romance\",\"rompre\",\"ronce\",\"rondin\",\"roseau\",\"rosier\",\"rotatif\",\"rotor\",\"rotule\",\"rouge\",\"rouille\",\"rouleau\",\"routine\",\"royaume\",\"ruban\",\"rubis\",\"ruche\",\"ruelle\",\"rugueux\",\"ruiner\",\"ruisseau\",\"ruser\",\"rustique\",\"rythme\",\"sabler\",\"saboter\",\"sabre\",\"sacoche\",\"safari\",\"sagesse\",\"saisir\",\"salade\",\"salive\",\"salon\",\"saluer\",\"samedi\",\"sanction\",\"sanglier\",\"sarcasme\",\"sardine\",\"saturer\",\"saugrenu\",\"saumon\",\"sauter\",\"sauvage\",\"savant\",\"savonner\",\"scalpel\",\"scandale\",\"scélérat\",\"scénario\",\"sceptre\",\"schéma\",\"science\",\"scinder\",\"score\",\"scrutin\",\"sculpter\",\"séance\",\"sécable\",\"sécher\",\"secouer\",\"sécréter\",\"sédatif\",\"séduire\",\"seigneur\",\"séjour\",\"sélectif\",\"semaine\",\"sembler\",\"semence\",\"séminal\",\"sénateur\",\"sensible\",\"sentence\",\"séparer\",\"séquence\",\"serein\",\"sergent\",\"sérieux\",\"serrure\",\"sérum\",\"service\",\"sésame\",\"sévir\",\"sevrage\",\"sextuple\",\"sidéral\",\"siècle\",\"siéger\",\"siffler\",\"sigle\",\"signal\",\"silence\",\"silicium\",\"simple\",\"sincère\",\"sinistre\",\"siphon\",\"sirop\",\"sismique\",\"situer\",\"skier\",\"social\",\"socle\",\"sodium\",\"soigneux\",\"soldat\",\"soleil\",\"solitude\",\"soluble\",\"sombre\",\"sommeil\",\"somnoler\",\"sonde\",\"songeur\",\"sonnette\",\"sonore\",\"sorcier\",\"sortir\",\"sosie\",\"sottise\",\"soucieux\",\"soudure\",\"souffle\",\"soulever\",\"soupape\",\"source\",\"soutirer\",\"souvenir\",\"spacieux\",\"spatial\",\"spécial\",\"sphère\",\"spiral\",\"stable\",\"station\",\"sternum\",\"stimulus\",\"stipuler\",\"strict\",\"studieux\",\"stupeur\",\"styliste\",\"sublime\",\"substrat\",\"subtil\",\"subvenir\",\"succès\",\"sucre\",\"suffixe\",\"suggérer\",\"suiveur\",\"sulfate\",\"superbe\",\"supplier\",\"surface\",\"suricate\",\"surmener\",\"surprise\",\"sursaut\",\"survie\",\"suspect\",\"syllabe\",\"symbole\",\"symétrie\",\"synapse\",\"syntaxe\",\"système\",\"tabac\",\"tablier\",\"tactile\",\"tailler\",\"talent\",\"talisman\",\"talonner\",\"tambour\",\"tamiser\",\"tangible\",\"tapis\",\"taquiner\",\"tarder\",\"tarif\",\"tartine\",\"tasse\",\"tatami\",\"tatouage\",\"taupe\",\"taureau\",\"taxer\",\"témoin\",\"temporel\",\"tenaille\",\"tendre\",\"teneur\",\"tenir\",\"tension\",\"terminer\",\"terne\",\"terrible\",\"tétine\",\"texte\",\"thème\",\"théorie\",\"thérapie\",\"thorax\",\"tibia\",\"tiède\",\"timide\",\"tirelire\",\"tiroir\",\"tissu\",\"titane\",\"titre\",\"tituber\",\"toboggan\",\"tolérant\",\"tomate\",\"tonique\",\"tonneau\",\"toponyme\",\"torche\",\"tordre\",\"tornade\",\"torpille\",\"torrent\",\"torse\",\"tortue\",\"totem\",\"toucher\",\"tournage\",\"tousser\",\"toxine\",\"traction\",\"trafic\",\"tragique\",\"trahir\",\"train\",\"trancher\",\"travail\",\"trèfle\",\"tremper\",\"trésor\",\"treuil\",\"triage\",\"tribunal\",\"tricoter\",\"trilogie\",\"triomphe\",\"tripler\",\"triturer\",\"trivial\",\"trombone\",\"tronc\",\"tropical\",\"troupeau\",\"tuile\",\"tulipe\",\"tumulte\",\"tunnel\",\"turbine\",\"tuteur\",\"tutoyer\",\"tuyau\",\"tympan\",\"typhon\",\"typique\",\"tyran\",\"ubuesque\",\"ultime\",\"ultrason\",\"unanime\",\"unifier\",\"union\",\"unique\",\"unitaire\",\"univers\",\"uranium\",\"urbain\",\"urticant\",\"usage\",\"usine\",\"usuel\",\"usure\",\"utile\",\"utopie\",\"vacarme\",\"vaccin\",\"vagabond\",\"vague\",\"vaillant\",\"vaincre\",\"vaisseau\",\"valable\",\"valise\",\"vallon\",\"valve\",\"vampire\",\"vanille\",\"vapeur\",\"varier\",\"vaseux\",\"vassal\",\"vaste\",\"vecteur\",\"vedette\",\"végétal\",\"véhicule\",\"veinard\",\"véloce\",\"vendredi\",\"vénérer\",\"venger\",\"venimeux\",\"ventouse\",\"verdure\",\"vérin\",\"vernir\",\"verrou\",\"verser\",\"vertu\",\"veston\",\"vétéran\",\"vétuste\",\"vexant\",\"vexer\",\"viaduc\",\"viande\",\"victoire\",\"vidange\",\"vidéo\",\"vignette\",\"vigueur\",\"vilain\",\"village\",\"vinaigre\",\"violon\",\"vipère\",\"virement\",\"virtuose\",\"virus\",\"visage\",\"viseur\",\"vision\",\"visqueux\",\"visuel\",\"vital\",\"vitesse\",\"viticole\",\"vitrine\",\"vivace\",\"vivipare\",\"vocation\",\"voguer\",\"voile\",\"voisin\",\"voiture\",\"volaille\",\"volcan\",\"voltiger\",\"volume\",\"vorace\",\"vortex\",\"voter\",\"vouloir\",\"voyage\",\"voyelle\",\"wagon\",\"xénon\",\"yacht\",\"zèbre\",\"zénith\",\"zeste\",\"zoologie\"]");

/***/ }),

/***/ 165296:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse("[\"abaco\",\"abbaglio\",\"abbinato\",\"abete\",\"abisso\",\"abolire\",\"abrasivo\",\"abrogato\",\"accadere\",\"accenno\",\"accusato\",\"acetone\",\"achille\",\"acido\",\"acqua\",\"acre\",\"acrilico\",\"acrobata\",\"acuto\",\"adagio\",\"addebito\",\"addome\",\"adeguato\",\"aderire\",\"adipe\",\"adottare\",\"adulare\",\"affabile\",\"affetto\",\"affisso\",\"affranto\",\"aforisma\",\"afoso\",\"africano\",\"agave\",\"agente\",\"agevole\",\"aggancio\",\"agire\",\"agitare\",\"agonismo\",\"agricolo\",\"agrumeto\",\"aguzzo\",\"alabarda\",\"alato\",\"albatro\",\"alberato\",\"albo\",\"albume\",\"alce\",\"alcolico\",\"alettone\",\"alfa\",\"algebra\",\"aliante\",\"alibi\",\"alimento\",\"allagato\",\"allegro\",\"allievo\",\"allodola\",\"allusivo\",\"almeno\",\"alogeno\",\"alpaca\",\"alpestre\",\"altalena\",\"alterno\",\"alticcio\",\"altrove\",\"alunno\",\"alveolo\",\"alzare\",\"amalgama\",\"amanita\",\"amarena\",\"ambito\",\"ambrato\",\"ameba\",\"america\",\"ametista\",\"amico\",\"ammasso\",\"ammenda\",\"ammirare\",\"ammonito\",\"amore\",\"ampio\",\"ampliare\",\"amuleto\",\"anacardo\",\"anagrafe\",\"analista\",\"anarchia\",\"anatra\",\"anca\",\"ancella\",\"ancora\",\"andare\",\"andrea\",\"anello\",\"angelo\",\"angolare\",\"angusto\",\"anima\",\"annegare\",\"annidato\",\"anno\",\"annuncio\",\"anonimo\",\"anticipo\",\"anzi\",\"apatico\",\"apertura\",\"apode\",\"apparire\",\"appetito\",\"appoggio\",\"approdo\",\"appunto\",\"aprile\",\"arabica\",\"arachide\",\"aragosta\",\"araldica\",\"arancio\",\"aratura\",\"arazzo\",\"arbitro\",\"archivio\",\"ardito\",\"arenile\",\"argento\",\"argine\",\"arguto\",\"aria\",\"armonia\",\"arnese\",\"arredato\",\"arringa\",\"arrosto\",\"arsenico\",\"arso\",\"artefice\",\"arzillo\",\"asciutto\",\"ascolto\",\"asepsi\",\"asettico\",\"asfalto\",\"asino\",\"asola\",\"aspirato\",\"aspro\",\"assaggio\",\"asse\",\"assoluto\",\"assurdo\",\"asta\",\"astenuto\",\"astice\",\"astratto\",\"atavico\",\"ateismo\",\"atomico\",\"atono\",\"attesa\",\"attivare\",\"attorno\",\"attrito\",\"attuale\",\"ausilio\",\"austria\",\"autista\",\"autonomo\",\"autunno\",\"avanzato\",\"avere\",\"avvenire\",\"avviso\",\"avvolgere\",\"azione\",\"azoto\",\"azzimo\",\"azzurro\",\"babele\",\"baccano\",\"bacino\",\"baco\",\"badessa\",\"badilata\",\"bagnato\",\"baita\",\"balcone\",\"baldo\",\"balena\",\"ballata\",\"balzano\",\"bambino\",\"bandire\",\"baraonda\",\"barbaro\",\"barca\",\"baritono\",\"barlume\",\"barocco\",\"basilico\",\"basso\",\"batosta\",\"battuto\",\"baule\",\"bava\",\"bavosa\",\"becco\",\"beffa\",\"belgio\",\"belva\",\"benda\",\"benevole\",\"benigno\",\"benzina\",\"bere\",\"berlina\",\"beta\",\"bibita\",\"bici\",\"bidone\",\"bifido\",\"biga\",\"bilancia\",\"bimbo\",\"binocolo\",\"biologo\",\"bipede\",\"bipolare\",\"birbante\",\"birra\",\"biscotto\",\"bisesto\",\"bisnonno\",\"bisonte\",\"bisturi\",\"bizzarro\",\"blando\",\"blatta\",\"bollito\",\"bonifico\",\"bordo\",\"bosco\",\"botanico\",\"bottino\",\"bozzolo\",\"braccio\",\"bradipo\",\"brama\",\"branca\",\"bravura\",\"bretella\",\"brevetto\",\"brezza\",\"briglia\",\"brillante\",\"brindare\",\"broccolo\",\"brodo\",\"bronzina\",\"brullo\",\"bruno\",\"bubbone\",\"buca\",\"budino\",\"buffone\",\"buio\",\"bulbo\",\"buono\",\"burlone\",\"burrasca\",\"bussola\",\"busta\",\"cadetto\",\"caduco\",\"calamaro\",\"calcolo\",\"calesse\",\"calibro\",\"calmo\",\"caloria\",\"cambusa\",\"camerata\",\"camicia\",\"cammino\",\"camola\",\"campale\",\"canapa\",\"candela\",\"cane\",\"canino\",\"canotto\",\"cantina\",\"capace\",\"capello\",\"capitolo\",\"capogiro\",\"cappero\",\"capra\",\"capsula\",\"carapace\",\"carcassa\",\"cardo\",\"carisma\",\"carovana\",\"carretto\",\"cartolina\",\"casaccio\",\"cascata\",\"caserma\",\"caso\",\"cassone\",\"castello\",\"casuale\",\"catasta\",\"catena\",\"catrame\",\"cauto\",\"cavillo\",\"cedibile\",\"cedrata\",\"cefalo\",\"celebre\",\"cellulare\",\"cena\",\"cenone\",\"centesimo\",\"ceramica\",\"cercare\",\"certo\",\"cerume\",\"cervello\",\"cesoia\",\"cespo\",\"ceto\",\"chela\",\"chiaro\",\"chicca\",\"chiedere\",\"chimera\",\"china\",\"chirurgo\",\"chitarra\",\"ciao\",\"ciclismo\",\"cifrare\",\"cigno\",\"cilindro\",\"ciottolo\",\"circa\",\"cirrosi\",\"citrico\",\"cittadino\",\"ciuffo\",\"civetta\",\"civile\",\"classico\",\"clinica\",\"cloro\",\"cocco\",\"codardo\",\"codice\",\"coerente\",\"cognome\",\"collare\",\"colmato\",\"colore\",\"colposo\",\"coltivato\",\"colza\",\"coma\",\"cometa\",\"commando\",\"comodo\",\"computer\",\"comune\",\"conciso\",\"condurre\",\"conferma\",\"congelare\",\"coniuge\",\"connesso\",\"conoscere\",\"consumo\",\"continuo\",\"convegno\",\"coperto\",\"copione\",\"coppia\",\"copricapo\",\"corazza\",\"cordata\",\"coricato\",\"cornice\",\"corolla\",\"corpo\",\"corredo\",\"corsia\",\"cortese\",\"cosmico\",\"costante\",\"cottura\",\"covato\",\"cratere\",\"cravatta\",\"creato\",\"credere\",\"cremoso\",\"crescita\",\"creta\",\"criceto\",\"crinale\",\"crisi\",\"critico\",\"croce\",\"cronaca\",\"crostata\",\"cruciale\",\"crusca\",\"cucire\",\"cuculo\",\"cugino\",\"cullato\",\"cupola\",\"curatore\",\"cursore\",\"curvo\",\"cuscino\",\"custode\",\"dado\",\"daino\",\"dalmata\",\"damerino\",\"daniela\",\"dannoso\",\"danzare\",\"datato\",\"davanti\",\"davvero\",\"debutto\",\"decennio\",\"deciso\",\"declino\",\"decollo\",\"decreto\",\"dedicato\",\"definito\",\"deforme\",\"degno\",\"delegare\",\"delfino\",\"delirio\",\"delta\",\"demenza\",\"denotato\",\"dentro\",\"deposito\",\"derapata\",\"derivare\",\"deroga\",\"descritto\",\"deserto\",\"desiderio\",\"desumere\",\"detersivo\",\"devoto\",\"diametro\",\"dicembre\",\"diedro\",\"difeso\",\"diffuso\",\"digerire\",\"digitale\",\"diluvio\",\"dinamico\",\"dinnanzi\",\"dipinto\",\"diploma\",\"dipolo\",\"diradare\",\"dire\",\"dirotto\",\"dirupo\",\"disagio\",\"discreto\",\"disfare\",\"disgelo\",\"disposto\",\"distanza\",\"disumano\",\"dito\",\"divano\",\"divelto\",\"dividere\",\"divorato\",\"doblone\",\"docente\",\"doganale\",\"dogma\",\"dolce\",\"domato\",\"domenica\",\"dominare\",\"dondolo\",\"dono\",\"dormire\",\"dote\",\"dottore\",\"dovuto\",\"dozzina\",\"drago\",\"druido\",\"dubbio\",\"dubitare\",\"ducale\",\"duna\",\"duomo\",\"duplice\",\"duraturo\",\"ebano\",\"eccesso\",\"ecco\",\"eclissi\",\"economia\",\"edera\",\"edicola\",\"edile\",\"editoria\",\"educare\",\"egemonia\",\"egli\",\"egoismo\",\"egregio\",\"elaborato\",\"elargire\",\"elegante\",\"elencato\",\"eletto\",\"elevare\",\"elfico\",\"elica\",\"elmo\",\"elsa\",\"eluso\",\"emanato\",\"emblema\",\"emesso\",\"emiro\",\"emotivo\",\"emozione\",\"empirico\",\"emulo\",\"endemico\",\"enduro\",\"energia\",\"enfasi\",\"enoteca\",\"entrare\",\"enzima\",\"epatite\",\"epilogo\",\"episodio\",\"epocale\",\"eppure\",\"equatore\",\"erario\",\"erba\",\"erboso\",\"erede\",\"eremita\",\"erigere\",\"ermetico\",\"eroe\",\"erosivo\",\"errante\",\"esagono\",\"esame\",\"esanime\",\"esaudire\",\"esca\",\"esempio\",\"esercito\",\"esibito\",\"esigente\",\"esistere\",\"esito\",\"esofago\",\"esortato\",\"esoso\",\"espanso\",\"espresso\",\"essenza\",\"esso\",\"esteso\",\"estimare\",\"estonia\",\"estroso\",\"esultare\",\"etilico\",\"etnico\",\"etrusco\",\"etto\",\"euclideo\",\"europa\",\"evaso\",\"evidenza\",\"evitato\",\"evoluto\",\"evviva\",\"fabbrica\",\"faccenda\",\"fachiro\",\"falco\",\"famiglia\",\"fanale\",\"fanfara\",\"fango\",\"fantasma\",\"fare\",\"farfalla\",\"farinoso\",\"farmaco\",\"fascia\",\"fastoso\",\"fasullo\",\"faticare\",\"fato\",\"favoloso\",\"febbre\",\"fecola\",\"fede\",\"fegato\",\"felpa\",\"feltro\",\"femmina\",\"fendere\",\"fenomeno\",\"fermento\",\"ferro\",\"fertile\",\"fessura\",\"festivo\",\"fetta\",\"feudo\",\"fiaba\",\"fiducia\",\"fifa\",\"figurato\",\"filo\",\"finanza\",\"finestra\",\"finire\",\"fiore\",\"fiscale\",\"fisico\",\"fiume\",\"flacone\",\"flamenco\",\"flebo\",\"flemma\",\"florido\",\"fluente\",\"fluoro\",\"fobico\",\"focaccia\",\"focoso\",\"foderato\",\"foglio\",\"folata\",\"folclore\",\"folgore\",\"fondente\",\"fonetico\",\"fonia\",\"fontana\",\"forbito\",\"forchetta\",\"foresta\",\"formica\",\"fornaio\",\"foro\",\"fortezza\",\"forzare\",\"fosfato\",\"fosso\",\"fracasso\",\"frana\",\"frassino\",\"fratello\",\"freccetta\",\"frenata\",\"fresco\",\"frigo\",\"frollino\",\"fronde\",\"frugale\",\"frutta\",\"fucilata\",\"fucsia\",\"fuggente\",\"fulmine\",\"fulvo\",\"fumante\",\"fumetto\",\"fumoso\",\"fune\",\"funzione\",\"fuoco\",\"furbo\",\"furgone\",\"furore\",\"fuso\",\"futile\",\"gabbiano\",\"gaffe\",\"galateo\",\"gallina\",\"galoppo\",\"gambero\",\"gamma\",\"garanzia\",\"garbo\",\"garofano\",\"garzone\",\"gasdotto\",\"gasolio\",\"gastrico\",\"gatto\",\"gaudio\",\"gazebo\",\"gazzella\",\"geco\",\"gelatina\",\"gelso\",\"gemello\",\"gemmato\",\"gene\",\"genitore\",\"gennaio\",\"genotipo\",\"gergo\",\"ghepardo\",\"ghiaccio\",\"ghisa\",\"giallo\",\"gilda\",\"ginepro\",\"giocare\",\"gioiello\",\"giorno\",\"giove\",\"girato\",\"girone\",\"gittata\",\"giudizio\",\"giurato\",\"giusto\",\"globulo\",\"glutine\",\"gnomo\",\"gobba\",\"golf\",\"gomito\",\"gommone\",\"gonfio\",\"gonna\",\"governo\",\"gracile\",\"grado\",\"grafico\",\"grammo\",\"grande\",\"grattare\",\"gravoso\",\"grazia\",\"greca\",\"gregge\",\"grifone\",\"grigio\",\"grinza\",\"grotta\",\"gruppo\",\"guadagno\",\"guaio\",\"guanto\",\"guardare\",\"gufo\",\"guidare\",\"ibernato\",\"icona\",\"identico\",\"idillio\",\"idolo\",\"idra\",\"idrico\",\"idrogeno\",\"igiene\",\"ignaro\",\"ignorato\",\"ilare\",\"illeso\",\"illogico\",\"illudere\",\"imballo\",\"imbevuto\",\"imbocco\",\"imbuto\",\"immane\",\"immerso\",\"immolato\",\"impacco\",\"impeto\",\"impiego\",\"importo\",\"impronta\",\"inalare\",\"inarcare\",\"inattivo\",\"incanto\",\"incendio\",\"inchino\",\"incisivo\",\"incluso\",\"incontro\",\"incrocio\",\"incubo\",\"indagine\",\"india\",\"indole\",\"inedito\",\"infatti\",\"infilare\",\"inflitto\",\"ingaggio\",\"ingegno\",\"inglese\",\"ingordo\",\"ingrosso\",\"innesco\",\"inodore\",\"inoltrare\",\"inondato\",\"insano\",\"insetto\",\"insieme\",\"insonnia\",\"insulina\",\"intasato\",\"intero\",\"intonaco\",\"intuito\",\"inumidire\",\"invalido\",\"invece\",\"invito\",\"iperbole\",\"ipnotico\",\"ipotesi\",\"ippica\",\"iride\",\"irlanda\",\"ironico\",\"irrigato\",\"irrorare\",\"isolato\",\"isotopo\",\"isterico\",\"istituto\",\"istrice\",\"italia\",\"iterare\",\"labbro\",\"labirinto\",\"lacca\",\"lacerato\",\"lacrima\",\"lacuna\",\"laddove\",\"lago\",\"lampo\",\"lancetta\",\"lanterna\",\"lardoso\",\"larga\",\"laringe\",\"lastra\",\"latenza\",\"latino\",\"lattuga\",\"lavagna\",\"lavoro\",\"legale\",\"leggero\",\"lembo\",\"lentezza\",\"lenza\",\"leone\",\"lepre\",\"lesivo\",\"lessato\",\"lesto\",\"letterale\",\"leva\",\"levigato\",\"libero\",\"lido\",\"lievito\",\"lilla\",\"limatura\",\"limitare\",\"limpido\",\"lineare\",\"lingua\",\"liquido\",\"lira\",\"lirica\",\"lisca\",\"lite\",\"litigio\",\"livrea\",\"locanda\",\"lode\",\"logica\",\"lombare\",\"londra\",\"longevo\",\"loquace\",\"lorenzo\",\"loto\",\"lotteria\",\"luce\",\"lucidato\",\"lumaca\",\"luminoso\",\"lungo\",\"lupo\",\"luppolo\",\"lusinga\",\"lusso\",\"lutto\",\"macabro\",\"macchina\",\"macero\",\"macinato\",\"madama\",\"magico\",\"maglia\",\"magnete\",\"magro\",\"maiolica\",\"malafede\",\"malgrado\",\"malinteso\",\"malsano\",\"malto\",\"malumore\",\"mana\",\"mancia\",\"mandorla\",\"mangiare\",\"manifesto\",\"mannaro\",\"manovra\",\"mansarda\",\"mantide\",\"manubrio\",\"mappa\",\"maratona\",\"marcire\",\"maretta\",\"marmo\",\"marsupio\",\"maschera\",\"massaia\",\"mastino\",\"materasso\",\"matricola\",\"mattone\",\"maturo\",\"mazurca\",\"meandro\",\"meccanico\",\"mecenate\",\"medesimo\",\"meditare\",\"mega\",\"melassa\",\"melis\",\"melodia\",\"meninge\",\"meno\",\"mensola\",\"mercurio\",\"merenda\",\"merlo\",\"meschino\",\"mese\",\"messere\",\"mestolo\",\"metallo\",\"metodo\",\"mettere\",\"miagolare\",\"mica\",\"micelio\",\"michele\",\"microbo\",\"midollo\",\"miele\",\"migliore\",\"milano\",\"milite\",\"mimosa\",\"minerale\",\"mini\",\"minore\",\"mirino\",\"mirtillo\",\"miscela\",\"missiva\",\"misto\",\"misurare\",\"mitezza\",\"mitigare\",\"mitra\",\"mittente\",\"mnemonico\",\"modello\",\"modifica\",\"modulo\",\"mogano\",\"mogio\",\"mole\",\"molosso\",\"monastero\",\"monco\",\"mondina\",\"monetario\",\"monile\",\"monotono\",\"monsone\",\"montato\",\"monviso\",\"mora\",\"mordere\",\"morsicato\",\"mostro\",\"motivato\",\"motosega\",\"motto\",\"movenza\",\"movimento\",\"mozzo\",\"mucca\",\"mucosa\",\"muffa\",\"mughetto\",\"mugnaio\",\"mulatto\",\"mulinello\",\"multiplo\",\"mummia\",\"munto\",\"muovere\",\"murale\",\"musa\",\"muscolo\",\"musica\",\"mutevole\",\"muto\",\"nababbo\",\"nafta\",\"nanometro\",\"narciso\",\"narice\",\"narrato\",\"nascere\",\"nastrare\",\"naturale\",\"nautica\",\"naviglio\",\"nebulosa\",\"necrosi\",\"negativo\",\"negozio\",\"nemmeno\",\"neofita\",\"neretto\",\"nervo\",\"nessuno\",\"nettuno\",\"neutrale\",\"neve\",\"nevrotico\",\"nicchia\",\"ninfa\",\"nitido\",\"nobile\",\"nocivo\",\"nodo\",\"nome\",\"nomina\",\"nordico\",\"normale\",\"norvegese\",\"nostrano\",\"notare\",\"notizia\",\"notturno\",\"novella\",\"nucleo\",\"nulla\",\"numero\",\"nuovo\",\"nutrire\",\"nuvola\",\"nuziale\",\"oasi\",\"obbedire\",\"obbligo\",\"obelisco\",\"oblio\",\"obolo\",\"obsoleto\",\"occasione\",\"occhio\",\"occidente\",\"occorrere\",\"occultare\",\"ocra\",\"oculato\",\"odierno\",\"odorare\",\"offerta\",\"offrire\",\"offuscato\",\"oggetto\",\"oggi\",\"ognuno\",\"olandese\",\"olfatto\",\"oliato\",\"oliva\",\"ologramma\",\"oltre\",\"omaggio\",\"ombelico\",\"ombra\",\"omega\",\"omissione\",\"ondoso\",\"onere\",\"onice\",\"onnivoro\",\"onorevole\",\"onta\",\"operato\",\"opinione\",\"opposto\",\"oracolo\",\"orafo\",\"ordine\",\"orecchino\",\"orefice\",\"orfano\",\"organico\",\"origine\",\"orizzonte\",\"orma\",\"ormeggio\",\"ornativo\",\"orologio\",\"orrendo\",\"orribile\",\"ortensia\",\"ortica\",\"orzata\",\"orzo\",\"osare\",\"oscurare\",\"osmosi\",\"ospedale\",\"ospite\",\"ossa\",\"ossidare\",\"ostacolo\",\"oste\",\"otite\",\"otre\",\"ottagono\",\"ottimo\",\"ottobre\",\"ovale\",\"ovest\",\"ovino\",\"oviparo\",\"ovocito\",\"ovunque\",\"ovviare\",\"ozio\",\"pacchetto\",\"pace\",\"pacifico\",\"padella\",\"padrone\",\"paese\",\"paga\",\"pagina\",\"palazzina\",\"palesare\",\"pallido\",\"palo\",\"palude\",\"pandoro\",\"pannello\",\"paolo\",\"paonazzo\",\"paprica\",\"parabola\",\"parcella\",\"parere\",\"pargolo\",\"pari\",\"parlato\",\"parola\",\"partire\",\"parvenza\",\"parziale\",\"passivo\",\"pasticca\",\"patacca\",\"patologia\",\"pattume\",\"pavone\",\"peccato\",\"pedalare\",\"pedonale\",\"peggio\",\"peloso\",\"penare\",\"pendice\",\"penisola\",\"pennuto\",\"penombra\",\"pensare\",\"pentola\",\"pepe\",\"pepita\",\"perbene\",\"percorso\",\"perdonato\",\"perforare\",\"pergamena\",\"periodo\",\"permesso\",\"perno\",\"perplesso\",\"persuaso\",\"pertugio\",\"pervaso\",\"pesatore\",\"pesista\",\"peso\",\"pestifero\",\"petalo\",\"pettine\",\"petulante\",\"pezzo\",\"piacere\",\"pianta\",\"piattino\",\"piccino\",\"picozza\",\"piega\",\"pietra\",\"piffero\",\"pigiama\",\"pigolio\",\"pigro\",\"pila\",\"pilifero\",\"pillola\",\"pilota\",\"pimpante\",\"pineta\",\"pinna\",\"pinolo\",\"pioggia\",\"piombo\",\"piramide\",\"piretico\",\"pirite\",\"pirolisi\",\"pitone\",\"pizzico\",\"placebo\",\"planare\",\"plasma\",\"platano\",\"plenario\",\"pochezza\",\"poderoso\",\"podismo\",\"poesia\",\"poggiare\",\"polenta\",\"poligono\",\"pollice\",\"polmonite\",\"polpetta\",\"polso\",\"poltrona\",\"polvere\",\"pomice\",\"pomodoro\",\"ponte\",\"popoloso\",\"porfido\",\"poroso\",\"porpora\",\"porre\",\"portata\",\"posa\",\"positivo\",\"possesso\",\"postulato\",\"potassio\",\"potere\",\"pranzo\",\"prassi\",\"pratica\",\"precluso\",\"predica\",\"prefisso\",\"pregiato\",\"prelievo\",\"premere\",\"prenotare\",\"preparato\",\"presenza\",\"pretesto\",\"prevalso\",\"prima\",\"principe\",\"privato\",\"problema\",\"procura\",\"produrre\",\"profumo\",\"progetto\",\"prolunga\",\"promessa\",\"pronome\",\"proposta\",\"proroga\",\"proteso\",\"prova\",\"prudente\",\"prugna\",\"prurito\",\"psiche\",\"pubblico\",\"pudica\",\"pugilato\",\"pugno\",\"pulce\",\"pulito\",\"pulsante\",\"puntare\",\"pupazzo\",\"pupilla\",\"puro\",\"quadro\",\"qualcosa\",\"quasi\",\"querela\",\"quota\",\"raccolto\",\"raddoppio\",\"radicale\",\"radunato\",\"raffica\",\"ragazzo\",\"ragione\",\"ragno\",\"ramarro\",\"ramingo\",\"ramo\",\"randagio\",\"rantolare\",\"rapato\",\"rapina\",\"rappreso\",\"rasatura\",\"raschiato\",\"rasente\",\"rassegna\",\"rastrello\",\"rata\",\"ravveduto\",\"reale\",\"recepire\",\"recinto\",\"recluta\",\"recondito\",\"recupero\",\"reddito\",\"redimere\",\"regalato\",\"registro\",\"regola\",\"regresso\",\"relazione\",\"remare\",\"remoto\",\"renna\",\"replica\",\"reprimere\",\"reputare\",\"resa\",\"residente\",\"responso\",\"restauro\",\"rete\",\"retina\",\"retorica\",\"rettifica\",\"revocato\",\"riassunto\",\"ribadire\",\"ribelle\",\"ribrezzo\",\"ricarica\",\"ricco\",\"ricevere\",\"riciclato\",\"ricordo\",\"ricreduto\",\"ridicolo\",\"ridurre\",\"rifasare\",\"riflesso\",\"riforma\",\"rifugio\",\"rigare\",\"rigettato\",\"righello\",\"rilassato\",\"rilevato\",\"rimanere\",\"rimbalzo\",\"rimedio\",\"rimorchio\",\"rinascita\",\"rincaro\",\"rinforzo\",\"rinnovo\",\"rinomato\",\"rinsavito\",\"rintocco\",\"rinuncia\",\"rinvenire\",\"riparato\",\"ripetuto\",\"ripieno\",\"riportare\",\"ripresa\",\"ripulire\",\"risata\",\"rischio\",\"riserva\",\"risibile\",\"riso\",\"rispetto\",\"ristoro\",\"risultato\",\"risvolto\",\"ritardo\",\"ritegno\",\"ritmico\",\"ritrovo\",\"riunione\",\"riva\",\"riverso\",\"rivincita\",\"rivolto\",\"rizoma\",\"roba\",\"robotico\",\"robusto\",\"roccia\",\"roco\",\"rodaggio\",\"rodere\",\"roditore\",\"rogito\",\"rollio\",\"romantico\",\"rompere\",\"ronzio\",\"rosolare\",\"rospo\",\"rotante\",\"rotondo\",\"rotula\",\"rovescio\",\"rubizzo\",\"rubrica\",\"ruga\",\"rullino\",\"rumine\",\"rumoroso\",\"ruolo\",\"rupe\",\"russare\",\"rustico\",\"sabato\",\"sabbiare\",\"sabotato\",\"sagoma\",\"salasso\",\"saldatura\",\"salgemma\",\"salivare\",\"salmone\",\"salone\",\"saltare\",\"saluto\",\"salvo\",\"sapere\",\"sapido\",\"saporito\",\"saraceno\",\"sarcasmo\",\"sarto\",\"sassoso\",\"satellite\",\"satira\",\"satollo\",\"saturno\",\"savana\",\"savio\",\"saziato\",\"sbadiglio\",\"sbalzo\",\"sbancato\",\"sbarra\",\"sbattere\",\"sbavare\",\"sbendare\",\"sbirciare\",\"sbloccato\",\"sbocciato\",\"sbrinare\",\"sbruffone\",\"sbuffare\",\"scabroso\",\"scadenza\",\"scala\",\"scambiare\",\"scandalo\",\"scapola\",\"scarso\",\"scatenare\",\"scavato\",\"scelto\",\"scenico\",\"scettro\",\"scheda\",\"schiena\",\"sciarpa\",\"scienza\",\"scindere\",\"scippo\",\"sciroppo\",\"scivolo\",\"sclerare\",\"scodella\",\"scolpito\",\"scomparto\",\"sconforto\",\"scoprire\",\"scorta\",\"scossone\",\"scozzese\",\"scriba\",\"scrollare\",\"scrutinio\",\"scuderia\",\"scultore\",\"scuola\",\"scuro\",\"scusare\",\"sdebitare\",\"sdoganare\",\"seccatura\",\"secondo\",\"sedano\",\"seggiola\",\"segnalato\",\"segregato\",\"seguito\",\"selciato\",\"selettivo\",\"sella\",\"selvaggio\",\"semaforo\",\"sembrare\",\"seme\",\"seminato\",\"sempre\",\"senso\",\"sentire\",\"sepolto\",\"sequenza\",\"serata\",\"serbato\",\"sereno\",\"serio\",\"serpente\",\"serraglio\",\"servire\",\"sestina\",\"setola\",\"settimana\",\"sfacelo\",\"sfaldare\",\"sfamato\",\"sfarzoso\",\"sfaticato\",\"sfera\",\"sfida\",\"sfilato\",\"sfinge\",\"sfocato\",\"sfoderare\",\"sfogo\",\"sfoltire\",\"sforzato\",\"sfratto\",\"sfruttato\",\"sfuggito\",\"sfumare\",\"sfuso\",\"sgabello\",\"sgarbato\",\"sgonfiare\",\"sgorbio\",\"sgrassato\",\"sguardo\",\"sibilo\",\"siccome\",\"sierra\",\"sigla\",\"signore\",\"silenzio\",\"sillaba\",\"simbolo\",\"simpatico\",\"simulato\",\"sinfonia\",\"singolo\",\"sinistro\",\"sino\",\"sintesi\",\"sinusoide\",\"sipario\",\"sisma\",\"sistole\",\"situato\",\"slitta\",\"slogatura\",\"sloveno\",\"smarrito\",\"smemorato\",\"smentito\",\"smeraldo\",\"smilzo\",\"smontare\",\"smottato\",\"smussato\",\"snellire\",\"snervato\",\"snodo\",\"sobbalzo\",\"sobrio\",\"soccorso\",\"sociale\",\"sodale\",\"soffitto\",\"sogno\",\"soldato\",\"solenne\",\"solido\",\"sollazzo\",\"solo\",\"solubile\",\"solvente\",\"somatico\",\"somma\",\"sonda\",\"sonetto\",\"sonnifero\",\"sopire\",\"soppeso\",\"sopra\",\"sorgere\",\"sorpasso\",\"sorriso\",\"sorso\",\"sorteggio\",\"sorvolato\",\"sospiro\",\"sosta\",\"sottile\",\"spada\",\"spalla\",\"spargere\",\"spatola\",\"spavento\",\"spazzola\",\"specie\",\"spedire\",\"spegnere\",\"spelatura\",\"speranza\",\"spessore\",\"spettrale\",\"spezzato\",\"spia\",\"spigoloso\",\"spillato\",\"spinoso\",\"spirale\",\"splendido\",\"sportivo\",\"sposo\",\"spranga\",\"sprecare\",\"spronato\",\"spruzzo\",\"spuntino\",\"squillo\",\"sradicare\",\"srotolato\",\"stabile\",\"stacco\",\"staffa\",\"stagnare\",\"stampato\",\"stantio\",\"starnuto\",\"stasera\",\"statuto\",\"stelo\",\"steppa\",\"sterzo\",\"stiletto\",\"stima\",\"stirpe\",\"stivale\",\"stizzoso\",\"stonato\",\"storico\",\"strappo\",\"stregato\",\"stridulo\",\"strozzare\",\"strutto\",\"stuccare\",\"stufo\",\"stupendo\",\"subentro\",\"succoso\",\"sudore\",\"suggerito\",\"sugo\",\"sultano\",\"suonare\",\"superbo\",\"supporto\",\"surgelato\",\"surrogato\",\"sussurro\",\"sutura\",\"svagare\",\"svedese\",\"sveglio\",\"svelare\",\"svenuto\",\"svezia\",\"sviluppo\",\"svista\",\"svizzera\",\"svolta\",\"svuotare\",\"tabacco\",\"tabulato\",\"tacciare\",\"taciturno\",\"tale\",\"talismano\",\"tampone\",\"tannino\",\"tara\",\"tardivo\",\"targato\",\"tariffa\",\"tarpare\",\"tartaruga\",\"tasto\",\"tattico\",\"taverna\",\"tavolata\",\"tazza\",\"teca\",\"tecnico\",\"telefono\",\"temerario\",\"tempo\",\"temuto\",\"tendone\",\"tenero\",\"tensione\",\"tentacolo\",\"teorema\",\"terme\",\"terrazzo\",\"terzetto\",\"tesi\",\"tesserato\",\"testato\",\"tetro\",\"tettoia\",\"tifare\",\"tigella\",\"timbro\",\"tinto\",\"tipico\",\"tipografo\",\"tiraggio\",\"tiro\",\"titanio\",\"titolo\",\"titubante\",\"tizio\",\"tizzone\",\"toccare\",\"tollerare\",\"tolto\",\"tombola\",\"tomo\",\"tonfo\",\"tonsilla\",\"topazio\",\"topologia\",\"toppa\",\"torba\",\"tornare\",\"torrone\",\"tortora\",\"toscano\",\"tossire\",\"tostatura\",\"totano\",\"trabocco\",\"trachea\",\"trafila\",\"tragedia\",\"tralcio\",\"tramonto\",\"transito\",\"trapano\",\"trarre\",\"trasloco\",\"trattato\",\"trave\",\"treccia\",\"tremolio\",\"trespolo\",\"tributo\",\"tricheco\",\"trifoglio\",\"trillo\",\"trincea\",\"trio\",\"tristezza\",\"triturato\",\"trivella\",\"tromba\",\"trono\",\"troppo\",\"trottola\",\"trovare\",\"truccato\",\"tubatura\",\"tuffato\",\"tulipano\",\"tumulto\",\"tunisia\",\"turbare\",\"turchino\",\"tuta\",\"tutela\",\"ubicato\",\"uccello\",\"uccisore\",\"udire\",\"uditivo\",\"uffa\",\"ufficio\",\"uguale\",\"ulisse\",\"ultimato\",\"umano\",\"umile\",\"umorismo\",\"uncinetto\",\"ungere\",\"ungherese\",\"unicorno\",\"unificato\",\"unisono\",\"unitario\",\"unte\",\"uovo\",\"upupa\",\"uragano\",\"urgenza\",\"urlo\",\"usanza\",\"usato\",\"uscito\",\"usignolo\",\"usuraio\",\"utensile\",\"utilizzo\",\"utopia\",\"vacante\",\"vaccinato\",\"vagabondo\",\"vagliato\",\"valanga\",\"valgo\",\"valico\",\"valletta\",\"valoroso\",\"valutare\",\"valvola\",\"vampata\",\"vangare\",\"vanitoso\",\"vano\",\"vantaggio\",\"vanvera\",\"vapore\",\"varano\",\"varcato\",\"variante\",\"vasca\",\"vedetta\",\"vedova\",\"veduto\",\"vegetale\",\"veicolo\",\"velcro\",\"velina\",\"velluto\",\"veloce\",\"venato\",\"vendemmia\",\"vento\",\"verace\",\"verbale\",\"vergogna\",\"verifica\",\"vero\",\"verruca\",\"verticale\",\"vescica\",\"vessillo\",\"vestale\",\"veterano\",\"vetrina\",\"vetusto\",\"viandante\",\"vibrante\",\"vicenda\",\"vichingo\",\"vicinanza\",\"vidimare\",\"vigilia\",\"vigneto\",\"vigore\",\"vile\",\"villano\",\"vimini\",\"vincitore\",\"viola\",\"vipera\",\"virgola\",\"virologo\",\"virulento\",\"viscoso\",\"visione\",\"vispo\",\"vissuto\",\"visura\",\"vita\",\"vitello\",\"vittima\",\"vivanda\",\"vivido\",\"viziare\",\"voce\",\"voga\",\"volatile\",\"volere\",\"volpe\",\"voragine\",\"vulcano\",\"zampogna\",\"zanna\",\"zappato\",\"zattera\",\"zavorra\",\"zefiro\",\"zelante\",\"zelo\",\"zenzero\",\"zerbino\",\"zibetto\",\"zinco\",\"zircone\",\"zitto\",\"zolla\",\"zotico\",\"zucchero\",\"zufolo\",\"zulu\",\"zuppa\"]");

/***/ }),

/***/ 598439:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse("[\"あいこくしん\",\"あいさつ\",\"あいだ\",\"あおぞら\",\"あかちゃん\",\"あきる\",\"あけがた\",\"あける\",\"あこがれる\",\"あさい\",\"あさひ\",\"あしあと\",\"あじわう\",\"あずかる\",\"あずき\",\"あそぶ\",\"あたえる\",\"あたためる\",\"あたりまえ\",\"あたる\",\"あつい\",\"あつかう\",\"あっしゅく\",\"あつまり\",\"あつめる\",\"あてな\",\"あてはまる\",\"あひる\",\"あぶら\",\"あぶる\",\"あふれる\",\"あまい\",\"あまど\",\"あまやかす\",\"あまり\",\"あみもの\",\"あめりか\",\"あやまる\",\"あゆむ\",\"あらいぐま\",\"あらし\",\"あらすじ\",\"あらためる\",\"あらゆる\",\"あらわす\",\"ありがとう\",\"あわせる\",\"あわてる\",\"あんい\",\"あんがい\",\"あんこ\",\"あんぜん\",\"あんてい\",\"あんない\",\"あんまり\",\"いいだす\",\"いおん\",\"いがい\",\"いがく\",\"いきおい\",\"いきなり\",\"いきもの\",\"いきる\",\"いくじ\",\"いくぶん\",\"いけばな\",\"いけん\",\"いこう\",\"いこく\",\"いこつ\",\"いさましい\",\"いさん\",\"いしき\",\"いじゅう\",\"いじょう\",\"いじわる\",\"いずみ\",\"いずれ\",\"いせい\",\"いせえび\",\"いせかい\",\"いせき\",\"いぜん\",\"いそうろう\",\"いそがしい\",\"いだい\",\"いだく\",\"いたずら\",\"いたみ\",\"いたりあ\",\"いちおう\",\"いちじ\",\"いちど\",\"いちば\",\"いちぶ\",\"いちりゅう\",\"いつか\",\"いっしゅん\",\"いっせい\",\"いっそう\",\"いったん\",\"いっち\",\"いってい\",\"いっぽう\",\"いてざ\",\"いてん\",\"いどう\",\"いとこ\",\"いない\",\"いなか\",\"いねむり\",\"いのち\",\"いのる\",\"いはつ\",\"いばる\",\"いはん\",\"いびき\",\"いひん\",\"いふく\",\"いへん\",\"いほう\",\"いみん\",\"いもうと\",\"いもたれ\",\"いもり\",\"いやがる\",\"いやす\",\"いよかん\",\"いよく\",\"いらい\",\"いらすと\",\"いりぐち\",\"いりょう\",\"いれい\",\"いれもの\",\"いれる\",\"いろえんぴつ\",\"いわい\",\"いわう\",\"いわかん\",\"いわば\",\"いわゆる\",\"いんげんまめ\",\"いんさつ\",\"いんしょう\",\"いんよう\",\"うえき\",\"うえる\",\"うおざ\",\"うがい\",\"うかぶ\",\"うかべる\",\"うきわ\",\"うくらいな\",\"うくれれ\",\"うけたまわる\",\"うけつけ\",\"うけとる\",\"うけもつ\",\"うける\",\"うごかす\",\"うごく\",\"うこん\",\"うさぎ\",\"うしなう\",\"うしろがみ\",\"うすい\",\"うすぎ\",\"うすぐらい\",\"うすめる\",\"うせつ\",\"うちあわせ\",\"うちがわ\",\"うちき\",\"うちゅう\",\"うっかり\",\"うつくしい\",\"うったえる\",\"うつる\",\"うどん\",\"うなぎ\",\"うなじ\",\"うなずく\",\"うなる\",\"うねる\",\"うのう\",\"うぶげ\",\"うぶごえ\",\"うまれる\",\"うめる\",\"うもう\",\"うやまう\",\"うよく\",\"うらがえす\",\"うらぐち\",\"うらない\",\"うりあげ\",\"うりきれ\",\"うるさい\",\"うれしい\",\"うれゆき\",\"うれる\",\"うろこ\",\"うわき\",\"うわさ\",\"うんこう\",\"うんちん\",\"うんてん\",\"うんどう\",\"えいえん\",\"えいが\",\"えいきょう\",\"えいご\",\"えいせい\",\"えいぶん\",\"えいよう\",\"えいわ\",\"えおり\",\"えがお\",\"えがく\",\"えきたい\",\"えくせる\",\"えしゃく\",\"えすて\",\"えつらん\",\"えのぐ\",\"えほうまき\",\"えほん\",\"えまき\",\"えもじ\",\"えもの\",\"えらい\",\"えらぶ\",\"えりあ\",\"えんえん\",\"えんかい\",\"えんぎ\",\"えんげき\",\"えんしゅう\",\"えんぜつ\",\"えんそく\",\"えんちょう\",\"えんとつ\",\"おいかける\",\"おいこす\",\"おいしい\",\"おいつく\",\"おうえん\",\"おうさま\",\"おうじ\",\"おうせつ\",\"おうたい\",\"おうふく\",\"おうべい\",\"おうよう\",\"おえる\",\"おおい\",\"おおう\",\"おおどおり\",\"おおや\",\"おおよそ\",\"おかえり\",\"おかず\",\"おがむ\",\"おかわり\",\"おぎなう\",\"おきる\",\"おくさま\",\"おくじょう\",\"おくりがな\",\"おくる\",\"おくれる\",\"おこす\",\"おこなう\",\"おこる\",\"おさえる\",\"おさない\",\"おさめる\",\"おしいれ\",\"おしえる\",\"おじぎ\",\"おじさん\",\"おしゃれ\",\"おそらく\",\"おそわる\",\"おたがい\",\"おたく\",\"おだやか\",\"おちつく\",\"おっと\",\"おつり\",\"おでかけ\",\"おとしもの\",\"おとなしい\",\"おどり\",\"おどろかす\",\"おばさん\",\"おまいり\",\"おめでとう\",\"おもいで\",\"おもう\",\"おもたい\",\"おもちゃ\",\"おやつ\",\"おやゆび\",\"およぼす\",\"おらんだ\",\"おろす\",\"おんがく\",\"おんけい\",\"おんしゃ\",\"おんせん\",\"おんだん\",\"おんちゅう\",\"おんどけい\",\"かあつ\",\"かいが\",\"がいき\",\"がいけん\",\"がいこう\",\"かいさつ\",\"かいしゃ\",\"かいすいよく\",\"かいぜん\",\"かいぞうど\",\"かいつう\",\"かいてん\",\"かいとう\",\"かいふく\",\"がいへき\",\"かいほう\",\"かいよう\",\"がいらい\",\"かいわ\",\"かえる\",\"かおり\",\"かかえる\",\"かがく\",\"かがし\",\"かがみ\",\"かくご\",\"かくとく\",\"かざる\",\"がぞう\",\"かたい\",\"かたち\",\"がちょう\",\"がっきゅう\",\"がっこう\",\"がっさん\",\"がっしょう\",\"かなざわし\",\"かのう\",\"がはく\",\"かぶか\",\"かほう\",\"かほご\",\"かまう\",\"かまぼこ\",\"かめれおん\",\"かゆい\",\"かようび\",\"からい\",\"かるい\",\"かろう\",\"かわく\",\"かわら\",\"がんか\",\"かんけい\",\"かんこう\",\"かんしゃ\",\"かんそう\",\"かんたん\",\"かんち\",\"がんばる\",\"きあい\",\"きあつ\",\"きいろ\",\"ぎいん\",\"きうい\",\"きうん\",\"きえる\",\"きおう\",\"きおく\",\"きおち\",\"きおん\",\"きかい\",\"きかく\",\"きかんしゃ\",\"ききて\",\"きくばり\",\"きくらげ\",\"きけんせい\",\"きこう\",\"きこえる\",\"きこく\",\"きさい\",\"きさく\",\"きさま\",\"きさらぎ\",\"ぎじかがく\",\"ぎしき\",\"ぎじたいけん\",\"ぎじにってい\",\"ぎじゅつしゃ\",\"きすう\",\"きせい\",\"きせき\",\"きせつ\",\"きそう\",\"きぞく\",\"きぞん\",\"きたえる\",\"きちょう\",\"きつえん\",\"ぎっちり\",\"きつつき\",\"きつね\",\"きてい\",\"きどう\",\"きどく\",\"きない\",\"きなが\",\"きなこ\",\"きぬごし\",\"きねん\",\"きのう\",\"きのした\",\"きはく\",\"きびしい\",\"きひん\",\"きふく\",\"きぶん\",\"きぼう\",\"きほん\",\"きまる\",\"きみつ\",\"きむずかしい\",\"きめる\",\"きもだめし\",\"きもち\",\"きもの\",\"きゃく\",\"きやく\",\"ぎゅうにく\",\"きよう\",\"きょうりゅう\",\"きらい\",\"きらく\",\"きりん\",\"きれい\",\"きれつ\",\"きろく\",\"ぎろん\",\"きわめる\",\"ぎんいろ\",\"きんかくじ\",\"きんじょ\",\"きんようび\",\"ぐあい\",\"くいず\",\"くうかん\",\"くうき\",\"くうぐん\",\"くうこう\",\"ぐうせい\",\"くうそう\",\"ぐうたら\",\"くうふく\",\"くうぼ\",\"くかん\",\"くきょう\",\"くげん\",\"ぐこう\",\"くさい\",\"くさき\",\"くさばな\",\"くさる\",\"くしゃみ\",\"くしょう\",\"くすのき\",\"くすりゆび\",\"くせげ\",\"くせん\",\"ぐたいてき\",\"くださる\",\"くたびれる\",\"くちこみ\",\"くちさき\",\"くつした\",\"ぐっすり\",\"くつろぐ\",\"くとうてん\",\"くどく\",\"くなん\",\"くねくね\",\"くのう\",\"くふう\",\"くみあわせ\",\"くみたてる\",\"くめる\",\"くやくしょ\",\"くらす\",\"くらべる\",\"くるま\",\"くれる\",\"くろう\",\"くわしい\",\"ぐんかん\",\"ぐんしょく\",\"ぐんたい\",\"ぐんて\",\"けあな\",\"けいかく\",\"けいけん\",\"けいこ\",\"けいさつ\",\"げいじゅつ\",\"けいたい\",\"げいのうじん\",\"けいれき\",\"けいろ\",\"けおとす\",\"けおりもの\",\"げきか\",\"げきげん\",\"げきだん\",\"げきちん\",\"げきとつ\",\"げきは\",\"げきやく\",\"げこう\",\"げこくじょう\",\"げざい\",\"けさき\",\"げざん\",\"けしき\",\"けしごむ\",\"けしょう\",\"げすと\",\"けたば\",\"けちゃっぷ\",\"けちらす\",\"けつあつ\",\"けつい\",\"けつえき\",\"けっこん\",\"けつじょ\",\"けっせき\",\"けってい\",\"けつまつ\",\"げつようび\",\"げつれい\",\"けつろん\",\"げどく\",\"けとばす\",\"けとる\",\"けなげ\",\"けなす\",\"けなみ\",\"けぬき\",\"げねつ\",\"けねん\",\"けはい\",\"げひん\",\"けぶかい\",\"げぼく\",\"けまり\",\"けみかる\",\"けむし\",\"けむり\",\"けもの\",\"けらい\",\"けろけろ\",\"けわしい\",\"けんい\",\"けんえつ\",\"けんお\",\"けんか\",\"げんき\",\"けんげん\",\"けんこう\",\"けんさく\",\"けんしゅう\",\"けんすう\",\"げんそう\",\"けんちく\",\"けんてい\",\"けんとう\",\"けんない\",\"けんにん\",\"げんぶつ\",\"けんま\",\"けんみん\",\"けんめい\",\"けんらん\",\"けんり\",\"こあくま\",\"こいぬ\",\"こいびと\",\"ごうい\",\"こうえん\",\"こうおん\",\"こうかん\",\"ごうきゅう\",\"ごうけい\",\"こうこう\",\"こうさい\",\"こうじ\",\"こうすい\",\"ごうせい\",\"こうそく\",\"こうたい\",\"こうちゃ\",\"こうつう\",\"こうてい\",\"こうどう\",\"こうない\",\"こうはい\",\"ごうほう\",\"ごうまん\",\"こうもく\",\"こうりつ\",\"こえる\",\"こおり\",\"ごかい\",\"ごがつ\",\"ごかん\",\"こくご\",\"こくさい\",\"こくとう\",\"こくない\",\"こくはく\",\"こぐま\",\"こけい\",\"こける\",\"ここのか\",\"こころ\",\"こさめ\",\"こしつ\",\"こすう\",\"こせい\",\"こせき\",\"こぜん\",\"こそだて\",\"こたい\",\"こたえる\",\"こたつ\",\"こちょう\",\"こっか\",\"こつこつ\",\"こつばん\",\"こつぶ\",\"こてい\",\"こてん\",\"ことがら\",\"ことし\",\"ことば\",\"ことり\",\"こなごな\",\"こねこね\",\"このまま\",\"このみ\",\"このよ\",\"ごはん\",\"こひつじ\",\"こふう\",\"こふん\",\"こぼれる\",\"ごまあぶら\",\"こまかい\",\"ごますり\",\"こまつな\",\"こまる\",\"こむぎこ\",\"こもじ\",\"こもち\",\"こもの\",\"こもん\",\"こやく\",\"こやま\",\"こゆう\",\"こゆび\",\"こよい\",\"こよう\",\"こりる\",\"これくしょん\",\"ころっけ\",\"こわもて\",\"こわれる\",\"こんいん\",\"こんかい\",\"こんき\",\"こんしゅう\",\"こんすい\",\"こんだて\",\"こんとん\",\"こんなん\",\"こんびに\",\"こんぽん\",\"こんまけ\",\"こんや\",\"こんれい\",\"こんわく\",\"ざいえき\",\"さいかい\",\"さいきん\",\"ざいげん\",\"ざいこ\",\"さいしょ\",\"さいせい\",\"ざいたく\",\"ざいちゅう\",\"さいてき\",\"ざいりょう\",\"さうな\",\"さかいし\",\"さがす\",\"さかな\",\"さかみち\",\"さがる\",\"さぎょう\",\"さくし\",\"さくひん\",\"さくら\",\"さこく\",\"さこつ\",\"さずかる\",\"ざせき\",\"さたん\",\"さつえい\",\"ざつおん\",\"ざっか\",\"ざつがく\",\"さっきょく\",\"ざっし\",\"さつじん\",\"ざっそう\",\"さつたば\",\"さつまいも\",\"さてい\",\"さといも\",\"さとう\",\"さとおや\",\"さとし\",\"さとる\",\"さのう\",\"さばく\",\"さびしい\",\"さべつ\",\"さほう\",\"さほど\",\"さます\",\"さみしい\",\"さみだれ\",\"さむけ\",\"さめる\",\"さやえんどう\",\"さゆう\",\"さよう\",\"さよく\",\"さらだ\",\"ざるそば\",\"さわやか\",\"さわる\",\"さんいん\",\"さんか\",\"さんきゃく\",\"さんこう\",\"さんさい\",\"ざんしょ\",\"さんすう\",\"さんせい\",\"さんそ\",\"さんち\",\"さんま\",\"さんみ\",\"さんらん\",\"しあい\",\"しあげ\",\"しあさって\",\"しあわせ\",\"しいく\",\"しいん\",\"しうち\",\"しえい\",\"しおけ\",\"しかい\",\"しかく\",\"じかん\",\"しごと\",\"しすう\",\"じだい\",\"したうけ\",\"したぎ\",\"したて\",\"したみ\",\"しちょう\",\"しちりん\",\"しっかり\",\"しつじ\",\"しつもん\",\"してい\",\"してき\",\"してつ\",\"じてん\",\"じどう\",\"しなぎれ\",\"しなもの\",\"しなん\",\"しねま\",\"しねん\",\"しのぐ\",\"しのぶ\",\"しはい\",\"しばかり\",\"しはつ\",\"しはらい\",\"しはん\",\"しひょう\",\"しふく\",\"じぶん\",\"しへい\",\"しほう\",\"しほん\",\"しまう\",\"しまる\",\"しみん\",\"しむける\",\"じむしょ\",\"しめい\",\"しめる\",\"しもん\",\"しゃいん\",\"しゃうん\",\"しゃおん\",\"じゃがいも\",\"しやくしょ\",\"しゃくほう\",\"しゃけん\",\"しゃこ\",\"しゃざい\",\"しゃしん\",\"しゃせん\",\"しゃそう\",\"しゃたい\",\"しゃちょう\",\"しゃっきん\",\"じゃま\",\"しゃりん\",\"しゃれい\",\"じゆう\",\"じゅうしょ\",\"しゅくはく\",\"じゅしん\",\"しゅっせき\",\"しゅみ\",\"しゅらば\",\"じゅんばん\",\"しょうかい\",\"しょくたく\",\"しょっけん\",\"しょどう\",\"しょもつ\",\"しらせる\",\"しらべる\",\"しんか\",\"しんこう\",\"じんじゃ\",\"しんせいじ\",\"しんちく\",\"しんりん\",\"すあげ\",\"すあし\",\"すあな\",\"ずあん\",\"すいえい\",\"すいか\",\"すいとう\",\"ずいぶん\",\"すいようび\",\"すうがく\",\"すうじつ\",\"すうせん\",\"すおどり\",\"すきま\",\"すくう\",\"すくない\",\"すける\",\"すごい\",\"すこし\",\"ずさん\",\"すずしい\",\"すすむ\",\"すすめる\",\"すっかり\",\"ずっしり\",\"ずっと\",\"すてき\",\"すてる\",\"すねる\",\"すのこ\",\"すはだ\",\"すばらしい\",\"ずひょう\",\"ずぶぬれ\",\"すぶり\",\"すふれ\",\"すべて\",\"すべる\",\"ずほう\",\"すぼん\",\"すまい\",\"すめし\",\"すもう\",\"すやき\",\"すらすら\",\"するめ\",\"すれちがう\",\"すろっと\",\"すわる\",\"すんぜん\",\"すんぽう\",\"せあぶら\",\"せいかつ\",\"せいげん\",\"せいじ\",\"せいよう\",\"せおう\",\"せかいかん\",\"せきにん\",\"せきむ\",\"せきゆ\",\"せきらんうん\",\"せけん\",\"せこう\",\"せすじ\",\"せたい\",\"せたけ\",\"せっかく\",\"せっきゃく\",\"ぜっく\",\"せっけん\",\"せっこつ\",\"せっさたくま\",\"せつぞく\",\"せつだん\",\"せつでん\",\"せっぱん\",\"せつび\",\"せつぶん\",\"せつめい\",\"せつりつ\",\"せなか\",\"せのび\",\"せはば\",\"せびろ\",\"せぼね\",\"せまい\",\"せまる\",\"せめる\",\"せもたれ\",\"せりふ\",\"ぜんあく\",\"せんい\",\"せんえい\",\"せんか\",\"せんきょ\",\"せんく\",\"せんげん\",\"ぜんご\",\"せんさい\",\"せんしゅ\",\"せんすい\",\"せんせい\",\"せんぞ\",\"せんたく\",\"せんちょう\",\"せんてい\",\"せんとう\",\"せんぬき\",\"せんねん\",\"せんぱい\",\"ぜんぶ\",\"ぜんぽう\",\"せんむ\",\"せんめんじょ\",\"せんもん\",\"せんやく\",\"せんゆう\",\"せんよう\",\"ぜんら\",\"ぜんりゃく\",\"せんれい\",\"せんろ\",\"そあく\",\"そいとげる\",\"そいね\",\"そうがんきょう\",\"そうき\",\"そうご\",\"そうしん\",\"そうだん\",\"そうなん\",\"そうび\",\"そうめん\",\"そうり\",\"そえもの\",\"そえん\",\"そがい\",\"そげき\",\"そこう\",\"そこそこ\",\"そざい\",\"そしな\",\"そせい\",\"そせん\",\"そそぐ\",\"そだてる\",\"そつう\",\"そつえん\",\"そっかん\",\"そつぎょう\",\"そっけつ\",\"そっこう\",\"そっせん\",\"そっと\",\"そとがわ\",\"そとづら\",\"そなえる\",\"そなた\",\"そふぼ\",\"そぼく\",\"そぼろ\",\"そまつ\",\"そまる\",\"そむく\",\"そむりえ\",\"そめる\",\"そもそも\",\"そよかぜ\",\"そらまめ\",\"そろう\",\"そんかい\",\"そんけい\",\"そんざい\",\"そんしつ\",\"そんぞく\",\"そんちょう\",\"ぞんび\",\"ぞんぶん\",\"そんみん\",\"たあい\",\"たいいん\",\"たいうん\",\"たいえき\",\"たいおう\",\"だいがく\",\"たいき\",\"たいぐう\",\"たいけん\",\"たいこ\",\"たいざい\",\"だいじょうぶ\",\"だいすき\",\"たいせつ\",\"たいそう\",\"だいたい\",\"たいちょう\",\"たいてい\",\"だいどころ\",\"たいない\",\"たいねつ\",\"たいのう\",\"たいはん\",\"だいひょう\",\"たいふう\",\"たいへん\",\"たいほ\",\"たいまつばな\",\"たいみんぐ\",\"たいむ\",\"たいめん\",\"たいやき\",\"たいよう\",\"たいら\",\"たいりょく\",\"たいる\",\"たいわん\",\"たうえ\",\"たえる\",\"たおす\",\"たおる\",\"たおれる\",\"たかい\",\"たかね\",\"たきび\",\"たくさん\",\"たこく\",\"たこやき\",\"たさい\",\"たしざん\",\"だじゃれ\",\"たすける\",\"たずさわる\",\"たそがれ\",\"たたかう\",\"たたく\",\"ただしい\",\"たたみ\",\"たちばな\",\"だっかい\",\"だっきゃく\",\"だっこ\",\"だっしゅつ\",\"だったい\",\"たてる\",\"たとえる\",\"たなばた\",\"たにん\",\"たぬき\",\"たのしみ\",\"たはつ\",\"たぶん\",\"たべる\",\"たぼう\",\"たまご\",\"たまる\",\"だむる\",\"ためいき\",\"ためす\",\"ためる\",\"たもつ\",\"たやすい\",\"たよる\",\"たらす\",\"たりきほんがん\",\"たりょう\",\"たりる\",\"たると\",\"たれる\",\"たれんと\",\"たろっと\",\"たわむれる\",\"だんあつ\",\"たんい\",\"たんおん\",\"たんか\",\"たんき\",\"たんけん\",\"たんご\",\"たんさん\",\"たんじょうび\",\"だんせい\",\"たんそく\",\"たんたい\",\"だんち\",\"たんてい\",\"たんとう\",\"だんな\",\"たんにん\",\"だんねつ\",\"たんのう\",\"たんぴん\",\"だんぼう\",\"たんまつ\",\"たんめい\",\"だんれつ\",\"だんろ\",\"だんわ\",\"ちあい\",\"ちあん\",\"ちいき\",\"ちいさい\",\"ちえん\",\"ちかい\",\"ちから\",\"ちきゅう\",\"ちきん\",\"ちけいず\",\"ちけん\",\"ちこく\",\"ちさい\",\"ちしき\",\"ちしりょう\",\"ちせい\",\"ちそう\",\"ちたい\",\"ちたん\",\"ちちおや\",\"ちつじょ\",\"ちてき\",\"ちてん\",\"ちぬき\",\"ちぬり\",\"ちのう\",\"ちひょう\",\"ちへいせん\",\"ちほう\",\"ちまた\",\"ちみつ\",\"ちみどろ\",\"ちめいど\",\"ちゃんこなべ\",\"ちゅうい\",\"ちゆりょく\",\"ちょうし\",\"ちょさくけん\",\"ちらし\",\"ちらみ\",\"ちりがみ\",\"ちりょう\",\"ちるど\",\"ちわわ\",\"ちんたい\",\"ちんもく\",\"ついか\",\"ついたち\",\"つうか\",\"つうじょう\",\"つうはん\",\"つうわ\",\"つかう\",\"つかれる\",\"つくね\",\"つくる\",\"つけね\",\"つける\",\"つごう\",\"つたえる\",\"つづく\",\"つつじ\",\"つつむ\",\"つとめる\",\"つながる\",\"つなみ\",\"つねづね\",\"つのる\",\"つぶす\",\"つまらない\",\"つまる\",\"つみき\",\"つめたい\",\"つもり\",\"つもる\",\"つよい\",\"つるぼ\",\"つるみく\",\"つわもの\",\"つわり\",\"てあし\",\"てあて\",\"てあみ\",\"ていおん\",\"ていか\",\"ていき\",\"ていけい\",\"ていこく\",\"ていさつ\",\"ていし\",\"ていせい\",\"ていたい\",\"ていど\",\"ていねい\",\"ていひょう\",\"ていへん\",\"ていぼう\",\"てうち\",\"ておくれ\",\"てきとう\",\"てくび\",\"でこぼこ\",\"てさぎょう\",\"てさげ\",\"てすり\",\"てそう\",\"てちがい\",\"てちょう\",\"てつがく\",\"てつづき\",\"でっぱ\",\"てつぼう\",\"てつや\",\"でぬかえ\",\"てぬき\",\"てぬぐい\",\"てのひら\",\"てはい\",\"てぶくろ\",\"てふだ\",\"てほどき\",\"てほん\",\"てまえ\",\"てまきずし\",\"てみじか\",\"てみやげ\",\"てらす\",\"てれび\",\"てわけ\",\"てわたし\",\"でんあつ\",\"てんいん\",\"てんかい\",\"てんき\",\"てんぐ\",\"てんけん\",\"てんごく\",\"てんさい\",\"てんし\",\"てんすう\",\"でんち\",\"てんてき\",\"てんとう\",\"てんない\",\"てんぷら\",\"てんぼうだい\",\"てんめつ\",\"てんらんかい\",\"でんりょく\",\"でんわ\",\"どあい\",\"といれ\",\"どうかん\",\"とうきゅう\",\"どうぐ\",\"とうし\",\"とうむぎ\",\"とおい\",\"とおか\",\"とおく\",\"とおす\",\"とおる\",\"とかい\",\"とかす\",\"ときおり\",\"ときどき\",\"とくい\",\"とくしゅう\",\"とくてん\",\"とくに\",\"とくべつ\",\"とけい\",\"とける\",\"とこや\",\"とさか\",\"としょかん\",\"とそう\",\"とたん\",\"とちゅう\",\"とっきゅう\",\"とっくん\",\"とつぜん\",\"とつにゅう\",\"とどける\",\"ととのえる\",\"とない\",\"となえる\",\"となり\",\"とのさま\",\"とばす\",\"どぶがわ\",\"とほう\",\"とまる\",\"とめる\",\"ともだち\",\"ともる\",\"どようび\",\"とらえる\",\"とんかつ\",\"どんぶり\",\"ないかく\",\"ないこう\",\"ないしょ\",\"ないす\",\"ないせん\",\"ないそう\",\"なおす\",\"ながい\",\"なくす\",\"なげる\",\"なこうど\",\"なさけ\",\"なたでここ\",\"なっとう\",\"なつやすみ\",\"ななおし\",\"なにごと\",\"なにもの\",\"なにわ\",\"なのか\",\"なふだ\",\"なまいき\",\"なまえ\",\"なまみ\",\"なみだ\",\"なめらか\",\"なめる\",\"なやむ\",\"ならう\",\"ならび\",\"ならぶ\",\"なれる\",\"なわとび\",\"なわばり\",\"にあう\",\"にいがた\",\"にうけ\",\"におい\",\"にかい\",\"にがて\",\"にきび\",\"にくしみ\",\"にくまん\",\"にげる\",\"にさんかたんそ\",\"にしき\",\"にせもの\",\"にちじょう\",\"にちようび\",\"にっか\",\"にっき\",\"にっけい\",\"にっこう\",\"にっさん\",\"にっしょく\",\"にっすう\",\"にっせき\",\"にってい\",\"になう\",\"にほん\",\"にまめ\",\"にもつ\",\"にやり\",\"にゅういん\",\"にりんしゃ\",\"にわとり\",\"にんい\",\"にんか\",\"にんき\",\"にんげん\",\"にんしき\",\"にんずう\",\"にんそう\",\"にんたい\",\"にんち\",\"にんてい\",\"にんにく\",\"にんぷ\",\"にんまり\",\"にんむ\",\"にんめい\",\"にんよう\",\"ぬいくぎ\",\"ぬかす\",\"ぬぐいとる\",\"ぬぐう\",\"ぬくもり\",\"ぬすむ\",\"ぬまえび\",\"ぬめり\",\"ぬらす\",\"ぬんちゃく\",\"ねあげ\",\"ねいき\",\"ねいる\",\"ねいろ\",\"ねぐせ\",\"ねくたい\",\"ねくら\",\"ねこぜ\",\"ねこむ\",\"ねさげ\",\"ねすごす\",\"ねそべる\",\"ねだん\",\"ねつい\",\"ねっしん\",\"ねつぞう\",\"ねったいぎょ\",\"ねぶそく\",\"ねふだ\",\"ねぼう\",\"ねほりはほり\",\"ねまき\",\"ねまわし\",\"ねみみ\",\"ねむい\",\"ねむたい\",\"ねもと\",\"ねらう\",\"ねわざ\",\"ねんいり\",\"ねんおし\",\"ねんかん\",\"ねんきん\",\"ねんぐ\",\"ねんざ\",\"ねんし\",\"ねんちゃく\",\"ねんど\",\"ねんぴ\",\"ねんぶつ\",\"ねんまつ\",\"ねんりょう\",\"ねんれい\",\"のいず\",\"のおづま\",\"のがす\",\"のきなみ\",\"のこぎり\",\"のこす\",\"のこる\",\"のせる\",\"のぞく\",\"のぞむ\",\"のたまう\",\"のちほど\",\"のっく\",\"のばす\",\"のはら\",\"のべる\",\"のぼる\",\"のみもの\",\"のやま\",\"のらいぬ\",\"のらねこ\",\"のりもの\",\"のりゆき\",\"のれん\",\"のんき\",\"ばあい\",\"はあく\",\"ばあさん\",\"ばいか\",\"ばいく\",\"はいけん\",\"はいご\",\"はいしん\",\"はいすい\",\"はいせん\",\"はいそう\",\"はいち\",\"ばいばい\",\"はいれつ\",\"はえる\",\"はおる\",\"はかい\",\"ばかり\",\"はかる\",\"はくしゅ\",\"はけん\",\"はこぶ\",\"はさみ\",\"はさん\",\"はしご\",\"ばしょ\",\"はしる\",\"はせる\",\"ぱそこん\",\"はそん\",\"はたん\",\"はちみつ\",\"はつおん\",\"はっかく\",\"はづき\",\"はっきり\",\"はっくつ\",\"はっけん\",\"はっこう\",\"はっさん\",\"はっしん\",\"はったつ\",\"はっちゅう\",\"はってん\",\"はっぴょう\",\"はっぽう\",\"はなす\",\"はなび\",\"はにかむ\",\"はぶらし\",\"はみがき\",\"はむかう\",\"はめつ\",\"はやい\",\"はやし\",\"はらう\",\"はろうぃん\",\"はわい\",\"はんい\",\"はんえい\",\"はんおん\",\"はんかく\",\"はんきょう\",\"ばんぐみ\",\"はんこ\",\"はんしゃ\",\"はんすう\",\"はんだん\",\"ぱんち\",\"ぱんつ\",\"はんてい\",\"はんとし\",\"はんのう\",\"はんぱ\",\"はんぶん\",\"はんぺん\",\"はんぼうき\",\"はんめい\",\"はんらん\",\"はんろん\",\"ひいき\",\"ひうん\",\"ひえる\",\"ひかく\",\"ひかり\",\"ひかる\",\"ひかん\",\"ひくい\",\"ひけつ\",\"ひこうき\",\"ひこく\",\"ひさい\",\"ひさしぶり\",\"ひさん\",\"びじゅつかん\",\"ひしょ\",\"ひそか\",\"ひそむ\",\"ひたむき\",\"ひだり\",\"ひたる\",\"ひつぎ\",\"ひっこし\",\"ひっし\",\"ひつじゅひん\",\"ひっす\",\"ひつぜん\",\"ぴったり\",\"ぴっちり\",\"ひつよう\",\"ひてい\",\"ひとごみ\",\"ひなまつり\",\"ひなん\",\"ひねる\",\"ひはん\",\"ひびく\",\"ひひょう\",\"ひほう\",\"ひまわり\",\"ひまん\",\"ひみつ\",\"ひめい\",\"ひめじし\",\"ひやけ\",\"ひやす\",\"ひよう\",\"びょうき\",\"ひらがな\",\"ひらく\",\"ひりつ\",\"ひりょう\",\"ひるま\",\"ひるやすみ\",\"ひれい\",\"ひろい\",\"ひろう\",\"ひろき\",\"ひろゆき\",\"ひんかく\",\"ひんけつ\",\"ひんこん\",\"ひんしゅ\",\"ひんそう\",\"ぴんち\",\"ひんぱん\",\"びんぼう\",\"ふあん\",\"ふいうち\",\"ふうけい\",\"ふうせん\",\"ぷうたろう\",\"ふうとう\",\"ふうふ\",\"ふえる\",\"ふおん\",\"ふかい\",\"ふきん\",\"ふくざつ\",\"ふくぶくろ\",\"ふこう\",\"ふさい\",\"ふしぎ\",\"ふじみ\",\"ふすま\",\"ふせい\",\"ふせぐ\",\"ふそく\",\"ぶたにく\",\"ふたん\",\"ふちょう\",\"ふつう\",\"ふつか\",\"ふっかつ\",\"ふっき\",\"ふっこく\",\"ぶどう\",\"ふとる\",\"ふとん\",\"ふのう\",\"ふはい\",\"ふひょう\",\"ふへん\",\"ふまん\",\"ふみん\",\"ふめつ\",\"ふめん\",\"ふよう\",\"ふりこ\",\"ふりる\",\"ふるい\",\"ふんいき\",\"ぶんがく\",\"ぶんぐ\",\"ふんしつ\",\"ぶんせき\",\"ふんそう\",\"ぶんぽう\",\"へいあん\",\"へいおん\",\"へいがい\",\"へいき\",\"へいげん\",\"へいこう\",\"へいさ\",\"へいしゃ\",\"へいせつ\",\"へいそ\",\"へいたく\",\"へいてん\",\"へいねつ\",\"へいわ\",\"へきが\",\"へこむ\",\"べにいろ\",\"べにしょうが\",\"へらす\",\"へんかん\",\"べんきょう\",\"べんごし\",\"へんさい\",\"へんたい\",\"べんり\",\"ほあん\",\"ほいく\",\"ぼうぎょ\",\"ほうこく\",\"ほうそう\",\"ほうほう\",\"ほうもん\",\"ほうりつ\",\"ほえる\",\"ほおん\",\"ほかん\",\"ほきょう\",\"ぼきん\",\"ほくろ\",\"ほけつ\",\"ほけん\",\"ほこう\",\"ほこる\",\"ほしい\",\"ほしつ\",\"ほしゅ\",\"ほしょう\",\"ほせい\",\"ほそい\",\"ほそく\",\"ほたて\",\"ほたる\",\"ぽちぶくろ\",\"ほっきょく\",\"ほっさ\",\"ほったん\",\"ほとんど\",\"ほめる\",\"ほんい\",\"ほんき\",\"ほんけ\",\"ほんしつ\",\"ほんやく\",\"まいにち\",\"まかい\",\"まかせる\",\"まがる\",\"まける\",\"まこと\",\"まさつ\",\"まじめ\",\"ますく\",\"まぜる\",\"まつり\",\"まとめ\",\"まなぶ\",\"まぬけ\",\"まねく\",\"まほう\",\"まもる\",\"まゆげ\",\"まよう\",\"まろやか\",\"まわす\",\"まわり\",\"まわる\",\"まんが\",\"まんきつ\",\"まんぞく\",\"まんなか\",\"みいら\",\"みうち\",\"みえる\",\"みがく\",\"みかた\",\"みかん\",\"みけん\",\"みこん\",\"みじかい\",\"みすい\",\"みすえる\",\"みせる\",\"みっか\",\"みつかる\",\"みつける\",\"みてい\",\"みとめる\",\"みなと\",\"みなみかさい\",\"みねらる\",\"みのう\",\"みのがす\",\"みほん\",\"みもと\",\"みやげ\",\"みらい\",\"みりょく\",\"みわく\",\"みんか\",\"みんぞく\",\"むいか\",\"むえき\",\"むえん\",\"むかい\",\"むかう\",\"むかえ\",\"むかし\",\"むぎちゃ\",\"むける\",\"むげん\",\"むさぼる\",\"むしあつい\",\"むしば\",\"むじゅん\",\"むしろ\",\"むすう\",\"むすこ\",\"むすぶ\",\"むすめ\",\"むせる\",\"むせん\",\"むちゅう\",\"むなしい\",\"むのう\",\"むやみ\",\"むよう\",\"むらさき\",\"むりょう\",\"むろん\",\"めいあん\",\"めいうん\",\"めいえん\",\"めいかく\",\"めいきょく\",\"めいさい\",\"めいし\",\"めいそう\",\"めいぶつ\",\"めいれい\",\"めいわく\",\"めぐまれる\",\"めざす\",\"めした\",\"めずらしい\",\"めだつ\",\"めまい\",\"めやす\",\"めんきょ\",\"めんせき\",\"めんどう\",\"もうしあげる\",\"もうどうけん\",\"もえる\",\"もくし\",\"もくてき\",\"もくようび\",\"もちろん\",\"もどる\",\"もらう\",\"もんく\",\"もんだい\",\"やおや\",\"やける\",\"やさい\",\"やさしい\",\"やすい\",\"やすたろう\",\"やすみ\",\"やせる\",\"やそう\",\"やたい\",\"やちん\",\"やっと\",\"やっぱり\",\"やぶる\",\"やめる\",\"ややこしい\",\"やよい\",\"やわらかい\",\"ゆうき\",\"ゆうびんきょく\",\"ゆうべ\",\"ゆうめい\",\"ゆけつ\",\"ゆしゅつ\",\"ゆせん\",\"ゆそう\",\"ゆたか\",\"ゆちゃく\",\"ゆでる\",\"ゆにゅう\",\"ゆびわ\",\"ゆらい\",\"ゆれる\",\"ようい\",\"ようか\",\"ようきゅう\",\"ようじ\",\"ようす\",\"ようちえん\",\"よかぜ\",\"よかん\",\"よきん\",\"よくせい\",\"よくぼう\",\"よけい\",\"よごれる\",\"よさん\",\"よしゅう\",\"よそう\",\"よそく\",\"よっか\",\"よてい\",\"よどがわく\",\"よねつ\",\"よやく\",\"よゆう\",\"よろこぶ\",\"よろしい\",\"らいう\",\"らくがき\",\"らくご\",\"らくさつ\",\"らくだ\",\"らしんばん\",\"らせん\",\"らぞく\",\"らたい\",\"らっか\",\"られつ\",\"りえき\",\"りかい\",\"りきさく\",\"りきせつ\",\"りくぐん\",\"りくつ\",\"りけん\",\"りこう\",\"りせい\",\"りそう\",\"りそく\",\"りてん\",\"りねん\",\"りゆう\",\"りゅうがく\",\"りよう\",\"りょうり\",\"りょかん\",\"りょくちゃ\",\"りょこう\",\"りりく\",\"りれき\",\"りろん\",\"りんご\",\"るいけい\",\"るいさい\",\"るいじ\",\"るいせき\",\"るすばん\",\"るりがわら\",\"れいかん\",\"れいぎ\",\"れいせい\",\"れいぞうこ\",\"れいとう\",\"れいぼう\",\"れきし\",\"れきだい\",\"れんあい\",\"れんけい\",\"れんこん\",\"れんさい\",\"れんしゅう\",\"れんぞく\",\"れんらく\",\"ろうか\",\"ろうご\",\"ろうじん\",\"ろうそく\",\"ろくが\",\"ろこつ\",\"ろじうら\",\"ろしゅつ\",\"ろせん\",\"ろてん\",\"ろめん\",\"ろれつ\",\"ろんぎ\",\"ろんぱ\",\"ろんぶん\",\"ろんり\",\"わかす\",\"わかめ\",\"わかやま\",\"わかれる\",\"わしつ\",\"わじまし\",\"わすれもの\",\"わらう\",\"われる\"]");

/***/ }),

/***/ 77576:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse("[\"가격\",\"가끔\",\"가난\",\"가능\",\"가득\",\"가르침\",\"가뭄\",\"가방\",\"가상\",\"가슴\",\"가운데\",\"가을\",\"가이드\",\"가입\",\"가장\",\"가정\",\"가족\",\"가죽\",\"각오\",\"각자\",\"간격\",\"간부\",\"간섭\",\"간장\",\"간접\",\"간판\",\"갈등\",\"갈비\",\"갈색\",\"갈증\",\"감각\",\"감기\",\"감소\",\"감수성\",\"감자\",\"감정\",\"갑자기\",\"강남\",\"강당\",\"강도\",\"강력히\",\"강변\",\"강북\",\"강사\",\"강수량\",\"강아지\",\"강원도\",\"강의\",\"강제\",\"강조\",\"같이\",\"개구리\",\"개나리\",\"개방\",\"개별\",\"개선\",\"개성\",\"개인\",\"객관적\",\"거실\",\"거액\",\"거울\",\"거짓\",\"거품\",\"걱정\",\"건강\",\"건물\",\"건설\",\"건조\",\"건축\",\"걸음\",\"검사\",\"검토\",\"게시판\",\"게임\",\"겨울\",\"견해\",\"결과\",\"결국\",\"결론\",\"결석\",\"결승\",\"결심\",\"결정\",\"결혼\",\"경계\",\"경고\",\"경기\",\"경력\",\"경복궁\",\"경비\",\"경상도\",\"경영\",\"경우\",\"경쟁\",\"경제\",\"경주\",\"경찰\",\"경치\",\"경향\",\"경험\",\"계곡\",\"계단\",\"계란\",\"계산\",\"계속\",\"계약\",\"계절\",\"계층\",\"계획\",\"고객\",\"고구려\",\"고궁\",\"고급\",\"고등학생\",\"고무신\",\"고민\",\"고양이\",\"고장\",\"고전\",\"고집\",\"고춧가루\",\"고통\",\"고향\",\"곡식\",\"골목\",\"골짜기\",\"골프\",\"공간\",\"공개\",\"공격\",\"공군\",\"공급\",\"공기\",\"공동\",\"공무원\",\"공부\",\"공사\",\"공식\",\"공업\",\"공연\",\"공원\",\"공장\",\"공짜\",\"공책\",\"공통\",\"공포\",\"공항\",\"공휴일\",\"과목\",\"과일\",\"과장\",\"과정\",\"과학\",\"관객\",\"관계\",\"관광\",\"관념\",\"관람\",\"관련\",\"관리\",\"관습\",\"관심\",\"관점\",\"관찰\",\"광경\",\"광고\",\"광장\",\"광주\",\"괴로움\",\"굉장히\",\"교과서\",\"교문\",\"교복\",\"교실\",\"교양\",\"교육\",\"교장\",\"교직\",\"교통\",\"교환\",\"교훈\",\"구경\",\"구름\",\"구멍\",\"구별\",\"구분\",\"구석\",\"구성\",\"구속\",\"구역\",\"구입\",\"구청\",\"구체적\",\"국가\",\"국기\",\"국내\",\"국립\",\"국물\",\"국민\",\"국수\",\"국어\",\"국왕\",\"국적\",\"국제\",\"국회\",\"군대\",\"군사\",\"군인\",\"궁극적\",\"권리\",\"권위\",\"권투\",\"귀국\",\"귀신\",\"규정\",\"규칙\",\"균형\",\"그날\",\"그냥\",\"그늘\",\"그러나\",\"그룹\",\"그릇\",\"그림\",\"그제서야\",\"그토록\",\"극복\",\"극히\",\"근거\",\"근교\",\"근래\",\"근로\",\"근무\",\"근본\",\"근원\",\"근육\",\"근처\",\"글씨\",\"글자\",\"금강산\",\"금고\",\"금년\",\"금메달\",\"금액\",\"금연\",\"금요일\",\"금지\",\"긍정적\",\"기간\",\"기관\",\"기념\",\"기능\",\"기독교\",\"기둥\",\"기록\",\"기름\",\"기법\",\"기본\",\"기분\",\"기쁨\",\"기숙사\",\"기술\",\"기억\",\"기업\",\"기온\",\"기운\",\"기원\",\"기적\",\"기준\",\"기침\",\"기혼\",\"기획\",\"긴급\",\"긴장\",\"길이\",\"김밥\",\"김치\",\"김포공항\",\"깍두기\",\"깜빡\",\"깨달음\",\"깨소금\",\"껍질\",\"꼭대기\",\"꽃잎\",\"나들이\",\"나란히\",\"나머지\",\"나물\",\"나침반\",\"나흘\",\"낙엽\",\"난방\",\"날개\",\"날씨\",\"날짜\",\"남녀\",\"남대문\",\"남매\",\"남산\",\"남자\",\"남편\",\"남학생\",\"낭비\",\"낱말\",\"내년\",\"내용\",\"내일\",\"냄비\",\"냄새\",\"냇물\",\"냉동\",\"냉면\",\"냉방\",\"냉장고\",\"넥타이\",\"넷째\",\"노동\",\"노란색\",\"노력\",\"노인\",\"녹음\",\"녹차\",\"녹화\",\"논리\",\"논문\",\"논쟁\",\"놀이\",\"농구\",\"농담\",\"농민\",\"농부\",\"농업\",\"농장\",\"농촌\",\"높이\",\"눈동자\",\"눈물\",\"눈썹\",\"뉴욕\",\"느낌\",\"늑대\",\"능동적\",\"능력\",\"다방\",\"다양성\",\"다음\",\"다이어트\",\"다행\",\"단계\",\"단골\",\"단독\",\"단맛\",\"단순\",\"단어\",\"단위\",\"단점\",\"단체\",\"단추\",\"단편\",\"단풍\",\"달걀\",\"달러\",\"달력\",\"달리\",\"닭고기\",\"담당\",\"담배\",\"담요\",\"담임\",\"답변\",\"답장\",\"당근\",\"당분간\",\"당연히\",\"당장\",\"대규모\",\"대낮\",\"대단히\",\"대답\",\"대도시\",\"대략\",\"대량\",\"대륙\",\"대문\",\"대부분\",\"대신\",\"대응\",\"대장\",\"대전\",\"대접\",\"대중\",\"대책\",\"대출\",\"대충\",\"대통령\",\"대학\",\"대한민국\",\"대합실\",\"대형\",\"덩어리\",\"데이트\",\"도대체\",\"도덕\",\"도둑\",\"도망\",\"도서관\",\"도심\",\"도움\",\"도입\",\"도자기\",\"도저히\",\"도전\",\"도중\",\"도착\",\"독감\",\"독립\",\"독서\",\"독일\",\"독창적\",\"동화책\",\"뒷모습\",\"뒷산\",\"딸아이\",\"마누라\",\"마늘\",\"마당\",\"마라톤\",\"마련\",\"마무리\",\"마사지\",\"마약\",\"마요네즈\",\"마을\",\"마음\",\"마이크\",\"마중\",\"마지막\",\"마찬가지\",\"마찰\",\"마흔\",\"막걸리\",\"막내\",\"막상\",\"만남\",\"만두\",\"만세\",\"만약\",\"만일\",\"만점\",\"만족\",\"만화\",\"많이\",\"말기\",\"말씀\",\"말투\",\"맘대로\",\"망원경\",\"매년\",\"매달\",\"매력\",\"매번\",\"매스컴\",\"매일\",\"매장\",\"맥주\",\"먹이\",\"먼저\",\"먼지\",\"멀리\",\"메일\",\"며느리\",\"며칠\",\"면담\",\"멸치\",\"명단\",\"명령\",\"명예\",\"명의\",\"명절\",\"명칭\",\"명함\",\"모금\",\"모니터\",\"모델\",\"모든\",\"모범\",\"모습\",\"모양\",\"모임\",\"모조리\",\"모집\",\"모퉁이\",\"목걸이\",\"목록\",\"목사\",\"목소리\",\"목숨\",\"목적\",\"목표\",\"몰래\",\"몸매\",\"몸무게\",\"몸살\",\"몸속\",\"몸짓\",\"몸통\",\"몹시\",\"무관심\",\"무궁화\",\"무더위\",\"무덤\",\"무릎\",\"무슨\",\"무엇\",\"무역\",\"무용\",\"무조건\",\"무지개\",\"무척\",\"문구\",\"문득\",\"문법\",\"문서\",\"문제\",\"문학\",\"문화\",\"물가\",\"물건\",\"물결\",\"물고기\",\"물론\",\"물리학\",\"물음\",\"물질\",\"물체\",\"미국\",\"미디어\",\"미사일\",\"미술\",\"미역\",\"미용실\",\"미움\",\"미인\",\"미팅\",\"미혼\",\"민간\",\"민족\",\"민주\",\"믿음\",\"밀가루\",\"밀리미터\",\"밑바닥\",\"바가지\",\"바구니\",\"바나나\",\"바늘\",\"바닥\",\"바닷가\",\"바람\",\"바이러스\",\"바탕\",\"박물관\",\"박사\",\"박수\",\"반대\",\"반드시\",\"반말\",\"반발\",\"반성\",\"반응\",\"반장\",\"반죽\",\"반지\",\"반찬\",\"받침\",\"발가락\",\"발걸음\",\"발견\",\"발달\",\"발레\",\"발목\",\"발바닥\",\"발생\",\"발음\",\"발자국\",\"발전\",\"발톱\",\"발표\",\"밤하늘\",\"밥그릇\",\"밥맛\",\"밥상\",\"밥솥\",\"방금\",\"방면\",\"방문\",\"방바닥\",\"방법\",\"방송\",\"방식\",\"방안\",\"방울\",\"방지\",\"방학\",\"방해\",\"방향\",\"배경\",\"배꼽\",\"배달\",\"배드민턴\",\"백두산\",\"백색\",\"백성\",\"백인\",\"백제\",\"백화점\",\"버릇\",\"버섯\",\"버튼\",\"번개\",\"번역\",\"번지\",\"번호\",\"벌금\",\"벌레\",\"벌써\",\"범위\",\"범인\",\"범죄\",\"법률\",\"법원\",\"법적\",\"법칙\",\"베이징\",\"벨트\",\"변경\",\"변동\",\"변명\",\"변신\",\"변호사\",\"변화\",\"별도\",\"별명\",\"별일\",\"병실\",\"병아리\",\"병원\",\"보관\",\"보너스\",\"보라색\",\"보람\",\"보름\",\"보상\",\"보안\",\"보자기\",\"보장\",\"보전\",\"보존\",\"보통\",\"보편적\",\"보험\",\"복도\",\"복사\",\"복숭아\",\"복습\",\"볶음\",\"본격적\",\"본래\",\"본부\",\"본사\",\"본성\",\"본인\",\"본질\",\"볼펜\",\"봉사\",\"봉지\",\"봉투\",\"부근\",\"부끄러움\",\"부담\",\"부동산\",\"부문\",\"부분\",\"부산\",\"부상\",\"부엌\",\"부인\",\"부작용\",\"부장\",\"부정\",\"부족\",\"부지런히\",\"부친\",\"부탁\",\"부품\",\"부회장\",\"북부\",\"북한\",\"분노\",\"분량\",\"분리\",\"분명\",\"분석\",\"분야\",\"분위기\",\"분필\",\"분홍색\",\"불고기\",\"불과\",\"불교\",\"불꽃\",\"불만\",\"불법\",\"불빛\",\"불안\",\"불이익\",\"불행\",\"브랜드\",\"비극\",\"비난\",\"비닐\",\"비둘기\",\"비디오\",\"비로소\",\"비만\",\"비명\",\"비밀\",\"비바람\",\"비빔밥\",\"비상\",\"비용\",\"비율\",\"비중\",\"비타민\",\"비판\",\"빌딩\",\"빗물\",\"빗방울\",\"빗줄기\",\"빛깔\",\"빨간색\",\"빨래\",\"빨리\",\"사건\",\"사계절\",\"사나이\",\"사냥\",\"사람\",\"사랑\",\"사립\",\"사모님\",\"사물\",\"사방\",\"사상\",\"사생활\",\"사설\",\"사슴\",\"사실\",\"사업\",\"사용\",\"사월\",\"사장\",\"사전\",\"사진\",\"사촌\",\"사춘기\",\"사탕\",\"사투리\",\"사흘\",\"산길\",\"산부인과\",\"산업\",\"산책\",\"살림\",\"살인\",\"살짝\",\"삼계탕\",\"삼국\",\"삼십\",\"삼월\",\"삼촌\",\"상관\",\"상금\",\"상대\",\"상류\",\"상반기\",\"상상\",\"상식\",\"상업\",\"상인\",\"상자\",\"상점\",\"상처\",\"상추\",\"상태\",\"상표\",\"상품\",\"상황\",\"새벽\",\"색깔\",\"색연필\",\"생각\",\"생명\",\"생물\",\"생방송\",\"생산\",\"생선\",\"생신\",\"생일\",\"생활\",\"서랍\",\"서른\",\"서명\",\"서민\",\"서비스\",\"서양\",\"서울\",\"서적\",\"서점\",\"서쪽\",\"서클\",\"석사\",\"석유\",\"선거\",\"선물\",\"선배\",\"선생\",\"선수\",\"선원\",\"선장\",\"선전\",\"선택\",\"선풍기\",\"설거지\",\"설날\",\"설렁탕\",\"설명\",\"설문\",\"설사\",\"설악산\",\"설치\",\"설탕\",\"섭씨\",\"성공\",\"성당\",\"성명\",\"성별\",\"성인\",\"성장\",\"성적\",\"성질\",\"성함\",\"세금\",\"세미나\",\"세상\",\"세월\",\"세종대왕\",\"세탁\",\"센터\",\"센티미터\",\"셋째\",\"소규모\",\"소극적\",\"소금\",\"소나기\",\"소년\",\"소득\",\"소망\",\"소문\",\"소설\",\"소속\",\"소아과\",\"소용\",\"소원\",\"소음\",\"소중히\",\"소지품\",\"소질\",\"소풍\",\"소형\",\"속담\",\"속도\",\"속옷\",\"손가락\",\"손길\",\"손녀\",\"손님\",\"손등\",\"손목\",\"손뼉\",\"손실\",\"손질\",\"손톱\",\"손해\",\"솔직히\",\"솜씨\",\"송아지\",\"송이\",\"송편\",\"쇠고기\",\"쇼핑\",\"수건\",\"수년\",\"수단\",\"수돗물\",\"수동적\",\"수면\",\"수명\",\"수박\",\"수상\",\"수석\",\"수술\",\"수시로\",\"수업\",\"수염\",\"수영\",\"수입\",\"수준\",\"수집\",\"수출\",\"수컷\",\"수필\",\"수학\",\"수험생\",\"수화기\",\"숙녀\",\"숙소\",\"숙제\",\"순간\",\"순서\",\"순수\",\"순식간\",\"순위\",\"숟가락\",\"술병\",\"술집\",\"숫자\",\"스님\",\"스물\",\"스스로\",\"스승\",\"스웨터\",\"스위치\",\"스케이트\",\"스튜디오\",\"스트레스\",\"스포츠\",\"슬쩍\",\"슬픔\",\"습관\",\"습기\",\"승객\",\"승리\",\"승부\",\"승용차\",\"승진\",\"시각\",\"시간\",\"시골\",\"시금치\",\"시나리오\",\"시댁\",\"시리즈\",\"시멘트\",\"시민\",\"시부모\",\"시선\",\"시설\",\"시스템\",\"시아버지\",\"시어머니\",\"시월\",\"시인\",\"시일\",\"시작\",\"시장\",\"시절\",\"시점\",\"시중\",\"시즌\",\"시집\",\"시청\",\"시합\",\"시험\",\"식구\",\"식기\",\"식당\",\"식량\",\"식료품\",\"식물\",\"식빵\",\"식사\",\"식생활\",\"식초\",\"식탁\",\"식품\",\"신고\",\"신규\",\"신념\",\"신문\",\"신발\",\"신비\",\"신사\",\"신세\",\"신용\",\"신제품\",\"신청\",\"신체\",\"신화\",\"실감\",\"실내\",\"실력\",\"실례\",\"실망\",\"실수\",\"실습\",\"실시\",\"실장\",\"실정\",\"실질적\",\"실천\",\"실체\",\"실컷\",\"실태\",\"실패\",\"실험\",\"실현\",\"심리\",\"심부름\",\"심사\",\"심장\",\"심정\",\"심판\",\"쌍둥이\",\"씨름\",\"씨앗\",\"아가씨\",\"아나운서\",\"아드님\",\"아들\",\"아쉬움\",\"아스팔트\",\"아시아\",\"아울러\",\"아저씨\",\"아줌마\",\"아직\",\"아침\",\"아파트\",\"아프리카\",\"아픔\",\"아홉\",\"아흔\",\"악기\",\"악몽\",\"악수\",\"안개\",\"안경\",\"안과\",\"안내\",\"안녕\",\"안동\",\"안방\",\"안부\",\"안주\",\"알루미늄\",\"알코올\",\"암시\",\"암컷\",\"압력\",\"앞날\",\"앞문\",\"애인\",\"애정\",\"액수\",\"앨범\",\"야간\",\"야단\",\"야옹\",\"약간\",\"약국\",\"약속\",\"약수\",\"약점\",\"약품\",\"약혼녀\",\"양념\",\"양력\",\"양말\",\"양배추\",\"양주\",\"양파\",\"어둠\",\"어려움\",\"어른\",\"어젯밤\",\"어쨌든\",\"어쩌다가\",\"어쩐지\",\"언니\",\"언덕\",\"언론\",\"언어\",\"얼굴\",\"얼른\",\"얼음\",\"얼핏\",\"엄마\",\"업무\",\"업종\",\"업체\",\"엉덩이\",\"엉망\",\"엉터리\",\"엊그제\",\"에너지\",\"에어컨\",\"엔진\",\"여건\",\"여고생\",\"여관\",\"여군\",\"여권\",\"여대생\",\"여덟\",\"여동생\",\"여든\",\"여론\",\"여름\",\"여섯\",\"여성\",\"여왕\",\"여인\",\"여전히\",\"여직원\",\"여학생\",\"여행\",\"역사\",\"역시\",\"역할\",\"연결\",\"연구\",\"연극\",\"연기\",\"연락\",\"연설\",\"연세\",\"연속\",\"연습\",\"연애\",\"연예인\",\"연인\",\"연장\",\"연주\",\"연출\",\"연필\",\"연합\",\"연휴\",\"열기\",\"열매\",\"열쇠\",\"열심히\",\"열정\",\"열차\",\"열흘\",\"염려\",\"엽서\",\"영국\",\"영남\",\"영상\",\"영양\",\"영역\",\"영웅\",\"영원히\",\"영하\",\"영향\",\"영혼\",\"영화\",\"옆구리\",\"옆방\",\"옆집\",\"예감\",\"예금\",\"예방\",\"예산\",\"예상\",\"예선\",\"예술\",\"예습\",\"예식장\",\"예약\",\"예전\",\"예절\",\"예정\",\"예컨대\",\"옛날\",\"오늘\",\"오락\",\"오랫동안\",\"오렌지\",\"오로지\",\"오른발\",\"오븐\",\"오십\",\"오염\",\"오월\",\"오전\",\"오직\",\"오징어\",\"오페라\",\"오피스텔\",\"오히려\",\"옥상\",\"옥수수\",\"온갖\",\"온라인\",\"온몸\",\"온종일\",\"온통\",\"올가을\",\"올림픽\",\"올해\",\"옷차림\",\"와이셔츠\",\"와인\",\"완성\",\"완전\",\"왕비\",\"왕자\",\"왜냐하면\",\"왠지\",\"외갓집\",\"외국\",\"외로움\",\"외삼촌\",\"외출\",\"외침\",\"외할머니\",\"왼발\",\"왼손\",\"왼쪽\",\"요금\",\"요일\",\"요즘\",\"요청\",\"용기\",\"용서\",\"용어\",\"우산\",\"우선\",\"우승\",\"우연히\",\"우정\",\"우체국\",\"우편\",\"운동\",\"운명\",\"운반\",\"운전\",\"운행\",\"울산\",\"울음\",\"움직임\",\"웃어른\",\"웃음\",\"워낙\",\"원고\",\"원래\",\"원서\",\"원숭이\",\"원인\",\"원장\",\"원피스\",\"월급\",\"월드컵\",\"월세\",\"월요일\",\"웨이터\",\"위반\",\"위법\",\"위성\",\"위원\",\"위험\",\"위협\",\"윗사람\",\"유난히\",\"유럽\",\"유명\",\"유물\",\"유산\",\"유적\",\"유치원\",\"유학\",\"유행\",\"유형\",\"육군\",\"육상\",\"육십\",\"육체\",\"은행\",\"음력\",\"음료\",\"음반\",\"음성\",\"음식\",\"음악\",\"음주\",\"의견\",\"의논\",\"의문\",\"의복\",\"의식\",\"의심\",\"의외로\",\"의욕\",\"의원\",\"의학\",\"이것\",\"이곳\",\"이념\",\"이놈\",\"이달\",\"이대로\",\"이동\",\"이렇게\",\"이력서\",\"이론적\",\"이름\",\"이민\",\"이발소\",\"이별\",\"이불\",\"이빨\",\"이상\",\"이성\",\"이슬\",\"이야기\",\"이용\",\"이웃\",\"이월\",\"이윽고\",\"이익\",\"이전\",\"이중\",\"이튿날\",\"이틀\",\"이혼\",\"인간\",\"인격\",\"인공\",\"인구\",\"인근\",\"인기\",\"인도\",\"인류\",\"인물\",\"인생\",\"인쇄\",\"인연\",\"인원\",\"인재\",\"인종\",\"인천\",\"인체\",\"인터넷\",\"인하\",\"인형\",\"일곱\",\"일기\",\"일단\",\"일대\",\"일등\",\"일반\",\"일본\",\"일부\",\"일상\",\"일생\",\"일손\",\"일요일\",\"일월\",\"일정\",\"일종\",\"일주일\",\"일찍\",\"일체\",\"일치\",\"일행\",\"일회용\",\"임금\",\"임무\",\"입대\",\"입력\",\"입맛\",\"입사\",\"입술\",\"입시\",\"입원\",\"입장\",\"입학\",\"자가용\",\"자격\",\"자극\",\"자동\",\"자랑\",\"자부심\",\"자식\",\"자신\",\"자연\",\"자원\",\"자율\",\"자전거\",\"자정\",\"자존심\",\"자판\",\"작가\",\"작년\",\"작성\",\"작업\",\"작용\",\"작은딸\",\"작품\",\"잔디\",\"잔뜩\",\"잔치\",\"잘못\",\"잠깐\",\"잠수함\",\"잠시\",\"잠옷\",\"잠자리\",\"잡지\",\"장관\",\"장군\",\"장기간\",\"장래\",\"장례\",\"장르\",\"장마\",\"장면\",\"장모\",\"장미\",\"장비\",\"장사\",\"장소\",\"장식\",\"장애인\",\"장인\",\"장점\",\"장차\",\"장학금\",\"재능\",\"재빨리\",\"재산\",\"재생\",\"재작년\",\"재정\",\"재채기\",\"재판\",\"재학\",\"재활용\",\"저것\",\"저고리\",\"저곳\",\"저녁\",\"저런\",\"저렇게\",\"저번\",\"저울\",\"저절로\",\"저축\",\"적극\",\"적당히\",\"적성\",\"적용\",\"적응\",\"전개\",\"전공\",\"전기\",\"전달\",\"전라도\",\"전망\",\"전문\",\"전반\",\"전부\",\"전세\",\"전시\",\"전용\",\"전자\",\"전쟁\",\"전주\",\"전철\",\"전체\",\"전통\",\"전혀\",\"전후\",\"절대\",\"절망\",\"절반\",\"절약\",\"절차\",\"점검\",\"점수\",\"점심\",\"점원\",\"점점\",\"점차\",\"접근\",\"접시\",\"접촉\",\"젓가락\",\"정거장\",\"정도\",\"정류장\",\"정리\",\"정말\",\"정면\",\"정문\",\"정반대\",\"정보\",\"정부\",\"정비\",\"정상\",\"정성\",\"정오\",\"정원\",\"정장\",\"정지\",\"정치\",\"정확히\",\"제공\",\"제과점\",\"제대로\",\"제목\",\"제발\",\"제법\",\"제삿날\",\"제안\",\"제일\",\"제작\",\"제주도\",\"제출\",\"제품\",\"제한\",\"조각\",\"조건\",\"조금\",\"조깅\",\"조명\",\"조미료\",\"조상\",\"조선\",\"조용히\",\"조절\",\"조정\",\"조직\",\"존댓말\",\"존재\",\"졸업\",\"졸음\",\"종교\",\"종로\",\"종류\",\"종소리\",\"종업원\",\"종종\",\"종합\",\"좌석\",\"죄인\",\"주관적\",\"주름\",\"주말\",\"주머니\",\"주먹\",\"주문\",\"주민\",\"주방\",\"주변\",\"주식\",\"주인\",\"주일\",\"주장\",\"주전자\",\"주택\",\"준비\",\"줄거리\",\"줄기\",\"줄무늬\",\"중간\",\"중계방송\",\"중국\",\"중년\",\"중단\",\"중독\",\"중반\",\"중부\",\"중세\",\"중소기업\",\"중순\",\"중앙\",\"중요\",\"중학교\",\"즉석\",\"즉시\",\"즐거움\",\"증가\",\"증거\",\"증권\",\"증상\",\"증세\",\"지각\",\"지갑\",\"지경\",\"지극히\",\"지금\",\"지급\",\"지능\",\"지름길\",\"지리산\",\"지방\",\"지붕\",\"지식\",\"지역\",\"지우개\",\"지원\",\"지적\",\"지점\",\"지진\",\"지출\",\"직선\",\"직업\",\"직원\",\"직장\",\"진급\",\"진동\",\"진로\",\"진료\",\"진리\",\"진짜\",\"진찰\",\"진출\",\"진통\",\"진행\",\"질문\",\"질병\",\"질서\",\"짐작\",\"집단\",\"집안\",\"집중\",\"짜증\",\"찌꺼기\",\"차남\",\"차라리\",\"차량\",\"차림\",\"차별\",\"차선\",\"차츰\",\"착각\",\"찬물\",\"찬성\",\"참가\",\"참기름\",\"참새\",\"참석\",\"참여\",\"참외\",\"참조\",\"찻잔\",\"창가\",\"창고\",\"창구\",\"창문\",\"창밖\",\"창작\",\"창조\",\"채널\",\"채점\",\"책가방\",\"책방\",\"책상\",\"책임\",\"챔피언\",\"처벌\",\"처음\",\"천국\",\"천둥\",\"천장\",\"천재\",\"천천히\",\"철도\",\"철저히\",\"철학\",\"첫날\",\"첫째\",\"청년\",\"청바지\",\"청소\",\"청춘\",\"체계\",\"체력\",\"체온\",\"체육\",\"체중\",\"체험\",\"초등학생\",\"초반\",\"초밥\",\"초상화\",\"초순\",\"초여름\",\"초원\",\"초저녁\",\"초점\",\"초청\",\"초콜릿\",\"촛불\",\"총각\",\"총리\",\"총장\",\"촬영\",\"최근\",\"최상\",\"최선\",\"최신\",\"최악\",\"최종\",\"추석\",\"추억\",\"추진\",\"추천\",\"추측\",\"축구\",\"축소\",\"축제\",\"축하\",\"출근\",\"출발\",\"출산\",\"출신\",\"출연\",\"출입\",\"출장\",\"출판\",\"충격\",\"충고\",\"충돌\",\"충분히\",\"충청도\",\"취업\",\"취직\",\"취향\",\"치약\",\"친구\",\"친척\",\"칠십\",\"칠월\",\"칠판\",\"침대\",\"침묵\",\"침실\",\"칫솔\",\"칭찬\",\"카메라\",\"카운터\",\"칼국수\",\"캐릭터\",\"캠퍼스\",\"캠페인\",\"커튼\",\"컨디션\",\"컬러\",\"컴퓨터\",\"코끼리\",\"코미디\",\"콘서트\",\"콜라\",\"콤플렉스\",\"콩나물\",\"쾌감\",\"쿠데타\",\"크림\",\"큰길\",\"큰딸\",\"큰소리\",\"큰아들\",\"큰어머니\",\"큰일\",\"큰절\",\"클래식\",\"클럽\",\"킬로\",\"타입\",\"타자기\",\"탁구\",\"탁자\",\"탄생\",\"태권도\",\"태양\",\"태풍\",\"택시\",\"탤런트\",\"터널\",\"터미널\",\"테니스\",\"테스트\",\"테이블\",\"텔레비전\",\"토론\",\"토마토\",\"토요일\",\"통계\",\"통과\",\"통로\",\"통신\",\"통역\",\"통일\",\"통장\",\"통제\",\"통증\",\"통합\",\"통화\",\"퇴근\",\"퇴원\",\"퇴직금\",\"튀김\",\"트럭\",\"특급\",\"특별\",\"특성\",\"특수\",\"특징\",\"특히\",\"튼튼히\",\"티셔츠\",\"파란색\",\"파일\",\"파출소\",\"판결\",\"판단\",\"판매\",\"판사\",\"팔십\",\"팔월\",\"팝송\",\"패션\",\"팩스\",\"팩시밀리\",\"팬티\",\"퍼센트\",\"페인트\",\"편견\",\"편의\",\"편지\",\"편히\",\"평가\",\"평균\",\"평생\",\"평소\",\"평양\",\"평일\",\"평화\",\"포스터\",\"포인트\",\"포장\",\"포함\",\"표면\",\"표정\",\"표준\",\"표현\",\"품목\",\"품질\",\"풍경\",\"풍속\",\"풍습\",\"프랑스\",\"프린터\",\"플라스틱\",\"피곤\",\"피망\",\"피아노\",\"필름\",\"필수\",\"필요\",\"필자\",\"필통\",\"핑계\",\"하느님\",\"하늘\",\"하드웨어\",\"하룻밤\",\"하반기\",\"하숙집\",\"하순\",\"하여튼\",\"하지만\",\"하천\",\"하품\",\"하필\",\"학과\",\"학교\",\"학급\",\"학기\",\"학년\",\"학력\",\"학번\",\"학부모\",\"학비\",\"학생\",\"학술\",\"학습\",\"학용품\",\"학원\",\"학위\",\"학자\",\"학점\",\"한계\",\"한글\",\"한꺼번에\",\"한낮\",\"한눈\",\"한동안\",\"한때\",\"한라산\",\"한마디\",\"한문\",\"한번\",\"한복\",\"한식\",\"한여름\",\"한쪽\",\"할머니\",\"할아버지\",\"할인\",\"함께\",\"함부로\",\"합격\",\"합리적\",\"항공\",\"항구\",\"항상\",\"항의\",\"해결\",\"해군\",\"해답\",\"해당\",\"해물\",\"해석\",\"해설\",\"해수욕장\",\"해안\",\"핵심\",\"핸드백\",\"햄버거\",\"햇볕\",\"햇살\",\"행동\",\"행복\",\"행사\",\"행운\",\"행위\",\"향기\",\"향상\",\"향수\",\"허락\",\"허용\",\"헬기\",\"현관\",\"현금\",\"현대\",\"현상\",\"현실\",\"현장\",\"현재\",\"현지\",\"혈액\",\"협력\",\"형부\",\"형사\",\"형수\",\"형식\",\"형제\",\"형태\",\"형편\",\"혜택\",\"호기심\",\"호남\",\"호랑이\",\"호박\",\"호텔\",\"호흡\",\"혹시\",\"홀로\",\"홈페이지\",\"홍보\",\"홍수\",\"홍차\",\"화면\",\"화분\",\"화살\",\"화요일\",\"화장\",\"화학\",\"확보\",\"확인\",\"확장\",\"확정\",\"환갑\",\"환경\",\"환영\",\"환율\",\"환자\",\"활기\",\"활동\",\"활발히\",\"활용\",\"활짝\",\"회견\",\"회관\",\"회복\",\"회색\",\"회원\",\"회장\",\"회전\",\"횟수\",\"횡단보도\",\"효율적\",\"후반\",\"후춧가루\",\"훈련\",\"훨씬\",\"휴식\",\"휴일\",\"흉내\",\"흐름\",\"흑백\",\"흑인\",\"흔적\",\"흔히\",\"흥미\",\"흥분\",\"희곡\",\"희망\",\"희생\",\"흰색\",\"힘껏\"]");

/***/ }),

/***/ 594390:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse("[\"ábaco\",\"abdomen\",\"abeja\",\"abierto\",\"abogado\",\"abono\",\"aborto\",\"abrazo\",\"abrir\",\"abuelo\",\"abuso\",\"acabar\",\"academia\",\"acceso\",\"acción\",\"aceite\",\"acelga\",\"acento\",\"aceptar\",\"ácido\",\"aclarar\",\"acné\",\"acoger\",\"acoso\",\"activo\",\"acto\",\"actriz\",\"actuar\",\"acudir\",\"acuerdo\",\"acusar\",\"adicto\",\"admitir\",\"adoptar\",\"adorno\",\"aduana\",\"adulto\",\"aéreo\",\"afectar\",\"afición\",\"afinar\",\"afirmar\",\"ágil\",\"agitar\",\"agonía\",\"agosto\",\"agotar\",\"agregar\",\"agrio\",\"agua\",\"agudo\",\"águila\",\"aguja\",\"ahogo\",\"ahorro\",\"aire\",\"aislar\",\"ajedrez\",\"ajeno\",\"ajuste\",\"alacrán\",\"alambre\",\"alarma\",\"alba\",\"álbum\",\"alcalde\",\"aldea\",\"alegre\",\"alejar\",\"alerta\",\"aleta\",\"alfiler\",\"alga\",\"algodón\",\"aliado\",\"aliento\",\"alivio\",\"alma\",\"almeja\",\"almíbar\",\"altar\",\"alteza\",\"altivo\",\"alto\",\"altura\",\"alumno\",\"alzar\",\"amable\",\"amante\",\"amapola\",\"amargo\",\"amasar\",\"ámbar\",\"ámbito\",\"ameno\",\"amigo\",\"amistad\",\"amor\",\"amparo\",\"amplio\",\"ancho\",\"anciano\",\"ancla\",\"andar\",\"andén\",\"anemia\",\"ángulo\",\"anillo\",\"ánimo\",\"anís\",\"anotar\",\"antena\",\"antiguo\",\"antojo\",\"anual\",\"anular\",\"anuncio\",\"añadir\",\"añejo\",\"año\",\"apagar\",\"aparato\",\"apetito\",\"apio\",\"aplicar\",\"apodo\",\"aporte\",\"apoyo\",\"aprender\",\"aprobar\",\"apuesta\",\"apuro\",\"arado\",\"araña\",\"arar\",\"árbitro\",\"árbol\",\"arbusto\",\"archivo\",\"arco\",\"arder\",\"ardilla\",\"arduo\",\"área\",\"árido\",\"aries\",\"armonía\",\"arnés\",\"aroma\",\"arpa\",\"arpón\",\"arreglo\",\"arroz\",\"arruga\",\"arte\",\"artista\",\"asa\",\"asado\",\"asalto\",\"ascenso\",\"asegurar\",\"aseo\",\"asesor\",\"asiento\",\"asilo\",\"asistir\",\"asno\",\"asombro\",\"áspero\",\"astilla\",\"astro\",\"astuto\",\"asumir\",\"asunto\",\"atajo\",\"ataque\",\"atar\",\"atento\",\"ateo\",\"ático\",\"atleta\",\"átomo\",\"atraer\",\"atroz\",\"atún\",\"audaz\",\"audio\",\"auge\",\"aula\",\"aumento\",\"ausente\",\"autor\",\"aval\",\"avance\",\"avaro\",\"ave\",\"avellana\",\"avena\",\"avestruz\",\"avión\",\"aviso\",\"ayer\",\"ayuda\",\"ayuno\",\"azafrán\",\"azar\",\"azote\",\"azúcar\",\"azufre\",\"azul\",\"baba\",\"babor\",\"bache\",\"bahía\",\"baile\",\"bajar\",\"balanza\",\"balcón\",\"balde\",\"bambú\",\"banco\",\"banda\",\"baño\",\"barba\",\"barco\",\"barniz\",\"barro\",\"báscula\",\"bastón\",\"basura\",\"batalla\",\"batería\",\"batir\",\"batuta\",\"baúl\",\"bazar\",\"bebé\",\"bebida\",\"bello\",\"besar\",\"beso\",\"bestia\",\"bicho\",\"bien\",\"bingo\",\"blanco\",\"bloque\",\"blusa\",\"boa\",\"bobina\",\"bobo\",\"boca\",\"bocina\",\"boda\",\"bodega\",\"boina\",\"bola\",\"bolero\",\"bolsa\",\"bomba\",\"bondad\",\"bonito\",\"bono\",\"bonsái\",\"borde\",\"borrar\",\"bosque\",\"bote\",\"botín\",\"bóveda\",\"bozal\",\"bravo\",\"brazo\",\"brecha\",\"breve\",\"brillo\",\"brinco\",\"brisa\",\"broca\",\"broma\",\"bronce\",\"brote\",\"bruja\",\"brusco\",\"bruto\",\"buceo\",\"bucle\",\"bueno\",\"buey\",\"bufanda\",\"bufón\",\"búho\",\"buitre\",\"bulto\",\"burbuja\",\"burla\",\"burro\",\"buscar\",\"butaca\",\"buzón\",\"caballo\",\"cabeza\",\"cabina\",\"cabra\",\"cacao\",\"cadáver\",\"cadena\",\"caer\",\"café\",\"caída\",\"caimán\",\"caja\",\"cajón\",\"cal\",\"calamar\",\"calcio\",\"caldo\",\"calidad\",\"calle\",\"calma\",\"calor\",\"calvo\",\"cama\",\"cambio\",\"camello\",\"camino\",\"campo\",\"cáncer\",\"candil\",\"canela\",\"canguro\",\"canica\",\"canto\",\"caña\",\"cañón\",\"caoba\",\"caos\",\"capaz\",\"capitán\",\"capote\",\"captar\",\"capucha\",\"cara\",\"carbón\",\"cárcel\",\"careta\",\"carga\",\"cariño\",\"carne\",\"carpeta\",\"carro\",\"carta\",\"casa\",\"casco\",\"casero\",\"caspa\",\"castor\",\"catorce\",\"catre\",\"caudal\",\"causa\",\"cazo\",\"cebolla\",\"ceder\",\"cedro\",\"celda\",\"célebre\",\"celoso\",\"célula\",\"cemento\",\"ceniza\",\"centro\",\"cerca\",\"cerdo\",\"cereza\",\"cero\",\"cerrar\",\"certeza\",\"césped\",\"cetro\",\"chacal\",\"chaleco\",\"champú\",\"chancla\",\"chapa\",\"charla\",\"chico\",\"chiste\",\"chivo\",\"choque\",\"choza\",\"chuleta\",\"chupar\",\"ciclón\",\"ciego\",\"cielo\",\"cien\",\"cierto\",\"cifra\",\"cigarro\",\"cima\",\"cinco\",\"cine\",\"cinta\",\"ciprés\",\"circo\",\"ciruela\",\"cisne\",\"cita\",\"ciudad\",\"clamor\",\"clan\",\"claro\",\"clase\",\"clave\",\"cliente\",\"clima\",\"clínica\",\"cobre\",\"cocción\",\"cochino\",\"cocina\",\"coco\",\"código\",\"codo\",\"cofre\",\"coger\",\"cohete\",\"cojín\",\"cojo\",\"cola\",\"colcha\",\"colegio\",\"colgar\",\"colina\",\"collar\",\"colmo\",\"columna\",\"combate\",\"comer\",\"comida\",\"cómodo\",\"compra\",\"conde\",\"conejo\",\"conga\",\"conocer\",\"consejo\",\"contar\",\"copa\",\"copia\",\"corazón\",\"corbata\",\"corcho\",\"cordón\",\"corona\",\"correr\",\"coser\",\"cosmos\",\"costa\",\"cráneo\",\"cráter\",\"crear\",\"crecer\",\"creído\",\"crema\",\"cría\",\"crimen\",\"cripta\",\"crisis\",\"cromo\",\"crónica\",\"croqueta\",\"crudo\",\"cruz\",\"cuadro\",\"cuarto\",\"cuatro\",\"cubo\",\"cubrir\",\"cuchara\",\"cuello\",\"cuento\",\"cuerda\",\"cuesta\",\"cueva\",\"cuidar\",\"culebra\",\"culpa\",\"culto\",\"cumbre\",\"cumplir\",\"cuna\",\"cuneta\",\"cuota\",\"cupón\",\"cúpula\",\"curar\",\"curioso\",\"curso\",\"curva\",\"cutis\",\"dama\",\"danza\",\"dar\",\"dardo\",\"dátil\",\"deber\",\"débil\",\"década\",\"decir\",\"dedo\",\"defensa\",\"definir\",\"dejar\",\"delfín\",\"delgado\",\"delito\",\"demora\",\"denso\",\"dental\",\"deporte\",\"derecho\",\"derrota\",\"desayuno\",\"deseo\",\"desfile\",\"desnudo\",\"destino\",\"desvío\",\"detalle\",\"detener\",\"deuda\",\"día\",\"diablo\",\"diadema\",\"diamante\",\"diana\",\"diario\",\"dibujo\",\"dictar\",\"diente\",\"dieta\",\"diez\",\"difícil\",\"digno\",\"dilema\",\"diluir\",\"dinero\",\"directo\",\"dirigir\",\"disco\",\"diseño\",\"disfraz\",\"diva\",\"divino\",\"doble\",\"doce\",\"dolor\",\"domingo\",\"don\",\"donar\",\"dorado\",\"dormir\",\"dorso\",\"dos\",\"dosis\",\"dragón\",\"droga\",\"ducha\",\"duda\",\"duelo\",\"dueño\",\"dulce\",\"dúo\",\"duque\",\"durar\",\"dureza\",\"duro\",\"ébano\",\"ebrio\",\"echar\",\"eco\",\"ecuador\",\"edad\",\"edición\",\"edificio\",\"editor\",\"educar\",\"efecto\",\"eficaz\",\"eje\",\"ejemplo\",\"elefante\",\"elegir\",\"elemento\",\"elevar\",\"elipse\",\"élite\",\"elixir\",\"elogio\",\"eludir\",\"embudo\",\"emitir\",\"emoción\",\"empate\",\"empeño\",\"empleo\",\"empresa\",\"enano\",\"encargo\",\"enchufe\",\"encía\",\"enemigo\",\"enero\",\"enfado\",\"enfermo\",\"engaño\",\"enigma\",\"enlace\",\"enorme\",\"enredo\",\"ensayo\",\"enseñar\",\"entero\",\"entrar\",\"envase\",\"envío\",\"época\",\"equipo\",\"erizo\",\"escala\",\"escena\",\"escolar\",\"escribir\",\"escudo\",\"esencia\",\"esfera\",\"esfuerzo\",\"espada\",\"espejo\",\"espía\",\"esposa\",\"espuma\",\"esquí\",\"estar\",\"este\",\"estilo\",\"estufa\",\"etapa\",\"eterno\",\"ética\",\"etnia\",\"evadir\",\"evaluar\",\"evento\",\"evitar\",\"exacto\",\"examen\",\"exceso\",\"excusa\",\"exento\",\"exigir\",\"exilio\",\"existir\",\"éxito\",\"experto\",\"explicar\",\"exponer\",\"extremo\",\"fábrica\",\"fábula\",\"fachada\",\"fácil\",\"factor\",\"faena\",\"faja\",\"falda\",\"fallo\",\"falso\",\"faltar\",\"fama\",\"familia\",\"famoso\",\"faraón\",\"farmacia\",\"farol\",\"farsa\",\"fase\",\"fatiga\",\"fauna\",\"favor\",\"fax\",\"febrero\",\"fecha\",\"feliz\",\"feo\",\"feria\",\"feroz\",\"fértil\",\"fervor\",\"festín\",\"fiable\",\"fianza\",\"fiar\",\"fibra\",\"ficción\",\"ficha\",\"fideo\",\"fiebre\",\"fiel\",\"fiera\",\"fiesta\",\"figura\",\"fijar\",\"fijo\",\"fila\",\"filete\",\"filial\",\"filtro\",\"fin\",\"finca\",\"fingir\",\"finito\",\"firma\",\"flaco\",\"flauta\",\"flecha\",\"flor\",\"flota\",\"fluir\",\"flujo\",\"flúor\",\"fobia\",\"foca\",\"fogata\",\"fogón\",\"folio\",\"folleto\",\"fondo\",\"forma\",\"forro\",\"fortuna\",\"forzar\",\"fosa\",\"foto\",\"fracaso\",\"frágil\",\"franja\",\"frase\",\"fraude\",\"freír\",\"freno\",\"fresa\",\"frío\",\"frito\",\"fruta\",\"fuego\",\"fuente\",\"fuerza\",\"fuga\",\"fumar\",\"función\",\"funda\",\"furgón\",\"furia\",\"fusil\",\"fútbol\",\"futuro\",\"gacela\",\"gafas\",\"gaita\",\"gajo\",\"gala\",\"galería\",\"gallo\",\"gamba\",\"ganar\",\"gancho\",\"ganga\",\"ganso\",\"garaje\",\"garza\",\"gasolina\",\"gastar\",\"gato\",\"gavilán\",\"gemelo\",\"gemir\",\"gen\",\"género\",\"genio\",\"gente\",\"geranio\",\"gerente\",\"germen\",\"gesto\",\"gigante\",\"gimnasio\",\"girar\",\"giro\",\"glaciar\",\"globo\",\"gloria\",\"gol\",\"golfo\",\"goloso\",\"golpe\",\"goma\",\"gordo\",\"gorila\",\"gorra\",\"gota\",\"goteo\",\"gozar\",\"grada\",\"gráfico\",\"grano\",\"grasa\",\"gratis\",\"grave\",\"grieta\",\"grillo\",\"gripe\",\"gris\",\"grito\",\"grosor\",\"grúa\",\"grueso\",\"grumo\",\"grupo\",\"guante\",\"guapo\",\"guardia\",\"guerra\",\"guía\",\"guiño\",\"guion\",\"guiso\",\"guitarra\",\"gusano\",\"gustar\",\"haber\",\"hábil\",\"hablar\",\"hacer\",\"hacha\",\"hada\",\"hallar\",\"hamaca\",\"harina\",\"haz\",\"hazaña\",\"hebilla\",\"hebra\",\"hecho\",\"helado\",\"helio\",\"hembra\",\"herir\",\"hermano\",\"héroe\",\"hervir\",\"hielo\",\"hierro\",\"hígado\",\"higiene\",\"hijo\",\"himno\",\"historia\",\"hocico\",\"hogar\",\"hoguera\",\"hoja\",\"hombre\",\"hongo\",\"honor\",\"honra\",\"hora\",\"hormiga\",\"horno\",\"hostil\",\"hoyo\",\"hueco\",\"huelga\",\"huerta\",\"hueso\",\"huevo\",\"huida\",\"huir\",\"humano\",\"húmedo\",\"humilde\",\"humo\",\"hundir\",\"huracán\",\"hurto\",\"icono\",\"ideal\",\"idioma\",\"ídolo\",\"iglesia\",\"iglú\",\"igual\",\"ilegal\",\"ilusión\",\"imagen\",\"imán\",\"imitar\",\"impar\",\"imperio\",\"imponer\",\"impulso\",\"incapaz\",\"índice\",\"inerte\",\"infiel\",\"informe\",\"ingenio\",\"inicio\",\"inmenso\",\"inmune\",\"innato\",\"insecto\",\"instante\",\"interés\",\"íntimo\",\"intuir\",\"inútil\",\"invierno\",\"ira\",\"iris\",\"ironía\",\"isla\",\"islote\",\"jabalí\",\"jabón\",\"jamón\",\"jarabe\",\"jardín\",\"jarra\",\"jaula\",\"jazmín\",\"jefe\",\"jeringa\",\"jinete\",\"jornada\",\"joroba\",\"joven\",\"joya\",\"juerga\",\"jueves\",\"juez\",\"jugador\",\"jugo\",\"juguete\",\"juicio\",\"junco\",\"jungla\",\"junio\",\"juntar\",\"júpiter\",\"jurar\",\"justo\",\"juvenil\",\"juzgar\",\"kilo\",\"koala\",\"labio\",\"lacio\",\"lacra\",\"lado\",\"ladrón\",\"lagarto\",\"lágrima\",\"laguna\",\"laico\",\"lamer\",\"lámina\",\"lámpara\",\"lana\",\"lancha\",\"langosta\",\"lanza\",\"lápiz\",\"largo\",\"larva\",\"lástima\",\"lata\",\"látex\",\"latir\",\"laurel\",\"lavar\",\"lazo\",\"leal\",\"lección\",\"leche\",\"lector\",\"leer\",\"legión\",\"legumbre\",\"lejano\",\"lengua\",\"lento\",\"leña\",\"león\",\"leopardo\",\"lesión\",\"letal\",\"letra\",\"leve\",\"leyenda\",\"libertad\",\"libro\",\"licor\",\"líder\",\"lidiar\",\"lienzo\",\"liga\",\"ligero\",\"lima\",\"límite\",\"limón\",\"limpio\",\"lince\",\"lindo\",\"línea\",\"lingote\",\"lino\",\"linterna\",\"líquido\",\"liso\",\"lista\",\"litera\",\"litio\",\"litro\",\"llaga\",\"llama\",\"llanto\",\"llave\",\"llegar\",\"llenar\",\"llevar\",\"llorar\",\"llover\",\"lluvia\",\"lobo\",\"loción\",\"loco\",\"locura\",\"lógica\",\"logro\",\"lombriz\",\"lomo\",\"lonja\",\"lote\",\"lucha\",\"lucir\",\"lugar\",\"lujo\",\"luna\",\"lunes\",\"lupa\",\"lustro\",\"luto\",\"luz\",\"maceta\",\"macho\",\"madera\",\"madre\",\"maduro\",\"maestro\",\"mafia\",\"magia\",\"mago\",\"maíz\",\"maldad\",\"maleta\",\"malla\",\"malo\",\"mamá\",\"mambo\",\"mamut\",\"manco\",\"mando\",\"manejar\",\"manga\",\"maniquí\",\"manjar\",\"mano\",\"manso\",\"manta\",\"mañana\",\"mapa\",\"máquina\",\"mar\",\"marco\",\"marea\",\"marfil\",\"margen\",\"marido\",\"mármol\",\"marrón\",\"martes\",\"marzo\",\"masa\",\"máscara\",\"masivo\",\"matar\",\"materia\",\"matiz\",\"matriz\",\"máximo\",\"mayor\",\"mazorca\",\"mecha\",\"medalla\",\"medio\",\"médula\",\"mejilla\",\"mejor\",\"melena\",\"melón\",\"memoria\",\"menor\",\"mensaje\",\"mente\",\"menú\",\"mercado\",\"merengue\",\"mérito\",\"mes\",\"mesón\",\"meta\",\"meter\",\"método\",\"metro\",\"mezcla\",\"miedo\",\"miel\",\"miembro\",\"miga\",\"mil\",\"milagro\",\"militar\",\"millón\",\"mimo\",\"mina\",\"minero\",\"mínimo\",\"minuto\",\"miope\",\"mirar\",\"misa\",\"miseria\",\"misil\",\"mismo\",\"mitad\",\"mito\",\"mochila\",\"moción\",\"moda\",\"modelo\",\"moho\",\"mojar\",\"molde\",\"moler\",\"molino\",\"momento\",\"momia\",\"monarca\",\"moneda\",\"monja\",\"monto\",\"moño\",\"morada\",\"morder\",\"moreno\",\"morir\",\"morro\",\"morsa\",\"mortal\",\"mosca\",\"mostrar\",\"motivo\",\"mover\",\"móvil\",\"mozo\",\"mucho\",\"mudar\",\"mueble\",\"muela\",\"muerte\",\"muestra\",\"mugre\",\"mujer\",\"mula\",\"muleta\",\"multa\",\"mundo\",\"muñeca\",\"mural\",\"muro\",\"músculo\",\"museo\",\"musgo\",\"música\",\"muslo\",\"nácar\",\"nación\",\"nadar\",\"naipe\",\"naranja\",\"nariz\",\"narrar\",\"nasal\",\"natal\",\"nativo\",\"natural\",\"náusea\",\"naval\",\"nave\",\"navidad\",\"necio\",\"néctar\",\"negar\",\"negocio\",\"negro\",\"neón\",\"nervio\",\"neto\",\"neutro\",\"nevar\",\"nevera\",\"nicho\",\"nido\",\"niebla\",\"nieto\",\"niñez\",\"niño\",\"nítido\",\"nivel\",\"nobleza\",\"noche\",\"nómina\",\"noria\",\"norma\",\"norte\",\"nota\",\"noticia\",\"novato\",\"novela\",\"novio\",\"nube\",\"nuca\",\"núcleo\",\"nudillo\",\"nudo\",\"nuera\",\"nueve\",\"nuez\",\"nulo\",\"número\",\"nutria\",\"oasis\",\"obeso\",\"obispo\",\"objeto\",\"obra\",\"obrero\",\"observar\",\"obtener\",\"obvio\",\"oca\",\"ocaso\",\"océano\",\"ochenta\",\"ocho\",\"ocio\",\"ocre\",\"octavo\",\"octubre\",\"oculto\",\"ocupar\",\"ocurrir\",\"odiar\",\"odio\",\"odisea\",\"oeste\",\"ofensa\",\"oferta\",\"oficio\",\"ofrecer\",\"ogro\",\"oído\",\"oír\",\"ojo\",\"ola\",\"oleada\",\"olfato\",\"olivo\",\"olla\",\"olmo\",\"olor\",\"olvido\",\"ombligo\",\"onda\",\"onza\",\"opaco\",\"opción\",\"ópera\",\"opinar\",\"oponer\",\"optar\",\"óptica\",\"opuesto\",\"oración\",\"orador\",\"oral\",\"órbita\",\"orca\",\"orden\",\"oreja\",\"órgano\",\"orgía\",\"orgullo\",\"oriente\",\"origen\",\"orilla\",\"oro\",\"orquesta\",\"oruga\",\"osadía\",\"oscuro\",\"osezno\",\"oso\",\"ostra\",\"otoño\",\"otro\",\"oveja\",\"óvulo\",\"óxido\",\"oxígeno\",\"oyente\",\"ozono\",\"pacto\",\"padre\",\"paella\",\"página\",\"pago\",\"país\",\"pájaro\",\"palabra\",\"palco\",\"paleta\",\"pálido\",\"palma\",\"paloma\",\"palpar\",\"pan\",\"panal\",\"pánico\",\"pantera\",\"pañuelo\",\"papá\",\"papel\",\"papilla\",\"paquete\",\"parar\",\"parcela\",\"pared\",\"parir\",\"paro\",\"párpado\",\"parque\",\"párrafo\",\"parte\",\"pasar\",\"paseo\",\"pasión\",\"paso\",\"pasta\",\"pata\",\"patio\",\"patria\",\"pausa\",\"pauta\",\"pavo\",\"payaso\",\"peatón\",\"pecado\",\"pecera\",\"pecho\",\"pedal\",\"pedir\",\"pegar\",\"peine\",\"pelar\",\"peldaño\",\"pelea\",\"peligro\",\"pellejo\",\"pelo\",\"peluca\",\"pena\",\"pensar\",\"peñón\",\"peón\",\"peor\",\"pepino\",\"pequeño\",\"pera\",\"percha\",\"perder\",\"pereza\",\"perfil\",\"perico\",\"perla\",\"permiso\",\"perro\",\"persona\",\"pesa\",\"pesca\",\"pésimo\",\"pestaña\",\"pétalo\",\"petróleo\",\"pez\",\"pezuña\",\"picar\",\"pichón\",\"pie\",\"piedra\",\"pierna\",\"pieza\",\"pijama\",\"pilar\",\"piloto\",\"pimienta\",\"pino\",\"pintor\",\"pinza\",\"piña\",\"piojo\",\"pipa\",\"pirata\",\"pisar\",\"piscina\",\"piso\",\"pista\",\"pitón\",\"pizca\",\"placa\",\"plan\",\"plata\",\"playa\",\"plaza\",\"pleito\",\"pleno\",\"plomo\",\"pluma\",\"plural\",\"pobre\",\"poco\",\"poder\",\"podio\",\"poema\",\"poesía\",\"poeta\",\"polen\",\"policía\",\"pollo\",\"polvo\",\"pomada\",\"pomelo\",\"pomo\",\"pompa\",\"poner\",\"porción\",\"portal\",\"posada\",\"poseer\",\"posible\",\"poste\",\"potencia\",\"potro\",\"pozo\",\"prado\",\"precoz\",\"pregunta\",\"premio\",\"prensa\",\"preso\",\"previo\",\"primo\",\"príncipe\",\"prisión\",\"privar\",\"proa\",\"probar\",\"proceso\",\"producto\",\"proeza\",\"profesor\",\"programa\",\"prole\",\"promesa\",\"pronto\",\"propio\",\"próximo\",\"prueba\",\"público\",\"puchero\",\"pudor\",\"pueblo\",\"puerta\",\"puesto\",\"pulga\",\"pulir\",\"pulmón\",\"pulpo\",\"pulso\",\"puma\",\"punto\",\"puñal\",\"puño\",\"pupa\",\"pupila\",\"puré\",\"quedar\",\"queja\",\"quemar\",\"querer\",\"queso\",\"quieto\",\"química\",\"quince\",\"quitar\",\"rábano\",\"rabia\",\"rabo\",\"ración\",\"radical\",\"raíz\",\"rama\",\"rampa\",\"rancho\",\"rango\",\"rapaz\",\"rápido\",\"rapto\",\"rasgo\",\"raspa\",\"rato\",\"rayo\",\"raza\",\"razón\",\"reacción\",\"realidad\",\"rebaño\",\"rebote\",\"recaer\",\"receta\",\"rechazo\",\"recoger\",\"recreo\",\"recto\",\"recurso\",\"red\",\"redondo\",\"reducir\",\"reflejo\",\"reforma\",\"refrán\",\"refugio\",\"regalo\",\"regir\",\"regla\",\"regreso\",\"rehén\",\"reino\",\"reír\",\"reja\",\"relato\",\"relevo\",\"relieve\",\"relleno\",\"reloj\",\"remar\",\"remedio\",\"remo\",\"rencor\",\"rendir\",\"renta\",\"reparto\",\"repetir\",\"reposo\",\"reptil\",\"res\",\"rescate\",\"resina\",\"respeto\",\"resto\",\"resumen\",\"retiro\",\"retorno\",\"retrato\",\"reunir\",\"revés\",\"revista\",\"rey\",\"rezar\",\"rico\",\"riego\",\"rienda\",\"riesgo\",\"rifa\",\"rígido\",\"rigor\",\"rincón\",\"riñón\",\"río\",\"riqueza\",\"risa\",\"ritmo\",\"rito\",\"rizo\",\"roble\",\"roce\",\"rociar\",\"rodar\",\"rodeo\",\"rodilla\",\"roer\",\"rojizo\",\"rojo\",\"romero\",\"romper\",\"ron\",\"ronco\",\"ronda\",\"ropa\",\"ropero\",\"rosa\",\"rosca\",\"rostro\",\"rotar\",\"rubí\",\"rubor\",\"rudo\",\"rueda\",\"rugir\",\"ruido\",\"ruina\",\"ruleta\",\"rulo\",\"rumbo\",\"rumor\",\"ruptura\",\"ruta\",\"rutina\",\"sábado\",\"saber\",\"sabio\",\"sable\",\"sacar\",\"sagaz\",\"sagrado\",\"sala\",\"saldo\",\"salero\",\"salir\",\"salmón\",\"salón\",\"salsa\",\"salto\",\"salud\",\"salvar\",\"samba\",\"sanción\",\"sandía\",\"sanear\",\"sangre\",\"sanidad\",\"sano\",\"santo\",\"sapo\",\"saque\",\"sardina\",\"sartén\",\"sastre\",\"satán\",\"sauna\",\"saxofón\",\"sección\",\"seco\",\"secreto\",\"secta\",\"sed\",\"seguir\",\"seis\",\"sello\",\"selva\",\"semana\",\"semilla\",\"senda\",\"sensor\",\"señal\",\"señor\",\"separar\",\"sepia\",\"sequía\",\"ser\",\"serie\",\"sermón\",\"servir\",\"sesenta\",\"sesión\",\"seta\",\"setenta\",\"severo\",\"sexo\",\"sexto\",\"sidra\",\"siesta\",\"siete\",\"siglo\",\"signo\",\"sílaba\",\"silbar\",\"silencio\",\"silla\",\"símbolo\",\"simio\",\"sirena\",\"sistema\",\"sitio\",\"situar\",\"sobre\",\"socio\",\"sodio\",\"sol\",\"solapa\",\"soldado\",\"soledad\",\"sólido\",\"soltar\",\"solución\",\"sombra\",\"sondeo\",\"sonido\",\"sonoro\",\"sonrisa\",\"sopa\",\"soplar\",\"soporte\",\"sordo\",\"sorpresa\",\"sorteo\",\"sostén\",\"sótano\",\"suave\",\"subir\",\"suceso\",\"sudor\",\"suegra\",\"suelo\",\"sueño\",\"suerte\",\"sufrir\",\"sujeto\",\"sultán\",\"sumar\",\"superar\",\"suplir\",\"suponer\",\"supremo\",\"sur\",\"surco\",\"sureño\",\"surgir\",\"susto\",\"sutil\",\"tabaco\",\"tabique\",\"tabla\",\"tabú\",\"taco\",\"tacto\",\"tajo\",\"talar\",\"talco\",\"talento\",\"talla\",\"talón\",\"tamaño\",\"tambor\",\"tango\",\"tanque\",\"tapa\",\"tapete\",\"tapia\",\"tapón\",\"taquilla\",\"tarde\",\"tarea\",\"tarifa\",\"tarjeta\",\"tarot\",\"tarro\",\"tarta\",\"tatuaje\",\"tauro\",\"taza\",\"tazón\",\"teatro\",\"techo\",\"tecla\",\"técnica\",\"tejado\",\"tejer\",\"tejido\",\"tela\",\"teléfono\",\"tema\",\"temor\",\"templo\",\"tenaz\",\"tender\",\"tener\",\"tenis\",\"tenso\",\"teoría\",\"terapia\",\"terco\",\"término\",\"ternura\",\"terror\",\"tesis\",\"tesoro\",\"testigo\",\"tetera\",\"texto\",\"tez\",\"tibio\",\"tiburón\",\"tiempo\",\"tienda\",\"tierra\",\"tieso\",\"tigre\",\"tijera\",\"tilde\",\"timbre\",\"tímido\",\"timo\",\"tinta\",\"tío\",\"típico\",\"tipo\",\"tira\",\"tirón\",\"titán\",\"títere\",\"título\",\"tiza\",\"toalla\",\"tobillo\",\"tocar\",\"tocino\",\"todo\",\"toga\",\"toldo\",\"tomar\",\"tono\",\"tonto\",\"topar\",\"tope\",\"toque\",\"tórax\",\"torero\",\"tormenta\",\"torneo\",\"toro\",\"torpedo\",\"torre\",\"torso\",\"tortuga\",\"tos\",\"tosco\",\"toser\",\"tóxico\",\"trabajo\",\"tractor\",\"traer\",\"tráfico\",\"trago\",\"traje\",\"tramo\",\"trance\",\"trato\",\"trauma\",\"trazar\",\"trébol\",\"tregua\",\"treinta\",\"tren\",\"trepar\",\"tres\",\"tribu\",\"trigo\",\"tripa\",\"triste\",\"triunfo\",\"trofeo\",\"trompa\",\"tronco\",\"tropa\",\"trote\",\"trozo\",\"truco\",\"trueno\",\"trufa\",\"tubería\",\"tubo\",\"tuerto\",\"tumba\",\"tumor\",\"túnel\",\"túnica\",\"turbina\",\"turismo\",\"turno\",\"tutor\",\"ubicar\",\"úlcera\",\"umbral\",\"unidad\",\"unir\",\"universo\",\"uno\",\"untar\",\"uña\",\"urbano\",\"urbe\",\"urgente\",\"urna\",\"usar\",\"usuario\",\"útil\",\"utopía\",\"uva\",\"vaca\",\"vacío\",\"vacuna\",\"vagar\",\"vago\",\"vaina\",\"vajilla\",\"vale\",\"válido\",\"valle\",\"valor\",\"válvula\",\"vampiro\",\"vara\",\"variar\",\"varón\",\"vaso\",\"vecino\",\"vector\",\"vehículo\",\"veinte\",\"vejez\",\"vela\",\"velero\",\"veloz\",\"vena\",\"vencer\",\"venda\",\"veneno\",\"vengar\",\"venir\",\"venta\",\"venus\",\"ver\",\"verano\",\"verbo\",\"verde\",\"vereda\",\"verja\",\"verso\",\"verter\",\"vía\",\"viaje\",\"vibrar\",\"vicio\",\"víctima\",\"vida\",\"vídeo\",\"vidrio\",\"viejo\",\"viernes\",\"vigor\",\"vil\",\"villa\",\"vinagre\",\"vino\",\"viñedo\",\"violín\",\"viral\",\"virgo\",\"virtud\",\"visor\",\"víspera\",\"vista\",\"vitamina\",\"viudo\",\"vivaz\",\"vivero\",\"vivir\",\"vivo\",\"volcán\",\"volumen\",\"volver\",\"voraz\",\"votar\",\"voto\",\"voz\",\"vuelo\",\"vulgar\",\"yacer\",\"yate\",\"yegua\",\"yema\",\"yerno\",\"yeso\",\"yodo\",\"yoga\",\"yogur\",\"zafiro\",\"zanja\",\"zapato\",\"zarza\",\"zona\",\"zorro\",\"zumo\",\"zurdo\"]");

/***/ })

};
;
//# sourceMappingURL=708.bundled.js.map