(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("reselect-tree", [], factory);
	else if(typeof exports === 'object')
		exports["reselect-tree"] = factory();
	else
		root["reselect-tree"] = factory();
})(typeof self !== 'undefined' ? self : this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 9);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = require("debug");

/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = require("source-map-support/register");

/***/ }),
/* 2 */
/***/ (function(module, exports) {

module.exports = require("assert");

/***/ }),
/* 3 */,
/* 4 */,
/* 5 */,
/* 6 */,
/* 7 */,
/* 8 */,
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


const debug = __webpack_require__(0)("reselect-tree:esdoc-plugin");
const assert = __webpack_require__(2);
const path = __webpack_require__(10);
const fs = __webpack_require__(11);
const DocFactory = __webpack_require__(12);

__webpack_require__(1);

// hack
const ESParser = __webpack_require__(22).default;
const InvalidCodeLogger = __webpack_require__(23).default;
const PathResolver = __webpack_require__(24).default;
const ASTUtil = __webpack_require__(25).default;

class Plugin {
  onHandleDocs(ev) {
    this._docs = ev.data.docs;
    this._option = ev.data.option;

    this._exec();
  }

  _exec() {
    this._setDefault();

    const docs = this._generateDocs();
    this._docs.push(...docs);
  }

  _setDefault() {
    if (!this._option) return;

    const option = this._option;
    assert(option.source);
    if (!option.interfaces) option.interfaces = ['createSelectorTree', 'createLeaf', '<arrow>', '<function>', '<subtree>'];
    if (!option.includes) option.includes = ['selectors/.*\\.js$', 'selectors.js$'];
    if (!option.excludes) option.excludes = ['\\.config\\.js$'];
  }

  /**
   * Generate document from selector code.
   */
  _generateDocs() {
    const option = this._option;
    const results = [];

    if (!option) return results;

    const includes = option.includes.map(v => new RegExp(v));
    const excludes = option.excludes.map(v => new RegExp(v));
    const sourceDirPath = path.resolve(option.source);

    this._walk(option.source, filePath => {
      const relativeFilePath = path.relative(sourceDirPath, filePath);
      let match = false;
      for (const reg of includes) {
        if (relativeFilePath.match(reg)) {
          match = true;
          break;
        }
      }
      if (!match) return;

      for (const reg of excludes) {
        if (relativeFilePath.match(reg)) return;
      }

      console.log(`parse: ${filePath}`);
      const temp = this._traverse(option.interfaces, option.source, filePath);
      if (!temp) return;
      results.push(...temp.results);
    });

    return results;
  }

  /**
   * walk recursive in directory.
   * @param {string} dirPath - target directory path.
   * @param {function(entryPath: string)} callback - callback for find file.
   * @private
   */
  _walk(dirPath, callback) {
    const entries = fs.readdirSync(dirPath);

    for (const entry of entries) {
      const entryPath = path.resolve(dirPath, entry);
      const stat = fs.statSync(entryPath);

      if (stat.isFile()) {
        callback(entryPath);
      } else if (stat.isDirectory()) {
        this._walk(entryPath, callback);
      }
    }
  }

  /**
   * traverse doc comment in selector code file.
   * @param {string[]} interfaces - selector interface names.
   * @param {string} inDirPath - root directory path.
   * @param {string} filePath - target selector code file path.
   * @returns {Object} return document info that is traversed.
   * @property {DocObject[]} results - this is contained selector code.
   * @property {AST} ast - this is AST of selector code.
   * @private
   */
  _traverse(interfaces, inDirPath, filePath) {
    let ast;
    try {
      ast = ESParser.parse(filePath);
    } catch (e) {
      InvalidCodeLogger.showFile(filePath, e);
      return null;
    }
    const pathResolver = new PathResolver(inDirPath, filePath);
    const factory = new DocFactory(interfaces, ast, pathResolver);

    ASTUtil.traverse(ast, (node, parent) => {
      try {
        factory.push(node, parent);
      } catch (e) {
        InvalidCodeLogger.show(filePath, node);
        throw e;
      }
    });

    return { results: factory.results, ast: ast };
  }
}

module.exports = new Plugin();

/***/ }),
/* 10 */
/***/ (function(module, exports) {

module.exports = require("path");

/***/ }),
/* 11 */
/***/ (function(module, exports) {

module.exports = require("fs");

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _defineProperty = __webpack_require__(13);

var _defineProperty2 = _interopRequireDefault(_defineProperty);

var _symbol = __webpack_require__(14);

var _symbol2 = _interopRequireDefault(_symbol);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const debug = __webpack_require__(0)("reselect-tree:esdoc-plugin:factory");
const assert = __webpack_require__(2);
const Doc = __webpack_require__(15);
const FileDoc = __webpack_require__(19);
// hack: depends on ESDoc internal class
const CommentParser = __webpack_require__(21).default;

const already = (0, _symbol2.default)('already');

/**
 * Selector doc factory class.
 * @example
 * let factory = new DocFactory('mocha', ast, pathResolver);
 * factory.push(node, parentNode);
 * let results = factory.results;
 */
class DocFactory {
  /**
   * get unique id.
   * @returns {number} unique id.
   * @private
   */
  static _getUniqueId() {
    if (!this._sequence) /** @type {number} */this._sequence = 0;

    return this._sequence++;
  }

  /**
   * @type {DocObject[]}
   */
  get results() {
    return [...this._results];
  }

  /**
   * create instance.
   * @param {string[]} interfaces - selector interface names.
   * @param {AST} ast - AST of selector code.
   * @param {PathResolver} pathResolver - path resolver of selector code.
   */
  constructor(interfaces, ast, pathResolver) {
    /** @type {string} */
    this._interfaces = interfaces;

    /** @type {AST} */
    this._ast = ast;

    /** @type {PathResolver} */
    this._pathResolver = pathResolver;

    /** @type {DocObject[]} */
    this._results = [];

    // file doc
    const doc = new FileDoc(ast, ast, pathResolver, []);
    this._results.push(doc.value);
  }

  /**
   * push node, and factory process the node.
   * @param {ASTNode} node - target node.
   * @param {ASTNode} parentNode - parent node of target node.
   */
  push(node, parentNode) {
    if (node[already]) return;

    node[already] = true;
    (0, _defineProperty2.default)(node, 'parent', { value: parentNode });

    this._push(node);
  }

  /**
   * match node for conforming as selector to document
   */
  _match(node) {
    var expression;
    var name;
    var iface;
    var children = [];

    /* match node for possible signified types */
    switch (node.type) {
      case "ExpressionStatement":
        expression = node.expression;
        break;

      case "ObjectProperty":
        expression = node;
        break;

      case "VariableDeclaration":
        if (node.declarations.length > 0) {
          expression = node.declarations[0];
        }
        break;

      default:
        return null;
      // debug("skipping node type %s", node.type);
    }

    debug("node %s %O", node.type, node);

    if (!expression) return null;

    debug("expression %s %O", expression.type, expression);

    /* match left-hand side if exists */
    switch (expression.type) {
      case "AssignmentExpression":
        name = expression.left.name;

        children.push(expression); // to assign parent (so we don't lose it)
        expression = expression.right;
        break;

      case "VariableDeclarator":
        name = expression.id.name;

        children.push(expression); // to assign parent (so we don't lose it)
        expression = expression.init;
        break;

      case "ObjectProperty":
        name = expression.key.name;

        children.push(expression); // to assign parent (so we don't lose it)
        expression = expression.value;
        break;
    }

    debug("name %s", name);

    if (!expression) return null;

    /* match right hand side */
    switch (expression.type) {
      case "ArrowFunctionExpression":
        iface = "<arrow>";
        break;

      case "FunctionExpression":
        iface = "<function>";
        break;

      case "CallExpression":
        iface = expression.callee.name;
        break;

      case "ObjectExpression":
        iface = "<subtree>";
        break;

      default:
        return null;
    }

    debug("interface %s", iface);

    if (!this._interfaces.includes(iface)) return;

    // HACK assign state param to make expression work as function
    if (!expression.params) {
      expression.params = [{
        "type": "Identifier",
        "name": "state",
        "types": ["Object"]
      }];
    }

    children.push(expression);

    return {
      "expression": expression,
      "children": children,
      "name": name
    };
  }

  /**
   * push node as selector code.
   * @param {ASTNode} node - target node.
   * @private
   */
  _push(node) {
    const match = this._match(node);
    if (!match) return;

    const expression = match.expression;
    const name = match.name;
    const children = match.children;

    expression[already] = true;

    for (const child of children) {
      (0, _defineProperty2.default)(child, 'parent', { value: node });
    }

    let tags = [];
    if (node.leadingComments && node.leadingComments.length) {
      const comment = node.leadingComments[node.leadingComments.length - 1];
      tags = CommentParser.parse(comment);
    } else {
      return;
    }

    const uniqueId = this.constructor._getUniqueId();
    expression._esdocSelectorId = uniqueId;
    expression._esdocSelectorName = name;

    const selectorDoc = new Doc(this._ast, expression, this._pathResolver, tags);

    this._results.push(selectorDoc.value);
  }
}

module.exports = DocFactory;

/***/ }),
/* 13 */
/***/ (function(module, exports) {

module.exports = require("babel-runtime/core-js/reflect/define-property");

/***/ }),
/* 14 */
/***/ (function(module, exports) {

module.exports = require("babel-runtime/core-js/symbol");

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _deleteProperty = __webpack_require__(16);

var _deleteProperty2 = _interopRequireDefault(_deleteProperty);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const debug = __webpack_require__(0)("reselect-tree:esdoc-plugin:doc");
// hack: depends on esdoc internal class
const AbstractDoc = __webpack_require__(17).default;
const ParamParser = __webpack_require__(18).default;

/**
 * Doc Class from selector code file.
 */
class SelectorDoc extends AbstractDoc {
  /**
   * apply own tag.
   * @private
   */
  _apply() {
    super._apply();

    this._$selectorTarget();

    (0, _deleteProperty2.default)(this._value, 'export');
    (0, _deleteProperty2.default)(this._value, 'importPath');
    (0, _deleteProperty2.default)(this._value, 'importStyle');
  }

  /** use name property of self node. */
  _$kind() {
    super._$kind();

    this._value.kind = 'function';
  }

  /** set name and selectorId from special esdoc property. */
  _$name() {
    super._$name();

    const chain = [this._node._esdocSelectorName];
    let parent = this._node.parent;
    while (parent) {
      if (parent._esdocSelectorName) chain.push(parent._esdocSelectorName);
      parent = parent.parent;
    }
    debug("chain %o", chain);
    this._value.name = chain.reverse().join('.');
    this._value.selectorId = this._node._esdocSelectorId;
  }

  _$params() {
    super._$params();

    this._value.params = [{
      "name": "state",
      "types": ["Object"],
      "description": "initial state"
    }];
  }

  _$return() {
    this._value.return = {
      "types": ["Object"],
      "description": "new state"
    };
  }

  /** set memberof to use parent selector nod and file path. */
  _$memberof() {
    super._$memberof();

    const chain = [];
    let parent = this._node.parent;
    while (parent) {
      if (parent._esdocSelectorName) chain.push(parent._esdocSelectorName);
      parent = parent.parent;
    }

    const filePath = this._pathResolver.filePath;

    if (chain.length) {
      this._value.memberof = `${filePath}~${chain.reverse().join('.')}`;
      this._value.selectorDepth = chain.length;
    } else {
      this._value.memberof = filePath;
      this._value.selectorDepth = 0;
    }
  }

  // /** set describe by using selector node arguments. */
  // _$desc() {
  //   super._$desc();
  //   if (this._value.description) return;

  //   this._value.description = this._node.arguments[0].value;
  // }

  /** for @selectorTarget. */
  _$selectorTarget() {
    const values = this._findAllTagValues(['@selector', '@selectorTarget']);
    if (!values) return;

    this._value.selectorTarget = [];
    for (const value of values) {
      const { typeText } = ParamParser.parseParamValue(value, true, false, false);
      this._value.selectorTarget.push(typeText);
    }
  }

  _$selectorTarget() {
    // alias of selectorTarget
  }
}

module.exports = SelectorDoc;

/***/ }),
/* 16 */
/***/ (function(module, exports) {

module.exports = require("babel-runtime/core-js/reflect/delete-property");

/***/ }),
/* 17 */
/***/ (function(module, exports) {

module.exports = require("esdoc/out/src/Doc/AbstractDoc");

/***/ }),
/* 18 */
/***/ (function(module, exports) {

module.exports = require("esdoc/out/src/Parser/ParamParser");

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// hack: depends on esdoc internal class
const FileDoc = __webpack_require__(20).default;

/**
 * Doc class for selector code file.
 */
class SelectorFileDoc extends FileDoc {
  /** set ``testFile`` to kind. */
  _$kind() {
    this._value.kind = 'file';
  }
}

module.exports = SelectorFileDoc;

/***/ }),
/* 20 */
/***/ (function(module, exports) {

module.exports = require("esdoc/out/src/Doc/FileDoc");

/***/ }),
/* 21 */
/***/ (function(module, exports) {

module.exports = require("esdoc/out/src/Parser/CommentParser");

/***/ }),
/* 22 */
/***/ (function(module, exports) {

module.exports = require("esdoc/out/src/Parser/ESParser");

/***/ }),
/* 23 */
/***/ (function(module, exports) {

module.exports = require("esdoc/out/src/Util/InvalidCodeLogger");

/***/ }),
/* 24 */
/***/ (function(module, exports) {

module.exports = require("esdoc/out/src/Util/PathResolver");

/***/ }),
/* 25 */
/***/ (function(module, exports) {

module.exports = require("esdoc/out/src/Util/ASTUtil");

/***/ })
/******/ ]);
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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