/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;

public class PaginatedQueryResult
extends PaginatedNodeIterator {
    protected QueryResult queryResult;

    public PaginatedQueryResult(int pageSize) {
        super(pageSize);
    }

    public PaginatedQueryResult(QueryResult queryResult, int pageSize) throws Exception {
        super(pageSize);
        this.nodeIterator = queryResult.getNodes();
        this.setAvailablePage((int)this.nodeIterator.getSize());
        this.queryResult = queryResult;
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (page == this.currentPage_ && this.currentListPage_ != null && !this.currentListPage_.isEmpty()) {
            return;
        }
        this.checkAndSetPosition(page);
        this.currentListPage_ = new CopyOnWriteArrayList();
        int count = 0;
        RowIterator iterator = this.queryResult.getRows();
        while (this.nodeIterator.hasNext()) {
            Node node = this.nodeIterator.nextNode();
            Node viewNode = this.filterNodeToDisplay(node);
            if (viewNode == null) continue;
            long position = this.nodeIterator.getPosition();
            long rowPosition = iterator.getPosition();
            long skipNum = position - rowPosition;
            iterator.skip(skipNum - 1L);
            Row row = iterator.nextRow();
            ResultNode resultNode = new ResultNode(viewNode, row);
            this.currentListPage_.add(resultNode);
            if (++count != this.getPageSize()) continue;
            break;
        }
        this.currentPage_ = page;
    }

    protected Node filterNodeToDisplay(Node node) throws Exception {
        Node displayNode = node;
        if (node.isNodeType("nt:resource")) {
            displayNode = node.getParent();
        }
        return displayNode;
    }

    public static class ResultNode {
        private Node node;
        private float score;
        private String excerpt;

        public ResultNode(Node node, Row row) throws RepositoryException {
            this.node = node;
            this.excerpt = row.getValue("rep:excerpt(.)").getString();
            this.score = row.getValue("jcr:score").getLong();
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public float getScore() {
            return this.score;
        }

        public void setScore(float score) {
            this.score = score;
        }

        public String getExcerpt() {
            return this.excerpt;
        }

        public void setExcerpt(String excerpt) {
            this.excerpt = excerpt;
        }

        public String getTitle() throws Exception {
            if (this.node.hasProperty("exo:title")) {
                return this.node.getProperty("exo:title").getString();
            }
            return this.node.getName();
        }

        public String getSummary() throws Exception {
            if (this.node.hasProperty("exo:summary")) {
                return this.node.getProperty("exo:summary").getString();
            }
            return null;
        }
    }
}

