/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal;

import javax.jcr.Node;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;

public class PortalFolderSchemaHandler
extends BaseWebSchemaHandler {
    public Node getCSSFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("css");
    }

    public Node getJSFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("js");
    }

    public Node getMultimediaFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias");
    }

    public Node getImagesFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/images");
    }

    public Node getVideoFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/videos");
    }

    public Node getAudioFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/audio");
    }

    public Node getDocumentStorage(Node portalFolder) throws Exception {
        return portalFolder.getNode("documents");
    }

    public Node getLinkFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("links");
    }

    public Node getWebContentStorage(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents");
    }

    public Node getBannerThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/banner");
    }

    public Node getFooterThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/footer");
    }

    public Node getNavigationThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/navigation");
    }

    public Node getBreadcumsThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/breadcums");
    }

    public Node getHomepageThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/home page");
    }

    protected String getHandlerNodeType() {
        return "exo:portalFolder";
    }

    protected String getParentNodeType() {
        return "nt:unstructured";
    }

    public void onCreateNode(Node portalFolder, SessionProvider sessionProvider) throws Exception {
        Node jsFolder = portalFolder.addNode("js", "exo:jsFolder");
        this.addMixin(jsFolder, "exo:owneable");
        Node cssFolder = portalFolder.addNode("css", "exo:cssFolder");
        this.addMixin(cssFolder, "exo:owneable");
        Node multimedia = portalFolder.addNode("medias", "exo:multimediaFolder");
        this.addMixin(multimedia, "exo:owneable");
        Node images = multimedia.addNode("images", this.NT_FOLDER);
        this.addMixin(images, "exo:pictureFolder");
        this.addMixin(images, "exo:owneable");
        Node video = multimedia.addNode("videos", this.NT_FOLDER);
        this.addMixin(video, "exo:videoFolder");
        this.addMixin(video, "exo:owneable");
        Node audio = multimedia.addNode("audio", this.NT_FOLDER);
        this.addMixin(audio, "exo:musicFolder");
        this.addMixin(audio, "exo:owneable");
        Node document = portalFolder.addNode("documents", this.NT_UNSTRUCTURED);
        this.addMixin(document, "exo:documentFolder");
        this.addMixin(document, "exo:owneable");
        Node webContents = portalFolder.addNode("web contents", "exo:webFolder");
        this.addMixin(webContents, "exo:owneable");
        Node themes = webContents.addNode("site artifacts", "exo:themeFolder");
        this.addMixin(themes, "exo:owneable");
        Node bannerFolder = themes.addNode("banner", "nt:unstructured");
        this.addMixin(bannerFolder, "exo:owneable");
        Node searchboxFolder = themes.addNode("searchbox", "nt:unstructured");
        this.addMixin(searchboxFolder, "exo:owneable");
        Node navigationFolder = themes.addNode("navigation", "nt:unstructured");
        this.addMixin(navigationFolder, "exo:owneable");
        Node breadcumbsFolder = themes.addNode("breadcrumb", "nt:unstructured");
        this.addMixin(breadcumbsFolder, "exo:owneable");
        Node homepageFolder = themes.addNode("homepage", "nt:unstructured");
        this.addMixin(homepageFolder, "exo:owneable");
        Node footerFolder = themes.addNode("footer", "nt:unstructured");
        this.addMixin(footerFolder, "exo:owneable");
        Node sitemapFolder = themes.addNode("sitemap", "nt:unstructured");
        this.addMixin(sitemapFolder, "exo:owneable");
        Node accessFolder = themes.addNode("access", "nt:unstructured");
        this.addMixin(accessFolder, "exo:owneable");
        Node links = portalFolder.addNode("links", "exo:linkFolder");
        this.addMixin(links, "exo:owneable");
        portalFolder.getSession().save();
    }
}

