/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.search;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequestWrapper;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.wcm.webui.search.UISearchForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SearchActionListener.class})})
public class UISearchForm
extends UIForm {
    private String templatePath;
    private ResourceResolver resourceResolver;
    public static final String KEYWORD_INPUT = "keywordInput".intern();
    public static final String DOCUMENT_CHECKING = "documentCheckBox".intern();
    public static final String PAGE_CHECKING = "pageCheckBox".intern();
    public static final String PORTALS_SELECTOR = "portalSelector".intern();
    public static final String ALL_OPTION = "all".intern();
    public static final String MESSAGE_NOT_CHECKED_TYPE_SEARCH = "UISearchForm.message.not-checked".intern();
    public static final String MESSAGE_NOT_SUPPORT_KEYWORD = "UISearchForm.message.keyword-not-support".intern();
    public static final String MESSAGE_NOT_EMPTY_KEYWORD = "UISearchForm.message.keyword-not-empty".intern();

    public UISearchForm() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = context.getRequest().getPreferences();
        UIFormStringInput uiKeywordInput = new UIFormStringInput(KEYWORD_INPUT, KEYWORD_INPUT, null);
        UIFormSelectBox uiPortalSelectBox = new UIFormSelectBox(PORTALS_SELECTOR, PORTALS_SELECTOR, this.getPortalList());
        UIFormCheckBoxInput uiPageCheckBox = new UIFormCheckBoxInput(PAGE_CHECKING, PAGE_CHECKING, null);
        uiPageCheckBox.setChecked(true);
        UIFormCheckBoxInput uiDocumentCheckBox = new UIFormCheckBoxInput(DOCUMENT_CHECKING, DOCUMENT_CHECKING, null);
        uiDocumentCheckBox.setChecked(true);
        this.addUIFormInput((UIFormInput)uiKeywordInput);
        this.addUIFormInput((UIFormInput)uiPortalSelectBox);
        this.addUIFormInput((UIFormInput)uiPageCheckBox);
        this.addUIFormInput((UIFormInput)uiDocumentCheckBox);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)context;
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)portletRequestContext.getRequest();
        String queryString = requestWrapper.getQueryString();
        UIFormStringInput keywordInput = this.getUIStringInput(KEYWORD_INPUT);
        if (queryString != null && queryString.matches("(portal=.*)&(keyword=.*)")) {
            queryString = URLDecoder.decode(queryString, "UTF-8");
            String[] params = queryString.split("&");
            String portalParam = params[0];
            String currentPortal = portalParam.split("=")[1];
            String keywordParam = queryString.substring(portalParam.length() + 1);
            String keyword = keywordParam.substring("keyword=".length());
            if (keyword == null || keyword.length() == 0) {
                keywordInput.setValue(null);
            } else {
                keywordInput.setValue((Object)keyword);
            }
            this.getUIFormSelectBox(PORTALS_SELECTOR).setValue(currentPortal);
        }
        super.processRender(context);
    }

    public void init(String templatePath, ResourceResolver resourceResolver) {
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    private List getPortalList() throws Exception {
        ArrayList<SelectItemOption> portals = new ArrayList<SelectItemOption>();
        DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        List list = service.find(query).getAll();
        portals.add(new SelectItemOption(ALL_OPTION, (Object)ALL_OPTION));
        for (PortalConfig portalConfig : list) {
            portals.add(new SelectItemOption(portalConfig.getName(), (Object)portalConfig.getName()));
        }
        return portals;
    }
}

