/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui;

import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

public class Utils {
    public static boolean isEditPortletInCreatePageWizard() {
        UIPortal uiPortal = Util.getUIPortal();
        UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
        return uiMaskWS.getWindowWidth() > 0 && uiMaskWS.getWindowHeight() < 0;
    }

    public static void refreshBrowser(PortletRequestContext context) {
        context.getJavascriptManager().addJavascript((CharSequence)"location.reload();");
    }

    public static boolean canEditCurrentPortal(String remoteUser) throws Exception {
        if (remoteUser == null) {
            return false;
        }
        IdentityRegistry identityRegistry = (IdentityRegistry)Util.getUIPortalApplication().getApplicationComponent(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(remoteUser);
        if (identity == null) {
            return false;
        }
        UIPortal uiPortal = Util.getUIPortal();
        String editPermission = uiPortal.getEditPermission();
        UserACL userACL = (UserACL)Util.getUIPortalApplication().getApplicationComponent(UserACL.class);
        return userACL.hasPermission(editPermission);
    }
}

