/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dashboard.webui.component;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.dashboard.webui.component.UIWebOSTabPaneDashboard;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webos.webui.page.UIDesktopPage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/dashboard/UIWebOSTabPaneDashboard.gtmpl", events={@EventConfig(confirm="UIWebOSTabPaneDashboard.msg.deleteTab", name="DeleteTab", listeners={DeleteTabActionListener.class}), @EventConfig(name="AddDashboard", listeners={AddDashboardActionListener.class}), @EventConfig(name="RenameTabLabel", listeners={RenameTabLabelActionListener.class})})
public class UIWebOSTabPaneDashboard
extends UIContainer {
    private static Log logger = ExoLogger.getExoLogger(UIWebOSTabPaneDashboard.class);
    private UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
    private DataStorage dataService = (DataStorage)this.getApplicationComponent(DataStorage.class);
    private PageNavigation pageNavigation;
    private UIPortal uiPortal = Util.getUIPortal();
    public static final String PAGE_TEMPLATE = "dashboard";

    public UIWebOSTabPaneDashboard() throws Exception {
        this.initPageNavigation();
    }

    private void initPageNavigation() throws Exception {
        this.pageNavigation = this.uiPortal.getSelectedNavigation();
    }

    public int getCurrentNumberOfTabs() throws Exception {
        return this.getSameSiblingsNode().size();
    }

    public List<PageNode> getSameSiblingsNode() throws Exception {
        List siblings = this.getPageNavigation().getNodes();
        List selectedPath = Util.getUIPortal().getSelectedPath();
        if (selectedPath != null && selectedPath.size() > 1) {
            PageNode currentParent = (PageNode)selectedPath.get(selectedPath.size() - 2);
            siblings = currentParent.getChildren();
        }
        return this.filterWebOSNode(siblings);
    }

    private List<PageNode> filterWebOSNode(List<PageNode> pageNodes) throws Exception {
        if (pageNodes == null || pageNodes.size() == 0) {
            return pageNodes;
        }
        ArrayList<PageNode> tempNodes = new ArrayList<PageNode>(pageNodes);
        for (int i = 0; i < tempNodes.size(); ++i) {
            PageNode node = (PageNode)tempNodes.get(i);
            if (!this.isWebOSNode(node)) continue;
            tempNodes.remove(node);
        }
        return tempNodes;
    }

    private boolean isWebOSNode(PageNode pageNode) throws Exception {
        if (pageNode == null) {
            return false;
        }
        String pageRef = pageNode.getPageReference();
        if (pageRef == null) {
            return false;
        }
        DataStorage ds = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Page page = ds.getPage(pageRef);
        return page == null || UIDesktopPage.DESKTOP_FACTORY_ID.equals(page.getFactoryId());
    }

    public PageNavigation getPageNavigation() throws Exception {
        if (this.pageNavigation == null) {
            this.initPageNavigation();
        }
        return this.pageNavigation;
    }

    public PageNode removePageNode(int nodeIndex) {
        try {
            List nodes = this.getSameSiblingsNode();
            PageNode tobeRemoved = (PageNode)nodes.get(nodeIndex);
            PageNode selectedNode = this.uiPortal.getSelectedNode();
            boolean isRemoved = true;
            PageNavigation updateNav = this.dataService.getPageNavigation(this.pageNavigation.getOwnerType(), this.pageNavigation.getOwnerId());
            for (PageNode pageNode : updateNav.getNodes()) {
                if (!pageNode.getUri().equals(tobeRemoved.getUri())) continue;
                isRemoved = false;
                break;
            }
            if (nodes.size() >= 2) {
                this.pageNavigation.getNodes().remove(tobeRemoved);
                nodes.remove(tobeRemoved);
                if (tobeRemoved.getUri().equals(selectedNode.getUri())) {
                    selectedNode = (PageNode)nodes.get(Math.max(0, nodeIndex - 1));
                } else if (!nodes.contains(selectedNode)) {
                    selectedNode = (PageNode)nodes.get(0);
                }
                if (!isRemoved) {
                    String pageRef = tobeRemoved.getPageReference();
                    if (pageRef != null && pageRef.length() > 0) {
                        Page page = this.configService.getPage(pageRef);
                        if (page != null) {
                            this.dataService.remove(page);
                        }
                        UIPortal uiPortal = Util.getUIPortal();
                        uiPortal.setUIPage(pageRef, null);
                    }
                    this.dataService.save(this.pageNavigation);
                }
            } else {
                ((UIApplication)this.getAncestorOfType(UIApplication.class)).addMessage(new ApplicationMessage("UIWebOSTabPaneDashboard.msg.cannotDeleteLastTab", null));
                return null;
            }
            return selectedNode;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String createNewPageNode(String nodeLabel) {
        try {
            if (nodeLabel == null || nodeLabel.length() == 0) {
                nodeLabel = "Tab_" + this.getCurrentNumberOfTabs();
            }
            Page page = this.configService.createPageTemplate(PAGE_TEMPLATE, this.pageNavigation.getOwnerType(), this.pageNavigation.getOwnerId());
            page.setTitle(nodeLabel);
            List selectedPath = this.uiPortal.getSelectedPath();
            PageNode parentNode = null;
            if (selectedPath != null && selectedPath.size() > 1) {
                parentNode = (PageNode)selectedPath.get(selectedPath.size() - 2);
            }
            PageNode pageNode = new PageNode();
            pageNode.setLabel(nodeLabel);
            String uniqueNodeName = nodeLabel.toLowerCase().replace(' ', '_');
            if (this.nameExisted(uniqueNodeName)) {
                uniqueNodeName = uniqueNodeName + "_" + System.currentTimeMillis();
            }
            String fullName = parentNode != null ? parentNode.getUri() + "/" + uniqueNodeName : uniqueNodeName;
            page.setName(uniqueNodeName + "_" + page.hashCode());
            pageNode.setName(uniqueNodeName);
            pageNode.setUri(fullName);
            pageNode.setPageReference(page.getPageId());
            if (parentNode == null) {
                this.pageNavigation.addNode(pageNode);
            } else if (parentNode.getChildren() != null) {
                parentNode.getChildren().add(pageNode);
            }
            this.dataService.create(page);
            this.dataService.save(this.pageNavigation);
            return fullName;
        }
        catch (Exception ex) {
            logger.info((Object)"Could not create page template", (Throwable)ex);
            return null;
        }
    }

    private boolean validateName(String label) {
        if (label == null || label.length() < 1) {
            return false;
        }
        if ((label = label.trim()).length() < 1 || Character.isDigit(label.charAt(0)) || label.charAt(0) == '-') {
            return false;
        }
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    private boolean nameExisted(String nodeName) {
        for (PageNode node : this.pageNavigation.getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    public String renamePageNode(int nodeIndex, String newNodeLabel) {
        try {
            List nodes = this.getSameSiblingsNode();
            PageNode renamedNode = (PageNode)nodes.get(nodeIndex);
            if (renamedNode == null || newNodeLabel.length() == 0) {
                return null;
            }
            renamedNode.setLabel(newNodeLabel);
            String newNodeName = newNodeLabel.toLowerCase().replace(' ', '_');
            if (this.nameExisted(newNodeName)) {
                newNodeName = newNodeName + "_" + System.currentTimeMillis();
            }
            renamedNode.setName(newNodeName);
            List selectedPath = Util.getUIPortal().getSelectedPath();
            PageNode parentNode = null;
            if (selectedPath != null && selectedPath.size() > 1) {
                parentNode = (PageNode)selectedPath.get(selectedPath.size() - 2);
            }
            String newUri = parentNode != null ? parentNode.getUri() + "/" + newNodeName : newNodeName;
            renamedNode.setUri(newUri);
            Page page = this.configService.getPage(renamedNode.getPageReference());
            page.setTitle(newNodeLabel);
            if (page != null) {
                this.dataService.save(page);
            }
            this.dataService.save(this.pageNavigation);
            return newUri;
        }
        catch (Exception ex) {
            return null;
        }
    }

    static /* synthetic */ boolean access$000(UIWebOSTabPaneDashboard x0, String x1) {
        return x0.validateName(x1);
    }

    static /* synthetic */ UIPortal access$100(UIWebOSTabPaneDashboard x0) {
        return x0.uiPortal;
    }
}

