/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webos.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopPageLifecycle
implements ApplicationLifecycle<PortalRequestContext> {
    public static String DESKTOP_FACTORY_ID = "Desktop";
    public static final String PAGE_ID = "webos";
    public static final String PAGE_TITLE = "WebOS Page";
    public static final String NODE_NAME = "classicWebosPage";
    public static final String NODE_LABEL = "WebOS Page";

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, PortalRequestContext context) throws Exception {
        UserPortalConfig pconfig;
        UserPortal userPortal;
        UserNode rootNode;
        String userName = context.getRemoteUser();
        if (userName != null && SiteType.USER == context.getSiteType() && userName.equals(context.getSiteName()) && NODE_NAME.equals(context.getNodePath()) && (rootNode = (userPortal = (pconfig = context.getUserPortalConfig()).getUserPortal()).getNode(userPortal.getNavigation(context.getSiteKey()), Scope.CHILDREN, UserNodeFilterConfig.builder().build(), null)).getChild(NODE_NAME) == null) {
            DataStorage storage = (DataStorage)PortalContainer.getComponent(DataStorage.class);
            Page page = storage.getPage(SiteType.USER.getName() + "::" + userName + "::" + PAGE_ID);
            if (page == null) {
                page = new Page();
                page.setName(PAGE_ID);
                page.setTitle("WebOS Page");
                page.setFactoryId(DESKTOP_FACTORY_ID);
                page.setShowMaxWindow(Boolean.valueOf(true));
                page.setOwnerType(SiteType.USER.getName());
                page.setOwnerId(userName);
                storage.create(page);
            }
            UserNode desktopNode = rootNode.addChild(NODE_NAME);
            desktopNode.setLabel("WebOS Page");
            desktopNode.setPageRef(page.getPageId());
            desktopNode.setVisibility(Visibility.SYSTEM);
            userPortal.saveNode(rootNode, null);
        }
    }

    public void onFailRequest(Application app, PortalRequestContext context, RequestFailure failureType) throws Exception {
    }

    public void onEndRequest(Application app, PortalRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) throws Exception {
    }
}

