/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.migration;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.settings.impl.SettingServiceImpl;
import org.exoplatform.wiki.jpa.migration.WikiMigrationContext;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;

public class WikiMigrationSettingService {
    private static final Log LOG = ExoLogger.getLogger(WikiMigrationSettingService.class);
    private SettingService settingService;
    private boolean forceJCRDeletion = false;
    private boolean forceRunMigration = false;
    private static final String INNER_OBJECT_SPLIT = ":";
    private static final String OUTER_OBJECT_SPLIT = ";";

    public WikiMigrationSettingService(SettingService settingService) {
        this.settingService = settingService;
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)"exo.wiki.migration.forceJCRDeletion"))) {
            this.forceJCRDeletion = Boolean.valueOf(PropertyManager.getProperty((String)"exo.wiki.migration.forceJCRDeletion"));
        }
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)"exo.wiki.migration.forceRunMigration"))) {
            this.forceRunMigration = Boolean.valueOf(PropertyManager.getProperty((String)"exo.wiki.migration.forceRunMigration"));
        }
    }

    public boolean isForceJCRDeletion() {
        return this.forceJCRDeletion;
    }

    public void setForceJCRDeletion(boolean forceJCRDeletion) {
        this.forceJCRDeletion = forceJCRDeletion;
    }

    public boolean isForceRunMigration() {
        return this.forceRunMigration;
    }

    public void setForceRunMigration(boolean forceRunMigration) {
        this.forceRunMigration = forceRunMigration;
    }

    public void initMigrationSetting() {
        if (this.forceRunMigration) {
            this.initMigrationSettingToDefault();
            return;
        }
        this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        WikiMigrationContext.setMigrationDone(this.getOrCreateOperationState("WIKI_RDBMS_MIGRATION_DONE"));
        WikiMigrationContext.setPortalWikiMigrationDone(this.getOrCreateOperationState("WIKI_RDBMS_MIGRATION_PORTAL_WIKI_DONE"));
        WikiMigrationContext.setSpaceWikiMigrationDone(this.getOrCreateOperationState("WIKI_RDBMS_MIGRATION_SPACE_WIKI_DONE"));
        WikiMigrationContext.setUserWikiMigrationDone(this.getOrCreateOperationState("WIKI_RDBMS_MIGRATION_USER_WIKI_DONE"));
        WikiMigrationContext.setDraftPageMigrationDone(this.getOrCreateOperationState("WIKI_RDBMS_MIGRATION_DRAFT_PAGE_DONE"));
        WikiMigrationContext.setRelatedPageMigrationDone(this.getOrCreateOperationState("WIKI_RDBMS_MIGRATION_RELATED_PAGE_DONE"));
        WikiMigrationContext.setReindexDone(this.getOrCreateOperationState("WIKI_RDBMS_MIGRATION_REINDEX_DONE"));
        WikiMigrationContext.setDeletionDone(this.getOrCreateOperationState("WIKI_RDBMS_DELETION_DONE"));
        WikiMigrationContext.setPortalWikiCleanupDone(this.getOrCreateOperationState("WIKI_RDBMS_CLEANUP_PORTAL_WIKI_DONE"));
        WikiMigrationContext.setSpaceWikiCleanupDone(this.getOrCreateOperationState("WIKI_RDBMS_CLEANUP_SPACE_WIKI_DONE"));
        WikiMigrationContext.setUserWikiCleanupDone(this.getOrCreateOperationState("WIKI_RDBMS_CLEANUP_USER_WIKI_DONE"));
        WikiMigrationContext.setEmoticonCleanupDone(this.getOrCreateOperationState("WIKI_RDBMS_CLEANUP_DRAFT_PAGE_DONE"));
    }

    private void initMigrationSettingToDefault() {
        this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        WikiMigrationContext.setMigrationDone(this.setOperationStatusToDefault("WIKI_RDBMS_MIGRATION_DONE"));
        WikiMigrationContext.setPortalWikiMigrationDone(this.setOperationStatusToDefault("WIKI_RDBMS_MIGRATION_PORTAL_WIKI_DONE"));
        WikiMigrationContext.setSpaceWikiMigrationDone(this.setOperationStatusToDefault("WIKI_RDBMS_MIGRATION_SPACE_WIKI_DONE"));
        WikiMigrationContext.setUserWikiMigrationDone(this.setOperationStatusToDefault("WIKI_RDBMS_MIGRATION_USER_WIKI_DONE"));
        WikiMigrationContext.setDraftPageMigrationDone(this.setOperationStatusToDefault("WIKI_RDBMS_MIGRATION_DRAFT_PAGE_DONE"));
        WikiMigrationContext.setRelatedPageMigrationDone(this.setOperationStatusToDefault("WIKI_RDBMS_MIGRATION_RELATED_PAGE_DONE"));
        WikiMigrationContext.setReindexDone(this.setOperationStatusToDefault("WIKI_RDBMS_MIGRATION_REINDEX_DONE"));
        WikiMigrationContext.setDeletionDone(this.setOperationStatusToDefault("WIKI_RDBMS_DELETION_DONE"));
        WikiMigrationContext.setPortalWikiCleanupDone(this.setOperationStatusToDefault("WIKI_RDBMS_CLEANUP_PORTAL_WIKI_DONE"));
        WikiMigrationContext.setSpaceWikiCleanupDone(this.setOperationStatusToDefault("WIKI_RDBMS_CLEANUP_SPACE_WIKI_DONE"));
        WikiMigrationContext.setUserWikiCleanupDone(this.setOperationStatusToDefault("WIKI_RDBMS_CLEANUP_USER_WIKI_DONE"));
        WikiMigrationContext.setEmoticonCleanupDone(this.setOperationStatusToDefault("WIKI_RDBMS_CLEANUP_DRAFT_PAGE_DONE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getOrCreateOperationState(String operation) {
        try {
            SettingValue migrationValue;
            if (this.settingService == null) {
                LOG.info((Object)"settingService is null");
            }
            if ((migrationValue = this.settingService.get(Context.GLOBAL, Scope.APPLICATION.id("WIKI_MIGRATION_SETTING_GLOBAL"), operation)) != null) {
                boolean bl = Boolean.parseBoolean(migrationValue.getValue().toString());
                return bl;
            }
            this.updateOperationStatus(operation, Boolean.FALSE);
            boolean bl = false;
            return bl;
        }
        finally {
            Scope.APPLICATION.id(null);
        }
    }

    public boolean setOperationStatusToDefault(String operation) {
        this.updateOperationStatus(operation, Boolean.FALSE);
        return false;
    }

    public void setWikiMigrationOfTypeDone(String wikiType) {
        if (wikiType.equals(PortalConfig.PORTAL_TYPE)) {
            this.updateOperationStatus("WIKI_RDBMS_MIGRATION_PORTAL_WIKI_DONE", true);
        } else if (wikiType.equals(PortalConfig.GROUP_TYPE)) {
            this.updateOperationStatus("WIKI_RDBMS_MIGRATION_SPACE_WIKI_DONE", true);
        }
    }

    public void setWikiCleanupOfTypeDone(String wikiType) {
        if (wikiType.equals(PortalConfig.PORTAL_TYPE)) {
            this.updateOperationStatus("WIKI_RDBMS_CLEANUP_PORTAL_WIKI_DONE", true);
        } else if (wikiType.equals(PortalConfig.GROUP_TYPE)) {
            this.updateOperationStatus("WIKI_RDBMS_CLEANUP_SPACE_WIKI_DONE", true);
        }
    }

    public void updateOperationStatus(String key, Boolean status) {
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id("WIKI_MIGRATION_SETTING_GLOBAL"), key, SettingValue.create((Boolean)status));
        }
        finally {
            Scope.APPLICATION.id(null);
            RequestLifeCycle.end();
        }
    }

    public void removeSettingValue(String settingKey) {
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.settingService.remove(Context.GLOBAL, Scope.APPLICATION.id("WIKI_MIGRATION_SETTING_GLOBAL"), settingKey);
        }
        finally {
            Scope.APPLICATION.id(null);
            RequestLifeCycle.end();
        }
    }

    public void removeAllSettingValues() {
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.settingService.remove(Context.GLOBAL, Scope.APPLICATION.id("WIKI_MIGRATION_SETTING_GLOBAL"));
        }
        finally {
            Scope.APPLICATION.id(null);
            RequestLifeCycle.end();
        }
    }

    public void addWikiErrorToSetting(Wiki wikiMigrationError) {
        String wiki = this.wikiToString(wikiMigrationError);
        this.addErrorToSetting("WIKI_RDBMS_MIGRATION_ERROR_WIKI_LIST", wiki);
    }

    public void addPageErrorToSetting(Page pageMigrationError) {
        String page = this.pageToString(pageMigrationError);
        this.addErrorToSetting("WIKI_RDBMS_MIGRATION_ERROR_PAGE_LIST", page);
    }

    public void addWikiDeletionErrorToSetting(Wiki wikiDeletionError) {
        String wiki = this.wikiToString(wikiDeletionError);
        this.addErrorToSetting("WIKI_RDBMS_DELETION_ERROR_WIKI_LIST", wiki);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addErrorToSetting(String settingErrorKey, String settingErrorValue) {
        SettingServiceImpl settingServiceImpl = (SettingServiceImpl)CommonsUtils.getService(SettingServiceImpl.class);
        try {
            String migrationErrors = this.getErrorsSetting(settingErrorKey);
            migrationErrors = migrationErrors == null ? settingErrorValue : migrationErrors + OUTER_OBJECT_SPLIT + settingErrorValue;
            SettingValue errorsSetting = new SettingValue((Object)migrationErrors);
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id("WIKI_MIGRATION_SETTING_GLOBAL"), settingErrorKey, errorsSetting);
        }
        finally {
            Scope.APPLICATION.id(null);
            RequestLifeCycle.end();
        }
    }

    public String getWikiErrorsSetting() {
        return this.getErrorsSetting("WIKI_RDBMS_MIGRATION_ERROR_WIKI_LIST");
    }

    public String getPageErrorsSetting() {
        return this.getErrorsSetting("WIKI_RDBMS_MIGRATION_ERROR_PAGE_LIST");
    }

    public String getWikiDeletionErrorsSetting() {
        return this.getErrorsSetting("WIKI_RDBMS_DELETION_ERROR_WIKI_LIST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorsSetting(String settingErrorKey) {
        String migrationErrors = null;
        SettingServiceImpl settingServiceImpl = (SettingServiceImpl)CommonsUtils.getService(SettingServiceImpl.class);
        boolean created = settingServiceImpl.startSynchronization();
        try {
            SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.APPLICATION.id("WIKI_MIGRATION_SETTING_GLOBAL"), settingErrorKey);
            if (settingValue != null) {
                migrationErrors = (String)settingValue.getValue();
            }
        }
        finally {
            Scope.APPLICATION.id(null);
            settingServiceImpl.stopSynchronization(created);
        }
        return migrationErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelatedPagesToSetting(Page relatedPage) {
        try {
            String relatedPages = this.getRelatedPagesSetting();
            relatedPages = relatedPages == null ? this.pageToString(relatedPage) : relatedPages + OUTER_OBJECT_SPLIT + this.pageToString(relatedPage);
            SettingValue relatedPageSetting = new SettingValue((Object)relatedPages);
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id("WIKI_MIGRATION_SETTING_GLOBAL"), "WIKI_RDBMS_MIGRATION_RELATED_PAGE_LIST", relatedPageSetting);
        }
        finally {
            Scope.APPLICATION.id(null);
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRelatedPagesSetting() {
        String relatedPage = null;
        SettingServiceImpl settingServiceImpl = (SettingServiceImpl)CommonsUtils.getService(SettingServiceImpl.class);
        boolean created = settingServiceImpl.startSynchronization();
        try {
            SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.APPLICATION.id("WIKI_MIGRATION_SETTING_GLOBAL"), "WIKI_RDBMS_MIGRATION_RELATED_PAGE_LIST");
            if (settingValue != null) {
                relatedPage = (String)settingValue.getValue();
            }
        }
        finally {
            Scope.APPLICATION.id(null);
            settingServiceImpl.stopSynchronization(created);
        }
        return relatedPage;
    }

    public String[] getPagesWithRelatedPages() {
        String pageWithRelatedPages = this.getRelatedPagesSetting();
        if (pageWithRelatedPages != null) {
            return pageWithRelatedPages.split(OUTER_OBJECT_SPLIT);
        }
        return null;
    }

    public Integer getWikiMigrationErrorsNumber() {
        String wikiMigrationErrors = this.getWikiErrorsSetting();
        return wikiMigrationErrors != null ? wikiMigrationErrors.split(OUTER_OBJECT_SPLIT).length : 0;
    }

    public Integer getWikiDeletionErrorsNumber() {
        String wikiDeletionErrors = this.getWikiDeletionErrorsSetting();
        return wikiDeletionErrors != null ? wikiDeletionErrors.split(OUTER_OBJECT_SPLIT).length : 0;
    }

    public Integer getPageErrorsNumber() {
        String pageErrors = this.getPageErrorsSetting();
        if (pageErrors != null) {
            return pageErrors.split(OUTER_OBJECT_SPLIT).length;
        }
        return 0;
    }

    public String wikiToString(Wiki wiki) {
        return wiki.getType() + INNER_OBJECT_SPLIT + wiki.getOwner();
    }

    public String wikiToString(WikiImpl wiki) {
        return wiki.getType() + INNER_OBJECT_SPLIT + wiki.getOwner();
    }

    public Page stringToPage(String pageString) {
        String[] pageAttribute = pageString.split(INNER_OBJECT_SPLIT);
        Page page = new Page();
        page.setWikiType(pageAttribute[0]);
        page.setWikiOwner(pageAttribute[1]);
        page.setId(pageAttribute[2]);
        page.setName(pageAttribute[3]);
        return page;
    }

    public String pageToString(Page page) {
        return page.getWikiType() + INNER_OBJECT_SPLIT + page.getWikiOwner() + INNER_OBJECT_SPLIT + page.getId() + INNER_OBJECT_SPLIT + page.getName();
    }

    public void setRelatedPagesToSetting(String pagesWithRelatedPagesString) {
        try {
            SettingValue relatedPageSetting = new SettingValue((Object)pagesWithRelatedPagesString);
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id("WIKI_MIGRATION_SETTING_GLOBAL"), "WIKI_RDBMS_MIGRATION_RELATED_PAGE_LIST", relatedPageSetting);
        }
        finally {
            Scope.APPLICATION.id(null);
            RequestLifeCycle.end();
        }
    }
}

