/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.search.es.ElasticSearchServiceConnector;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;
import org.json.simple.JSONObject;

public class WikiElasticUnifiedSearchServiceConnector
extends ElasticSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(WikiElasticUnifiedSearchServiceConnector.class);
    private WikiService wikiService;

    public WikiElasticUnifiedSearchServiceConnector(InitParams initParams, ElasticSearchingClient client, WikiService wikiService) {
        super(initParams, client);
        this.wikiService = wikiService;
    }

    protected String getSourceFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(this.getTitleElasticFieldName());
        fields.add("wikiType");
        fields.add("wikiOwner");
        fields.add("name");
        fields.add("pageName");
        ArrayList<String> sourceFields = new ArrayList<String>();
        for (String sourceField : fields) {
            sourceFields.add("\"" + sourceField + "\"");
        }
        return StringUtils.join(sourceFields, (String)",");
    }

    protected String getUrlFromJsonResult(JSONObject hitSource, SearchContext context) {
        String wikiType = (String)hitSource.get((Object)"wikiType");
        String wikiOwner = (String)hitSource.get((Object)"wikiOwner");
        String pageName = (String)hitSource.get((Object)"pageName");
        if (StringUtils.isEmpty((String)pageName)) {
            pageName = (String)hitSource.get((Object)"name");
        }
        StringBuffer permalink = new StringBuffer();
        try {
            String portalContainerName = Utils.getPortalName();
            String portalOwner = context.getSiteName();
            String wikiWebappUri = this.wikiService.getWikiWebappUri();
            permalink.append("/");
            permalink.append(portalContainerName);
            permalink.append("/");
            permalink.append(portalOwner);
            permalink.append("/");
            permalink.append(wikiWebappUri);
            if (wikiType.equalsIgnoreCase(WikiType.GROUP.toString())) {
                permalink.append("/");
                permalink.append(PortalConfig.GROUP_TYPE);
                permalink.append(wikiOwner);
            } else if (wikiType.equalsIgnoreCase(WikiType.USER.toString())) {
                permalink.append("/");
                permalink.append(PortalConfig.USER_TYPE);
                permalink.append("/");
                permalink.append(wikiOwner);
            }
            permalink.append("/");
            permalink.append(pageName);
        }
        catch (Exception ex) {
            LOG.info((Object)"Can not build the permalink for wiki page ", (Throwable)ex);
        }
        return permalink.toString();
    }
}

