/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.utils.Utils;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPermissionEntry.gtmpl")
public class UIWikiPermissionEntry
extends UIContainer {
    private static final String ANY_OWNER = "any";
    private static final Log log = ExoLogger.getLogger(UIWikiPermissionEntry.class);
    private PermissionEntry permissionEntry;
    private static final String MANAGER_SPACE_PATTERN = "manager:/spaces";
    private static Map<String, String> permissionLabels = new HashMap<String, String>();

    public PermissionEntry getPermissionEntry() {
        return this.permissionEntry;
    }

    public static Map<String, String> getPermissionLabels() throws Exception {
        if (permissionLabels.isEmpty()) {
            PermissionType[] all = PermissionType.values();
            for (int i = 0; i < all.length; ++i) {
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                ResourceBundle res = context.getApplicationResourceBundle();
                permissionLabels.put(all[i].name(), res.getString("UIPermissionGrid.label." + all[i].name()));
            }
        }
        return permissionLabels;
    }

    public void setPermissionEntry(PermissionEntry permissionEntry) throws Exception {
        this.permissionEntry = permissionEntry;
        this.getChildren().clear();
        if (this.permissionEntry == null) {
            return;
        }
        Permission[] permissions = this.permissionEntry.getPermissions();
        for (int i = 0; i < permissions.length; ++i) {
            this.addChild((UIComponent)new UICheckBoxInput(permissions[i].getPermissionType().name() + this.permissionEntry.getId(), "", Boolean.valueOf(permissions[i].isAllowed())));
        }
    }

    public String getEntryFullName() {
        block10: {
            if (this.permissionEntry.getFullName() != null) {
                return this.permissionEntry.getFullName();
            }
            String id = this.permissionEntry.getId();
            if (ANY_OWNER.equals(id)) {
                this.permissionEntry.setFullName(id);
                return this.permissionEntry.getFullName();
            }
            OrganizationService organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            try {
                switch (this.permissionEntry.getIdType()) {
                    case USER: {
                        UserHandler userHandler = organizationService.getUserHandler();
                        this.permissionEntry.setFullName(userHandler.findUserByName(id).getFullName());
                        break;
                    }
                    case GROUP: {
                        GroupHandler groupHandler = organizationService.getGroupHandler();
                        this.permissionEntry.setFullName(groupHandler.findGroupById(id).getGroupName());
                        break;
                    }
                    case MEMBERSHIP: {
                        int index = id.indexOf(58);
                        if (index == -1) {
                            this.permissionEntry.setFullName(id);
                            break;
                        }
                        String membership = id.split(":")[0];
                        String groupId = id.split(":")[1];
                        GroupHandler groupHandler1 = organizationService.getGroupHandler();
                        String groupName = groupHandler1.findGroupById(groupId).getGroupName();
                        groupName = groupName.substring(0, 1).toUpperCase() + groupName.substring(1);
                        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                        String key = context.getApplicationResourceBundle().getString("UIWikiPermissionForm.PermissionEntry.fullName");
                        this.permissionEntry.setFullName(key.replace("{0}", membership).replace("{1}", groupName));
                    }
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)"Exception when determineFullName", (Throwable)ex);
            }
        }
        return this.permissionEntry.getFullName();
    }

    public boolean isImmutable() {
        try {
            if (this.permissionEntry.getId().indexOf(MANAGER_SPACE_PATTERN) >= 0) {
                boolean isSpaceManager = true;
                Class<?> spaceServiceClass = Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
                Object spaceService = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(spaceServiceClass);
                String groupId = this.permissionEntry.getId();
                groupId = groupId.substring(groupId.lastIndexOf(":") + 1, groupId.length());
                Object space = spaceServiceClass.getDeclaredMethod("getSpaceByGroupId", String.class).invoke(spaceService, groupId);
                ConversationState conversationState = ConversationState.getCurrent();
                String userId = conversationState.getIdentity().getUserId();
                isSpaceManager = (Boolean)spaceServiceClass.getDeclaredMethod("isManager", space.getClass(), String.class).invoke(spaceService, space, userId);
                return !isSpaceManager;
            }
            for (Map.Entry entry : Utils.getACLForAdmins().entrySet()) {
                if (!this.permissionEntry.getId().equals(entry.getKey()) || this.permissionEntry.getIdType() != entry.getValue()) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception when checking isImmutable", (Throwable)ex);
            }
            return false;
        }
    }
}

