/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiDeletePageConfirm.gtmpl", events={@EventConfig(listeners={OKActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWikiDeletePageConfirm
extends UIForm
implements UIPopupComponent {
    public static final String OK_ACTION = "OK";
    public static final String CANCEL_ACTION = "Cancel";
    private static final String BREADCRUM_NAME = "uiWikiDeletePageConfirm_UIWikiBreadcrum";
    private String pageID;
    private String owner;

    public UIWikiDeletePageConfirm() throws Exception {
        ((UIWikiBreadCrumb)this.addChild(UIWikiBreadCrumb.class, null, BREADCRUM_NAME)).setLink(false).setShowWikiType(false);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIWikiBreadCrumb breadCrumb = (UIWikiBreadCrumb)this.getChild(UIWikiBreadCrumb.class);
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        Page page = Utils.getCurrentWikiPage();
        Page parent = wikiService.getParentPageOf(page);
        WikiPageParams params = Utils.getCurrentWikiPageParams();
        if (params != null) {
            breadCrumb.setBreadCumbs(wikiService.getBreadcumb(params.getType(), params.getOwner(), parent.getName()));
        }
        super.processRender(context);
    }

    protected Page getCurrentPage() {
        try {
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            this.pageID = params.getPageName();
            this.owner = params.getOwner();
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            return wservice.getPageOfWikiByName(params.getType(), params.getOwner(), params.getPageName());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getCurrentPageId() {
        return this.pageID;
    }

    protected String getWiki() {
        return this.owner;
    }

    protected String getHomeURL() {
        return Util.getPortalRequestContext().getPortalURI() + "wiki";
    }

    protected void cancelPopup(Event<UIWikiDeletePageConfirm> event) throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
        popupContainer.cancelPopupAction();
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class CancelActionListener
    extends EventListener<UIWikiDeletePageConfirm> {
        public void execute(Event<UIWikiDeletePageConfirm> event) throws Exception {
            UIWikiDeletePageConfirm uiWikiDeletePageConfirm = (UIWikiDeletePageConfirm)((Object)event.getSource());
            uiWikiDeletePageConfirm.cancelPopup(event);
        }
    }

    public static class OKActionListener
    extends EventListener<UIWikiDeletePageConfirm> {
        public void execute(Event<UIWikiDeletePageConfirm> event) throws Exception {
            UIWikiDeletePageConfirm uiWikiDeletePageConfirm = (UIWikiDeletePageConfirm)((Object)event.getSource());
            WikiService wService = (WikiService)PortalContainer.getComponent(WikiService.class);
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            wService.removeDraftOfPage(params);
            wService.deletePage(params.getType(), params.getOwner(), params.getPageName());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)uiWikiDeletePageConfirm.getAncestorOfType(UIWikiPortlet.class);
            wikiPortlet.changeMode(WikiMode.VIEW);
            UIWikiBreadCrumb breadcumb = (UIWikiBreadCrumb)wikiPortlet.findFirstComponentOfType(UIWikiBreadCrumb.class);
            String parentURL = breadcumb.getParentURL();
            uiWikiDeletePageConfirm.cancelPopup(event);
            Utils.ajaxRedirect(event, parentURL);
        }
    }
}

