/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.webui.UIWikiAdvanceSearchForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;

@ComponentConfig(template="app:/templates/wiki/webui/UIAdvancePageIterator.gtmpl", events={@EventConfig(listeners={GoPageActionListener.class})})
public class UIAdvancePageIterator
extends UIComponent {
    public static String PREVIOUS = "previous".intern();
    public static String NEXT = "next".intern();
    public static String FIRST = "first".intern();
    public static String LAST = "last".intern();
    public static String GOPAGE = "GoPage".intern();
    public static String GOTOPPAGE = "goPageTop".intern();
    private int beginPageRange = 0;
    private int endPageRange = 0;
    private int currentPage;

    public List<String> getDisplayedRange() throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)wikiPortlet.findFirstComponentOfType(UIWikiAdvanceSearchForm.class);
        int maxPage = advanceSearchForm.getPageAvailable();
        long page = this.currentPage;
        if (page <= 3L) {
            this.beginPageRange = 1;
            this.endPageRange = maxPage <= 7 ? maxPage : 7;
        } else if ((long)maxPage > page + 3L) {
            this.endPageRange = (int)(page + 3L);
            this.beginPageRange = (int)(page - 3L);
        } else {
            this.endPageRange = maxPage;
            this.beginPageRange = maxPage > 7 ? maxPage - 6 : 1;
        }
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = this.beginPageRange; i <= this.endPageRange; ++i) {
            temp.add(String.valueOf(i));
        }
        return temp;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getMaxPage() {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)wikiPortlet.findFirstComponentOfType(UIWikiAdvanceSearchForm.class);
        return advanceSearchForm.getPageAvailable();
    }

    public static class GoPageActionListener
    extends EventListener<UIAdvancePageIterator> {
        public void execute(Event<UIAdvancePageIterator> event) throws Exception {
            UIAdvancePageIterator pageIterator = (UIAdvancePageIterator)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)pageIterator.getAncestorOfType(UIWikiPortlet.class);
            UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)wikiPortlet.findFirstComponentOfType(UIWikiAdvanceSearchForm.class);
            String changeToPage = event.getRequestContext().getRequestParameter("objectId").trim();
            int maxPage = advanceSearchForm.getPageAvailable();
            int presentPage = pageIterator.currentPage;
            if (NEXT.equalsIgnoreCase(changeToPage)) {
                if (presentPage < maxPage) {
                    advanceSearchForm.gotoSearchPage(presentPage + 1);
                }
            } else if (PREVIOUS.equalsIgnoreCase(changeToPage)) {
                if (presentPage > 1) {
                    advanceSearchForm.gotoSearchPage(presentPage - 1);
                }
            } else if (LAST.equalsIgnoreCase(changeToPage)) {
                if (presentPage != maxPage) {
                    advanceSearchForm.gotoSearchPage(maxPage);
                }
            } else if (FIRST.equalsIgnoreCase(changeToPage)) {
                if (presentPage != 1) {
                    advanceSearchForm.gotoSearchPage(1);
                }
            } else {
                int temp = Integer.parseInt(changeToPage);
                if (temp > 0 && temp <= maxPage && temp != presentPage) {
                    advanceSearchForm.gotoSearchPage(temp);
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(pageIterator.getParent());
        }
    }
}

