/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.render.xwiki;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.wiki.rendering.render.xwiki.image.BaseImageWriterImpl;
import org.exoplatform.wiki.rendering.util.Utils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.formula.FormulaRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.internal.macro.formula.FormulaMacro;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.formula.FormulaMacroConfiguration;
import org.xwiki.rendering.macro.formula.FormulaMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="formula")
@Singleton
public class WikiFormulaMacro
extends FormulaMacro {
    @Inject
    private ComponentManager manager;
    @Inject
    private FormulaMacroConfiguration configuration;
    @Inject
    private Logger logger;

    public List<Block> execute(FormulaMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (StringUtils.isEmpty((CharSequence)content)) {
            throw new MacroExecutionException("The mandatory formula text is missing.");
        }
        String rendererHint = this.configuration.getRenderer();
        FormulaRenderer.FontSize size = parameters.getFontSize();
        FormulaRenderer.Type type = parameters.getImageType();
        Block result = null;
        try {
            result = this.render(content, context.isInline(), size, type, rendererHint);
        }
        catch (ComponentLookupException ex) {
            this.logger.warn("Invalid renderer: [" + rendererHint + "]. Falling back to the safe renderer.");
            try {
                result = this.render(content, context.isInline(), size, type, this.configuration.getSafeRenderer());
            }
            catch (ComponentLookupException ex2) {
                this.logger.error("Safe renderer not found. No image generated. Returning plain text.", (Throwable)ex);
            }
            catch (IllegalArgumentException ex2) {
                throw new MacroExecutionException("The formula text is not valid, please correct it.");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MacroExecutionException("The formula text is not valid, please correct it.");
        }
        if (result == null) {
            result = new WordBlock(content);
        }
        if (!context.isInline()) {
            result = new ParagraphBlock(Collections.singletonList(result));
        }
        return Collections.singletonList(result);
    }

    private Block render(String formula, boolean inline, FormulaRenderer.FontSize fontSize, FormulaRenderer.Type imageType, String rendererHint) throws ComponentLookupException, IllegalArgumentException {
        try {
            FormulaRenderer renderer = (FormulaRenderer)this.manager.getInstance(FormulaRenderer.class, rendererHint);
            String imageName = renderer.process(formula, inline, fontSize, imageType);
            BaseImageWriterImpl imageWriter = Utils.getService(BaseImageWriterImpl.class);
            imageWriter.writeImage(imageName, renderer.getImage(imageName).getData());
            String url = imageWriter.getURL(imageName);
            ResourceReference imageReference = new ResourceReference(url, ResourceType.URL);
            ImageBlock result = new ImageBlock(imageReference, false);
            result.setParameter("alt", formula);
            return result;
        }
        catch (IOException ex) {
            throw new ComponentLookupException("Failed to render formula using [" + rendererHint + "] renderer");
        }
        catch (Exception e) {
            throw new ComponentLookupException("Failed to render formula using [" + rendererHint + "] renderer");
        }
    }
}

