/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.render.xwiki.image;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.exoplatform.wiki.rendering.util.Utils;
import org.picocontainer.Startable;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="base")
@Singleton
public class BaseImageWriterImpl
implements Startable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(String imageId, byte[] imageData) throws Exception {
        File imageFile = this.getStorageLocation(imageId);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(imageFile);
            fos.write(imageData);
            fos.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    protected File getStorageLocation(String imageId) throws Exception {
        File directory = new File("temp/wiki");
        directory.mkdirs();
        File locationFile = new File(directory, imageId + ".png");
        return locationFile;
    }

    public String getURL(String imageId) {
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(Utils.getPortalName()).append("/").append(Utils.getRestContextName()).append("/thumbnailImage/originImage/temp/wiki/").append(imageId).append(".png");
        return sb.toString();
    }

    public void start() {
    }

    public void stop() {
    }
}

