/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search;

import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.wiki.service.search.SearchData;

public class WikiSearchData
extends SearchData {
    public static String WIKIHOME_PATH = "WikiHome";
    public static String ALL_PAGESPATH = "%/" + WIKIHOME_PATH;
    public static String PORTAL_PAGESPATH = PORTAL_PATH + WIKIHOME_PATH;
    public static String GROUP_PAGESPATH = GROUP_PATH + WIKIHOME_PATH;
    private String pagePath = "";
    private String nodeType = null;

    public WikiSearchData(String text, String title, String content, String wikiType, String wikiOwner, String pageId) {
        super(text, title, content, wikiType, wikiOwner, pageId);
        this.createJcrQueryPath();
    }

    public WikiSearchData(String wikiType, String wikiOwner, String pageId) {
        this(null, null, null, wikiType, wikiOwner, pageId);
    }

    public WikiSearchData(String text, String title, String content, String wikiType, String wikiOwner) {
        this(text, title, content, wikiType, wikiOwner, null);
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void createJcrQueryPath() {
        if (this.wikiType == null && this.wikiOwner == null) {
            this.pagePath = ALL_PAGESPATH;
        }
        if (this.wikiType != null) {
            if (this.wikiType.equals(PortalConfig.USER_TYPE)) {
                this.pagePath = this.USER_PATH + WIKIHOME_PATH;
            } else {
                if (this.wikiType.equals(PortalConfig.PORTAL_TYPE)) {
                    this.pagePath = PORTAL_PAGESPATH;
                } else if (this.wikiType.equals(PortalConfig.GROUP_TYPE)) {
                    this.pagePath = GROUP_PAGESPATH;
                }
                if (this.wikiOwner != null && this.wikiOwner.length() > 0) {
                    this.pagePath = this.pagePath.replaceFirst("%", this.wikiOwner);
                }
            }
        }
        this.jcrQueryPath = "jcr:path LIKE '" + this.pagePath + "/%'";
    }

    public String getStatementForTitle(boolean onlyHomePages) {
        StringBuilder statement = new StringBuilder();
        String queryPath = this.jcrQueryPath;
        if (onlyHomePages) {
            queryPath = queryPath.substring(0, queryPath.length() - 3) + "'";
        }
        statement.append("SELECT jcr:primaryType, jcr:path, title, fileType ").append("FROM nt:base ").append("WHERE ").append(queryPath).append(" AND ").append("LOWER(title) LIKE '%").append(this.title).append("%' ").append("ORDER BY jcr:score DESC");
        return statement.toString();
    }

    @Override
    public String getStatement() {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT title, jcr:primaryType, path, excerpt(.) ");
        if (this.nodeType == null) {
            statement.append("FROM nt:base ");
        } else {
            statement.append("FROM " + this.nodeType + " ");
        }
        statement.append("WHERE ");
        statement.append(this.getContentCdt());
        return statement.toString();
    }

    public String getStatementForRenamedPage() {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT * ").append("FROM wiki:renamed ").append("WHERE ");
        statement.append(this.jcrQueryPath);
        if (this.getPageId() != null && this.getPageId().length() > 0) {
            statement.append(" AND ");
            statement.append(" oldPageIds = '").append(this.getPageId()).append("'");
        }
        return statement.toString();
    }

    public String getPageConstraint() {
        StringBuilder constraint = new StringBuilder();
        String absPagePath = this.pagePath + "/" + this.pageId;
        String pageLikePath = this.pagePath + "/%/" + this.pageId;
        boolean isWikiHome = false;
        if ("WikiHome".equals(this.pageId)) {
            absPagePath = this.pagePath;
            isWikiHome = true;
        }
        if (this.wikiType == null || this.wikiOwner == null) {
            absPagePath = "/" + this.pageId;
            pageLikePath = "/%/" + this.pageId;
        }
        constraint.append('(').append('(').append("jcr:path LIKE '").append(pageLikePath).append('\'');
        if (!isWikiHome) {
            constraint.append(" or (jcr:path = '").append(absPagePath).append('\'').append(')');
        }
        constraint.append(")").append(" AND ").append("(jcr:mixinTypes IS NULL OR NOT (jcr:mixinTypes = 'wiki:removed'))").append(')');
        return constraint.toString();
    }

    private String getContentCdt() {
        StringBuilder clause = new StringBuilder();
        String queryPath = this.jcrQueryPath;
        clause.append(queryPath);
        if (this.text != null && this.text.length() > 0) {
            clause.append(" AND ");
            clause.append(" CONTAINS(*, '").append(this.text).append("')");
        } else {
            if (this.title != null && this.title.length() > 0) {
                clause.append(" AND ");
                clause.append(" CONTAINS(title, '").append(this.title).append("') ");
            }
            if (this.content != null && this.content.length() > 0) {
                clause.append(" AND ");
                clause.append(" CONTAINS(*, '").append(this.content).append("') ");
            }
        }
        return clause.toString();
    }
}

