/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.chromattic.api.ChromatticSession;
import org.chromattic.common.IO;
import org.chromattic.core.api.ChromatticSessionImpl;
import org.chromattic.core.jcr.SessionWrapper;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.Template;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.TitleSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.template.plugin.WikiTemplatePagePlugin;
import org.exoplatform.wiki.utils.Utils;

public class JCRDataStorage
implements DataStorage {
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);
    private WikiTemplatePagePlugin templatePlugin;

    public void setTemplatePagePlugin(WikiTemplatePagePlugin plugin) {
        this.templatePlugin = plugin;
    }

    @Override
    public PageList<SearchResult> search(ChromatticSession session, WikiSearchData data) throws Exception {
        ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
        String statement = data.getStatementForSearchingTitle();
        QueryImpl q = (QueryImpl)((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
        QueryResult result = q.execute();
        RowIterator iter = result.getRows();
        long numberOfSearchForTitleResult = iter.getSize();
        if (numberOfSearchForTitleResult > data.getOffset()) {
            if (data.getOffset() > 0L) {
                iter.skip(data.getOffset());
            }
            long position = data.getOffset();
            while (iter.hasNext()) {
                if (position < data.getOffset() + (long)data.getLimit()) {
                    SearchResult tempResult = this.getResult(iter.nextRow());
                    if (tempResult != null && !this.isContains(resultList, tempResult)) {
                        resultList.add(tempResult);
                    }
                } else {
                    iter.nextRow();
                }
                ++position;
            }
        }
        if (resultList.size() >= data.getLimit()) {
            return new ObjectPageList(resultList, resultList.size());
        }
        long searchForContentOffset = 0L;
        long searchForContentLimit = 0L;
        if (numberOfSearchForTitleResult > data.getOffset()) {
            searchForContentOffset = 0L;
            searchForContentLimit = (long)data.getLimit() - (numberOfSearchForTitleResult - data.getOffset());
        } else {
            searchForContentOffset = data.getOffset() - numberOfSearchForTitleResult;
            searchForContentLimit = searchForContentOffset + (long)data.getLimit();
        }
        if (searchForContentOffset > 0L && searchForContentLimit > 0L) {
            statement = data.getStatementForSearchingContent();
            q = (QueryImpl)((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
            q.setOffset(searchForContentOffset);
            q.setLimit(searchForContentLimit);
            result = q.execute();
            iter = result.getRows();
            while (iter.hasNext()) {
                SearchResult tempResult = this.getResult(iter.nextRow());
                if (tempResult == null || this.isContains(resultList, tempResult)) continue;
                resultList.add(tempResult);
            }
        }
        return new ObjectPageList(resultList, resultList.size());
    }

    @Override
    public Page getWikiPageByUUID(ChromatticSession session, String uuid) throws Exception {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT path ");
        statement.append("FROM ").append("wiki:page").append(" ");
        statement.append("WHERE jcr:uuid = '").append(uuid).append("'");
        Query q = ((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement.toString());
        QueryResult result = q.execute();
        RowIterator iter = result.getRows();
        if (iter.hasNext()) {
            Row row = iter.nextRow();
            String path = row.getValue("jcr:path").getString();
            Page page = (Page)Utils.getObject(path, "wiki:page");
            return page;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDefaultTemplatePage(ChromatticSession crmSession, ConfigurationManager configurationManager, String path) {
        if (this.templatePlugin != null) {
            try {
                Iterator<String> iterator = this.templatePlugin.getSourcePaths().iterator();
                Session session = crmSession.getJCRSession();
                InputStream is = null;
                while (iterator.hasNext()) {
                    try {
                        String sourcePath = iterator.next();
                        is = configurationManager.getInputStream(sourcePath);
                        int type = 0;
                        if (((Node)session.getItem(path)).hasNode("wiki:templatecontainer")) {
                            type = 2;
                        }
                        session.importXML(path, is, type);
                        session.save();
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                log.info((Object)("Failed to init default template page because: " + e.getCause()));
            }
        }
    }

    private SearchResult getResult(Row row) throws Exception {
        AttachmentImpl searchAtt;
        String type = row.getValue("jcr:primaryType").getString();
        String path = row.getValue("jcr:path").getString();
        String title = row.getValue("title") == null ? null : row.getValue("title").getString();
        String excerpt = null;
        long jcrScore = row.getValue("jcr:score").getLong();
        Calendar updateDate = GregorianCalendar.getInstance();
        Calendar createdDate = GregorianCalendar.getInstance();
        PageImpl page = null;
        if ("nt:resource".equals(type)) {
            type = "wiki:attachment".toString();
            if (!(path = path.substring(0, path.lastIndexOf("/"))).endsWith("content")) {
                searchAtt = (AttachmentImpl)Utils.getObject(path, "wiki:attachment");
                updateDate = searchAtt.getUpdatedDate();
                page = searchAtt.getParentPage();
                createdDate.setTime(page.getCreatedDate());
                title = page.getTitle();
            } else {
                String pagePath = path.substring(0, path.lastIndexOf("/content"));
                type = "wiki:content".toString();
                page = (PageImpl)Utils.getObject(pagePath, "wiki:page");
                title = page.getTitle();
                updateDate.setTime(page.getUpdatedDate());
                createdDate.setTime(page.getCreatedDate());
            }
        } else if ("wiki:attachment".equals(type)) {
            searchAtt = (AttachmentImpl)Utils.getObject(path, "wiki:attachment");
            updateDate = searchAtt.getUpdatedDate();
            page = searchAtt.getParentPage();
            createdDate.setTime(page.getCreatedDate());
        } else if ("wiki:page".equals(type)) {
            page = (PageImpl)Utils.getObject(path, type);
            updateDate.setTime(page.getUpdatedDate());
            createdDate.setTime(page.getCreatedDate());
        }
        try {
            excerpt = row.getValue("rep:excerpt(.)").getString();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            excerpt = "";
        }
        if (page == null || !page.hasPermission(PermissionType.VIEWPAGE)) {
            return null;
        }
        SearchResult result = new SearchResult(excerpt, title, path, type, updateDate, createdDate);
        result.setUrl(page.getURL());
        result.setJcrScore(jcrScore);
        return result;
    }

    private TitleSearchResult getTitleSearchResult(Row row) throws Exception {
        String type = row.getValue("jcr:primaryType").getString();
        String path = row.getValue("jcr:path").getString();
        String fullTitle = row.getValue("title").getString();
        String fileType = "page";
        PageImpl page = null;
        if ("wiki:page".equals(type) || "exo:wikihome".equals(type)) {
            fileType = "page";
            page = (PageImpl)Utils.getObject(path, "wiki:page");
        } else {
            Value value = row.getValue("fileType");
            if (value != null) {
                fileType = value.getString();
                fullTitle = fullTitle.concat(fileType);
            }
            if (fileType.length() > 0 && fileType.charAt(0) == '.') {
                fileType = fileType.substring(1);
            }
            AttachmentImpl searchAtt = (AttachmentImpl)Utils.getObject(path, "wiki:attachment");
            page = searchAtt.getParentPage();
        }
        if (page == null || !page.hasPermission(PermissionType.VIEWPAGE)) {
            return null;
        }
        TitleSearchResult result = new TitleSearchResult(fullTitle, path, type, fileType);
        return result;
    }

    @Override
    public List<SearchResult> searchRenamedPage(ChromatticSession session, WikiSearchData data) throws Exception {
        ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
        String statement = data.getStatementForRenamedPage();
        Query q = ((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
        QueryResult result = q.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            try {
                resultList.add(this.getResult(iter.nextNode()));
            }
            catch (Exception e) {
                log.debug((Object)"Failed to add item search result", (Throwable)e);
            }
        }
        return resultList;
    }

    private SearchResult getResult(Node node) throws Exception {
        SearchResult result = new SearchResult();
        result.setPageName(node.getName());
        String title = node.getProperty("title").getString();
        InputStream data = node.getNode("content").getNode("jcr:content").getProperty("jcr:data").getStream();
        byte[] bytes = IO.getBytes((InputStream)data);
        String content = new String(bytes, "UTF-8");
        if (content.length() > 100) {
            content = content.substring(0, 100) + "...";
        }
        result.setExcerpt(content);
        result.setTitle(title);
        return result;
    }

    @Override
    public InputStream getAttachmentAsStream(String path, ChromatticSession session) throws Exception {
        Node attContent = (Node)session.getJCRSession().getItem(path);
        return attContent.getProperty("jcr:data").getStream();
    }

    public List<TitleSearchResult> searchDataByTitle(ChromatticSession session, WikiSearchData data) throws Exception {
        ArrayList<TitleSearchResult> resultList = new ArrayList<TitleSearchResult>();
        SessionWrapper sessionWrapper = ((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper();
        int limit = data.getLimit();
        QueryImpl q = (QueryImpl)sessionWrapper.createQuery(data.getStatementForTitle(true));
        this.searchDataByTitle(q, resultList, limit);
        if (limit == 0 || (limit -= resultList.size()) > 0) {
            q = (QueryImpl)sessionWrapper.createQuery(data.getStatementForTitle(false));
            this.searchDataByTitle(q, resultList, limit);
        }
        Collections.sort(resultList, new SortComparatorDESC());
        return resultList;
    }

    private void searchDataByTitle(QueryImpl q, List<TitleSearchResult> resultList, int numberItem) throws Exception {
        if (numberItem == 0) {
            RowIterator iter = q.execute().getRows();
            while (iter.hasNext()) {
                this.addTitleSearchResult(iter.nextRow(), resultList);
            }
        } else {
            int offset = 0;
            int count = 0;
            int limit = 0;
            while (count < numberItem) {
                q.setOffset((long)offset);
                limit = numberItem + offset;
                q.setLimit((long)limit);
                RowIterator iter = q.execute().getRows();
                if (iter.getSize() > 0L) {
                    while (iter.hasNext() && (count += this.addTitleSearchResult(iter.nextRow(), resultList)) != numberItem) {
                    }
                    offset = limit;
                    continue;
                }
                break;
            }
        }
    }

    private int addTitleSearchResult(Row row, List<TitleSearchResult> resultList) throws Exception {
        try {
            TitleSearchResult iterResult = this.getTitleSearchResult(row);
            if (iterResult != null) {
                resultList.add(iterResult);
                return 1;
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("Failed to add item %s ", row.toString()), (Throwable)e);
        }
        return 0;
    }

    private boolean isContains(List<SearchResult> list, SearchResult result) throws Exception {
        AttachmentImpl att = null;
        PageImpl page = null;
        if ("wiki:attachment".equals(result.getType())) {
            att = (AttachmentImpl)Utils.getObject(result.getPath(), "wiki:attachment");
        } else if ("nt:resource".equals(result.getType())) {
            String attPath = result.getPath().substring(0, result.getPath().lastIndexOf("/"));
            att = (AttachmentImpl)Utils.getObject(attPath, "wiki:attachment");
        } else if ("wiki:page".equals(result.getType()) || "exo:wikihome".equals(result.getType())) {
            page = (PageImpl)Utils.getObject(result.getPath(), "wiki:page");
        } else if ("wiki:content".equals(result.getType())) {
            att = (AttachmentImpl)Utils.getObject(result.getPath(), "wiki:attachment");
            page = att.getParentPage();
        }
        if (att != null || page != null) {
            Iterator<SearchResult> iter = list.iterator();
            while (iter.hasNext()) {
                SearchResult child = iter.next();
                if ("wiki:attachment".equals(child.getType()) || "wiki:content".equals(child.getType())) {
                    AttachmentImpl tempAtt = (AttachmentImpl)Utils.getObject(child.getPath(), "wiki:attachment");
                    if (att != null && att.equals(tempAtt)) {
                        if (child.getExcerpt() == null && result.getExcerpt() != null) {
                            child.setExcerpt(result.getExcerpt());
                        }
                        return true;
                    }
                    if (page == null || !page.getName().equals(tempAtt.getParentPage())) continue;
                    return true;
                }
                if (!"wiki:page".equals(child.getType()) || page == null || !page.getPath().equals(child.getPath())) continue;
                iter.remove();
                return false;
            }
        }
        return false;
    }

    @Override
    public List<TemplateSearchResult> searchTemplate(ChromatticSession session, TemplateSearchData data) throws Exception {
        ArrayList<TemplateSearchResult> resultList = new ArrayList<TemplateSearchResult>();
        String statement = data.getStatementForSearchingTitle();
        Query q = ((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
        QueryResult result = q.execute();
        RowIterator iter = result.getRows();
        while (iter.hasNext()) {
            TemplateSearchResult tempResult = this.getTemplateResult(iter.nextRow());
            resultList.add(tempResult);
        }
        return resultList;
    }

    private TemplateSearchResult getTemplateResult(Row row) throws Exception {
        String type = row.getValue("jcr:primaryType").getString();
        String path = row.getValue("jcr:path").getString();
        String title = row.getValue("title") == null ? null : row.getValue("title").getString();
        Template template = (Template)Utils.getObject(path, "wiki:page");
        String description = template.getDescription();
        TemplateSearchResult result = new TemplateSearchResult(template.getName(), title, path, type, null, null, description);
        return result;
    }

    private static class SortComparatorDESC
    implements Comparator<TitleSearchResult> {
        private SortComparatorDESC() {
        }

        @Override
        public int compare(TitleSearchResult titleSearchResult1, TitleSearchResult titleSearchResult2) {
            return titleSearchResult2.getType().compareTo(titleSearchResult1.getType());
        }
    }
}

