/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.tree.PageTreeNode;
import org.exoplatform.wiki.tree.RootTreeNode;
import org.exoplatform.wiki.tree.SpaceTreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.WikiHomeTreeNode;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.utils.Utils;

public class TreeNode {
    protected String name;
    protected String path;
    protected boolean isRetricted = false;
    protected boolean hasChild;
    protected TreeNodeType nodeType;
    protected List<TreeNode> children = new ArrayList<TreeNode>();
    public static final String STACK_PARAMS = "stackParams";
    public static final String PATH = "path";
    public static final String SELECTED_PAGE = "selectedPage";
    public static final String CURRENT_PATH = "page";
    public static final String CURRENT_PAGE = "currentPage";
    public static final String SHOW_EXCERPT = "excerpt";
    public static final String SHOW_DESCENDANT = "showDes";
    public static final String CHILDREN_NUMBER = "childrenNumber";
    public static final String DEPTH = "depth";
    protected boolean isSelected = false;

    public TreeNode() {
    }

    public TreeNode(String name, TreeNodeType nodeType) {
        this.name = name;
        this.nodeType = nodeType;
    }

    public TreeNodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(TreeNodeType nodeType) {
        this.nodeType = nodeType;
    }

    public boolean isHasChild() {
        return this.hasChild;
    }

    public void setHasChild(boolean hasChild) {
        this.hasChild = hasChild;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRetricted() {
        return this.isRetricted;
    }

    public void setRetricted(boolean isRetricted) {
        this.isRetricted = isRetricted;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : ((Object)this.children).hashCode());
        result = 31 * result + (this.hasChild ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNode other = (TreeNode)obj;
        if (this.children == null ? other.children != null : !((Object)this.children).equals(other.children)) {
            return false;
        }
        if (this.hasChild != other.hasChild) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nodeType == null ? other.nodeType != null : !this.nodeType.equals((Object)other.nodeType)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public void pushDescendants(HashMap<String, Object> context) throws Exception {
        this.addChildren(context);
        this.pushChildren(context);
    }

    protected void addChildren(HashMap<String, Object> context) throws Exception {
    }

    protected int getNumberOfChildren(HashMap<String, Object> context, int size) {
        int childrenNUm;
        String childNumCdt = (String)context.get(CHILDREN_NUMBER);
        int n = childrenNUm = childNumCdt == null || "".equals(childNumCdt) ? -1 : Integer.valueOf(childNumCdt);
        if (childrenNUm < 0 || childrenNUm > size) {
            childrenNUm = size;
        }
        if (context.containsKey(CHILDREN_NUMBER)) {
            context.remove(CHILDREN_NUMBER);
        }
        return childrenNUm;
    }

    private void pushChildren(HashMap<String, Object> context) throws Exception {
        Stack paramsStk = (Stack)context.get(STACK_PARAMS);
        if (paramsStk == null) {
            this.pushChild(context);
        } else if (paramsStk.empty()) {
            this.isSelected = true;
        } else {
            WikiPageParams params = new WikiPageParams();
            params = (WikiPageParams)paramsStk.pop();
            context.put(STACK_PARAMS, paramsStk);
            if (this instanceof RootTreeNode) {
                SpaceTreeNode spaceNode = new SpaceTreeNode(params.getType());
                this.pushChild(spaceNode, context);
            } else if (this instanceof SpaceTreeNode) {
                Wiki wiki = (Wiki)Utils.getObjectFromParams(params);
                WikiTreeNode wikiNode = new WikiTreeNode(wiki);
                this.pushChild(wikiNode, context);
            } else if (this instanceof WikiTreeNode) {
                this.pushChild(context);
            } else if (this instanceof WikiHomeTreeNode || this instanceof PageTreeNode) {
                PageImpl page = (PageImpl)Utils.getObjectFromParams(params);
                PageTreeNode pageNode = new PageTreeNode(page);
                this.pushChild(pageNode, context);
            }
        }
    }

    private void pushChild(TreeNode child, HashMap<String, Object> context) throws Exception {
        Boolean showDesCdt = (Boolean)context.get(SHOW_DESCENDANT);
        String depthCdt = (String)context.get(DEPTH);
        boolean showDes = showDesCdt == null ? true : showDesCdt;
        int depth = depthCdt == null || "".equals(depthCdt) ? -1 : Integer.valueOf(depthCdt);
        TreeNode temp = new TreeNode();
        if (showDes && --depth != 0) {
            context.put(DEPTH, String.valueOf(depth));
            for (int i = 0; i < this.children.size(); ++i) {
                temp = this.children.get(i);
                if (child == null) {
                    temp.pushDescendants(context);
                    continue;
                }
                if (!child.equals(temp)) continue;
                temp.pushDescendants(context);
                return;
            }
        }
    }

    private void pushChild(HashMap<String, Object> context) throws Exception {
        this.pushChild(null, context);
    }

    public String buildPath() {
        return null;
    }

    public static enum TREETYPE {
        ALL,
        CHILDREN;

    }
}

