/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.impl;

import java.net.URLEncoder;
import java.util.Map;
import javax.inject.Inject;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.rendering.context.MarkupContextManager;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.MetaDataPage;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;
import org.exoplatform.wiki.utils.WikiNameValidator;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.wiki.WikiModel;

@Component
public class DefaultWikiModel
implements WikiModel {
    private static final Log LOG = ExoLogger.getLogger(DefaultWikiModel.class);
    @Inject
    private Execution execution;
    @Inject
    private MarkupContextManager markupContextManager;

    public String getDocumentEditURL(ResourceReference documentReference) {
        WikiContext wikiContext = this.getWikiContext();
        WikiContext wikiMarkupContext = this.markupContextManager.getMarkupContext(documentReference.getReference(), ResourceType.DOCUMENT);
        if (wikiContext != null) {
            StringBuilder sb = new StringBuilder();
            String pageTitle = wikiMarkupContext.getPageTitle();
            String wikiType = wikiMarkupContext.getType();
            String wiki = wikiMarkupContext.getOwner();
            try {
                WikiNameValidator.validate(pageTitle);
                sb.append(this.getDocumentViewURL(wikiContext));
                sb.append("?").append("action").append("=").append("AddPage").append("&").append("pageTitle").append("=").append(pageTitle).append("&").append("wiki").append("=").append(wiki).append("&").append("wikiType").append("=").append(wikiType);
            }
            catch (IllegalNameException ex) {
                sb.append(String.format("javascript:void(0);", new Object[0]));
            }
            return sb.toString();
        }
        return "";
    }

    public String getDocumentViewURL(ResourceReference documentReference) {
        WikiContext wikiMarkupContext = this.markupContextManager.getMarkupContext(documentReference.getReference(), ResourceType.DOCUMENT);
        return this.getDocumentViewURL(wikiMarkupContext);
    }

    public String getImageURL(ResourceReference imageReference, Map<String, String> parameters) {
        StringBuilder sb;
        block4: {
            String imageName = imageReference.getReference();
            sb = new StringBuilder();
            try {
                PageRenderingCacheService renderingCacheService = (PageRenderingCacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PageRenderingCacheService.class);
                ResourceType resourceType = ResourceType.ICON.equals((Object)imageReference.getType()) ? ResourceType.ICON : ResourceType.ATTACHMENT;
                WikiContext wikiMarkupContext = this.markupContextManager.getMarkupContext(imageName, resourceType);
                String portalContainerName = PortalContainer.getCurrentPortalContainerName();
                String portalURL = wikiMarkupContext.getPortalURL();
                String domainURL = portalURL.substring(0, portalURL.indexOf(portalContainerName) - 1);
                sb.append(domainURL).append(Utils.getCurrentRepositoryWebDavUri());
                WikiContext context = this.getWikiContext();
                renderingCacheService.addPageLink(new WikiPageParams(context.getType(), context.getOwner(), context.getPageId()), new WikiPageParams(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageId()));
                renderingCacheService.addPageLink(new WikiPageParams(context.getType(), context.getOwner(), context.getPageId()), new WikiPageParams(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageId(), wikiMarkupContext.getAttachmentName()));
                PageImpl page = null;
                WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
                page = ResourceType.ATTACHMENT.equals((Object)resourceType) ? (PageImpl)wikiService.getExsitedOrNewDraftPageById(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageId()) : (PageImpl)wikiService.getMetaDataPage(MetaDataPage.EMOTION_ICONS_PAGE);
                if (page != null) {
                    sb.append(page.getWorkspace());
                    sb.append(page.getPath());
                    sb.append("/");
                    AttachmentImpl att = page.getAttachment(TitleResolver.getId(wikiMarkupContext.getAttachmentName(), false));
                    if (att != null) {
                        sb.append(URLEncoder.encode(att.getName(), "UTF-8"));
                    }
                    break block4;
                }
                return "";
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("Couldn't get attachment URL for attachment: " + imageName), (Throwable)e);
            }
        }
        return sb.toString();
    }

    public String getLinkURL(ResourceReference linkReference) {
        return this.getImageURL(linkReference, null);
    }

    public boolean isDocumentAvailable(ResourceReference documentReference) {
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        PageRenderingCacheService renderingCacheService = (PageRenderingCacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PageRenderingCacheService.class);
        Page page = null;
        String documentName = documentReference.getReference();
        ResourceType type = documentReference.getType();
        WikiContext wikiMarkupContext = this.markupContextManager.getMarkupContext(documentName, type);
        WikiContext wikiContext = this.getWikiContext();
        try {
            renderingCacheService.addPageLink(new WikiPageParams(wikiContext.getType(), wikiContext.getOwner(), wikiContext.getPageId()), new WikiPageParams(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageId()));
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed to link incoming pages for page %s", documentReference.toString()), (Throwable)e);
        }
        try {
            if (!Utils.isWikiAvailable(wikiMarkupContext.getType(), wikiMarkupContext.getOwner())) {
                return false;
            }
            page = wikiService.getPageById(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageId());
            if (page == null) {
                page = wikiService.getRelatedPage(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageId());
                if (page != null) {
                    renderingCacheService.addPageLink(new WikiPageParams(wikiContext.getType(), wikiContext.getOwner(), wikiContext.getPageId()), new WikiPageParams(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), page.getName()));
                }
                return page != null;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("An exception happened when checking available status of document: " + documentName), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private String getDocumentViewURL(WikiContext context) {
        block4: {
            try {
                WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
                PageImpl page = (PageImpl)wikiService.getPageById(context.getType(), context.getOwner(), context.getPageId());
                if (page == null) {
                    page = (PageImpl)wikiService.getRelatedPage(context.getType(), context.getOwner(), context.getPageId());
                }
                if (page != null) {
                    Wiki wiki = page.getWiki();
                    context.setType(wiki.getType());
                    context.setOwner(wiki.getOwner());
                    context.setPageId(page.getName());
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"An exception happened when process broken link.", (Throwable)e);
            }
        }
        return Utils.getDocumentURL(context);
    }

    private WikiContext getWikiContext() {
        ExecutionContext ec = this.execution.getContext();
        if (ec != null) {
            WikiContext wikiContext = (WikiContext)ec.getProperty("wikicontext");
            return wikiContext;
        }
        return null;
    }
}

