/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;

public class PageTreeNode
extends TreeNode {
    private PageImpl page;

    public PageTreeNode(PageImpl page) throws Exception {
        super(page.getTitle(), TreeNodeType.PAGE);
        this.page = page;
        this.path = this.buildPath();
        this.hasChild = this.page.getChildPages().size() > 0;
    }

    public PageImpl getPage() {
        return this.page;
    }

    public void setPage(PageImpl page) {
        this.page = page;
    }

    @Override
    protected void addChildren(HashMap<String, Object> context) throws Exception {
        Collection<PageImpl> pages = this.page.getChildrenByRootPermission().values();
        Iterator<PageImpl> childPageIterator = pages.iterator();
        int size = this.getNumberOfChildren(context, pages.size());
        PageImpl currentPage = (PageImpl)context.get("selectedPage");
        for (int count = 0; childPageIterator.hasNext() && count < size; ++count) {
            PageImpl childPage = childPageIterator.next();
            if (!childPage.hasPermission(PermissionType.VIEWPAGE) && (currentPage == null || !Utils.isDescendantPage(currentPage, childPage))) continue;
            PageTreeNode child = new PageTreeNode(childPage);
            this.children.add(child);
        }
        super.addChildren(context);
    }

    public PageTreeNode getChildByName(String name) throws Exception {
        for (TreeNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return (PageTreeNode)child;
        }
        return null;
    }

    @Override
    public String buildPath() {
        Wiki wiki = this.page.getWiki();
        WikiPageParams params = new WikiPageParams(wiki.getType(), wiki.getOwner(), this.page.getName());
        return TreeUtils.getPathFromPageParams(params);
    }
}

