/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;

public class SpaceTreeNode
extends TreeNode {
    public SpaceTreeNode(String name) throws Exception {
        super(name, TreeNodeType.SPACE);
        this.path = this.buildPath();
        try {
            WikiType wikiType = WikiType.valueOf(name.toUpperCase());
            this.hasChild = Utils.getWikisByType(wikiType).size() > 0;
        }
        catch (IllegalArgumentException ex) {
            this.hasChild = false;
        }
    }

    @Override
    protected void addChildren(HashMap<String, Object> context) throws Exception {
        try {
            WikiType wikiType = WikiType.valueOf(this.name.toUpperCase());
            Collection<Wiki> wikis = Utils.getWikisByType(wikiType);
            Iterator<Wiki> childWikiIterator = wikis.iterator();
            int size = this.getNumberOfChildren(context, wikis.size());
            for (int count = 0; childWikiIterator.hasNext() && count < size; ++count) {
                WikiTreeNode child = new WikiTreeNode(childWikiIterator.next());
                this.children.add(child);
            }
            super.addChildren(context);
        }
        catch (IllegalArgumentException ex) {
            this.hasChild = false;
        }
    }

    public WikiTreeNode getChildByName(String name) throws Exception {
        for (TreeNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return (WikiTreeNode)child;
        }
        return null;
    }

    @Override
    public String buildPath() {
        return TreeUtils.getPathFromPageParams(new WikiPageParams(this.name, null, null));
    }
}

