/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.wysiwyg;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.service.wysiwyg.EntityReferenceConverter;
import org.exoplatform.wiki.service.wysiwyg.LinkService;
import org.exoplatform.wiki.utils.Utils;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPage;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.model.reference.DocumentReference;

@Component
public class DefaultWikiService
implements org.xwiki.gwt.wysiwyg.client.wiki.WikiService {
    private static Log log = ExoLogger.getLogger((String)"wiki:GWTWikiService");
    @Inject
    private Execution execution;
    @Inject
    private LinkService linkService;
    private final EntityReferenceConverter entityReferenceConverter = new EntityReferenceConverter();

    private WikiContext getWikiContext() {
        return (WikiContext)this.execution.getContext().getProperty("wikicontext");
    }

    public Boolean isMultiWiki() {
        return false;
    }

    public List<String> getVirtualWikiNames() {
        ArrayList<String> virtualWikiNamesList = new ArrayList<String>();
        return virtualWikiNamesList;
    }

    public List<String> getSpaceNames(String wikiType) {
        ArrayList<String> spaceNames = new ArrayList<String>();
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        try {
            List<Wiki> wikis = wikiService.getWikisByType(wikiType);
            for (Wiki wiki : wikis) {
                spaceNames.add(wiki.getOwner());
            }
        }
        catch (WikiException e) {
            log.error((Object)("Cannot get space names - Cause : " + e.getMessage()), (Throwable)e);
        }
        return spaceNames;
    }

    public List<String> getPageNames(String wikiName, String spaceName) {
        WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
        try {
            WikiContext wikiContext = this.getWikiContext();
            WikiSearchData data = new WikiSearchData("", null, wikiContext.getType(), wikiContext.getOwner());
            PageList<SearchResult> results = wservice.search(data);
            ArrayList<String> pagesNames = new ArrayList<String>();
            if (results != null) {
                List<DocumentReference> documentReferences = this.prepareDocumentReferenceList(results);
                List<WikiPage> wikiPages = this.getWikiPages(documentReferences);
                for (WikiPage page : wikiPages) {
                    String pageName = page.getTitle();
                    if (pagesNames.contains(pageName)) continue;
                    pagesNames.add(pageName);
                }
            }
            return pagesNames;
        }
        catch (Exception e) {
            log.error((Object)"Exception happened when list pages name", (Throwable)e);
            throw new RuntimeException("Failed to list Wiki pages name.", e);
        }
    }

    public List<WikiPage> getRecentlyModifiedPages(String wikiName, int start, int count) {
        WikiContext wikiContext = this.getWikiContext();
        WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
        WikiSearchData data = new WikiSearchData("", "*", wikiContext.getType(), wikiContext.getOwner());
        data.setSort("exo:lastModifiedDate");
        data.setOrder("DESC");
        data.setLimit(count);
        try {
            PageList<SearchResult> results = wservice.search(data);
            List<DocumentReference> documentReferences = this.prepareDocumentReferenceList(results);
            return this.getWikiPages(documentReferences);
        }
        catch (Exception e) {
            log.error((Object)"Exception happened when searching pages", (Throwable)e);
            throw new RuntimeException("Failed to search Wiki pages.", e);
        }
    }

    public List<WikiPage> getMatchingPages(String wikiName, String keyword, int start, int count) {
        String quote = "'";
        String doubleQuote = "''";
        String escapedKeyword = keyword.replaceAll(quote, doubleQuote).toLowerCase();
        WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
        try {
            WikiContext wikiContext = this.getWikiContext();
            WikiSearchData data = new WikiSearchData(escapedKeyword, escapedKeyword, wikiContext.getType(), wikiContext.getOwner());
            PageList<SearchResult> results = wservice.search(data);
            List<DocumentReference> documentReferences = this.prepareDocumentReferenceList(results);
            return this.getWikiPages(documentReferences);
        }
        catch (Exception e) {
            log.error((Object)"Exception happened when searching pages", (Throwable)e);
            throw new RuntimeException("Failed to search Wiki pages.", e);
        }
    }

    private List<WikiPage> getWikiPages(List<DocumentReference> documentReferences) throws Exception {
        WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
        ArrayList<WikiPage> wikiPages = new ArrayList<WikiPage>();
        for (DocumentReference documentReference : documentReferences) {
            WikiPage wikiPage = new WikiPage();
            wikiPage.setReference(this.entityReferenceConverter.convert(documentReference).getEntityReference());
            String pageId = documentReference.getName();
            String wikiOwner = documentReference.getParent().getName();
            String wikiType = documentReference.getParent().getParent().getName();
            Page page = wservice.getPageByRootPermission(wikiType, wikiOwner, pageId);
            wikiPage.setTitle(page.getTitle());
            wikiPage.setUrl(pageId);
            wikiPages.add(wikiPage);
        }
        return wikiPages;
    }

    public EntityConfig getEntityConfig(EntityReference origin, ResourceReference destination) {
        return this.linkService.getEntityConfig(origin, destination);
    }

    public Attachment getAttachment(AttachmentReference attachmentReference) {
        String cleanedFileName = attachmentReference.getFileName();
        cleanedFileName = Utils.escapeIllegalCharacterInName(cleanedFileName);
        attachmentReference.setFileName(cleanedFileName);
        WikiPageReference pageReference = attachmentReference.getWikiPageReference();
        WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
        try {
            cleanedFileName = TitleResolver.getId(cleanedFileName, false);
            Page page = wservice.getExsitedOrNewDraftPageById(pageReference.getWikiName(), pageReference.getSpaceName(), pageReference.getPageName());
            if (page == null) {
                return null;
            }
            org.exoplatform.wiki.mow.api.Attachment attachment = wservice.getAttachmentOfPageByName(cleanedFileName, page);
            if (attachment == null) {
                log.warn((Object)String.format("Failed to get attachment: %s not found.", cleanedFileName));
                return null;
            }
            Attachment attach = new Attachment();
            attach.setReference(attachmentReference.getEntityReference());
            attach.setUrl(attachment.getDownloadURL());
            return attach;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get attachment: there was a problem with getting the document on the server.", (Throwable)e);
            return null;
        }
    }

    public List<Attachment> getImageAttachments(WikiPageReference reference) {
        ArrayList<Attachment> imageAttachments = new ArrayList<Attachment>();
        List<Attachment> allAttachments = this.getAttachments(reference);
        for (Attachment attachment : allAttachments) {
            if (!attachment.getMimeType().startsWith("image/")) continue;
            imageAttachments.add(attachment);
        }
        return imageAttachments;
    }

    public List<Attachment> getAttachments(WikiPageReference documentReference) {
        try {
            String wikiName = documentReference.getWikiName();
            String spaceName = documentReference.getSpaceName();
            String pageName = documentReference.getPageName();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Getting attachments of page : " + wikiName + "." + spaceName + "." + pageName));
            }
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            Page page = wservice.getExsitedOrNewDraftPageById(wikiName, spaceName, TitleResolver.getId(pageName, false));
            List<org.exoplatform.wiki.mow.api.Attachment> attachs = wservice.getAttachmentsOfPage(page);
            for (org.exoplatform.wiki.mow.api.Attachment attach : attachs) {
                AttachmentReference attachmentReference = new AttachmentReference(attach.getName(), documentReference);
                EntityReference entityReference = attachmentReference.getEntityReference();
                entityReference.setType(EntityReference.EntityType.ATTACHMENT);
                Attachment currentAttach = new Attachment();
                currentAttach.setUrl(attach.getDownloadURL());
                currentAttach.setReference(entityReference);
                currentAttach.setMimeType(attach.getMimeType());
                attachments.add(currentAttach);
            }
            return attachments;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve the list of attachments.", e);
        }
    }

    public String getUploadURL(WikiPageReference documentReference) {
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/");
        sb.append(PortalContainer.getCurrentRestContextName()).append("/wiki/upload/");
        sb.append(documentReference.getWikiName()).append("/").append(documentReference.getSpaceName());
        sb.append("/").append(documentReference.getPageName()).append("/");
        return sb.toString();
    }

    public ResourceReference parseLinkReference(String linkReference, EntityReference baseReference) {
        return this.linkService.parseLinkReference(linkReference, baseReference);
    }

    private List<DocumentReference> prepareDocumentReferenceList(PageList<SearchResult> results) throws Exception {
        ArrayList<DocumentReference> documentReferences = new ArrayList<DocumentReference>();
        for (SearchResult result : results.getAll()) {
            String nodeName = result.getPageName();
            if (nodeName != null && nodeName.length() > 0 && nodeName.startsWith("/")) {
                nodeName = nodeName.substring(1);
            }
            WikiContext wikiContext = this.getWikiContext();
            log.info((Object)("Prepair DocumentReference : " + wikiContext.getType() + "@" + wikiContext.getOwner() + "@" + nodeName));
            documentReferences.add(new DocumentReference(wikiContext.getType(), wikiContext.getOwner(), nodeName));
        }
        return documentReferences;
    }
}

