/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.wysiwyg;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.DefaultStringEntityReferenceSerializer;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceValueProvider;

@Component(value="compact")
public class CompactStringEntityReferenceSerializer
extends DefaultStringEntityReferenceSerializer {
    @Inject
    @Named(value="current")
    private EntityReferenceValueProvider provider;

    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        boolean shouldPrint = false;
        if (isLastReference || representation.length() > 0) {
            shouldPrint = true;
        } else {
            String defaultName = this.resolveDefaultValue(currentReference.getType(), parameters);
            if (defaultName == null || !defaultName.equals(currentReference.getName())) {
                shouldPrint = true;
            }
        }
        if (shouldPrint) {
            super.serializeEntityReference(currentReference, representation, isLastReference, new Object[0]);
        }
    }

    protected String resolveDefaultValue(EntityType type, Object ... parameters) {
        EntityReference referenceParameter;
        EntityReference extractedReference;
        String resolvedDefaultValue = null;
        if (parameters.length > 0 && parameters[0] instanceof EntityReference && (extractedReference = (referenceParameter = (EntityReference)parameters[0]).extractReference(type)) != null) {
            resolvedDefaultValue = extractedReference.getName();
        }
        if (resolvedDefaultValue == null) {
            resolvedDefaultValue = this.provider.getDefaultValue(type);
        }
        return resolvedDefaultValue;
    }
}

