/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.util.Collection;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToMany;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;

public abstract class WikiContainer<T extends WikiImpl> {
    private static final Log log = ExoLogger.getLogger(WikiContainer.class);
    protected MOWService mowService;

    public void setMOWService(MOWService mowService) {
        this.mowService = mowService;
    }

    @OneToMany(type=RelationshipType.REFERENCE)
    @MappedBy(value="ref")
    public abstract Collection<T> getWikis();

    public abstract T addWiki(Wiki var1) throws WikiException;

    public abstract T createWiki(Wiki var1) throws WikiException;

    @Create
    public abstract T createWiki();

    protected String validateWikiOwner(String wikiOwner) {
        return wikiOwner;
    }

    public T getWiki(String wikiOwner) {
        return this.contains(wikiOwner);
    }

    public Collection<T> getAllWikis() {
        return this.getWikis();
    }

    public T contains(String wikiOwner) {
        if ((wikiOwner = this.validateWikiOwner(wikiOwner)) == null) {
            return null;
        }
        return this.getWikiObject(wikiOwner);
    }

    protected abstract T getWikiObject(String var1);
}

