/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.inject.Inject;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.EmotionIcon;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.rendering.context.MarkupContextManager;
import org.exoplatform.wiki.rendering.impl.RenderingServiceImpl;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;
import org.exoplatform.wiki.utils.WikiNameValidator;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.wiki.WikiModel;

@Component
public class DefaultWikiModel
implements WikiModel {
    private static final Log LOG = ExoLogger.getLogger(DefaultWikiModel.class);
    @Inject
    private Execution execution;
    @Inject
    private MarkupContextManager markupContextManager;

    public String getDocumentEditURL(ResourceReference documentReference) {
        WikiContext wikiContext = this.getWikiContext();
        WikiContext wikiMarkupContext = this.markupContextManager.getMarkupContext(documentReference.getReference(), ResourceType.DOCUMENT);
        if (wikiContext != null) {
            StringBuilder sb = new StringBuilder();
            String pageTitle = wikiMarkupContext.getPageTitle();
            String wikiType = wikiMarkupContext.getType();
            String wiki = wikiMarkupContext.getOwner();
            try {
                WikiNameValidator.validate(pageTitle);
                sb.append(this.getDocumentViewURL(wikiContext));
                sb.append("?").append("action").append("=").append("AddPage").append("&").append("pageTitle").append("=").append(pageTitle).append("&").append("wiki").append("=").append(wiki).append("&").append("wikiType").append("=").append(wikiType);
            }
            catch (IllegalArgumentException ex) {
                sb.append(String.format("javascript:void(0);", new Object[0]));
            }
            return sb.toString();
        }
        return "";
    }

    public String getDocumentViewURL(ResourceReference documentReference) {
        WikiContext wikiMarkupContext = this.markupContextManager.getMarkupContext(documentReference.getReference(), ResourceType.DOCUMENT);
        return this.getDocumentViewURL(wikiMarkupContext);
    }

    public String getImageURL(ResourceReference imageReference, Map<String, String> parameters) {
        StringBuilder sb;
        block17: {
            String imageName = imageReference.getReference();
            sb = new StringBuilder();
            try {
                WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
                ResourceType resourceType = ResourceType.ICON.equals((Object)imageReference.getType()) ? ResourceType.ICON : ResourceType.ATTACHMENT;
                WikiContext wikiMarkupContext = this.markupContextManager.getMarkupContext(imageName, resourceType);
                String portalContainerName = PortalContainer.getCurrentPortalContainerName();
                String portalURL = wikiMarkupContext.getPortalURL();
                String domainURL = portalURL.substring(0, portalURL.indexOf("/" + portalContainerName));
                sb.append(domainURL);
                WikiContext context = this.getWikiContext();
                wikiService.addPageLink(new WikiPageParams(context.getType(), context.getOwner(), context.getPageName()), new WikiPageParams(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageName()));
                wikiService.addPageLink(new WikiPageParams(context.getType(), context.getOwner(), context.getPageName()), new WikiPageParams(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageName(), wikiMarkupContext.getAttachmentName()));
                String attachmentName = wikiMarkupContext.getAttachmentName();
                if (ResourceType.ATTACHMENT.equals((Object)resourceType)) {
                    Page page = wikiService.getExsitedOrNewDraftPageById(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageName());
                    Attachment att = wikiService.getAttachmentOfPageByName(attachmentName, page);
                    Boolean exportToPdf = parameters == null ? false : Boolean.valueOf(parameters.get("exportToPDF"));
                    if (att == null) break block17;
                    if (exportToPdf.booleanValue() && att.getMimeType().startsWith("image/")) {
                        File image = Files.createTempFile(attachmentName + Long.toString(System.currentTimeMillis()), null, new FileAttribute[0]).toFile();
                        try (FileOutputStream outStream = new FileOutputStream(image);){
                            ((OutputStream)outStream).write(att.getContent());
                        }
                        sb.setLength(0);
                        sb.append(image.toURI().toURL().toString());
                        image.deleteOnExit();
                        break block17;
                    }
                    sb.append(att.getDownloadURL());
                    break block17;
                }
                EmotionIcon emotionIcon = wikiService.getEmotionIconByName(attachmentName);
                if (emotionIcon != null) {
                    sb.append("/rest/wiki/emoticons/" + emotionIcon.getName());
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block17;
                LOG.debug((Object)("Couldn't get attachment URL for attachment: " + imageName), (Throwable)e);
            }
        }
        return sb.toString();
    }

    public String getLinkURL(ResourceReference linkReference) {
        return this.getImageURL(linkReference, null);
    }

    public boolean isDocumentAvailable(ResourceReference documentReference) {
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        Page page = null;
        String documentName = documentReference.getReference();
        ResourceType type = documentReference.getType();
        WikiContext wikiMarkupContext = this.markupContextManager.getMarkupContext(documentName, type);
        WikiContext wikiContext = this.getWikiContext();
        try {
            wikiService.addPageLink(new WikiPageParams(wikiContext.getType(), wikiContext.getOwner(), wikiContext.getPageName()), new WikiPageParams(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageName()));
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed to link incoming pages for page %s", documentReference.toString()), (Throwable)e);
        }
        try {
            if (wikiService.getWikiByTypeAndOwner(wikiMarkupContext.getType(), wikiMarkupContext.getOwner()) == null) {
                return false;
            }
            page = wikiService.getPageOfWikiByName(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageName());
            if (page == null) {
                page = wikiService.getRelatedPage(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), wikiMarkupContext.getPageName());
                if (page != null) {
                    wikiService.addPageLink(new WikiPageParams(wikiContext.getType(), wikiContext.getOwner(), wikiContext.getPageName()), new WikiPageParams(wikiMarkupContext.getType(), wikiMarkupContext.getOwner(), page.getName()));
                }
                return page != null;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("An exception happened when checking available status of document: " + documentName), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private String getDocumentViewURL(WikiContext context) {
        block4: {
            try {
                WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
                Page page = wikiService.getPageOfWikiByName(context.getType(), context.getOwner(), context.getPageName());
                if (page == null) {
                    page = wikiService.getRelatedPage(context.getType(), context.getOwner(), context.getPageName());
                }
                if (page != null) {
                    Wiki wiki = wikiService.getWikiByTypeAndOwner(page.getWikiType(), page.getWikiOwner());
                    context.setType(wiki.getType());
                    context.setOwner(wiki.getOwner());
                    context.setPageName(page.getName());
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"An exception happened when process broken link.", (Throwable)e);
            }
        }
        return Utils.getDocumentURL(context);
    }

    private WikiContext getWikiContext() {
        try {
            RenderingService renderingService = (RenderingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RenderingService.class);
            Execution execution = ((RenderingServiceImpl)renderingService).getExecution();
            ExecutionContext ec = execution.getContext();
            if (ec != null) {
                WikiContext wikiContext = (WikiContext)ec.getProperty("wikicontext");
                return wikiContext;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

