/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.chromattic.ext.ntdef;

import java.util.Date;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Properties;
import org.exoplatform.wiki.mow.core.api.MOWService;

@PrimaryType(name="nt:frozenNode")
public abstract class NTFrozenNode {
    private MOWService mowService;

    @org.chromattic.api.annotations.Property(name="jcr:frozenUuid")
    public abstract String getFrozenUuid();

    public abstract void setFrozenUuid(String var1);

    @OneToMany
    public abstract Map<String, Object> getChildren();

    @Properties
    public abstract Map<String, Object> getProperties();

    public String getAuthor() throws RepositoryException {
        Value value = this.getPropertyValue("author");
        if (value != null) {
            return value.getString();
        }
        value = this.getPropertyValue("exo:lastModifier");
        if (value != null) {
            return value.getString();
        }
        return null;
    }

    public Date getUpdatedDate() throws RepositoryException {
        Value value = this.getPropertyValue("updatedDate");
        if (value != null) {
            return value.getDate().getTime();
        }
        value = this.getPropertyValue("jcr:lastModified");
        if (value != null) {
            return value.getDate().getTime();
        }
        return null;
    }

    public String getComment() throws RepositoryException {
        Value value = this.getPropertyValue("comment");
        if (value != null) {
            return value.getString();
        }
        return null;
    }

    public String getContentString() throws RepositoryException {
        StringBuilder st = new StringBuilder("jcr:content");
        st.append("/").append("jcr:data");
        Value value = this.getPropertyValue(st.toString());
        if (value != null) {
            return value.getString();
        }
        return null;
    }

    public void setMOWService(MOWService mowService) {
        this.mowService = mowService;
    }

    @Path
    protected abstract String getPath();

    private Value getPropertyValue(String propertyName) throws RepositoryException {
        Node pageNode = this.getJCRNode();
        if (pageNode.hasProperty(propertyName)) {
            Property property = pageNode.getProperty(propertyName);
            Value value = property.getValue();
            return value;
        }
        return null;
    }

    public Node getJCRNode() throws RepositoryException {
        return (Node)this.mowService.getSession().getJCRSession().getItem(this.getPath());
    }
}

