/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.image.impl;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.service.image.ResizeImageService;

public class ResizeImageServiceImpl
implements ResizeImageService {
    private static final Log log = ExoLogger.getLogger(ResizeImageServiceImpl.class);
    private ExoCache<Serializable, Object> imageCaches;

    public ResizeImageServiceImpl(CacheService caService) {
        this.imageCaches = caService.getCacheInstance(ResizeImageServiceImpl.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream resizeImage(String imageName, InputStream is, int requestWidth, int requestHeight, boolean keepAspectRatio) {
        BufferedInputStream result;
        block12: {
            File file = null;
            BufferedImage image = null;
            result = null;
            String cacheFileName = imageName + requestWidth + requestHeight;
            File cacheFile = (File)this.imageCaches.get((Serializable)((Object)cacheFileName));
            if (cacheFile != null) {
                try {
                    result = new BufferedInputStream(new FileInputStream(cacheFile));
                }
                catch (FileNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Cached image is not found", (Throwable)e);
                    }
                    break block12;
                }
            }
            try {
                image = ImageIO.read(is);
                int currentWidth = ((Image)image).getWidth(null);
                int currentHeight = ((Image)image).getHeight(null);
                int[] dimensions = this.reduceImageDimensions(currentWidth, currentHeight, requestWidth, requestHeight, keepAspectRatio);
                RenderedImage renderedImage = this.scaleImage(image, dimensions[0], dimensions[1]);
                file = File.createTempFile(imageName, ".png");
                file.deleteOnExit();
                ImageIO.write(renderedImage, "png", file);
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't not get image", (Throwable)e);
                }
            }
            finally {
                image.flush();
            }
            try {
                this.imageCaches.put((Serializable)((Object)cacheFileName), file);
                result = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                log.debug((Object)"Image is not created", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public InputStream resizeImageByWidth(String imageName, InputStream is, int requestWidth) {
        return this.resizeImage(imageName, is, requestWidth, 0, true);
    }

    @Override
    public InputStream resizeImageByHeight(String imageName, InputStream is, int requestHeight) {
        return this.resizeImage(imageName, is, 0, requestHeight, true);
    }

    private RenderedImage scaleImage(Image image, int width, int height) {
        int imageType = 6;
        if (image instanceof BufferedImage && ((imageType = ((BufferedImage)image).getType()) == 13 || imageType == 12 || imageType == 0)) {
            imageType = 6;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, imageType);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (!graphics2D.drawImage(image, 0, 0, width, height, null)) {
            throw new RuntimeException("Failed to resize image.");
        }
        return bufferedImage;
    }

    private int[] reduceImageDimensions(int currentWidth, int currentHeight, int requestedWidth, int requestedHeight, boolean keepAspectRatio) {
        double aspectRatio = (double)currentWidth / (double)currentHeight;
        int width = currentWidth;
        int height = currentHeight;
        if (requestedWidth <= 0 || requestedWidth >= currentWidth) {
            if (requestedHeight > 0 && requestedHeight < currentHeight) {
                width = (int)((double)requestedHeight * aspectRatio);
                height = requestedHeight;
            }
        } else if (requestedHeight <= 0 || requestedHeight >= currentHeight) {
            width = requestedWidth;
            height = (int)((double)requestedWidth / aspectRatio);
        } else if (keepAspectRatio) {
            width = requestedWidth;
            height = (int)((double)requestedWidth / aspectRatio);
            if (height > requestedHeight) {
                width = (int)((double)requestedHeight * aspectRatio);
                height = requestedHeight;
            }
        } else {
            width = requestedWidth;
            height = requestedHeight;
        }
        return new int[]{width, height};
    }
}

