/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.HTMLSanitizer;

public class WikiHTMLSanitizer
extends HTMLSanitizer {
    private static final String LINK_START_TAG = "startwikilink:";
    private static final String IMAGE_START_TAG = "startimage:";
    private static final String MACRO_START_TAG = "startmacro:";
    private static final String LINK_END_TAG = "stopwikilink";
    private static final String IMAGE_END_TAG = "stopimage";
    private static final String MACRO_END_TAG = "stopmacro";
    private static final Pattern LINK_REGEX = Pattern.compile("<!--startwikilink:(.*)-->(.*)<!--stopwikilink-->");
    private static final Pattern IMAGE_REGEX = Pattern.compile("<!--startimage:(.*)-->(.*)<!--stopimage-->");
    private static final Pattern MACRO_REGEX = Pattern.compile("<!--startmacro:(.*)-->(.*)<!--stopmacro-->");
    private static final Pattern REDO_IMAGE_REGEX = Pattern.compile("<wikiimage wikiparam=\"(.*)\"> (.*)</wikiimage>");
    private static final Pattern REDO_LINK_REGEX = Pattern.compile("<wikilink wikiparam=\"(.*)\"> (.*)</wikilink>");
    private static final Pattern REDO_MACRO_REGEX = Pattern.compile("<wikimacro wikiparam=\"(.*)\"> (.*)</wikimacro>");

    public static String markupSanitize(String html) throws Exception {
        Matcher matcher = LINK_REGEX.matcher(html);
        while (matcher.find()) {
            html = html.replace(matcher.group(0), "<wikilink wikiparam='" + matcher.group(1) + "'> " + matcher.group(2) + "</wikilink>");
        }
        matcher = IMAGE_REGEX.matcher(html);
        while (matcher.find()) {
            html = html.replace(matcher.group(0), "<wikiimage wikiparam='" + matcher.group(1) + "'> " + matcher.group(2) + "</wikiimage>");
        }
        matcher = MACRO_REGEX.matcher(html);
        while (matcher.find()) {
            html = html.replace(matcher.group(0), "<wikimacro wikiparam='" + matcher.group(1) + "'> " + matcher.group(2) + "</wikimacro>");
        }
        html = WikiHTMLSanitizer.sanitize((String)html);
        matcher = REDO_IMAGE_REGEX.matcher(html);
        while (matcher.find()) {
            html = html.replace(matcher.group(0), "<!--startimage:" + WikiHTMLSanitizer.decode(matcher.group(1)) + "-->" + WikiHTMLSanitizer.decode(matcher.group(2)) + "<!--" + IMAGE_END_TAG + "-->");
        }
        matcher = REDO_LINK_REGEX.matcher(html);
        while (matcher.find()) {
            html = html.replace(matcher.group(0), "<!--startwikilink:" + WikiHTMLSanitizer.decode(matcher.group(1)) + "-->" + WikiHTMLSanitizer.decode(matcher.group(2)) + "<!--" + LINK_END_TAG + "-->");
        }
        matcher = REDO_MACRO_REGEX.matcher(html);
        while (matcher.find()) {
            html = html.replace(matcher.group(0), "<!--startmacro:" + WikiHTMLSanitizer.decode(matcher.group(1)) + "-->" + WikiHTMLSanitizer.decode(matcher.group(2)) + "<!--" + MACRO_END_TAG + "-->");
        }
        return html;
    }

    private static String decode(String input) {
        if (input != null) {
            input = input.replace("&#34;", "\"").replaceAll("&amp;", "&").replaceAll("&#39;", "'").replaceAll("&#43;", "+").replaceAll("&lt;", "<").replaceAll("&#61;", "=").replaceAll("&gt;", ">").replaceAll("&#64;", "@").replaceAll("&#96;", "`");
        }
        return input;
    }
}

