/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PortalWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.utils.JCRUtils;

@PrimaryType(name="wiki:portalwikis")
public abstract class PortalWikiContainer
extends WikiContainer<PortalWiki> {
    @OneToOne
    @MappedBy(value="portalwikis")
    public abstract WikiStoreImpl getMultiWiki();

    @Override
    public PortalWiki addWiki(Wiki wiki) throws WikiException {
        PortalWiki portalWiki = this.getWikiObject(wiki.getOwner());
        if (portalWiki == null) {
            portalWiki = this.createWiki(wiki);
        }
        return portalWiki;
    }

    @Override
    protected PortalWiki getWikiObject(String wikiOwner) {
        Node wikiNode;
        if ((wikiOwner = this.validateWikiOwner(wikiOwner)) == null) {
            return null;
        }
        ChromatticSession session = this.mowService.getSession();
        try {
            Node wikisNode = (Node)session.getJCRSession().getItem(PortalWikiContainer.getPortalWikisPath());
            try {
                wikiNode = wikisNode.getNode(wikiOwner);
            }
            catch (PathNotFoundException e) {
                return null;
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
        PortalWiki pwiki = (PortalWiki)session.findByNode(PortalWiki.class, wikiNode);
        pwiki.setPortalWikis(this);
        return pwiki;
    }

    @Override
    public PortalWiki createWiki(Wiki wiki) throws WikiException {
        try {
            String wikiOwner = this.validateWikiOwner(wiki.getOwner());
            if (wikiOwner == null) {
                return null;
            }
            ChromatticSession session = this.mowService.getSession();
            Node wikisNode = (Node)session.getJCRSession().getItem(PortalWikiContainer.getPortalWikisPath());
            Node wikiNode = wikisNode.addNode(wikiOwner, "wiki:portalwiki");
            wikisNode.save();
            PortalWiki pwiki = (PortalWiki)session.findByNode(PortalWiki.class, wikiNode);
            pwiki.setPortalWikis(this);
            pwiki.setOwner(wikiOwner);
            if (wiki.getPermissions() != null) {
                pwiki.setWikiPermissions(JCRUtils.convertPermissionEntryListToWikiPermissions(wiki.getPermissions()));
                pwiki.setDefaultPermissionsInited(true);
            }
            pwiki.getPreferences();
            session.save();
            return pwiki;
        }
        catch (Exception e) {
            throw new WikiException("Cannot create wiki " + wiki.getType() + ":" + wiki.getOwner(), e);
        }
    }

    public static String getPortalWikisPath() {
        String path = "/exo:applications/eXoWiki/wikis";
        return path;
    }
}

