/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.wiki.mow.core.api.wiki.TemplateImpl;

@PrimaryType(name="wiki:templatecontainer")
public abstract class TemplateContainer {
    @Create
    public abstract TemplateImpl createTemplatePage();

    @Path
    public abstract String getPath();

    @OneToMany
    public abstract Map<String, TemplateImpl> getTemplates();

    public abstract void setTemplates(Map<String, TemplateImpl> var1);

    public TemplateImpl addPage(String templateName, TemplateImpl template) {
        if (templateName == null) {
            throw new IllegalArgumentException("Template name cannot be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        Map<String, TemplateImpl> children = this.getTemplates();
        if (children.containsKey(templateName)) {
            return template;
        }
        children.put(templateName, template);
        return template;
    }

    public TemplateImpl getTemplate(String name) {
        for (Map.Entry<String, TemplateImpl> entry : this.getTemplates().entrySet()) {
            TemplateImpl template = entry.getValue();
            if (!template.getName().equals(name)) continue;
            return template;
        }
        return null;
    }
}

