/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.chromattic.api.NoSuchNodeException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.utils.JCRUtils;

public class JCRWikiSearchQueryBuilder {
    public static final String ALL_PATH = "%/";
    protected static String PORTAL_PATH = "/exo:applications/eXoWiki/wikis/%/";
    protected static String GROUP_PATH = "/Groups/%/ApplicationData/eXoWiki/";
    protected String USER_PATH = "/Users/%/ApplicationData/eXoWiki/";
    public static String ALL_PAGESPATH = "%/WikiHome";
    public static String PORTAL_PAGESPATH = PORTAL_PATH + "WikiHome";
    public static String GROUP_PAGESPATH = GROUP_PATH + "WikiHome";
    public static String ASC_ORDER = "ASC";
    public static String DESC_ORDER = "DESC";
    private WikiSearchData wikiSearchData;
    private String pagePath = "";
    protected List<String> propertyConstraints = new ArrayList<String>();

    public JCRWikiSearchQueryBuilder(WikiSearchData wikiSearchData) {
        this.wikiSearchData = wikiSearchData;
        if (PortalConfig.USER_TYPE.equals(wikiSearchData.getWikiType())) {
            NodeHierarchyCreator nodeHierachyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            try {
                if (wikiSearchData.getWikiOwner() != null && wikiSearchData.getWikiOwner().length() > 0) {
                    Node userNode = nodeHierachyCreator.getUserApplicationNode(JCRUtils.createSystemProvider(), wikiSearchData.getWikiOwner());
                    this.USER_PATH = userNode.getPath() + "/" + "eXoWiki" + "/";
                }
            }
            catch (Exception e) {
                if (e instanceof PathNotFoundException) {
                    throw new NoSuchNodeException((Throwable)e);
                }
                throw new UndeclaredRepositoryException(e.getMessage());
            }
        }
        this.propertyConstraints = new ArrayList<String>();
        this.initJcrQueryPath();
    }

    public List<String> getPropertyConstraints() {
        return new ArrayList<String>(this.propertyConstraints);
    }

    public void addPropertyConstraints(List<String> value) {
        if (value != null) {
            this.propertyConstraints.addAll(value);
        }
    }

    public void addPropertyConstraint(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.propertyConstraints.add(value);
        }
    }

    public void initJcrQueryPath() {
        if (this.wikiSearchData.getWikiType() == null && this.wikiSearchData.getWikiOwner() == null) {
            this.pagePath = ALL_PAGESPATH;
        } else if (this.wikiSearchData.getWikiType() != null) {
            if (this.wikiSearchData.getWikiType().equals(PortalConfig.USER_TYPE)) {
                this.pagePath = this.USER_PATH + "WikiHome";
            } else {
                if (this.wikiSearchData.getWikiType().equals(PortalConfig.PORTAL_TYPE)) {
                    this.pagePath = PORTAL_PAGESPATH;
                } else if (this.wikiSearchData.getWikiType().equals(PortalConfig.GROUP_TYPE)) {
                    this.pagePath = GROUP_PAGESPATH;
                }
                if (this.wikiSearchData.getWikiOwner() != null && this.wikiSearchData.getWikiOwner().length() > 0) {
                    this.pagePath = this.pagePath.replaceFirst("%", this.wikiSearchData.getWikiOwner());
                }
            }
        }
    }

    public String getStatementForSearchingTitle() {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT title, jcr:primaryType, path, excerpt(.) FROM nt:base WHERE ");
        statement.append(this.createJcrQueryPathClause());
        statement.append(this.searchTitleCondition());
        statement.append(this.createOrderClause());
        return statement.toString();
    }

    public String getStatementForSearchingContent() {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT jcr:primaryType, path, excerpt(.) FROM wiki:attachment WHERE ");
        statement.append(this.createJcrQueryPathClause());
        statement.append(this.searchContentCondition());
        statement.append(this.createOrderClause());
        return statement.toString();
    }

    private String createJcrQueryPathClause() {
        return "(jcr:path LIKE '" + this.pagePath + "/%')";
    }

    private String createOrderClause() {
        StringBuffer clause = new StringBuffer();
        if (this.isOrderValid(this.wikiSearchData.getOrder()) && StringUtils.isNotEmpty((String)this.wikiSearchData.getSort())) {
            clause.append(" ORDER BY ");
            clause.append(this.wikiSearchData.getSort());
            clause.append(" ");
            clause.append(this.wikiSearchData.getOrder());
        }
        return clause.toString();
    }

    private boolean isOrderValid(String order) {
        return ASC_ORDER.equals(order) || DESC_ORDER.equals(order) || "".equals(order);
    }

    public String getPageConstraint() {
        StringBuilder constraint = new StringBuilder();
        String absPagePath = this.pagePath + "/" + this.wikiSearchData.getPageId();
        String pageLikePath = this.pagePath + "/%/" + this.wikiSearchData.getPageId();
        boolean isWikiHome = false;
        if ("WikiHome".equals(this.wikiSearchData.getPageId())) {
            absPagePath = this.pagePath;
            isWikiHome = true;
        }
        if (this.wikiSearchData.getWikiType() == null || this.wikiSearchData.getWikiOwner() == null) {
            absPagePath = "/" + this.wikiSearchData.getPageId();
            pageLikePath = "/%/" + this.wikiSearchData.getPageId();
        }
        constraint.append('(').append('(').append("jcr:path LIKE '").append(pageLikePath).append('\'');
        if (!isWikiHome) {
            constraint.append(" or (jcr:path = '").append(absPagePath).append('\'').append(')');
        }
        constraint.append(")").append(" AND ").append("(jcr:mixinTypes IS NULL OR NOT (jcr:mixinTypes = 'wiki:removed'))").append(')');
        return constraint.toString();
    }

    private String searchContentCondition() {
        StringBuilder clause = new StringBuilder();
        if (this.wikiSearchData.getContent() != null && this.wikiSearchData.getContent().length() > 0 && !"*".equals(this.wikiSearchData.getContent())) {
            clause.append(" AND ");
            clause.append(" CONTAINS(*, '").append(this.wikiSearchData.getContent()).append("')");
        }
        return clause.toString();
    }

    private String searchTitleCondition() {
        StringBuilder clause = new StringBuilder();
        if (this.wikiSearchData.getTitle() != null && this.wikiSearchData.getTitle().length() > 0) {
            clause.append(" AND ");
            clause.append(" CONTAINS(title, '").append(this.wikiSearchData.getTitle()).append("')");
        }
        return clause.toString();
    }
}

