/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.utils.JCRUtils;

public class PermissionImpl {
    private static final Log log = ExoLogger.getLogger(PermissionImpl.class);
    protected MOWService mowService;

    public void setMOWService(MOWService mowService) {
        this.mowService = mowService;
    }

    public MOWService getMOWService() {
        return this.mowService;
    }

    public HashMap<String, String[]> getPermission(String jcrPath) throws WikiException {
        try {
            ExtendedNode extendedNode = (ExtendedNode)this.getJCRNode(jcrPath);
            HashMap<String, String[]> perm = new HashMap<String, String[]>();
            AccessControlList acl = extendedNode.getACL();
            List aceList = acl.getPermissionEntries();
            int length = aceList.size();
            for (int i = 0; i < length; ++i) {
                AccessControlEntry ace = (AccessControlEntry)aceList.get(i);
                String[] nodeActions = perm.get(ace.getIdentity());
                ArrayList<Object> actions = nodeActions != null ? new ArrayList<String>(Arrays.asList(nodeActions)) : new ArrayList<String>();
                actions.add(ace.getPermission());
                perm.put(ace.getIdentity(), actions.toArray(new String[actions.size()]));
            }
            return perm;
        }
        catch (Exception e) {
            throw new WikiException("Cannot get permissions of node " + jcrPath, e);
        }
    }

    public boolean hasPermission(org.exoplatform.wiki.mow.api.PermissionType permissionType, String jcrPath) {
        ConversationState conversationState = ConversationState.getCurrent();
        Identity user = conversationState != null ? conversationState.getIdentity() : new Identity(IdentityConstants.ANONIM);
        return this.hasPermission(permissionType, jcrPath, user);
    }

    public boolean hasPermission(org.exoplatform.wiki.mow.api.PermissionType permissionType, String jcrPath, Identity user) {
        String[] permission = new String[]{};
        if (org.exoplatform.wiki.mow.api.PermissionType.VIEWPAGE.equals((Object)permissionType) || org.exoplatform.wiki.mow.api.PermissionType.VIEW_ATTACHMENT.equals((Object)permissionType)) {
            permission = new String[]{"read"};
        } else if (org.exoplatform.wiki.mow.api.PermissionType.EDITPAGE.equals((Object)permissionType) || org.exoplatform.wiki.mow.api.PermissionType.EDIT_ATTACHMENT.equals((Object)permissionType)) {
            permission = new String[]{"add_node", "remove", "set_property"};
        }
        try {
            ExtendedNode extendedNode = (ExtendedNode)this.getJCRNode(jcrPath);
            AccessControlList acl = extendedNode.getACL();
            return JCRUtils.hasPermission(acl, permission, user);
        }
        catch (RepositoryException e) {
            log.error((Object)("Cannot check permissions of user " + user.getUserId() + " on node " + jcrPath + " - Cause : " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public void setPermission(HashMap<String, String[]> permissions, String jcrPath) throws WikiException {
        this.getChromatticSession().save();
        try {
            ExtendedNode extendedNode = (ExtendedNode)this.getJCRNode(jcrPath);
            if (extendedNode.canAddMixin("exo:privilegeable")) {
                extendedNode.addMixin("exo:privilegeable");
            }
            if (permissions != null && permissions.size() > 0) {
                extendedNode.setPermissions(permissions);
            } else {
                extendedNode.clearACL();
                extendedNode.setPermission(IdentityConstants.ANY, PermissionType.ALL);
            }
        }
        catch (RepositoryException e) {
            throw new WikiException("Cannot set permissions on node " + jcrPath, e);
        }
    }

    protected ChromatticSession getChromatticSession() {
        return this.mowService.getSession();
    }

    protected Node getJCRNode(String path) throws RepositoryException {
        return (Node)this.getChromatticSession().getJCRSession().getItem(path);
    }
}

