/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.util.Collection;
import java.util.Map;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;

@PrimaryType(name="wiki:trash")
public abstract class Trash {
    @Path
    public abstract String getPath();

    @OneToMany
    public abstract Map<String, PageImpl> getChildren();

    public Collection<PageImpl> getChildPages() {
        return this.getChildren().values();
    }

    public boolean isHasPage(String name) {
        return this.getChildren().containsKey(name);
    }

    public void addRemovedWikiPage(PageImpl page) {
        if (page == null) {
            throw new NullPointerException();
        }
        this.addChild(page.getName(), page);
    }

    public void addChild(String pageName, PageImpl page) {
        if (pageName == null) {
            throw new NullPointerException();
        }
        if (page == null) {
            throw new NullPointerException();
        }
        Map<String, PageImpl> children = this.getChildren();
        if (children.containsKey(pageName)) {
            throw new IllegalStateException();
        }
        children.put(pageName, page);
    }

    public PageImpl getPage(String pageName) {
        if (pageName == null) {
            throw new NullPointerException();
        }
        Map<String, PageImpl> children = this.getChildren();
        return children.get(pageName);
    }
}

