/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;

@Entity(name="WikiPageVersionEntity")
@ExoEntity
@Table(name="WIKI_PAGE_VERSIONS")
@NamedQueries(value={@NamedQuery(name="wikiPageVersion.getLastversionNumberOfPage", query="SELECT max(p.versionNumber) FROM WikiPageVersionEntity p WHERE p.page.id = :pageId"), @NamedQuery(name="wikiPageVersion.getPageversionByPageIdAndVersion", query="SELECT p FROM WikiPageVersionEntity p WHERE p.page.id = :pageId AND p.versionNumber = :versionNumber"), @NamedQuery(name="wikiPageVersion.getAllPagesVersionsBySyntax", query="SELECT p FROM WikiPageVersionEntity p WHERE p.syntax = :syntax OR p.syntax IS NULL ORDER BY p.updatedDate DESC"), @NamedQuery(name="wikiPageVersion.countAllPagesVersionsBySyntax", query="SELECT COUNT(p) FROM WikiPageVersionEntity p WHERE p.syntax = :syntax OR p.syntax IS NULL")})
public class PageVersionEntity
extends BasePageEntity {
    @Id
    @SequenceGenerator(name="SEQ_WIKI_PAGE_VERSIONS_VERS_ID", sequenceName="SEQ_WIKI_PAGE_VERSIONS_VERS_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_PAGE_VERSIONS_VERS_ID")
    @Column(name="PAGE_VERSION_ID")
    private long id;
    @ManyToOne
    @JoinColumn(name="PAGE_ID")
    private PageEntity page;
    @Column(name="VERSION_NUMBER")
    private long versionNumber;
    @Column(name="EDITION_COMMENT")
    private String comment;
    @Column(name="MINOR_EDIT")
    private boolean minorEdit;

    public long getId() {
        return this.id;
    }

    public PageEntity getPage() {
        return this.page;
    }

    public void setPage(PageEntity page) {
        this.page = page;
    }

    public long getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isMinorEdit() {
        return this.minorEdit;
    }

    public void setMinorEdit(boolean minorEdit) {
        this.minorEdit = minorEdit;
    }
}

