/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.List;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.dao.PageAttachmentDAO;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;

public class PageIndexingListener
extends PageWikiListener {
    private PageAttachmentDAO pageAttachmentDAO;
    private IndexingService indexingService;

    public PageIndexingListener(PageAttachmentDAO pageAttachmentDAO, IndexingService indexingService) {
        this.pageAttachmentDAO = pageAttachmentDAO;
        this.indexingService = indexingService;
    }

    @Override
    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.indexingService.index("wiki-page", page.getId());
    }

    @Override
    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        if (!(page instanceof DraftPage)) {
            this.indexingService.reindex("wiki-page", page.getId());
        }
    }

    @Override
    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.indexingService.unindex("wiki-page", page.getId());
        List<Long> attachmentIds = this.pageAttachmentDAO.getAttachmentIdByPageId(Long.valueOf(page.getId()));
        for (Long attachmentId : attachmentIds) {
            this.indexingService.unindex("wiki-attachment", String.valueOf(attachmentId));
        }
    }
}

