/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiBreadCrumb.gtmpl")
public class UIWikiBreadCrumb
extends UIContainer {
    private List<BreadcrumbData> breadCumbs = new ArrayList();
    private String actionLabel;
    private boolean isLink = true;
    private boolean isShowWikiType = true;
    private boolean isDisplayFullSpaceName = true;

    public List<BreadcrumbData> getBreadCumbs() {
        return this.breadCumbs;
    }

    public void setBreadCumbs(List<BreadcrumbData> breadCumbs) {
        this.breadCumbs = breadCumbs;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public String getParentURL() throws Exception {
        if (this.breadCumbs.size() > 1) {
            return this.createActionLink((BreadcrumbData)this.breadCumbs.get(this.breadCumbs.size() - 2));
        }
        return this.createActionLink((BreadcrumbData)this.breadCumbs.get(0));
    }

    public boolean isLink() {
        return this.isLink;
    }

    public void setLink(boolean isLink) {
        this.isLink = isLink;
    }

    public WikiPageParams getPageParam() throws Exception {
        if (this.breadCumbs != null && this.breadCumbs.size() > 0) {
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            return wservice.getWikiPageParams((BreadcrumbData)this.breadCumbs.get(this.breadCumbs.size() - 1));
        }
        return null;
    }

    public String getWikiType() throws Exception {
        WikiPageParams params = this.getPageParam();
        if (params != null) {
            return params.getType();
        }
        return null;
    }

    public String getWikiName() throws Exception {
        if (this.getPageParam() != null) {
            String wikiName = this.getPageParam().getOwner();
            if (!this.isDisplayFullSpaceName && wikiName.indexOf(47) > -1) {
                wikiName = wikiName.substring(wikiName.lastIndexOf(47) + 1);
            }
            return wikiName;
        }
        return null;
    }

    public boolean isShowWikiType() {
        return this.isShowWikiType;
    }

    public void setShowWikiType(boolean isShowWikiType) {
        this.isShowWikiType = isShowWikiType;
    }

    public boolean isDisplayFullSpaceName() {
        return this.isDisplayFullSpaceName;
    }

    public void setDisplayFullSpaceName(boolean isDisplayFullSpaceName) {
        this.isDisplayFullSpaceName = isDisplayFullSpaceName;
    }

    public String createActionLink(BreadcrumbData breadCumbData) throws Exception {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        StringBuilder sb = new StringBuilder(portalRequestContext.getPortalURI());
        UIPortal uiPortal = Util.getUIPortal();
        String pageNodeSelected = uiPortal.getSelectedUserNode().getURI();
        sb.append(pageNodeSelected);
        sb.append("/");
        if (!PortalConfig.PORTAL_TYPE.equalsIgnoreCase(breadCumbData.getWikiType())) {
            sb.append(breadCumbData.getWikiType());
            sb.append("/");
            sb.append(Utils.validateWikiOwner((String)breadCumbData.getWikiType(), (String)breadCumbData.getWikiOwner()));
            sb.append("/");
        }
        sb.append(breadCumbData.getId());
        return sb.toString();
    }
}

