/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTFrozenNode;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersion;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiContentDisplay;
import org.exoplatform.wiki.webui.UIWikiPageControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiVersionSelect;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiContainer;
import org.xwiki.rendering.converter.ConversionException;
import org.xwiki.rendering.syntax.Syntax;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPageContentArea.gtmpl")
public class UIWikiPageContentArea
extends UIWikiContainer {
    public static final String VIEW_DISPLAY = "UIViewContentDisplay";

    public UIWikiPageContentArea() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.VIEW, WikiMode.HELP, WikiMode.VIEWREVISION);
        this.addChild(UIWikiPageControlArea.class, null, null);
        this.addChild(UIWikiVersionSelect.class, null, null);
        this.addChild(UIWikiContentDisplay.class, null, VIEW_DISPLAY);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.renderVersion();
        super.processRender(context);
    }

    private void renderVersion() throws Exception {
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        String sessionId = Util.getPortalRequestContext().getRequest().getSession(false).getId();
        wikiService.removeDraft(sessionId);
        String currentVersionName = ((UIWikiVersionSelect)this.getChild(UIWikiVersionSelect.class)).getVersionName();
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        WikiMode currentMode = wikiPortlet.getWikiMode();
        RenderingService renderingService = (RenderingService)PortalContainer.getComponent(RenderingService.class);
        UIWikiContentDisplay contentDisplay = (UIWikiContentDisplay)this.getChildById(VIEW_DISPLAY);
        PageImpl wikipage = (PageImpl)Utils.getCurrentWikiPage();
        Utils.setUpWikiContext((UIWikiPortlet)wikiPortlet);
        try {
            if (currentMode.equals((Object)WikiMode.VIEW)) {
                PageRenderingCacheService renderingCacheService = (PageRenderingCacheService)this.getApplicationComponent(PageRenderingCacheService.class);
                WikiPageParams param = Utils.getCurrentWikiPageParams();
                contentDisplay.setHtmlOutput(renderingCacheService.getRenderedContent(param, Syntax.XHTML_1_0.toIdString()));
            }
            if (currentMode.equals((Object)WikiMode.HELP)) {
                contentDisplay.setHtmlOutput(renderingService.render(wikipage.getContent().getText(), wikipage.getSyntax(), Syntax.XHTML_1_0.toIdString(), false));
            }
            if (currentMode.equals((Object)WikiMode.VIEWREVISION) && currentVersionName != null) {
                NTVersion version = wikipage.getVersionableMixin().getVersionHistory().getVersion(currentVersionName);
                NTFrozenNode frozenNode = version.getNTFrozenNode();
                AttachmentImpl content = (AttachmentImpl)frozenNode.getChildren().get("content");
                String pageContent = content.getText();
                String pageSyntax = wikipage.getSyntax();
                contentDisplay.setHtmlOutput(renderingService.render(pageContent, pageSyntax, Syntax.XHTML_1_0.toIdString(), false));
            }
        }
        catch (ConversionException e) {
            contentDisplay.setHtmlOutput("Bad syntax in content! Cannot generate HTML content!");
        }
        Utils.removeWikiContext();
    }
}

