/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.wiki.webui.UIWikiPageContentArea;
import org.exoplatform.wiki.webui.UIWikiPageVersionsCompare;
import org.exoplatform.wiki.webui.UIWikiPageVersionsList;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiVersionSelect;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiContainer;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiHistorySpaceArea.gtmpl")
public class UIWikiHistorySpaceArea
extends UIWikiContainer {
    public static final String VERSION_LIST_COMPONENT = "UIWikiHistorySpaceArea_UIWikiPageVersionsList";

    public UIWikiHistorySpaceArea() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.SHOWHISTORY, WikiMode.COMPAREREVISION);
        this.addChild(UIWikiPageVersionsList.class, null, VERSION_LIST_COMPONENT);
        this.addChild(UIWikiPageVersionsCompare.class, null, null);
    }

    public boolean isShowVersion() {
        return ((UIWikiPageVersionsList)this.getChild(UIWikiPageVersionsList.class)).isRendered();
    }

    public boolean isShowHistorySpace() {
        WikiMode mode = ((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getWikiMode();
        return mode.equals((Object)WikiMode.VIEWREVISION) || mode.equals((Object)WikiMode.SHOWHISTORY);
    }

    public static void viewRevision(Event<?> event) throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIComponent)event.getSource()).getAncestorOfType(UIWikiPortlet.class);
        UIWikiPageContentArea pageContentArea = (UIWikiPageContentArea)wikiPortlet.findFirstComponentOfType(UIWikiPageContentArea.class);
        String versionName = event.getRequestContext().getRequestParameter("objectId");
        UIWikiVersionSelect wikiVersionSelect = (UIWikiVersionSelect)pageContentArea.getChild(UIWikiVersionSelect.class);
        wikiVersionSelect.setVersionName(versionName);
        wikiPortlet.changeMode(WikiMode.VIEWREVISION);
    }
}

