/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import java.net.URLEncoder;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.commons.EventUIComponent;
import org.exoplatform.webui.commons.UISpacesSwitcher;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.webui.UIWikiLocationContainer;
import org.exoplatform.wiki.webui.popup.UIWikiMovePageForm;
import org.exoplatform.wiki.webui.tree.UITreeExplorer;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/popup/UIWikiMovePageForm.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={MoveActionListener.class}), @EventConfig(listeners={SwitchSpaceActionListener.class}), @EventConfig(listeners={RenameActionListener.class})})
public class UIWikiMovePageForm
extends UIForm
implements UIPopupComponent {
    public static final String PAGENAME_INFO = "pageNameInfo";
    public static final String LOCATION_CONTAINER = "UIWikiLocationContainer";
    public static final String UITREE = "UIMoveTree";
    public String MOVE = "Move";
    private static final String MOVE_PAGE_CONTAINER = "UIWikiMovePageForm";
    private static final String SWITCH_SPACE_ACTION = "SwitchSpace";
    protected static final String SPACE_SWITCHER = "uiSpaceSwitcher_UIWikiMovePageForm";
    private static final String RENAME_ACTION = "Rename";
    private List<PageInfo> duplicatedPages;
    private PageInfo pageToMove;

    public UIWikiMovePageForm() throws Exception {
        this.addChild((UIComponent)new UIFormInputInfo(PAGENAME_INFO, PAGENAME_INFO, null));
        this.addChild(UIWikiLocationContainer.class, null, LOCATION_CONTAINER);
        UITreeExplorer uiTree = (UITreeExplorer)this.addChild(UITreeExplorer.class, null, UITREE);
        EventUIComponent eventComponent = new EventUIComponent(LOCATION_CONTAINER, "ChangeNewLocation", EventUIComponent.EVENTTYPE.EVENT);
        StringBuilder initURLSb = new StringBuilder(Utils.getCurrentRestURL());
        initURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.ALL.toString());
        StringBuilder childrenURLSb = new StringBuilder(Utils.getCurrentRestURL());
        childrenURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.CHILDREN.toString());
        uiTree.init(initURLSb.toString(), childrenURLSb.toString(), this.getInitParam(URLEncoder.encode(Utils.getCurrentWikiPagePath(), "utf-8")), eventComponent, false);
        UISpacesSwitcher uiWikiSpaceSwitcher = (UISpacesSwitcher)this.addChild(UISpacesSwitcher.class, null, SPACE_SWITCHER);
        uiWikiSpaceSwitcher.setCurrentSpaceName(Utils.upperFirstCharacter((String)Utils.getCurrentSpaceName()));
        uiWikiSpaceSwitcher.setAutoResize(true);
        EventUIComponent eventComponent1 = new EventUIComponent(MOVE_PAGE_CONTAINER, SWITCH_SPACE_ACTION, EventUIComponent.EVENTTYPE.EVENT);
        uiWikiSpaceSwitcher.init(eventComponent1);
    }

    protected String createDuplicatedPageNotification() throws Exception {
        if (this.duplicatedPages == null || this.duplicatedPages.isEmpty()) {
            return "";
        }
        ResourceBundle bundle = RequestContext.getCurrentInstance().getApplicationResourceBundle();
        StringBuilder notifications = new StringBuilder();
        int maxWarning = 5;
        if (((PageInfo)this.duplicatedPages.get(0)).getName().equals(this.pageToMove.getName())) {
            maxWarning = 6;
        }
        String dupplicatedParentMessage = bundle.getString("UIWikiMovePageForm.msg.main-page-duplicate");
        String dupplicatedChildMessage = bundle.getString("UIWikiMovePageForm.msg.sub-page-duplicate");
        String renameParentTooltip = bundle.getString("UIWikiMovePageForm.label.rename-main-page");
        String renameChildTooltip = bundle.getString("UIWikiMovePageForm.label.rename-sub-page");
        String renameActionLabel = bundle.getString("UIWikiMovePageForm.action.Rename");
        for (int i = 0; i < Math.min(this.duplicatedPages.size(), maxWarning); ++i) {
            PageInfo page = (PageInfo)this.duplicatedPages.get(i);
            String message = dupplicatedChildMessage;
            String tooltip = renameChildTooltip;
            if (this.pageToMove.getName().equals(page.getName())) {
                message = dupplicatedParentMessage;
                tooltip = renameParentTooltip;
            }
            String messageHTML = "<div class='alert'> <i class='uiIconWarning'></i>" + message + "</div>";
            String renameActionLink = this.event(RENAME_ACTION, page.getName());
            if (this.pageToMove.getName().equals(page.getName())) {
                messageHTML = messageHTML.replace("{0}", "<a title='" + tooltip + "' href=\"" + renameActionLink + "\">" + renameActionLabel + "</a>");
            } else {
                messageHTML = messageHTML.replace("{0}", page.getTitle());
                messageHTML = messageHTML.replace("{1}", "<a title='" + tooltip + "' href=\"" + renameActionLink + "\">" + renameActionLabel + "</a>");
            }
            notifications.append(messageHTML);
        }
        if (this.duplicatedPages.size() > maxWarning) {
            String andMoreLabel = bundle.getString("UIWikiMovePageForm.msg.and-more");
            andMoreLabel = "<div class='alert'> <i class='uiIconWarning'></i>" + andMoreLabel + "</div>";
            notifications.append(andMoreLabel);
        }
        return "<div class='box'>" + notifications.toString() + "</div>";
    }

    public List<PageInfo> getDupplicatedPages() {
        return this.duplicatedPages;
    }

    public void setDupplicatedPages(List<PageInfo> dupplicatedPages) {
        this.duplicatedPages = dupplicatedPages;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    private String getInitParam(String currentPath) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("?").append("path").append("=").append(currentPath).append("&").append("page").append("=").append(currentPath);
        return sb.toString();
    }

    static /* synthetic */ List access$002(UIWikiMovePageForm x0, List x1) {
        x0.duplicatedPages = x1;
        return x0.duplicatedPages;
    }

    static /* synthetic */ List access$000(UIWikiMovePageForm x0) {
        return x0.duplicatedPages;
    }

    static /* synthetic */ PageInfo access$102(UIWikiMovePageForm x0, PageInfo x1) {
        x0.pageToMove = x1;
        return x0.pageToMove;
    }
}

