/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.PermissionEntry;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.webui.UIWikiPageControlArea;
import org.exoplatform.wiki.webui.UIWikiPageInfoArea;
import org.exoplatform.wiki.webui.UIWikiPermissionForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiPermalinkForm.gtmpl", events={@EventConfig(listeners={RestrictActionListener.class}), @EventConfig(listeners={MakePublicActionListener.class}), @EventConfig(listeners={ManagePermisisonsActionListener.class})})
public class UIWikiPermalinkForm
extends UIForm
implements UIPopupComponent {
    public static final String RESTRICT_ACTION = "Restrict";
    public static final String MAKE_PUBLIC_ACTION = "MakePublic";
    public static final String MANAGE_PERMISSION_ACTION = "ManagePermisisons";

    public UIWikiPermalinkForm() throws Exception {
        this.setActions(new String[]{RESTRICT_ACTION, MAKE_PUBLIC_ACTION, MANAGE_PERMISSION_ACTION});
    }

    public void activate() {
    }

    public void deActivate() {
    }

    protected boolean canModifyPagePermission() throws Exception {
        return Utils.canModifyPagePermission();
    }

    protected boolean isCurrentPagePublic() throws Exception {
        return Utils.isCurrentPagePublic();
    }

    protected boolean canPublicAndRetrictPage() throws Exception {
        return Utils.canPublicAndRetrictPage();
    }

    protected static String getPermanlink() throws Exception {
        WikiPageParams params = Utils.getCurrentWikiPageParams();
        return org.exoplatform.wiki.utils.Utils.getPermanlink((WikiPageParams)params, (boolean)true);
    }

    public static class ManagePermisisonsActionListener
    extends EventListener<UIWikiPermalinkForm> {
        public void execute(Event<UIWikiPermalinkForm> event) throws Exception {
            UIWikiPermalinkForm uiWikiPermalinkForm = (UIWikiPermalinkForm)((Object)event.getSource());
            UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)uiWikiPermalinkForm.getAncestorOfType(UIWikiPortlet.class);
            if (uiWikiPermalinkForm.canModifyPagePermission()) {
                UIPopupContainer uiPopupContainer = uiWikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
                uiPopupContainer.cancelPopupAction();
                UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)uiPopupContainer.createUIComponent(UIWikiPermissionForm.class, null, "UIWikiPagePermissionForm");
                uiPopupContainer.activate((UIComponent)uiWikiPermissionForm, 800, 0);
                uiWikiPermissionForm.setPopupLevel(UIWikiPortlet.PopupLevel.L1);
                uiWikiPermissionForm.setScope(UIWikiPermissionForm.Scope.PAGE);
                PageImpl page = (PageImpl)Utils.getCurrentWikiPage();
                HashMap permissionMap = page.getPermission();
                List<PermissionEntry> permissionEntries = uiWikiPermissionForm.convertToPermissionEntryList(permissionMap);
                uiWikiPermissionForm.setPermission(permissionEntries);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
            }
        }
    }

    public static class MakePublicActionListener
    extends EventListener<UIWikiPermalinkForm> {
        public void execute(Event<UIWikiPermalinkForm> event) throws Exception {
            UIWikiPermalinkForm uiWikiPermalinkForm = (UIWikiPermalinkForm)((Object)event.getSource());
            if (uiWikiPermalinkForm.canPublicAndRetrictPage()) {
                Page currentPage = Utils.getCurrentWikiPage();
                HashMap permissions = currentPage.getPermission();
                permissions.put(IdentityConstants.ANY, new String[]{"read", "add_node", "remove", "set_property"});
                currentPage.setPermission(permissions);
                UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)uiWikiPermalinkForm.getAncestorOfType(UIWikiPortlet.class);
                UIWikiPageInfoArea uiWikiPageInfoArea = (UIWikiPageInfoArea)uiWikiPortlet.findFirstComponentOfType(UIWikiPageInfoArea.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPermalinkForm);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPageInfoArea);
            }
        }
    }

    public static class RestrictActionListener
    extends EventListener<UIWikiPermalinkForm> {
        public void execute(Event<UIWikiPermalinkForm> event) throws Exception {
            UIWikiPermalinkForm uiWikiPermalinkForm = (UIWikiPermalinkForm)((Object)event.getSource());
            if (uiWikiPermalinkForm.canPublicAndRetrictPage()) {
                Page currentPage = Utils.getCurrentWikiPage();
                HashMap permissions = currentPage.getPermission();
                permissions.remove(IdentityConstants.ANY);
                currentPage.setPermission(permissions);
                UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)uiWikiPermalinkForm.getAncestorOfType(UIWikiPortlet.class);
                if (currentPage.hasPermission(PermissionType.VIEWPAGE)) {
                    UIWikiPageInfoArea uiWikiPageInfoArea = (UIWikiPageInfoArea)uiWikiPortlet.findFirstComponentOfType(UIWikiPageInfoArea.class);
                    UIWikiPageControlArea uiWikiPageControlArea = (UIWikiPageControlArea)uiWikiPortlet.findFirstComponentOfType(UIWikiPageControlArea.class);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPermalinkForm);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPageInfoArea);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPageControlArea);
                } else {
                    uiWikiPortlet.changeMode(WikiMode.PAGE_NOT_FOUND);
                    event.getRequestContext().getJavascriptManager().addCustomizedOnLoadScript((CharSequence)"eXo.wiki.UIWikiPageNotFound.hidePopup();");
                    Utils.ajaxRedirect(event, Utils.getCurrentWikiPageParams(), WikiMode.PAGE_NOT_FOUND, null);
                }
            }
        }
    }
}

