/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.webui.UIWikiAdvanceSearchForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiSearchSpaceArea;
import org.exoplatform.wiki.webui.WikiMode;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiSearchBox.gtmpl", events={@EventConfig(listeners={AdvancedSearchActionListener.class})})
public class UIWikiSearchBox
extends UIForm {
    private static final String FIELD_SEARCHVALUE = "wikiSearchValue";
    private static final String KEYWORD = "keyword";
    private static final String WIKITYPE = "wikiType";
    private static final String WIKIOWNER = "wikiOwner";
    protected String wikiOwner;
    protected String wikiType;

    public UIWikiSearchBox() throws Exception {
        if (this.getId() == null) {
            this.setId("UIWikiSearchBox");
        }
        UIFormStringInput stringInput = new UIFormStringInput(FIELD_SEARCHVALUE, FIELD_SEARCHVALUE, null);
        stringInput.setHTMLAttribute("title", this.getLabel("Search"));
        this.addUIFormInput((UIFormInput)stringInput);
    }

    protected String getContextSearchURL() throws Exception {
        StringBuilder sb = new StringBuilder();
        WikiPageParams currentParams = Utils.getCurrentWikiPageParams();
        String wikiType = currentParams.getType();
        String wikiOwner = currentParams.getOwner();
        sb.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(PortalContainer.getCurrentRestContextName()).append("/wiki/contextsearch?").append(WIKITYPE).append("=").append(wikiType).append("&").append(WIKIOWNER).append("=").append(wikiOwner).append("&").append(KEYWORD).append("=");
        return sb.toString();
    }

    public static class AdvancedSearchActionListener
    extends EventListener<UIWikiSearchBox> {
        public void execute(Event<UIWikiSearchBox> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiSearchBox)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiSearchSpaceArea searchSpaceArea = (UIWikiSearchSpaceArea)wikiPortlet.findFirstComponentOfType(UIWikiSearchSpaceArea.class);
            UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)searchSpaceArea.getChild(UIWikiAdvanceSearchForm.class);
            advanceSearchForm.resetWikiSpaces();
            String searchValue = event.getRequestContext().getRequestParameter(UIWikiSearchBox.FIELD_SEARCHVALUE);
            advanceSearchForm.getUIStringInput(UIWikiAdvanceSearchForm.TEXT).setValue((Object)searchValue);
            advanceSearchForm.processSearchAction();
            if (!wikiPortlet.getWikiMode().equals((Object)WikiMode.ADVANCEDSEARCH)) {
                wikiPortlet.changeMode(WikiMode.ADVANCEDSEARCH);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)wikiPortlet);
        }
    }
}

