/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.WikiNameValidator;
import org.exoplatform.wiki.webui.UIWikiBottomArea;
import org.exoplatform.wiki.webui.UIWikiPageInfoArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.filter.EditPagesPermissionFilter;
import org.exoplatform.wiki.webui.control.listener.UIWikiPortletActionListener;
import org.exoplatform.wiki.webui.core.UIWikiForm;
import org.exoplatform.wiki.webui.form.UIWikiFormUploadInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiUploadAttachment.gtmpl", events={@EventConfig(listeners={UploadAttachmentActionListener.class})})
public class UIWikiUploadAttachment
extends UIWikiForm {
    public static int SIZE_LIMIT = -1;
    public static String FIELD_UPLOAD = "UploadAttachment";
    private static final Log log = ExoLogger.getLogger((String)UIWikiUploadAttachment.class.getName());
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new EditPagesPermissionFilter()});
    private static WikiService wikiService;

    public UIWikiUploadAttachment() throws Exception {
        wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        this.accept_Modes = Arrays.asList(WikiMode.VIEW, WikiMode.EDITPAGE, WikiMode.ADDPAGE);
        SIZE_LIMIT = Utils.getLimitUploadSize();
        UIWikiFormUploadInput uiInput = new UIWikiFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD, SIZE_LIMIT);
        this.addUIFormInput((UIFormInput)uiInput);
    }

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private Page getCurrentWikiPage() throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        if (wikiPortlet.getWikiMode() == WikiMode.ADDPAGE) {
            return Utils.getCurrentNewDraftWikiPage();
        }
        return Utils.getCurrentWikiPage();
    }

    public static class UploadAttachmentActionListener
    extends UIWikiPortletActionListener<UIWikiUploadAttachment> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processEvent(Event<UIWikiUploadAttachment> event) throws Exception {
            UIWikiUploadAttachment wikiAttachmentArea = (UIWikiUploadAttachment)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            UIWikiFormUploadInput input = (UIWikiFormUploadInput)wikiAttachmentArea.getUIInput(FIELD_UPLOAD);
            UploadResource uploadResource = input.getUploadResource(id);
            String fileName = null;
            try {
                if (uploadResource != null && (fileName = uploadResource.getFileName()) != null) {
                    fileName = org.exoplatform.wiki.utils.Utils.normalizeUploadedFilename((String)fileName);
                    WikiNameValidator.validateFileName((String)fileName);
                }
            }
            catch (IllegalArgumentException ex) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("AttachmentNameValidator.msg.Invalid-char", null, 1));
                event.getRequestContext().setProcessRender(true);
            }
            if (event.getRequestContext().getProcessRender()) {
                this.resetUploadInput(event);
                return;
            }
            Attachment attachment = null;
            if (uploadResource != null) {
                long fileSize = (long)uploadResource.getUploadedSize();
                if (SIZE_LIMIT > 0 && fileSize >= (long)(SIZE_LIMIT * 1024 * 1024)) {
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIFormUploadInput.msg.attachment-limit", (Object[])new String[]{String.valueOf(SIZE_LIMIT)}, 1));
                    this.resetUploadInput(event);
                    return;
                }
                InputStream is = null;
                try {
                    is = input.getUploadDataAsStream(id);
                    if (is == null) {
                        throw new FileNotFoundException();
                    }
                }
                catch (FileNotFoundException ex) {
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiUploadAttachment.msg.file-not-exist", null, 1));
                    this.resetUploadInput(event);
                    return;
                }
                byte[] imageBytes = new byte[is.available()];
                is.read(imageBytes);
                attachment = new Attachment();
                attachment.setName(fileName);
                if (uploadResource.getFileName().lastIndexOf(".") > 0) {
                    attachment.setTitle(uploadResource.getFileName().substring(0, uploadResource.getFileName().lastIndexOf(".")));
                }
                attachment.setMimeType(uploadResource.getMimeType());
                attachment.setContent(imageBytes);
                attachment.setCreator(event.getRequestContext().getRemoteUser());
            }
            if (attachment != null) {
                try {
                    Page page = wikiAttachmentArea.getCurrentWikiPage();
                    if (wikiService.getAttachmentOfPageByName(fileName, page) != null) {
                        event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiUploadAttachment.msg.file-already-exists", null, 1));
                        this.resetUploadInput(event);
                        return;
                    }
                    wikiService.addAttachmentToPage(attachment, page);
                    input.removeUploadId(id);
                }
                catch (Exception e) {
                    log.error((Object)("An exception happens when saving attach file:" + attachment.getName()), (Throwable)e);
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIApplication.msg.unknown-error", null, 0));
                }
                finally {
                    this.resetUploadInput(event);
                }
            }
        }

        private void resetUploadInput(Event<UIWikiUploadAttachment> event) {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiUploadAttachment)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiUploadAttachment wikiAttachmentArea = (UIWikiUploadAttachment)((Object)event.getSource());
            UIWikiBottomArea bottomArea = (UIWikiBottomArea)wikiPortlet.findFirstComponentOfType(UIWikiBottomArea.class);
            wikiAttachmentArea.removeChildById(FIELD_UPLOAD);
            UIWikiFormUploadInput uiInput = new UIWikiFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD, SIZE_LIMIT);
            wikiAttachmentArea.addChild((UIComponent)uiInput);
            UIWikiPageInfoArea inforArea = (UIWikiPageInfoArea)wikiPortlet.findFirstComponentOfType(UIWikiPageInfoArea.class);
            if (bottomArea != null && bottomArea.isRendered() && bottomArea.getAccept_Modes().contains((Object)bottomArea.getCurrentMode())) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)bottomArea);
            }
            if (inforArea != null && inforArea.isRendered() && inforArea.getAccept_Modes().contains((Object)inforArea.getCurrentMode())) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)inforArea);
            }
        }

        protected String getExtensionType() {
            return "org.exoplatform.wiki.webui.control.UIAttachmentContainer";
        }
    }
}

