/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtensionEventListener;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.filter.EditPagesPermissionFilter;
import org.exoplatform.wiki.webui.core.UIWikiForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIFieldEditableForm.gtmpl", events={@EventConfig(listeners={ChangeTitleModeActionListener.class}), @EventConfig(listeners={SavePageTitleActionListener.class})})
public class UIFieldEditableForm
extends UIWikiForm {
    private String EditableFieldId;
    private String parentFunctionName;
    private Class[] functionArgType;
    public static final String FIELD_TITLEINPUT = "EdiableInput";
    public static final String CHANGE_TITLEMODE = "ChangeTitleMode";
    public static final String SAVE = "SavePageTitle";
    public static final String SAVE_TITLE = "saveTitle";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new EditPagesPermissionFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public UIFieldEditableForm() {
        this.accept_Modes = Arrays.asList(WikiMode.VIEW);
        UIFormStringInput titleInput = new UIFormStringInput(FIELD_TITLEINPUT, FIELD_TITLEINPUT, null);
        this.addChild((UIComponent)titleInput);
        titleInput.setRendered(false);
        this.EditableFieldId = "titleInfo";
        Class[] arg = new Class[]{String.class, Event.class};
        this.setParentFunction(SAVE_TITLE, arg);
    }

    public void hideTitleInputBox() {
        UIFormStringInput titleInput = (UIFormStringInput)this.getChild(UIFormStringInput.class);
        titleInput.setRendered(false);
    }

    public String url(String name) throws Exception {
        return Utils.createFormActionLink((UIComponent)this, name, null);
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        UIComponent titleComponent = this.getParent().findComponentById(this.EditableFieldId);
        if (titleComponent != null && titleComponent.isRendered()) {
            ((UIFormStringInput)this.getChild(UIFormStringInput.class)).setRendered(false);
        }
        super.processRender(context);
    }

    public String getEditableFieldId() {
        return this.EditableFieldId;
    }

    public void setEditableFieldId(String editableFieldId) {
        this.EditableFieldId = editableFieldId;
    }

    public String getParentFunctionName() {
        return this.parentFunctionName;
    }

    public void setParentFunctionName(String parentFunctionName) {
        this.parentFunctionName = parentFunctionName;
    }

    public String getInputId() {
        return ((UIFormStringInput)this.getChild(UIFormStringInput.class)).getId();
    }

    public Class[] getFunctionArgType() {
        return this.functionArgType;
    }

    public void setFunctionArgType(Class[] functionArg) {
        this.functionArgType = functionArg;
    }

    public void setParentFunction(String name, Class[] arg) {
        this.setParentFunctionName(name);
        this.setFunctionArgType(arg);
    }

    public static class SavePageTitleActionListener
    extends UIExtensionEventListener<UIFieldEditableForm> {
        public void processEvent(Event<UIFieldEditableForm> event) throws Exception {
            boolean isError = false;
            ApplicationMessage appMsg = null;
            UIFieldEditableForm editableForm = (UIFieldEditableForm)((Object)event.getSource());
            editableForm.getParent().findComponentById(editableForm.getEditableFieldId()).setRendered(true);
            UIFormStringInput titleInput = (UIFormStringInput)((UIFormStringInput)editableForm.getChild(UIFormStringInput.class)).setRendered(false);
            String editableTitle = (String)titleInput.getValue();
            if (StringUtils.isBlank((String)editableTitle)) {
                isError = true;
                appMsg = new ApplicationMessage("WikiPageNameValidator.msg.EmptyTitle", null, 1);
            } else if (((String)titleInput.getValue()).trim().length() > 512) {
                isError = true;
                appMsg = new ApplicationMessage("WikiPageNameValidator.msg.TooLongTitle", new Object[]{512}, 1);
            }
            if (isError) {
                event.getRequestContext().getUIApplication().addMessage(appMsg);
                Utils.redirect(Utils.getCurrentWikiPageParams(), WikiMode.VIEW);
                return;
            }
            Method m = editableForm.getParent().getClass().getMethod(editableForm.getParentFunctionName(), editableForm.getFunctionArgType());
            m.invoke((Object)editableForm.getParent(), editableTitle, event);
        }

        protected Map<String, Object> createContext(Event<UIFieldEditableForm> event) throws Exception {
            return null;
        }

        protected String getExtensionType() {
            return "org.exoplatform.wiki.webui.UIWikiPageTitleControlArea";
        }
    }

    public static class ChangeTitleModeActionListener
    extends EventListener<UIFieldEditableForm> {
        public void execute(Event<UIFieldEditableForm> event) throws Exception {
            UIFieldEditableForm editableForm = (UIFieldEditableForm)((Object)event.getSource());
            UIWikiPageTitleControlArea pageTitleControlArea = (UIWikiPageTitleControlArea)editableForm.getParent();
            UIFormInputInfo editableField = (UIFormInputInfo)pageTitleControlArea.getChild(UIFormInputInfo.class);
            UIFormStringInput titleInput = (UIFormStringInput)editableForm.getChild(UIFormStringInput.class);
            boolean isShow = Boolean.parseBoolean(event.getRequestContext().getRequestParameter("objectId"));
            if (isShow) {
                editableField.setRendered(false);
                titleInput.setRendered(true);
                titleInput.setValue((Object)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)((String)editableField.getValue())));
            } else {
                editableField.setRendered(true);
                titleInput.setRendered(false);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(editableForm.getParent());
        }
    }
}

