/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import org.exoplatform.common.http.client.BufferedInputStream;
import org.exoplatform.common.http.client.Codecs;
import org.exoplatform.common.http.client.GlobalConstants;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.LinkedList;
import org.exoplatform.common.http.client.Log;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.common.http.client.Request;
import org.exoplatform.common.http.client.RespInputStream;
import org.exoplatform.common.http.client.Response;
import org.exoplatform.common.http.client.ResponseHandler;
import org.exoplatform.common.http.client.RetryException;
import org.exoplatform.common.http.client.SocketTimeout;

class StreamDemultiplexor
implements GlobalConstants {
    private int Protocol;
    private HTTPConnection Connection;
    private BufferedInputStream Stream;
    private Socket Sock = null;
    private ResponseHandler MarkedForClose;
    private SocketTimeout.TimeoutEntry Timer = null;
    private static SocketTimeout TimerThread = null;
    private static Object cleanup;
    private LinkedList RespHandlerList;
    private long chunk_len;
    private int cur_timeout = 0;

    StreamDemultiplexor(int protocol, Socket sock, HTTPConnection connection) throws IOException {
        this.Protocol = protocol;
        this.Connection = connection;
        this.RespHandlerList = new LinkedList();
        this.init(sock);
    }

    private void init(Socket sock) throws IOException {
        Log.write(4, "Demux: Initializing Stream Demultiplexor (" + this.hashCode() + ")");
        this.Sock = sock;
        this.Stream = new BufferedInputStream(sock.getInputStream());
        this.MarkedForClose = null;
        this.chunk_len = -1L;
        this.Timer = TimerThread.setTimeout(this);
        this.Timer.hyber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Response resp_handler, Request req) throws RetryException {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.Sock == null) {
                throw new RetryException();
            }
            this.RespHandlerList.addToEnd(new ResponseHandler(resp_handler, req, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RespInputStream getStream(Response resp) {
        ResponseHandler resph;
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            resph = (ResponseHandler)this.RespHandlerList.enumerate();
            while (resph != null && resph.resp != resp) {
                resph = (ResponseHandler)this.RespHandlerList.next();
            }
        }
        if (resph != null) {
            return resph.stream;
        }
        return null;
    }

    void restartTimer() {
        if (this.Timer != null) {
            this.Timer.reset();
        }
    }

    int read(byte[] b, int off, int len, ResponseHandler resph, int timeout) throws IOException {
        ResponseHandler head;
        if (resph.exception != null) {
            resph.exception.fillInStackTrace();
            throw resph.exception;
        }
        if (resph.eof) {
            return -1;
        }
        while ((head = (ResponseHandler)this.RespHandlerList.getFirst()) != null && head != resph) {
            try {
                head.stream.readAll(timeout);
            }
            catch (IOException ioe) {
                if (ioe instanceof InterruptedIOException) {
                    throw ioe;
                }
                resph.exception.fillInStackTrace();
                throw resph.exception;
            }
        }
        StreamDemultiplexor streamDemultiplexor = this;
        synchronized (streamDemultiplexor) {
            if (resph.exception != null) {
                resph.exception.fillInStackTrace();
                throw resph.exception;
            }
            if (resph.resp.cd_type != 1) {
                Log.write(4, "Demux: Reading for stream " + resph.stream.hashCode());
            }
            if (this.Timer != null) {
                this.Timer.hyber();
            }
            try {
                int rcvd = -1;
                if (timeout != this.cur_timeout) {
                    Log.write(4, "Demux: Setting timeout to " + timeout + " ms");
                    this.Sock.setSoTimeout(timeout);
                    this.cur_timeout = timeout;
                }
                switch (resph.resp.cd_type) {
                    case 1: {
                        rcvd = this.Stream.read(b, off, len);
                        if (rcvd != -1) break;
                        throw new EOFException("Premature EOF encountered");
                    }
                    case 2: {
                        rcvd = -1;
                        this.close(resph);
                        break;
                    }
                    case 3: {
                        rcvd = this.Stream.read(b, off, len);
                        if (rcvd != -1) break;
                        this.close(resph);
                        break;
                    }
                    case 4: {
                        int cl = resph.resp.ContentLength;
                        if (len > cl - resph.stream.count) {
                            len = cl - resph.stream.count;
                        }
                        if ((rcvd = this.Stream.read(b, off, len)) == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        if (resph.stream.count + rcvd != cl) break;
                        this.close(resph);
                        break;
                    }
                    case 5: {
                        if (this.chunk_len == -1L) {
                            this.chunk_len = Codecs.getChunkLength(this.Stream);
                        }
                        if (this.chunk_len > 0L) {
                            if ((long)len > this.chunk_len) {
                                len = (int)this.chunk_len;
                            }
                            if ((rcvd = this.Stream.read(b, off, len)) == -1) {
                                throw new EOFException("Premature EOF encountered");
                            }
                            this.chunk_len -= (long)rcvd;
                            if (this.chunk_len != 0L) break;
                            this.Stream.read();
                            this.Stream.read();
                            this.chunk_len = -1L;
                            break;
                        }
                        resph.resp.readTrailers(this.Stream);
                        rcvd = -1;
                        this.close(resph);
                        this.chunk_len = -1L;
                        break;
                    }
                    case 6: {
                        byte[] endbndry = resph.getEndBoundary(this.Stream);
                        int[] end_cmp = resph.getEndCompiled(this.Stream);
                        rcvd = this.Stream.read(b, off, len);
                        if (rcvd == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        int ovf = this.Stream.pastEnd(endbndry, end_cmp);
                        if (ovf == -1) break;
                        rcvd -= ovf;
                        this.close(resph);
                        break;
                    }
                    default: {
                        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + resph.resp.cd_type);
                    }
                }
                this.restartTimer();
                return rcvd;
            }
            catch (InterruptedIOException ie) {
                this.restartTimer();
                throw ie;
            }
            catch (IOException ioe) {
                Log.write(4, "Demux: ", ioe);
                this.close(ioe, true);
                throw resph.exception;
            }
            catch (ParseException pe) {
                Log.write(4, "Demux: ", pe);
                this.close(new IOException(pe.toString()), true);
                throw resph.exception;
            }
        }
    }

    synchronized long skip(long num, ResponseHandler resph) throws IOException {
        if (resph.exception != null) {
            resph.exception.fillInStackTrace();
            throw resph.exception;
        }
        if (resph.eof) {
            return 0L;
        }
        byte[] dummy = new byte[(int)num];
        int rcvd = this.read(dummy, 0, (int)num, resph, 0);
        if (rcvd == -1) {
            return 0L;
        }
        return rcvd;
    }

    synchronized int available(ResponseHandler resph) throws IOException {
        if (resph != null && resph.exception != null) {
            resph.exception.fillInStackTrace();
            throw resph.exception;
        }
        if (resph != null && resph.eof) {
            return 0;
        }
        int avail = this.Stream.available();
        if (resph == null) {
            return avail;
        }
        switch (resph.resp.cd_type) {
            case 2: {
                return 0;
            }
            case 1: {
                return avail > 0 ? 1 : 0;
            }
            case 3: {
                return avail;
            }
            case 4: {
                int cl = resph.resp.ContentLength;
                return avail < (cl -= resph.stream.count) ? avail : cl;
            }
            case 5: {
                return avail;
            }
            case 6: {
                return avail;
            }
        }
        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + resph.resp.cd_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close(IOException exception, boolean was_reset) {
        if (this.Sock == null) {
            return;
        }
        Log.write(4, "Demux: Closing all streams and socket (" + this.hashCode() + ")");
        try {
            this.Stream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.Sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.Sock = null;
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        this.Connection.DemuxList.remove(this);
        if (exception != null) {
            LinkedList linkedList = this.RespHandlerList;
            synchronized (linkedList) {
                this.retry_requests(exception, was_reset);
            }
        }
    }

    private void retry_requests(IOException exception, boolean was_reset) {
        RetryException first = null;
        RetryException prev = null;
        ResponseHandler resph = (ResponseHandler)this.RespHandlerList.enumerate();
        while (resph != null) {
            if (resph.resp.got_headers) {
                resph.exception = exception;
            } else {
                RetryException tmp = new RetryException(exception.getMessage());
                if (first == null) {
                    first = tmp;
                }
                tmp.request = resph.request;
                tmp.response = resph.resp;
                tmp.exception = exception;
                tmp.conn_reset = was_reset;
                tmp.first = first;
                tmp.addToListAfter(prev);
                prev = tmp;
                resph.exception = tmp;
            }
            this.RespHandlerList.remove(resph);
            resph = (ResponseHandler)this.RespHandlerList.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ResponseHandler resph) {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (resph != (ResponseHandler)this.RespHandlerList.getFirst()) {
                return;
            }
            Log.write(4, "Demux: Closing stream " + resph.stream.hashCode());
            resph.eof = true;
            this.RespHandlerList.remove(resph);
        }
        if (resph == this.MarkedForClose) {
            this.close(new IOException("Premature end of Keep-Alive"), false);
        } else {
            this.closeSocketIfAllStreamsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeSocketIfAllStreamsClosed() {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler resph = (ResponseHandler)this.RespHandlerList.enumerate();
            while (resph != null && resph.stream.closed) {
                if (resph == this.MarkedForClose) {
                    ResponseHandler tmp;
                    do {
                        tmp = (ResponseHandler)this.RespHandlerList.getFirst();
                        this.RespHandlerList.remove(tmp);
                    } while (tmp != resph);
                    this.close(new IOException("Premature end of Keep-Alive"), false);
                    return;
                }
                resph = (ResponseHandler)this.RespHandlerList.next();
            }
        }
    }

    synchronized Socket getSocket() {
        if (this.MarkedForClose != null) {
            return null;
        }
        if (this.Timer != null) {
            this.Timer.hyber();
        }
        return this.Sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void markForClose(Response resp) {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.RespHandlerList.getFirst() == null) {
                this.close(new IOException("Premature end of Keep-Alive"), false);
                return;
            }
            if (this.Timer != null) {
                this.Timer.kill();
                this.Timer = null;
            }
            ResponseHandler lasth = null;
            ResponseHandler resph = (ResponseHandler)this.RespHandlerList.enumerate();
            while (resph != null) {
                if (resph.resp == resp) {
                    this.MarkedForClose = resph;
                    Log.write(4, "Demux: stream " + resp.inp_stream.hashCode() + " marked for close");
                    this.closeSocketIfAllStreamsClosed();
                    return;
                }
                if (this.MarkedForClose == resph) {
                    return;
                }
                lasth = resph;
                resph = (ResponseHandler)this.RespHandlerList.next();
            }
            if (lasth == null) {
                return;
            }
            this.MarkedForClose = lasth;
            this.closeSocketIfAllStreamsClosed();
            Log.write(4, "Demux: stream " + lasth.stream.hashCode() + " marked for close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        Log.write(4, "Demux: Aborting socket (" + this.hashCode() + ")");
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler resph = (ResponseHandler)this.RespHandlerList.enumerate();
            while (resph != null) {
                if (resph.resp.http_resp != null) {
                    resph.resp.http_resp.markAborted();
                }
                if (resph.exception == null) {
                    resph.exception = new IOException("Request aborted by user");
                }
                resph = (ResponseHandler)this.RespHandlerList.next();
            }
            if (this.Sock != null) {
                try {
                    try {
                        this.Sock.setSoLinger(false, 0);
                    }
                    catch (SocketException se) {
                        // empty catch block
                    }
                    try {
                        this.Stream.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        this.Sock.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    this.Sock = null;
                    if (this.Timer != null) {
                        this.Timer.kill();
                        this.Timer = null;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.Connection.DemuxList.remove(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close(null, false);
        super.finalize();
    }

    public String toString() {
        String prot;
        switch (this.Protocol) {
            case 0: {
                prot = "HTTP";
                break;
            }
            case 1: {
                prot = "HTTPS";
                break;
            }
            case 2: {
                prot = "SHTTP";
                break;
            }
            case 3: {
                prot = "HTTP_NG";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        return this.getClass().getName() + "[Protocol=" + prot + "]";
    }

    static /* synthetic */ SocketTimeout access$000() {
        return TimerThread;
    }

    static {
        TimerThread = new SocketTimeout(60);
        TimerThread.start();
        cleanup = new Object(){
            private final SocketTimeout timer = StreamDemultiplexor.access$000();

            protected void finalize() {
                this.timer.kill();
            }
        };
    }
}

