/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.rest.GroupInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrganizationServiceHelper {
    protected static final Log LOG = ExoLogger.getLogger((String)"ws.OrganizationServiceHelper");
    private final GroupHandler groupHandler;
    private final MembershipHandler membershipHandler;
    private final MembershipTypeHandler membershipTypeHandler;
    private final UserHandler userHandler;

    public OrganizationServiceHelper(OrganizationService organizationService) {
        this.groupHandler = organizationService.getGroupHandler();
        this.userHandler = organizationService.getUserHandler();
        this.membershipHandler = organizationService.getMembershipHandler();
        this.membershipTypeHandler = organizationService.getMembershipTypeHandler();
    }

    public Group createGroup(String parentId, String groupName, String label, String description) {
        try {
            Group parent = null;
            if (parentId != null && parentId.length() > 0 && (parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId)) == null) {
                throw new IllegalArgumentException("Parent group '" + parentId + "' not found!");
            }
            Group group = this.groupHandler.createGroupInstance();
            group.setGroupName(groupName);
            group.setLabel(label);
            group.setDescription(description);
            this.groupHandler.addChild(parent, group, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("New group created " + group.getId()));
            }
            return group;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Membership createMembership(String username, String groupId, String type) {
        try {
            MembershipType membershipType;
            Group group;
            User user = this.userHandler.findUserByName(username);
            if (user == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("User : '" + username + "' not found!"));
            }
            if ((group = this.groupHandler.findGroupById(groupId = groupId.startsWith("/") ? groupId : "/" + groupId)) == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Group : '" + groupId + "' not found!"));
            }
            if ((membershipType = this.membershipTypeHandler.findMembershipType(type)) == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("MembershipType : '" + type + "' not found!"));
            }
            if (user == null || group == null || membershipType == null) {
                throw new IllegalArgumentException("User , group or membershiptype with specified name not found!");
            }
            this.membershipHandler.linkMembership(user, group, membershipType, true);
            Membership membership = this.membershipHandler.findMembershipByUserGroupAndType(username, groupId, type);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("New membership created " + membership.getId()));
            }
            return membership;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public User createUser(String username, String password, String firstname, String lastname, String email) {
        try {
            User user = this.userHandler.createUserInstance(username);
            if (user == null) {
                throw new IllegalArgumentException("Can't create user instance!");
            }
            user.setPassword(password);
            user.setFirstName(firstname);
            user.setLastName(lastname);
            user.setEmail(email);
            this.userHandler.createUser(user, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("New user created " + user.getUserName()));
            }
            return user;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean deleteGroupd(String groupId) {
        try {
            groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                throw new IllegalArgumentException("Group " + groupId + " not found!");
            }
            this.groupHandler.removeGroup(group, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Delete group " + groupId));
        }
        return true;
    }

    public boolean deleteMembership(String membershipId) {
        try {
            this.membershipHandler.removeMembership(membershipId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Delete membership created " + membershipId));
        }
        return true;
    }

    public boolean deleteUser(String username) {
        try {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                throw new IllegalArgumentException("User " + username + " not found!");
            }
            this.userHandler.removeUser(username, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Delete user " + username));
        }
        return true;
    }

    public boolean deleteUserFromGroup(String username, String groupId) {
        try {
            Group group;
            User user = this.userHandler.findUserByName(username);
            if (user == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("User : '" + username + "' not found!"));
            }
            if ((group = this.groupHandler.findGroupById(groupId = groupId.startsWith("/") ? groupId : "/" + groupId)) == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Group : '" + groupId + "' not found!"));
            }
            if (user == null || group == null) {
                throw new IllegalArgumentException("User or group with specified name not found!");
            }
            Collection memberships = this.membershipHandler.findMembershipsByUserAndGroup(username, groupId);
            for (Membership m : memberships) {
                this.membershipHandler.removeMembership(m.getId(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User " + username + " deleted from group " + groupId));
        }
        return true;
    }

    public Membership findMembership(String membershipId) throws Exception {
        Membership membership = this.membershipHandler.findMembership(membershipId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Find membership: " + membership));
        }
        return membership;
    }

    public Collection<Membership> findMemberships(Membership findMembership) throws Exception {
        String groupId = findMembership.getGroupId();
        if (groupId != null && !groupId.startsWith("/")) {
            groupId = "/" + groupId;
        }
        String username = findMembership.getUserName();
        String type = findMembership.getMembershipType();
        ArrayList<Membership> memberships = new ArrayList<Membership>();
        if (groupId != null && username != null && type != null) {
            Membership membership = this.membershipHandler.findMembershipByUserGroupAndType(username, groupId, type);
            if (membership != null) {
                memberships.add(membership);
            }
        } else if (groupId != null && username != null) {
            memberships.addAll(this.membershipHandler.findMembershipsByUserAndGroup(username, groupId));
        } else if (groupId != null) {
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                throw new IllegalArgumentException("Group " + groupId + " not found," + " username and membership type are null!");
            }
            memberships.addAll(this.membershipHandler.findMembershipsByGroup(group));
        } else if (username != null) {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                throw new IllegalArgumentException("User " + username + " not found," + " groupId and membership type are null!");
            }
            memberships.addAll(this.membershipHandler.findMembershipsByUser(username));
        } else if (type != null) {
            Membership membership = this.membershipHandler.findMembership(type);
            if (membership != null) {
                memberships.add(membership);
            }
        } else {
            throw new IllegalArgumentException("Username, groupId or membership type should be specified!");
        }
        if (memberships.size() > 0) {
            return memberships;
        }
        return null;
    }

    public Collection<User> findUsers(User user) throws Exception {
        Query query = new Query();
        query.setUserName(user.getUserName());
        query.setFirstName(user.getFirstName());
        query.setLastName(user.getLastName());
        query.setEmail(user.getEmail());
        List users = this.userHandler.findUsers(query).getAll();
        if (users.size() > 0) {
            return users;
        }
        return null;
    }

    public Collection<User> findUsersRange(User user, int offset, int amount) throws Exception {
        Query query = new Query();
        query.setUserName(user.getUserName());
        query.setFirstName(user.getFirstName());
        query.setLastName(user.getLastName());
        query.setEmail(user.getEmail());
        List users = this.userHandler.findUsers(query).getAll();
        if (users.size() > 0) {
            if (offset > amount) {
                throw new IllegalArgumentException("Start index is higher then end!");
            }
            if (amount > users.size()) {
                amount = users.size();
            }
            return users.subList(offset, amount);
        }
        return null;
    }

    public Collection<Group> getAllGroups() throws Exception {
        Collection groups = this.groupHandler.getAllGroups();
        return groups;
    }

    public Collection<Group> getFilteredGroup(String filter) throws Exception {
        Collection groups = this.groupHandler.getAllGroups();
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            if (g.getId().contains(filter)) continue;
            iter.remove();
        }
        return groups;
    }

    public GroupInfo getGroupInfo(String groupId) throws Exception {
        Group group = this.groupHandler.findGroupById(groupId = groupId.startsWith("/") ? groupId : "/" + groupId);
        if (group == null) {
            return null;
        }
        List members = this.userHandler.findUsersByGroup(groupId).getAll();
        GroupInfo groupInfo = new GroupInfo();
        groupInfo.setGroup(group);
        groupInfo.setMembers(members);
        return groupInfo;
    }

    public Collection<Group> getGroups(String parentId) throws Exception {
        Group parent;
        if (parentId != null) {
            String string = parentId = parentId.startsWith("/") ? parentId : "/" + parentId;
        }
        if ((parent = this.groupHandler.findGroupById(parentId)) == null) {
            throw new IllegalArgumentException("Parent " + parentId + " not found!");
        }
        Collection groups = this.groupHandler.findGroups(parent);
        return groups;
    }

    public Integer getGroupsCount() throws Exception {
        return this.groupHandler.getAllGroups().size();
    }

    public Collection<Group> getGroupsOfUser(String userId) throws Exception {
        if (this.userHandler.findUserByName(userId) == null) {
            throw new IllegalArgumentException("User " + userId + " not found!");
        }
        Collection groups = this.groupHandler.findGroupsOfUser(userId);
        return groups;
    }

    public Collection<Group> getGroupsRange(String parentId, int offset, int amount) throws Exception {
        Group parent;
        if (parentId != null) {
            String string = parentId = parentId.startsWith("/") ? parentId : "/" + parentId;
        }
        if ((parent = this.groupHandler.findGroupById(parentId)) == null) {
            throw new IllegalArgumentException("Parent " + parentId + " not found!");
        }
        Collection groups = this.groupHandler.findGroups(parent);
        if (offset > amount) {
            throw new IllegalArgumentException("Start index is higher then end!");
        }
        if (amount > groups.size()) {
            amount = groups.size();
        }
        return new ArrayList(groups).subList(offset, amount);
    }

    public Collection<MembershipType> getMembershipTypes() throws Exception {
        Collection membershipTypes = this.membershipTypeHandler.findMembershipTypes();
        return membershipTypes;
    }

    public User getUser(String userId) throws Exception {
        User user = this.userHandler.findUserByName(userId);
        return user;
    }

    public Collection<User> getUsers() throws Exception {
        Query query = new Query();
        List users = this.userHandler.findUsers(query).getAll();
        return users;
    }

    public Integer getUsersCount() throws Exception {
        return this.getUsers().size();
    }

    public Collection<User> getUsersRange(int offset, int amount) throws Exception {
        Query query = new Query();
        List users = this.userHandler.findUsers(query).getAll();
        if (offset > amount) {
            throw new IllegalArgumentException("Start index is higher then end!");
        }
        if (amount > users.size()) {
            amount = users.size();
        }
        return users.subList(offset, amount);
    }

    public String updateGroup(Group updGroup) throws Exception {
        String groupId = updGroup.getId();
        groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
        Group group = this.groupHandler.findGroupById(groupId);
        if (group != null) {
            if (updGroup.getGroupName() != null) {
                group.setGroupName(updGroup.getGroupName());
            }
            if (updGroup.getLabel() != null) {
                group.setLabel(updGroup.getLabel());
            }
            if (updGroup.getDescription() != null) {
                group.setDescription(updGroup.getDescription());
            }
            this.groupHandler.saveGroup(group, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Group " + groupId + " updated."));
            }
            return groupId;
        }
        return null;
    }

    public String updateUser(User updUser) throws Exception {
        String userId = updUser.getUserName();
        User user = this.userHandler.findUserByName(userId);
        if (user != null) {
            if (updUser.getFirstName() != null) {
                user.setFirstName(updUser.getFirstName());
            }
            if (updUser.getLastName() != null) {
                user.setLastName(updUser.getLastName());
            }
            if (updUser.getPassword() != null) {
                user.setPassword(updUser.getPassword());
            }
            if (updUser.getEmail() != null) {
                user.setEmail(updUser.getEmail());
            }
            return userId;
        }
        return null;
    }
}

