/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.rest.samples;

import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.XMLOutputTransformer;
import org.exoplatform.services.rest.transformer.XSLT4DOMOutputTransformer;
import org.exoplatform.services.ws.rest.samples.Book;
import org.exoplatform.services.ws.rest.samples.BookStorage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLBookService
implements ResourceContainer {
    private BookStorage bookStorage;
    private static final Log LOG = ExoLogger.getLogger((String)"ws.XMLBookService");

    public XMLBookService(BookStorage books) {
        this.bookStorage = books;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xml/{key}/")
    @OutputTransformer(value=XMLOutputTransformer.class)
    public Response get(@URIParam(value="key") String key) {
        Book book = this.bookStorage.getBook(key);
        if (book == null) {
            return Response.Builder.notFound().build();
        }
        LOG.info((Object)("GET: " + book));
        Document doc = null;
        try {
            doc = this.createDocument(book);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
        }
        return Response.Builder.ok((Object)doc).mediaType("text/xml").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/html/{key}/")
    @OutputTransformer(value=XSLT4DOMOutputTransformer.class)
    public Response get2(@URIParam(value="key") String key) {
        Book book = this.bookStorage.getBook(key);
        if (book == null) {
            return Response.Builder.notFound().build();
        }
        LOG.info((Object)("GET: " + book));
        Document doc = null;
        try {
            doc = this.createDocument(book);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage(e.getMessage()).build();
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("xslt.template", "book");
        return Response.Builder.ok((Object)doc).setTransformerParameters(p).mediaType("text/html").build();
    }

    private Document createDocument(Book book) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("book");
        Element isdn = doc.createElement("isdn");
        isdn.setTextContent(book.getIsdn());
        Element author = doc.createElement("author");
        author.setTextContent(book.getAuthor());
        Element title = doc.createElement("title");
        title.setTextContent(book.getTitle());
        Element pages = doc.createElement("pages");
        pages.setTextContent(book.getPages() + "");
        Element price = doc.createElement("price");
        price.setTextContent(book.getPrice() + "");
        root.appendChild(isdn);
        root.appendChild(title);
        root.appendChild(author);
        root.appendChild(pages);
        root.appendChild(price);
        doc.appendChild(root);
        return doc;
    }
}

