/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.IOException;
import java.net.ProtocolException;
import org.apache.commons.logging.Log;
import org.exoplatform.common.http.client.HTTPClientModule;
import org.exoplatform.common.http.client.Request;
import org.exoplatform.common.http.client.Response;
import org.exoplatform.common.http.client.RoRequest;
import org.exoplatform.services.log.ExoLogger;

class DefaultModule
implements HTTPClientModule {
    private int req_timeout_retries = 3;
    private static final Log log = ExoLogger.getLogger((String)"ws.commons.httpclient.DefaultModule");

    DefaultModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        int sts = resp.getStatusCode();
        switch (sts) {
            case 408: {
                if (this.req_timeout_retries-- == 0 || req.getStream() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Status " + sts + " " + resp.getReasonLine() + " not handled - maximum number of retries exceeded"));
                    }
                    return 10;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handling " + sts + " " + resp.getReasonLine() + " - resending request"));
                }
                return 13;
            }
            case 411: {
                if (req.getStream() != null && req.getStream().getLength() == -1) {
                    return 10;
                }
                try {
                    resp.getInputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (req.getData() != null) {
                    throw new ProtocolException("Received status code 411 even though Content-Length was sent");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handling " + sts + " " + resp.getReasonLine() + " - resending request with 'Content-length: 0'"));
                }
                req.setData(new byte[0]);
                return 13;
            }
            case 505: {
                return 10;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

