/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd.transport;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.cometd.transport.DelegateMessage;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;

public class RESTContinuationService
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"ws.RestServiceForCometdTransport");
    private final ContinuationService continuation;

    public RESTContinuationService(ContinuationService continuationService) {
        this.continuation = continuationService;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/gettoken/{exoID}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response getToken(@URIParam(value="exoID") String exoID) {
        String token = this.continuation.getUserToken(exoID);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Client with exoId " + exoID + " get token " + token));
        }
        return Response.Builder.ok((Object)token, (String)"text/txt").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/issubscribed/{exoID}/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response isSubscribed(@URIParam(value="exoID") String exoID, @QueryParam(value="channel") String channel) {
        Boolean b = this.continuation.isSubscribe(exoID, channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Is subcribed client " + exoID + " on channel " + channel + " " + b));
        }
        return Response.Builder.ok((Object)b.toString(), (String)"text/txt").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/haschannel/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response hasChannel(@QueryParam(value="channel") String channel) {
        Boolean b = this.continuation.hasChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Has channel " + channel + " " + b));
        }
        return Response.Builder.ok((Object)b.toString(), (String)"text/txt").build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/sendprivatemessage/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendMessage(DelegateMessage data) {
        this.continuation.sendMessage(data.getExoId(), data.getChannel(), data.getMessage(), data.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Send private message " + data.getMessage() + " on channel " + data.getChannel() + " to client " + data.getExoId()));
        }
        return Response.Builder.ok().build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/sendbroadcastmessage/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendBroadcastMessage(DelegateMessage data) {
        this.continuation.sendBroadcastMessage(data.getChannel(), data.getMessage(), data.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Send broadcast message " + data.getMessage() + " on channel " + data.getChannel()));
        }
        return Response.Builder.ok().build();
    }
}

